
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/SYMSTACK.H__   1.2.1.4   17 Apr 1997 16:04:26   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/SYMSTACK.H__  $
** 
**    Rev 1.2.1.4   17 Apr 1997 16:04:26   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:38:20   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:46:14   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:25:22   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:28:40   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:38:12   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:51:54   ZJRD
** Initial revision.
** 
****************************************************************************/

/****************************************************************************
**
**  Name:  SYMSTACK.H
**
**  Description:
**      All expression object's basic class have the prefix: CSymStack
**      Major header file used by expression.
**
**  Status:  CODED
**
**    Rev 1.0   13 March 1996 8:30:00am   Gates Hua
** Initial revision.
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef _SYMSTACK_H_
#define _SYMSTACK_H_
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/**********************************************************************
*                                                                     *
*    The Expression use this class to save token information          *
*                                                                     *
**********************************************************************/                        
struct StackNode {
	void * pNode;
	struct StackNode *next;
	struct StackNode *prev;
public :
	StackNode() {
		pNode = 0;
		next = 0;
		prev = 0;
	}
};

class CSymStack {                 
public :
    CSymStack() {
    	m_pTop = 0;
    	m_pBottom = 0;
    }
    ~CSymStack() {      
		DeleteStack();
    }
     
private :       
	struct StackNode *m_pTop;
	struct StackNode *m_pBottom;
    
public :
	int IsEmpty(void);
	int DeleteStack(void);
	int Push(void* pNode);	
	int Pop(void*& pNode);
};
                
#endif
/******************************** E O F ***********************************/
