
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/SYMSYN.H__   1.2.1.4   17 Apr 1997 16:04:34   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/SYMSYN.H__  $
** 
**    Rev 1.2.1.4   17 Apr 1997 16:04:34   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:38:28   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:46:18   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:25:28   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:28:44   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:38:16   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:51:58   ZJRD
** Initial revision.
** 
****************************************************************************/

/****************************************************************************
**
**  Name:  SYMSYN.H
**
**  Description:
**      All expression object's basic class have the prefix: CSymSyntax
**      Major header file used by expression.
**
**  Status:  CODED
**
**    Rev 1.0   13 March 1996 8:30:00am   Gates Hua
** Initial revision.
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef _SYMSYN_H_
#define _SYMSYN_H_
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "symtoken.h"               
#include "symstack.h"
#include "symcalc.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
    
                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/**********************************************************************
*                                                                     *
*    The Expression use this class to save token information          *
*                                                                     *
**********************************************************************/                        
class CSymSyntax : public CSymToken {
////////////////////////////////////////////////////////////////////
//   Algorithm
//   1. put input string in CSymObj's m_strCmd
//   2. analyse tokens
//   3. check syntax
//   4. calculate C expression's value
//       4.1 get one token : if NULL goto 4.3 
//           push operand to m_stkOperand; 
//       Or  push operator to m_stkOperator;
//       4.2 Check operator , Will the operand be calculated ?
//           Yes :  pop operand to calculate , 
//					push result to m_stkOperand ; goto 4.1
//           No : goto 4.1
//		 4.3 pop operand to C expression's value
////////////////////////////////////////////////////////////////////    
public :
    CSymSyntax() : CSymToken() {
		m_bValidSyntax = TRUE;
		m_bValidResult = TRUE;
		m_pValue = 0;
    }
    CSymSyntax(const char *str) : CSymToken() {
		m_bValidSyntax = TRUE;
		m_bValidResult = TRUE;
		m_pValue = 0;
		InitStrCmd( str );
    }
    ~CSymSyntax() {          
    	if ( m_pValue ) delete m_pValue;
		DeleteOperandStack();
		DeleteOperatorStack();
		DeleteSyntaxStack();
		DeleteArrayNum();
    }
     
protected :
	class CSymStack m_stkOperand;   // operand stack;
	class CSymStack m_stkOperator;  // operator stack;
	class CSymStack m_stkSyntax;  // syntax stack;
	class CSymStack m_stkArrayNum;  // array number;
	class CSymCalc *m_pValue;
	BOOL m_bValidSyntax;
	BOOL m_bValidResult;

public :
	int DisplayValue(char* temp) {
		if ( m_pValue ) return ( m_pValue->DisplayValue(temp) );
		return FAILURE;
	}

public :
	int GetExpAddr(ADDRESS_TYPE& addr);
	int GetTypeIndex(TYPE_INDEX& type);
	int IsComplexResult(int& nFlag);
	int IsSymbol(int& nFlag);
	int IsUserVariable();
	
public :
	void DeleteOperandStack(void);
	void DeleteOperatorStack(void);
	void DeleteSyntaxStack(void);
	void DeleteArrayNum(void);
	
public :
	int IsVariable(void);
	int CalculateValue(void);

	int Init(const char *str,int flag = 0);	
	int CheckSyntax(void);               
	void DisplayValue(void) {
		if ( m_pValue ) m_pValue->Display();
	}
	int GetStatus(BOOL& bResult) {
		if ( m_pValue ) return ( m_pValue->GetStatus(bResult) );
		return FAILURE;
	}
	int GetExpName(CString& strName) {
		return GetAllTokenNameToStr(strName);
	}
	int ReflushExpress(void);
};
                
#endif
/******************************** E O F ***********************************/
