
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/SYNLIB.CPP   1.2.1.4   17 Apr 1997 16:05:54   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/SYNLIB.CPP  $
** 
**    Rev 1.2.1.4   17 Apr 1997 16:05:54   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:40:30   ZJRD
** 2.09F
** 
**    Rev 1.2.1.2   10 Apr 1997 15:47:00   ZJRD
** 2.09F
** 
**    Rev 1.2.1.1   03 Apr 1997 15:26:08   ZJRD
** 2.09E
** 
**    Rev 1.2.1.0   28 Mar 1997 10:29:24   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:38:50   ZJRD
** Easy Pack SLD 2.09c
** 
**    Rev 1.0   12 Mar 1997 14:52:18   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:17:30   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 13:00:44   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:21:48   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:33:16   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 10:00:20   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:50:06   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.7.1.0   12 Aug 1996 10:54:10   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.7   11 Jun 1996 10:29:16   ZJRD
** EasyPack/SLD Version 1.97
** 
**    Rev 1.5   05 Jun 1996 14:57:54   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:34:48   ZJRD
** EasyPack/SLD Version 1.95
** 
**    Rev 1.3   16 May 1996 09:00:14   ZJRD
** EasyPack/SLD Version 1.94
** 
**    Rev 1.2   10 May 1996 09:15:26   ZJRD
** EasyPack/SLD Version 1.93
** 
**    Rev 1.1   02 May 1996 10:29:46   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:02:12   Shirley
** EasyPack/SLD Version 1.91
** 
**    Rev 1.30   12 Apr 1996 10:41:06   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:56:06   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:07:24   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:33:52   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:47:46   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:19:02   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:14:14   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:14:08   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:33:00   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:26:46   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:11:34   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:13:08   Shirley
** EasyPack/SLD Version 0.34a
** 
**    Rev 1.17   04 Jan 1996 11:11:12   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:15:00   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:29:32   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:21:46   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:23:26   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:34:22   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:32:20   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:41:42   Shirley
** EasyPack/SLD Version 0.22
** 
**    Rev 1.9   02 Nov 1995 10:07:24   Shirley
** EasyPack/SLD Version 0.21
** 
**    Rev 1.8   27 Oct 1995 16:47:02   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:48:14   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:29:30   Shirley
** EasyPack/SLD Version 0.1f
** 
**    Rev 1.5   18 Oct 1995 14:48:02   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:24:02   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:53:36   Shirley
** EasyPack/SLD Version 0.1c
** 
**    Rev 1.2   20 Sep 1995 10:54:22   Shirley
** EasyPack/SLD Version 0.1b
** 
**    Rev 1.1   15 Sep 1995 09:48:52   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:54:06   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SYNLIB.CPP
//
//  Description: The implementation file for the class: CSyntaxLib.
//
//  Author: Chen Jun
//
//  Date: 04/03/95
//
//  Modification:
//      1. 04/03/95, Initial version of the class: CSyntaxLib.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include <ctype.h>

#include "symblsvr.h"
#include "cpucom.h"

#include "synlib.h"
#include "abibase.h"                   
//Add by Annie, 3/15/96
#include "address.h"
#include "addrapi.h"
#include "hosterrs.h"

/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.
extern ADDR_SIZE  dwpMax;        // program  max address
extern ADDR_SIZE  dwxMax;        // external data  max address
extern ADDR_SIZE  dwiMax;        // internal data  max address
extern ADDR_SIZE  dwrMax;        // SFR  max address
extern ADDR_SIZE  dwbMax;        // bit  max address


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
//Add by Annie, 3/15/96
//int SymToAddr(char* lpStr , U8* lpType , U32* lpAddr);
int GetControlOption(CString &strReset,CString &strEa,CString &strEben);
extern UINT GetCpuId();

/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

 
/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CSyntaxLib.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxLib::CSyntaxLib().
//
//  Description: The construction of the class: CSyntaxLib.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CSyntaxLib::CSyntaxLib()
{
    // Maximum of the memory type.
    m_ulMaxTypeP = dwpMax;//0x0FFFF;
    m_ulMaxTypeX = dwxMax;//0x0FFFF;
    m_ulMaxTypeI = dwiMax;//0x0FF;
    m_ulMaxTypeR = dwrMax;//0x0FF;
    m_ulMaxTypeB = dwbMax;//0x0FF;

}   // End of CSyntaxLib::CSyntaxLib().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxLib::~CSyntaxLib().
//
//  Description: The destruction of the class: CSyntaxLib.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CSyntaxLib::~CSyntaxLib()
{

}   // End of CSyntaxLib::~CSyntaxLib().

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxLib::Init().
//
//  Description: The refrence of construction of the class: CSyntaxLib.
//               (Add by Chris, 04/16/1996)
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CSyntaxLib::Init(void)
{
    // Maximum of the memory type.
    m_ulMaxTypeP = dwpMax;//0x0FFFF;
    m_ulMaxTypeX = dwxMax;//0x0FFFF;
    m_ulMaxTypeI = dwiMax;//0x0FF;
    m_ulMaxTypeR = dwrMax;//0x0FF;
    m_ulMaxTypeB = dwbMax;//0x0FF;

}   // End of CSyntaxLib::Init().

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxLib::StrToVar().
//
//  Description: Convert the string to an unsigned long value.
//
//  Input:  pszStr - The string to be converted.
//
//  Output: None.
//
//  Return: An unsigned long value.
//
/////////////////////////////////////////////////////////////////////////////
unsigned long CSyntaxLib::StrToVar(char* pszStr)
{
    // Assertion of the input parameters.
    ASSERT( pszStr );
    
    // Convertion.
    char* pszStopStr;
    unsigned long ul = strtoul(pszStr, &pszStopStr, 16);
    
    // Return.
    return (ul);

}   // End of CSyntaxLib::StrToVar().


// Convert an unsigned long value to a string.
void CSyntaxLib::VarToStr(unsigned long ulVar, char* pszStr)
{
    // Assertion of the input parameters.
    ASSERT( pszStr );
    
    // Convert an unsigned long value to a string.
    _ultoa(ulVar, pszStr, 16);

}   // End of CSyntaxLib::VarToStr().

/*
// Convert the symbol name to address string.
//Add by Annie, 3/15/96
void CSyntaxLib::SymbolToAddr(char* pszSymbol, char* pszAddr)
{
    // Assertion of the input parameters.
    ASSERT( pszSymbol );
    ASSERT( pszAddr );
    
    // Call from symbol server.
    unsigned char uchType;
    unsigned long ulAddr;
    if ( 0 == ::SymToAddr(pszSymbol, &uchType, &ulAddr) ) {
        // Get address & type.
        char szAddr[33];
        VarToStr(ulAddr, szAddr);
        char szType[3];
        switch ( uchType ) {
            case 1:
                strcpy(szType, "P:");
                break;
            case 2:
                strcpy(szType, "X:");
                break;
            case 3:
                strcpy(szType, "I:");
                break;
            case 4:
                strcpy(szType, "R:");
                break;
            case 5:
                strcpy(szType, "B:");
                break;
            case 0:
                strcpy(szType, "");
                break;
            default:
                ASSERT( FALSE );
                strcpy(szType, "");
                break;
        }
        // Join to one string.
        strcpy(pszAddr, szType);
        strcat(pszAddr, szAddr);
    }
    else {
        strcpy(pszAddr, pszSymbol);
    }

}   // End of CSyntaxLib::SymbolToAddr().
*/
/*
// Convert the symbol name to address string without type prefix.
void CSyntaxLib::SymbolToAddr(char* pszSymbol, char* pszAddr, char chType)
{
    // Assertion of the input parameters.
    ASSERT( pszSymbol );
    ASSERT( pszAddr );
    ASSERT( 'P' == chType || 'X' == chType || 'B' == chType );
    
    // Call from symbol server.
    unsigned char uchType;
    unsigned long ulAddr;
    if ( 0 == ::SymToAddr(pszSymbol, &uchType, &ulAddr) ) {
        // Get address & type.
        char szAddr[33];
        VarToStr(ulAddr, szAddr);
        switch ( uchType ) {
            case 1:
                if ( 'P' != chType ) {
                    pszAddr = pszSymbol;
                    return;
                }
                break;
            case 2:
                if ( 'X' != chType ) {
                    pszAddr = pszSymbol;
                    return;
                }
                break;
            case 3:
                ASSERT( FALSE );
                break;
            case 4:
                ASSERT( FALSE );
                break;
            case 5:
                if ( 'B' != chType ) {
                    pszAddr = pszSymbol;
                    return;
                }
                break;
            case 0:
                ASSERT( FALSE );
                break;
            default:
                ASSERT( FALSE );
                break;
        }
        // Join to one string.
        strcpy(pszAddr, szAddr);
    }
    else {
        strcpy(pszAddr, pszSymbol);
    }

}   // End of CSyntaxLib::SymbolToAddr().
*/  
/*                                            
BOOL CSyntaxLib::ConvertAddress(char* pszArgv1, char* pszArgv2, int space)                                            
{
    ADDRESS         address;
    ADDR_RETCODE    retCode;
    UINT i;
	
	//AfxMessageBox("ConvertAddress");	
    retCode = AdrShellToAddr(pszArgv1, address, ADDR_SPACE(space));	// Data ADDR_SPACE
	if (ADR_OK == retCode) {                  
		if (!AdrCheckAddrRange(address)) {   
			//Error handle 
			m_nErrorID = ADDR_OUT_OF_RANGE;
			//DisplayError();
			
			//ShowLine("The address is out of range.");
			return (FALSE);	
		}
		else {				
    		retCode = AdrAddrToHex(address,pszArgv2);
			if (ADR_OK == retCode) {   
				if (pszArgv2[1] == ':') {
					for (i= 2; i<strlen(pszArgv2); i++)
						pszArgv2[i] = pszArgv2[i+2];						
				}
				else {
					for (i= 0; i<strlen(pszArgv2); i++)
						pszArgv2[i] = pszArgv2[i+2];						
				}   
				return (TRUE);				
			}
			else    
				return (FALSE);	
        }
    }
	else {
	    CString error;
     	AdrErrorDeal(retCode, error);
     	char* pszError = new char[error.GetLength()+2];
     	strcpy(pszError, error);
     	ShowLine(pszError);
     	delete []pszError;
		return (FALSE);
	}	
}  //End of CSyntaxLib::ConvertAddress		
*/
		
BOOL CSyntaxLib::ConvertAddress(char* pszArgv1, char* pszArgv2, int &nRet, int space)                                            
{
    ADDRESS         address;
    ADDR_RETCODE    retCode;
    UINT i;
	
	//AfxMessageBox("ConvertAddress");	
    retCode = AdrShellToAddr(pszArgv1, address, ADDR_SPACE(space));	// Data ADDR_SPACE
	//retCode = ADR_INVALIDCHAR;
	if (ADR_OK == retCode) {                  
		if (!AdrCheckAddrRange(address)) {   
			//Error handle 
			//m_nErrorID = ADDR_OUT_OF_RANGE;
			////DisplayError();
			nRet = ADDR_OUT_OF_RANGE;
			//ShowLine("The address is out of range.");
			return (FALSE);	
		}
		else {				
    		retCode = AdrAddrToHex(address,pszArgv2);
			if (ADR_OK == retCode) {   
				if (pszArgv2[1] == ':') {
					for (i= 2; i<strlen(pszArgv2); i++)
						pszArgv2[i] = pszArgv2[i+2];						
				}                     
				else if (pszArgv2[2] == ':') {
					for (i= 3; i<strlen(pszArgv2); i++)
						pszArgv2[i] = pszArgv2[i+2];						
				}    
				else {
					for (i= 0; i<strlen(pszArgv2); i++)
						pszArgv2[i] = pszArgv2[i+2];						
				}   
				return (TRUE);				
			}
			else    
				return (FALSE);	
        }
    }
	else {
	    /*
	    CString error;
     	AdrErrorDeal(retCode, error);
     	char* pszError = new char[error.GetLength()+2];
     	strcpy(pszError, error);
     	ShowLine(pszError);
     	delete []pszError;
		*/
		switch (retCode) {
			case 2:
				nRet = ADDR_FORMATERROR;
				break;
			case 3:
				nRet = ADDR_ERROR;
				break;
			case 4:
				nRet = ADDR_OUT_OF_RANGE;	
				break;
		    case 5:
		        nRet = ADDR_NOSYMBOL;
		        break;
			case 6:
				nRet = ADDR_COMPERROR;	
				break;
		    case 7:
		        nRet = ADDR_OVERFLOW; 
		        break; 
		    case 9:
		    	nRet = ADDR_FORMATERROR;
		    	break; 
		    case 10:
		    	nRet = ADDR_FORMATERROR;
		    	break; 
		    default:
		    	nRet = NO_ERROR;
		    	break;		        
		}
		return (FALSE);
	}	
}  //End of CSyntaxLib::ConvertAddress		


void CSyntaxLib::ConvertLen(char* pszArgv1, char* pszArgv2)                                            
{
    ADDRESS         address;
    ADDR_RETCODE    retCode;
    char 			tempAddress[256];
	
	retCode = AdrTextToAddr(pszArgv1, address, 0);
	if (ADR_OK != retCode) {
		//AfxMessageBox("Convert error!");
		return;
	}
	
	AdrAddrToHex( address, tempAddress );
	strcpy(pszArgv2, tempAddress+2);
	
	return;	
	
/*    
    UINT i; 
    int nValue;                   
    if( '0' == pszArgv1[0] && 'X' == toupper(pszArgv1[1])) {
        for (i=0; i<strlen(pszArgv1); i++) {
        	pszArgv1[i] = pszArgv1[i+2];
        }                               
        strcpy(pszArgv2, pszArgv1);
    }
	else {
		nValue = atoi(pszArgv1);
    	itoa(nValue,pszArgv2,16);    
    }	
*/
}  //End of CSyntaxLib::ConvertLen		

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxLib::Is***().
//
//  Description: Syntax checking lib routines.
//
//  Input:  pszArgv - Token arguments of command.
//
//  Output: None.
//
//  Return: FALSE - error; TRUE - pass.
//
/////////////////////////////////////////////////////////////////////////////
BOOL CSyntaxLib::IsAddr(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Convert symbol to standard address format.
    char szArgv[256];
    strcpy(szArgv, pszArgv);

	if (AdrIsOk(szArgv))
		return (TRUE);
	else {
		//Error handle			
		m_nErrorID = ADDR_ERROR;
		return (FALSE);
	}
}

BOOL CSyntaxLib::IsPAddr(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
/*
    if ('P' == toupper(pszArgv[0]) && ':' == pszArgv[1])
        return (TRUE);
    else
        return (FALSE);
*/
    ADDRESS         address;
    ADDR_RETCODE    retCode;
                 
    retCode = AdrTextToAddr(pszArgv, address, 1);    // Convert as address
   	if (ADR_OK == retCode) {
    	  if ( (SPACE_PROGRAME == address.adrSpace) ||
    	    ((address.adrSpace >= SPACE_BANK1) && 
    	     (address.adrSpace <= SPACE_BANK4)) ) {
            return (TRUE);
        }
        else {             
			return (FALSE);
		}              		                                     
	}                   
	else {
		return (FALSE);	
	}
}

BOOL CSyntaxLib::IsPAddrDefault(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Convert symbol to standard address format.
    ADDRESS         address;
    ADDR_RETCODE    retCode;

    retCode = AdrShellToAddr(pszArgv, address, SPACE_PROGRAME);	
	 if (ADR_OK == retCode) {
    	  if ( (SPACE_PROGRAME == address.adrSpace) ||
    	    ((address.adrSpace >= SPACE_BANK1) && 
    	     (address.adrSpace <= SPACE_BANK4)) ) {
	   		if (!AdrCheckAddrRange(address)) {   
					return (FALSE);
				}
		  }         
		  else {
		  	return (FALSE);
		  }
	}
	else {                 
		return (FALSE);
	}  
	return TRUE;
}


BOOL CSyntaxLib::IsXAddr(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
/*    
    if ('X' == toupper(pszArgv[0]) && ':' == pszArgv[1])
        return (TRUE);
    else
        return (FALSE);
*/
    ADDRESS         address;
    ADDR_RETCODE    retCode;
                 
    retCode = AdrTextToAddr(pszArgv, address, 1);    // Convert as address
   	if (ADR_OK == retCode) {
    	if (SPACE_EXTERNAL == address.adrSpace) {
            return (TRUE);
        }
        else {             
			return (FALSE);
		}              		                                     
	}                   
	else {
		return (FALSE);	
	}
}


BOOL CSyntaxLib::IsXAddrDefault(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Convert symbol to standard address format.
/*
    char szArgv[256];
    strcpy(szArgv, pszArgv);
    if (':' == szArgv[1]) return (FALSE);    
    unsigned long ul = StrToVar(szArgv);
    if ( ul < 0ul || ul > m_ulMaxTypeX ) {
        return (FALSE);
    }
    return (TRUE);
*/
    ADDRESS         address;
    ADDR_RETCODE    retCode;

    retCode = AdrShellToAddr(pszArgv, address, SPACE_EXTERNAL);	
	if ((ADR_OK == retCode) && (SPACE_EXTERNAL == address.adrSpace) ) {
		if (!AdrCheckAddrRange(address)) {   
			return (FALSE);
		}
		else {
		    return (TRUE);
		}	           
	}
	else {                 
		return (FALSE);
	}
    
}


BOOL CSyntaxLib::IsIAddr(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
/*    
    if ('I' == toupper(pszArgv[0]) && ':' == pszArgv[1])
        return (TRUE);
    else
        return (FALSE);
*/
    ADDRESS         address;
    ADDR_RETCODE    retCode;
                 
    retCode = AdrTextToAddr(pszArgv, address, 1);    // Convert as address
   	if (ADR_OK == retCode) {
    	if (SPACE_INTERNAL == address.adrSpace) {
            return (TRUE);
        }
        else {             
			return (FALSE);
		}              		                                     
	}                   
	else {
		return (FALSE);	
	}

}


BOOL CSyntaxLib::IsIAddrDefault(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Convert symbol to standard address format.            
/*    
    char szArgv[256];
    strcpy(szArgv, pszArgv);

    if (':' == szArgv[1]) return (FALSE);    
    unsigned long ul = StrToVar(szArgv);
    if ( ul < 0ul || ul > m_ulMaxTypeI ) {
        return (FALSE);
    }
    return (TRUE);
*/
    ADDRESS         address;
    ADDR_RETCODE    retCode;

    retCode = AdrShellToAddr(pszArgv, address, SPACE_INTERNAL);	
	if ((ADR_OK == retCode) && (SPACE_INTERNAL == address.adrSpace) ) {
		if (!AdrCheckAddrRange(address)) {   
			return (FALSE);
		}
		else {
		    return (TRUE);
		}	           
	}
	else {                 
		return (FALSE);
	}
    
}


BOOL CSyntaxLib::IsRAddr(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
/*  
    if ('R' == toupper(pszArgv[0]) && ':' == pszArgv[1])
        return (TRUE);
    else
        return (FALSE);
*/
    ADDRESS         address;
    ADDR_RETCODE    retCode;
                 
    retCode = AdrTextToAddr(pszArgv, address, 1);    // Convert as address
   	if (ADR_OK == retCode) {
    	if (SPACE_SFR == address.adrSpace) {
            return (TRUE);
        }
        else {             
			return (FALSE);
		}              		                                     
	}                   
	else {
		return (FALSE);	
	}

}


BOOL CSyntaxLib::IsRAddrDefault(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Convert symbol to standard address format.
/*  
    char szArgv[256];
    strcpy(szArgv, pszArgv);
    if (':' == szArgv[1]) return (FALSE);        
    unsigned long ul = StrToVar(szArgv);
    if ( ul < 0ul || ul > m_ulMaxTypeR ) {
        return (FALSE);
    }
    return (TRUE);
*/
    ADDRESS         address;
    ADDR_RETCODE    retCode;

    retCode = AdrShellToAddr(pszArgv, address, SPACE_SFR);	
	if ((ADR_OK == retCode) && (SPACE_SFR == address.adrSpace) ) {
		if (!AdrCheckAddrRange(address)) {   
			return (FALSE);
		}
		else {
		    return (TRUE);
		}	           
	}
	else {                 
		return (FALSE);
	}

}


BOOL CSyntaxLib::IsBAddr(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
/*    
    if ('B' == toupper(pszArgv[0]) && ':' == pszArgv[1])
        return (TRUE);
    else
        return (FALSE);
*/
    ADDRESS         address;
    ADDR_RETCODE    retCode;
                 
    retCode = AdrTextToAddr(pszArgv, address, 1);    // Convert as address
   	if (ADR_OK == retCode) {
    	if (SPACE_BIT == address.adrSpace) {
            return (TRUE);
        }
        else {             
			return (FALSE);
		}              		                                     
	}                   
	else {
		return (FALSE);	
	}

}


BOOL CSyntaxLib::IsBAddrDefault(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Convert symbol to standard address format.       
/*    
    char szArgv[256];
    strcpy(szArgv, pszArgv);
    if (':' == szArgv[1]) return (FALSE);        
    unsigned long ul = StrToVar(szArgv);
    if ( ul < 0ul || ul > m_ulMaxTypeB ) {
        return (FALSE);
    }
    return (TRUE);
*/
    ADDRESS         address;
    ADDR_RETCODE    retCode;

    retCode = AdrShellToAddr(pszArgv, address, SPACE_BIT);	
	if ((ADR_OK == retCode) && (SPACE_BIT == address.adrSpace) ) {
		if (!AdrCheckAddrRange(address)) {   
			return (FALSE);
		}
		else {
		    return (TRUE);
		}	           
	}
	else {                 
		return (FALSE);
	}
    
}


BOOL CSyntaxLib::IsAddrLen(char* pszArgv, int &nRet)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
	//Add by Annie, 3/19/96          
    // Is "length".
  	char* p;  
  	ADDR_RETCODE retCode;
  	ADDRESS address;
  	p = new char [ strlen(pszArgv)+1 ];
  	ASSERT( p );
  	strcpy(p,pszArgv);
  	retCode = AdrTextToAddr(p, address,0);
  	if ( p ) {
  		delete []p;
  		p = 0;
  	}	
  	if (ADR_OK == retCode) {
		if (SPACE_UNDEFINE == address.adrSpace )
			return (TRUE);
		else {
			//Error handle			
			nRet = LEN_ERROR;
			//DisplayError();
//			ShowLine("The length is invalid.");
			return (FALSE);	          		        
		}	
  	}
  	else {
		//Error handle			
		nRet = LEN_ERROR;
		//DisplayError();		
//		ShowLine("The length is invalid.");
		return (FALSE);	        
	}	
}
                        
                        

BOOL CSyntaxLib::IsKeywordLength(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "length".
    if ( 0 == stricmp(pszArgv, "LENGTH") ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }
}


// Is in the range: "addr Length length".
BOOL CSyntaxLib::IsLengthRange(char* pszAddr, char* pszLen, int &nRet, int space)
{
    // Assertion of the input parameters.
    ASSERT( pszAddr && pszLen );
    
    //Add by Annie 3/19/96
	ADDR_RETCODE retCode1;
  	ADDR_RETCODE retCode2;
  	ADDRESS address1;    
    ADDRESS address2;             
    DWORD dwBankLen = 0;
	    
    //retCode1 = AdrTextToAddr(pszAddr,address1);
    retCode1 = AdrShellToAddr(pszAddr, address1, ADDR_SPACE(space));
    retCode2 = AdrTextToAddr(pszLen,address2,0);
    if (ADR_OK == retCode1 && ADR_OK == retCode2) {
		if ( address1.adrSpace < SPACE_BANK1 ) {
			address2.adrAddress += address1.adrAddress;		
			address2.adrAddress--;			
			retCode1 = AdrCheck2Addr(address1, address2);
        	if (ADR_OK == retCode1) {       
            	return (TRUE); 
          	}               
	        else {               
				nRet = LEN_OUT_OF_RANGE;
	        	return (FALSE);
	        }	                        
       	}
       	else {
       		switch (address1.adrSpace) {
       			case SPACE_BANK2:
       				dwBankLen = 0x10000;
       				break;
       			case SPACE_BANK3:
       				dwBankLen = 0x20000;
       				break;
       			case SPACE_BANK4:
       				dwBankLen = 0x30000;
       				break;       				
       		}      
       		address1.adrAddress += dwBankLen;                     
       		address2.adrAddress += (address1.adrAddress-1);		
       		if ( g_nBankNum == 4 ) {
	       		if ( address2.adrAddress > 0x3ffff ) {
					nRet = LEN_OUT_OF_RANGE;
		        	return (FALSE);       		
	       		}                  
	       		else {
	       			return (TRUE); 	
	       		}	
	       	}
	       	else if ( g_nBankNum == 2 ) {
	       		if ( address2.adrAddress > 0x1ffff ) {
					nRet = LEN_OUT_OF_RANGE;
		        	return (FALSE);       		
	       		}                  
	       		else {
	       			return (TRUE); 	
	       		}		       	
	       	}
	       	else {
	       		return (FALSE);       		
	       	}	
       	}      
    }
    else {
     	if (retCode1 != ADR_OK ) {
     		nRet = ADDR_ERROR;
     		return (FALSE);
     	}                  
		if (retCode2 != ADR_OK ) {     	
	     	nRet = LEN_ERROR;
	    	return (FALSE);
	    }
	    return (FALSE);	
    }	
    
}


BOOL CSyntaxLib::IsLengthRange(char* pszAddr , char* pszLen, char* pszTarget, int &nRet)
{
    // Assertion of the input parameters.
    ASSERT( pszLen && pszTarget );
    
    // Convert symbol to standard address format.
	char szAddr1[256];
	char szLen[256];
	char szAddr2[256];
	ADDRESS	 addr1, addr2, addr3;     
	DWORD dwBankLen = 0;          
	DWORD dwMax = 0;
	
	strcpy(szAddr1, pszAddr);
	strcpy(szLen, pszLen);
	strcpy(szAddr2, pszTarget);
	
    AdrTextToAddr(szAddr1, addr1);
    AdrTextToAddr(szLen, addr2);
    AdrTextToAddr(szAddr2, addr3); 
	
	if ( addr1.adrSpace == SPACE_UNDEFINE ) {
		addr1.adrSpace = SPACE_EXTERNAL;
	}	                                
	if ( addr2.adrSpace == SPACE_UNDEFINE ) {
		addr2.adrSpace = addr1.adrSpace;
	}                                   
	if ( addr3.adrSpace == SPACE_UNDEFINE ) {
		addr3.adrSpace = SPACE_EXTERNAL;
	}
           
    if ( addr1.adrSpace < SPACE_BANK1 ) {
    	addr2.adrAddress += (addr1.adrAddress-1);
    }                                            
    else {
    	switch (addr1.adrSpace) {
   			case SPACE_BANK2:
   				dwBankLen = 0x10000;
   				break;
   			case SPACE_BANK3:
   				dwBankLen = 0x20000;
   				break;
   			case SPACE_BANK4:
   				dwBankLen = 0x30000;
   				break;       				
   		}      
		addr1.adrAddress += dwBankLen;     		
		addr2.adrAddress += (addr1.adrAddress-1);
    }
    
    if ( addr3.adrSpace >= SPACE_BANK1 ) {
    	dwBankLen = 0;
    	switch (addr3.adrSpace) {
   			case SPACE_BANK2:
   				dwBankLen = 0x10000;
   				break;
   			case SPACE_BANK3:
   				dwBankLen = 0x20000;
   				break;
   			case SPACE_BANK4:
   				dwBankLen = 0x30000;
   				break;       				
   		}      
		addr3.adrAddress += dwBankLen;     		
    }        
    
    if ( addr1.adrSpace >= SPACE_BANK1 &&
    	 addr3.adrSpace >= SPACE_BANK1 ) {
    	if ( g_nBankNum == 2 ) {
    	    dwMax = 0x1FFFF;
    	}                  
    	else if ( g_nBankNum == 4 ) {
    	    dwMax = 0x3FFFF;
    	}    
		if ( (addr2.adrAddress - addr1.adrAddress) <= 
			 (dwMax - addr3.adrAddress) ) {
			return TRUE; 
		}
		else {              
			nRet = LEN_OUT_OF_RANGE;
			return FALSE;
		}	     	    
    }
    else if ( addr1.adrSpace < SPACE_BANK1 && 
              addr3.adrSpace >= SPACE_BANK1 ) {
		if ( addr2.adrAddress - addr1.adrAddress <= dwMax - addr3.adrAddress) {
			return TRUE;
		}              
        else {                      
        	nRet = LEN_OUT_OF_RANGE;
        	return FALSE;
        }    
    }                 
	else if ( addr1.adrSpace >= SPACE_BANK1 && 
              addr3.adrSpace < SPACE_BANK1 ) {
		if ( addr3.adrSpace == SPACE_EXTERNAL ) {
			dwMax = dwxMax; 
		}                  
		else if ( addr3.adrSpace == SPACE_INTERNAL ) {
			dwMax = dwiMax;
		}
		if ( addr2.adrAddress - addr1.adrAddress <= dwMax - addr3.adrAddress) {
			return TRUE;
		}              
        else {
        	nRet = LEN_OUT_OF_RANGE;
        	return FALSE;
        }             
    }    
    else {          
		if ( addr3.adrSpace == SPACE_EXTERNAL ) {
			dwMax = dwxMax; 
		}                  
		else if ( addr3.adrSpace == SPACE_INTERNAL ) {
			dwMax = dwiMax;
		}                                            
		else if ( addr3.adrSpace == SPACE_PROGRAME ) {
			dwMax = dwpMax;
		}
		if ( addr2.adrAddress - addr1.adrAddress <= dwMax - addr3.adrAddress) {
			return TRUE;
		}              
        else {                      
        	nRet = LEN_OUT_OF_RANGE;
        	return FALSE;
        }             
    }                    
}


BOOL CSyntaxLib::IsAddrRange(char* pszAddr1, char* pszAddr2, char* pszAddr3)
{
    // Assertion of the input parameters.
    ASSERT( pszAddr1 && pszAddr2 && pszAddr3 );
    
    ADDRESS	 addr1, addr2, addr3;     
    DWORD dwBankLen = 0;
    DWORD  dwMax;
    
    // Convert symbol to standard address format.
    char szAddr1[256];
    strcpy(szAddr1, pszAddr1);
    char szAddr2[256];
    strcpy(szAddr2, pszAddr2);
    char szAddr3[256];
    strcpy(szAddr3, pszAddr3);          
    
    AdrTextToAddr(szAddr1, addr1);
    AdrTextToAddr(szAddr2, addr2);
    AdrTextToAddr(szAddr3, addr3); 
            
    if ( addr1.adrSpace == SPACE_UNDEFINE ) {
    	addr1.adrSpace = SPACE_EXTERNAL;
    }        
    if ( addr2.adrSpace == SPACE_UNDEFINE ) {
    	addr2.adrSpace = addr1.adrSpace;
    }                                                
    if ( addr3.adrSpace == SPACE_UNDEFINE ) {
    	addr3.adrSpace = SPACE_EXTERNAL;
    }
    
    if ( addr1.adrSpace >= SPACE_BANK1 &&
         addr2.adrSpace >= SPACE_BANK1 &&
    	 addr3.adrSpace >= SPACE_BANK1 ) {
		switch (addr1.adrSpace) {
   			case SPACE_BANK2:
   				dwBankLen = 0x10000;
   				break;
   			case SPACE_BANK3:
   				dwBankLen = 0x20000;
   				break;
   			case SPACE_BANK4:
   				dwBankLen = 0x30000;
   				break;       				
   		}      
		addr1.adrAddress += dwBankLen;     
		dwBankLen = 0;
		switch (addr2.adrSpace) {
   			case SPACE_BANK2:
   				dwBankLen = 0x10000;
   				break;
   			case SPACE_BANK3:
   				dwBankLen = 0x20000;
   				break;
   			case SPACE_BANK4:
   				dwBankLen = 0x30000;
   				break;       				
   		}      
		addr2.adrAddress += dwBankLen;
		dwBankLen = 0;
		switch (addr3.adrSpace) {
   			case SPACE_BANK2:
   				dwBankLen = 0x10000;
   				break;
   			case SPACE_BANK3:
   				dwBankLen = 0x20000;
   				break;
   			case SPACE_BANK4:
   				dwBankLen = 0x30000;
   				break;       				
   		}      
		addr3.adrAddress += dwBankLen;
    	if ( g_nBankNum == 2 ) {
    	    dwMax = 0x1FFFF;
    	}                  
    	else if ( g_nBankNum == 4 ) {
    	    dwMax = 0x3FFFF;
    	}    
    		 	
		if ( (addr2.adrAddress - addr1.adrAddress) <= 
			 (dwMax - addr3.adrAddress) ) {
			return TRUE; 
		}
		else {
			return FALSE;
		}	     	    
    }
    else if ( addr1.adrSpace < SPACE_BANK1 && 
              addr3.adrSpace >= SPACE_BANK1 ) {
		dwBankLen = 0;
		switch (addr3.adrSpace) {
   			case SPACE_BANK2:
   				dwBankLen = 0x10000;
   				break;
   			case SPACE_BANK3:
   				dwBankLen = 0x20000;
   				break;
   			case SPACE_BANK4:
   				dwBankLen = 0x30000;
   				break;       				
   		}      
		addr3.adrAddress += dwBankLen;    	
    	if ( g_nBankNum == 2 ) {
    	    dwMax = 0x1FFFF;
    	}                  
    	else if ( g_nBankNum == 4 ) {
    	    dwMax = 0x3FFFF;
    	}    
		if ( addr2.adrAddress - addr1.adrAddress <= dwMax - addr3.adrAddress) {
			return TRUE;
		}              
        else {
        	return FALSE;
        }    
    }                 
	else if ( addr1.adrSpace >= SPACE_BANK1 && 
              addr3.adrSpace < SPACE_BANK1 ) {
		dwBankLen = 0;
		switch (addr1.adrSpace) {
   			case SPACE_BANK2:
   				dwBankLen = 0x10000;
   				break;
   			case SPACE_BANK3:
   				dwBankLen = 0x20000;
   				break;
   			case SPACE_BANK4:
   				dwBankLen = 0x30000;
   				break;       				
   		}                           
   		addr1.adrAddress += dwBankLen;
		dwBankLen = 0;
		switch (addr2.adrSpace) {
   			case SPACE_BANK2:
   				dwBankLen = 0x10000;
   				break;
   			case SPACE_BANK3:
   				dwBankLen = 0x20000;
   				break;
   			case SPACE_BANK4:
   				dwBankLen = 0x30000;
   				break;       				
   		}            
		addr2.adrAddress += dwBankLen;                   
		
		if ( addr3.adrSpace == SPACE_EXTERNAL ) {
			dwMax = dwxMax; 
		}                  
		else if ( addr3.adrSpace == SPACE_INTERNAL ) {
			dwMax = dwiMax;
		}
		if ( addr2.adrAddress - addr1.adrAddress <= dwMax - addr3.adrAddress) {
			return TRUE;
		}              
        else {
        	return FALSE;
        }             
    }    
    else {          
		if ( addr3.adrSpace == SPACE_EXTERNAL ) {
			dwMax = dwxMax; 
		}                  
		else if ( addr3.adrSpace == SPACE_INTERNAL ) {
			dwMax = dwiMax;
		}        
		else if ( addr3.adrSpace == SPACE_PROGRAME ) {
			dwMax = dwpMax;
		}
		if ( addr2.adrAddress - addr1.adrAddress <= dwMax - addr3.adrAddress) {
			return TRUE;
		}              
        else {
        	return FALSE;
        }             
    }                    
}


BOOL CSyntaxLib::IsMapStartAddr(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Convert symbol to standard address format.
    char szArgv[256];
    ADDRESS addr;
    strcpy(szArgv, pszArgv);

	 AdrTextToAddr(szArgv, addr);	 
    unsigned long ul = addr.adrAddress;
    if ( 0 != (ul % 0x080) ) {          
		//Error handle
		m_nErrorID = ADDR_MAP_ERROR;
      return (FALSE);
    }
    return (TRUE);
}
                                             

BOOL CSyntaxLib::IsMapEndAddr(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Convert symbol to standard address format.
    char szArgv[256];
    ADDRESS addr;    
    strcpy(szArgv, pszArgv);   

	 AdrTextToAddr(szArgv, addr);	 
    unsigned long ul = addr.adrAddress;

    if ( 0 != ((ul+1) % 0x080) ) {
		//Error handle
		m_nErrorID = ADDR_MAP_ERROR;
		//DisplayError();
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLib::IsMapAddrLen(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "length".
    char* p;
    if ( strlen(p = pszArgv) < 1 ) {
        return (FALSE);
    }
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
			//Error handle
			m_nErrorID = ADDR_ERROR;
			//DisplayError();
            return (FALSE);
        }
    }
    unsigned long ul = StrToVar(pszArgv);
    if ( ul <= 0ul || ul > 0x010000ul ) {
		//Error handle
		m_nErrorID = ADDR_OUT_OF_RANGE;
		//DisplayError();
        return (FALSE);
    }
    else if ( 0 != (ul % 0x080) ) {
		//Error handle
		m_nErrorID = ADDR_MAP_ERROR;
		//DisplayError();
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLib::IsMapMemType(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "X:...".
	if ( g_nBankNum == 0 ) {
	    if ( 2 != strlen(pszArgv) ) {			
			m_nErrorID = ADDR_TYPE_ERROR ;	
	        return (FALSE);
	    }
	    
	    if ( ':' != pszArgv[1] ) {
			m_nErrorID = ADDR_TYPE_ERROR ;
	        return (FALSE);
	    }
	    
	    if ( 'P' != toupper(pszArgv[0]) &&
	         'X' != toupper(pszArgv[0]) ) {
			m_nErrorID = ADDR_TYPE_ERROR ;
	        return (FALSE);
	    }
	}
	else if ( g_nBankNum == 2 ) {
		if ( stricmp(pszArgv, "P0:") == 0 ||
			 stricmp(pszArgv, "P1:") == 0 ||			 
			 stricmp(pszArgv, "X:") == 0 ) {
			return TRUE;
		}
		else {
			return FALSE;
		}				 	
	}
	else if ( g_nBankNum == 4 ) {
		if ( stricmp(pszArgv, "P0:") == 0 ||
			 stricmp(pszArgv, "P1:") == 0 ||
			 stricmp(pszArgv, "P2:") == 0 ||
			 stricmp(pszArgv, "P3:") == 0 ||
			 stricmp(pszArgv, "X:") == 0 ) {
			return TRUE;
		}
		else {
			return FALSE;
		}				 	
	}
	    
    return (TRUE);
}


BOOL CSyntaxLib::IsMapAttr(char chType, char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    ASSERT( 'P' == toupper(chType) || 'X' == toupper(chType) );
    
    // Is "attribute".
    if ( !stricmp(pszArgv, "OVERLAY") ) {
        return (TRUE);
    }
    else if ( !stricmp(pszArgv, "OR") ) {
        return (TRUE);
    }
    else if ( !stricmp(pszArgv, "GUARD") ) {
        return (TRUE);
    }
    else if ( !stricmp(pszArgv, "TARGET") ) {
        return (TRUE);
    }
    else if ( !stricmp(pszArgv, "TR") ) {
        return (TRUE);
    }
    else if ( !stricmp(pszArgv, "COMBINATION") ) {
        if ( 'X' == toupper(chType) ) {
            return (TRUE);
        }
        else {
			//Error handle
			m_nErrorID = MAP_ATTR_ERROR;
			//DisplayError();
            return (FALSE);
        }
    }
    else if ( !stricmp(pszArgv, "CR") ) {
        if ( 'X' == toupper(chType) ) {
            return (TRUE);
        }
        else {
			//Error handle
			m_nErrorID = MAP_ATTR_ERROR;
			//DisplayError();
            return (FALSE);
        }
    }
    else {
		//Error handle
		m_nErrorID = MAP_ATTR_ERROR;
		//DisplayError();
        return (FALSE);
    }
}


BOOL CSyntaxLib::IsRegName(char* pszRegName)
{
    // Assertion of the input parameters.
    ASSERT( pszRegName );
    
#ifdef _SERVER_NO_ABI
    char* RegName[28] = {
        "PC",   "DPTR", "ACC",  "B",    "SP",   "PSW",
        "R0",   "R1",   "R2",   "R3",   "R4",   "R5",
        "R6",   "R7",   "IE",   "IP",   "SCON", "TMOD", 
        "TH0",  "TL0",  "TH1",  "TL1",  "TCON", "T2CON",
        "P0",   "P1",   "P2",   "P3"
    };
    int nMaxReg = 28;
#endif  // _SERVER_NO_ABI

    // Is in "RegName[]".
    CString str = strupr(pszRegName);
    for ( int i= 0; i < nMaxReg; i++ ) {
        if ( str == RegName[i] ) {
            return (TRUE);
        }
    }
	//Error handle
	m_nErrorID = REG_ERROR;
	//DisplayError();
    return (FALSE);
}


BOOL CSyntaxLib::IsRegData(char* pszRegName, char* pszRegData)
{
    // Assertion of the input parameters.
    ASSERT( pszRegName );
    ASSERT( pszRegData );
    UINT i; 
    long lValue;                   
    char* p = pszRegData;
    
    if( '0' == pszRegData[0] && 'X' == toupper(pszRegData[1])) {
	    if (2 == strlen(pszRegData)) return (FALSE);				    	
	    p += 2;
	    while ( *p ) {
	        if ( !isxdigit(*(p++)) ) {
				//Error handle
				m_nErrorID = DATA_ERROR;
				//DisplayError();
	            return (FALSE);
	        }
	    }
        for (i=0; i<strlen(pszRegData); i++) {
        	pszRegData[i] = pszRegData[i+2];
        }                               
    }
	else {
		while ( *p ) {
        	if ( !isdigit(*(p++)) ) {
				//Error handle
				m_nErrorID = DATA_ERROR;
				//DisplayError();
            	return (FALSE);
        	}
    	}
		//nValue = atoi(pszRegData);
    	//itoa(nValue,pszRegData,16);    
    	char* pszStopStr;
		lValue = strtol(pszRegData,&pszStopStr, 10);
    	_ltoa(lValue,pszRegData,16);    
    }	                   

    // Is "REG DATA".    
    
    CString str = strupr(pszRegName);
    unsigned long ul = StrToVar(pszRegData);
    if ( str == "PC" || str == "DPTR" ) {
        if ( ul < 0ul || ul > 0x0FFFFul ) {
			//Error handle
			m_nErrorID = DATA_OUT_OF_RANGE;
			//DisplayError();
            return (FALSE);
        }
    }
    else {
        if ( ul < 0ul || ul > 0x0FFul ) {
			//Error handle
			m_nErrorID = DATA_OUT_OF_RANGE;
			//DisplayError();
            return (FALSE);
        }
    }
    return (TRUE);
}                             

BOOL CSyntaxLib::IsKeywordAll(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "length".
    if ( 0 == stricmp(pszArgv, "ALL") ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }
    
}


BOOL CSyntaxLib::IsFilename(char* pszArgv, int &nRet)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "filename".
    if ( strlen(pszArgv) >= _MAX_PATH ) {
        
        return (FALSE);
    }

    if ( strchr(pszArgv, ',') ||
         strchr(pszArgv, '=') ||
         strchr(pszArgv, '+') ||
         strchr(pszArgv, '|') ||
         strchr(pszArgv, '[') ||
         strchr(pszArgv, ']') ||
         strchr(pszArgv, ';') ||
         strchr(pszArgv, '\"')||
         strchr(pszArgv, '<') ||
         strchr(pszArgv, '>') ||
         strchr(pszArgv, '*') ||
         strchr(pszArgv, '?') ) {
		//Error handle
		//m_nErrorID = FILE_NAME_ERROR;
		////DisplayError();
		nRet = FILE_NAME_ERROR;
        return (FALSE);
    }
      
    // Local driver: "..." invalid.
    // Netware driver: "..." valid.
    //if ( strstr(pszArgv, "...") ) {
    //    return (FALSE);
    //}
        
    if ( strstr(pszArgv, "\\\\") ||
         strstr(pszArgv, "//")   ||
         strstr(pszArgv, "\\/")  ||
         strstr(pszArgv, "/\\") ) {
		//Error handle
		//m_nErrorID = FILE_NAME_ERROR;
		////DisplayError();        
		nRet = FILE_NAME_ERROR;
        return (FALSE);
    }
    
    char pszDrive[_MAX_DRIVE];
    char pszDir[_MAX_DIR];
    char pszFname[_MAX_FNAME];
    char pszExt[_MAX_EXT];

    _splitpath(pszArgv, pszDrive, pszDir, pszFname, pszExt);

    //DumpText(pszDrive);
    //DumpText(pszDir);
    //DumpText(pszFname);
    //DumpText(pszExt);

    if ( strchr(pszDir, ':')   ||
         strchr(pszFname, ':') ||
         strchr(pszExt, ':') ) {
		//Error handle
		//m_nErrorID = FILE_NAME_ERROR;
		////DisplayError();
		nRet = FILE_NAME_ERROR;
        return (FALSE);
    }
    
    if ( *pszDrive && 
         !(*pszDrive >= 'A' && *pszDrive <= 'Z') &&
         !(*pszDrive >= 'a' && *pszDrive <= 'z') ) {
		//Error handle
		//m_nErrorID = FILE_NAME_ERROR;
		////DisplayError();
		nRet = FILE_NAME_ERROR;
        return (FALSE);
    }
    
    if ( strchr(pszFname, '.') ) {
		//Error handle
		//m_nErrorID = FILE_NAME_ERROR;
		////DisplayError();
		nRet = FILE_NAME_ERROR;
        return (FALSE);
    }
    
    if ( !*pszFname ) {
		//Error handle
		//m_nErrorID = FILE_NAME_ERROR;
		////DisplayError();
		nRet = FILE_NAME_ERROR;
        return (FALSE);
    }
    
    return (TRUE);
}


BOOL CSyntaxLib::IsLoadOption(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( nArgc > 2 );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    int nSymbols = FALSE, nNoSymbols = FALSE;
    int nCode = FALSE, nNoCode = FALSE;

    int nAppend = FALSE, nNoAppend = FALSE;
    int nWarm = FALSE, nNoWarm = FALSE;

    int nModule = FALSE;
    int nType = FALSE;
    
    // Is "LOAd filename [option]".
    for ( i = 2; i < nArgc; i++ ) {
        CString str = strupr(pszArgv[i]);
        if ( str == "NOSYMBOLS" ) {
            nNoSymbols = TRUE;
        }
        else if ( str == "SYMBOLS" ) {
            nSymbols = TRUE;
        }
        else if ( str == "NOCODE" ) {
            nNoCode = TRUE;
        }
        else if ( str == "CODE" ) {
            nCode = TRUE;
        }    
        else if ( str == "NOAPPEND" ) {
            nNoAppend = TRUE;
        }
        else if ( str == "APPEND" ) {
            nAppend = TRUE;
        } 
        else if ( str == "NOWARN" ) {
            nNoWarm = TRUE;
        }
        else if ( str == "WARN" ) {
            nWarm = TRUE;
        }
        else if ( str == "MODULE" ) {
            if ( i < nArgc-1 && IsModuleName(pszArgv[i++]) ) {
                nModule = TRUE;
            }
            else {
                return (FALSE);
            }
        }
        else if ( IsLoadMemType(pszArgv[i]) ) {
            if ( TRUE == nType ) {
                return (FALSE);
            }
            nType = TRUE;
        }
        else {
            return (FALSE);
        }
    }
    
    if ( nSymbols && nNoSymbols ) {
        return (FALSE);
    }
    if ( nCode && nNoCode ) {
        return (FALSE);
    }       
    if ( nAppend && nNoAppend ) {
        return (FALSE);
    } 
    if ( nWarm && nNoWarm ) {
        return (FALSE);
    }
    
    return (TRUE);
}

BOOL CSyntaxLib::IsLoadMemType(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
	if ( g_nBankNum == 0 ) {
		if ( stricmp(pszArgv, "p:") == 0 ||
			 stricmp(pszArgv, "x:") == 0 ) {
			return TRUE;
		}		   			 
	}    
	else if ( g_nBankNum == 2 ) {
		if ( stricmp(pszArgv, "p0:") == 0 || 
			 stricmp(pszArgv, "p1:") == 0 ||
			 stricmp(pszArgv, "x:") == 0 ) {
			return TRUE;
		}
	}
	else if ( g_nBankNum == 4 ) {
		if ( stricmp(pszArgv, "p0:") == 0 || 
			 stricmp(pszArgv, "p1:") == 0 ||
			 stricmp(pszArgv, "p2:") == 0 || 
			 stricmp(pszArgv, "p3:") == 0 ||
			 stricmp(pszArgv, "x:") == 0 ) {
			return TRUE;
		}
	}

    return FALSE;
}

BOOL CSyntaxLib::IsModuleName(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "module_name".
    if ( strchr(pszArgv, ',') ||
         strchr(pszArgv, '=') ||
         strchr(pszArgv, '+') ||
         strchr(pszArgv, '|') ||
         strchr(pszArgv, '[') ||
         strchr(pszArgv, ']') ||
         strchr(pszArgv, ';') ||
         strchr(pszArgv, '\"')||
         strchr(pszArgv, '<') ||
         strchr(pszArgv, '>') ||
         strchr(pszArgv, ':') ||
         strchr(pszArgv, '\\')||
         strchr(pszArgv, '/') ||
         strchr(pszArgv, '.') ||
         strchr(pszArgv, '*') ||
         strchr(pszArgv, '?') ) {
		//Error handle
		m_nErrorID = MODULE_NAME_ERROR;
		//DisplayError();
        return (FALSE);
    }
    else {
        return (TRUE);
    }
}


BOOL CSyntaxLib::IsArgument(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "argument ...".
    return (TRUE);
}


BOOL CSyntaxLib::IsBackLevel(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "@n".
    if ( '@' != pszArgv[0] ) {
        return (FALSE);
    }
    char* p = pszArgv+1;
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    unsigned long ul = StrToVar(pszArgv+1);
    if ( ul < 0ul || ul > 0x0FFFFul ) {
        return (FALSE);
    }
    return (TRUE);
}


BOOL CSyntaxLib::IsVariableName(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
	
    // Is "#xxx".
    if ( strlen(pszArgv) < 2 ) {               
		//Error handle
		m_nErrorID = VARIABLE_NAME_ERROR;
		//DisplayError();
        return (FALSE);
    }
    
    if ( '#' != pszArgv[0] ) {
		//Error handle
		m_nErrorID = VARIABLE_NAME_ERROR;
		//DisplayError();
        return (FALSE);
    }

//    if ( !iscsymf(pszArgv[1]) && '?' != pszArgv[1] ) {
//        return (FALSE);
//    }

    if ( !iscsymf(pszArgv[1]) ) {
		//Error handle
		m_nErrorID = VARIABLE_NAME_ERROR;
		//DisplayError();
        return (FALSE);
    }

    if ( '_' == pszArgv[1] && strlen(pszArgv) < 3 ) {
		//Error handle
		m_nErrorID = VARIABLE_NAME_ERROR;
		//DisplayError();
        return (FALSE);
    }
    
    BOOL isUnderscore = FALSE;
    char* p = pszArgv+1;
    if ( '_' == *p ) {
        isUnderscore = TRUE;
    }
            
    while ( *p ) {
        if ( !iscsym(*p) && '?' != *p ) {
			//Error handle
			m_nErrorID = VARIABLE_NAME_ERROR;
			//DisplayError();
            return (FALSE);
        }
        else if ( '_' != *(p++) ) {
            isUnderscore = FALSE;
        }
    }

    if ( isUnderscore ) {
		//Error handle
		m_nErrorID = VARIABLE_NAME_ERROR;
		//DisplayError();
        return (FALSE);
    }
    else {
        return (TRUE);
    }
}


BOOL CSyntaxLib::IsSymbolName(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "#xxx".
    if ( strlen(pszArgv) < 2 ) {              
		//Error handle
		m_nErrorID = SYMBOL_NAME_ERROR;
		//DisplayError();
        return (FALSE);
    }
    
    if ( '#' != pszArgv[0] ) {
		//Error handle
		m_nErrorID = SYMBOL_NAME_ERROR;
		//DisplayError();
        return (FALSE);
    }

    return (TRUE);
}


BOOL CSyntaxLib::IsDataBit(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Is "1 0...".
    char* p = pszArgv;
    int nCount = 0;
    while ( *p ) {
        if ( '0' != *p && '1' != *p && ' ' != *p ) {
			//Error handle
			m_nErrorID = DATA_ERROR;
			//DisplayError();
            return (FALSE);
        }
        if ( ' ' == *p ) {
            nCount++;
        }
        if ( nCount > MAX_FILL_SIZE ) {
            return (FALSE);
        }
        p++;
    }

    return (TRUE);

}   // End of CSyntaxLib::IsDataBit().


BOOL CSyntaxLib::IsDataLong(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Is "12345678...".
    char* p = pszArgv;
    int nCount = 0;
    while ( *p ) {
        if ( !isxdigit(*p) && (' ' != *p) ) {
			//Error handle
			m_nErrorID = DATA_ERROR;
			//DisplayError();
            return (FALSE);
        }
        if ( ' ' == *p ) {
            nCount++;
        }
        if ( nCount > MAX_FILL_SIZE/4 ) {
            return (FALSE);
        }
        p++;
    }

    return (TRUE);

}   // End of CSyntaxLib::IsDataLong().


BOOL CSyntaxLib::IsDataWord(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Is "1234...".
    char* p = pszArgv;
    int nCount = 0;
    while ( *p ) {
        if ( !isxdigit(*p) && (' ' != *p) ) {
			//Error handle
			m_nErrorID = DATA_ERROR;
			//DisplayError();
            return (FALSE);
        }
        if ( ' ' == *p ) {
            nCount++;
        }
        if ( nCount > MAX_FILL_SIZE/2 ) {
            return (FALSE);
        }
        p++;
    }

    return (TRUE);

}   // End of CSyntaxLib::IsDataWord().


BOOL CSyntaxLib::IsData(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Is "x xx ...".
    char* p = pszArgv;
    int nCount = 0;
    while ( *p ) {
        if ( !isxdigit(*p) && (' ' != *p) && ('x' != *p) && ('X' != *p)) {
			//Error handle
			m_nErrorID = DATA_ERROR;
			//DisplayError();
            return (FALSE);
        }
        if ( ' ' == *p ) {
            nCount++;
        }
        if ( nCount > MAX_FILL_SIZE ) {
            return (FALSE);
        }
        p++;
    }

    return (TRUE);

}   // End of CSyntaxLib::IsData().


BOOL CSyntaxLib::IsString(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Is "string".
    if ( strlen(pszArgv) > MAX_FILL_SIZE + 2 || strlen(pszArgv) < 3 ) {
        return (FALSE);
    }

    if ( '\"' != *pszArgv || '\"' != *(pszArgv+strlen(pszArgv)-1) ) {
        return (FALSE);
    }

    char* p = pszArgv;
    while ( *p ) {
        if ( *p < 0x020 || *p > 0x07E ) {
            return (FALSE);
        }
        /*
        if ( !isalnum(*p) && ('\"' != *p) && (' ' != *p) ) {
            return (FALSE);
        }
        */
        p++;
    }

    return (TRUE);

}   // End of CSyntaxLib::IsString().


BOOL CSyntaxLib::IsBitRange(char* pszAddr, char* pszData)
{
    // Assertion of the input parameters.
    ASSERT( pszAddr && pszData );
    
    // Check the Data field range.
    char* p = pszData;
    int nCount = 0;
    while ( *p ) {
        if ( ' ' == *p ) {
            nCount++;
        }
        p++;
    }

    // Convert symbol to standard address format.
    char szAddr[256];
    strcpy(szAddr, pszAddr);
    /*
    if ( '#' == szAddr[0] ) {
        SymbolToAddr(pszAddr, szAddr);
    }
    */
    char* p1;
    if ( ':' == szAddr[1] ) {
        if ( 'B' != szAddr[0] && 'b' != szAddr[0] ) {
            return (FALSE);
        }
        p1 = szAddr + 2;
    }
    else {
        p1 = szAddr;
    }

    if ( m_ulMaxTypeB - StrToVar(p1) + 1 < (unsigned long)nCount ) {
        return (FALSE);
    }
    
    return (TRUE);

}   // End of CSyntaxLib::IsBitRange().

/*
BOOL CSyntaxLib::IsDataRange(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( nArgc >= 3 && nArgc <= 5 );
    
    // Check the Data field range.
    switch ( nArgc ) {
        char* p;
        char* p1;
        char* p2;
        int nCount;
        char szAddr1[256];
        char szAddr2[256];
        unsigned long ul;
        case 3:
            nCount = 0;
            p = pszArgv[2];
            while ( *p ) {
                if ( ' ' == *p ) {
                    nCount++;
                }
                p++;
            }
            // Convert symbol to standard address format.
            strcpy(szAddr1, pszArgv[1]);
            if ( '#' == szAddr1[0] ) {
                SymbolToAddr(pszArgv[1], szAddr1);
            }
            if ( ':' == szAddr1[1] ) {
                if ( 'P' == szAddr1[0] || 'p' == szAddr1[0] ) {
                    ul = m_ulMaxTypeP;
                }
                else if ( 'X' == szAddr1[0] || 'x' == szAddr1[0] ) {
                    ul = m_ulMaxTypeX;
                }
                else if ( 'I' == szAddr1[0] || 'i' == szAddr1[0] ) {
                    ul = m_ulMaxTypeI;
                }
                else if ( 'R' == szAddr1[0] || 'r' == szAddr1[0] ) {
                    ul = m_ulMaxTypeR;
                }
                else if ( 'B' == szAddr1[0] || 'b' == szAddr1[0] ) {
                    ul = m_ulMaxTypeB;
                }
                p1 = szAddr1 + 2;
            }
            else {
                ul = m_ulMaxTypeX;
                p1 = szAddr1;
            }
            if ( ul - StrToVar(p1) + 1 < (unsigned long)nCount ) {
                return (FALSE);
            }
            break;
        case 4:
            nCount = 0;
            p = pszArgv[3];
            while ( *p ) {
                if ( ' ' == *p ) {
                    nCount++;
                }
                p++;
            }
            // Convert symbol to standard address format.
            strcpy(szAddr1, pszArgv[1]);
            if ( '#' == szAddr1[0] ) {
                SymbolToAddr(pszArgv[1], szAddr1);
            }
            strcpy(szAddr2, pszArgv[2]);
            if ( '#' == szAddr2[0] ) {
                SymbolToAddr(pszArgv[2], szAddr2);
            }
            p1 = (':' == szAddr1[1]) ? szAddr1+2 : szAddr1;
            p2 = (':' == szAddr2[1]) ? szAddr2+2 : szAddr2;
            if ( StrToVar(p2)-StrToVar(p1)+1 < (unsigned long)nCount ) {
                return (FALSE);
            }
            break;
        case 5:
            nCount = 0;
            p = pszArgv[4];
            while ( *p ) {
                if ( ' ' == *p ) {
                    nCount++;
                }
                p++;
            }
            if ( StrToVar(pszArgv[3]) < (unsigned long) nCount ) {
                return (FALSE);
            }
            break;
        default:
            ASSERT( FALSE );
            return (FALSE);
    }
    
    return (TRUE);

}   // End of CSyntaxLib::IsDataRange().
*/

BOOL CSyntaxLib::IsDataRange(int nArgc, char* pszArgv[], int nDigit)
{
    // Assertion of the input parameters.
	ASSERT( nArgc >= 3 && nArgc <= 5 );
    //ASSERT( 3 == nArgc );
    ASSERT( 1 == nDigit || 2 == nDigit || 4 == nDigit );

	ADDRESS address;         
	DWORD dwBankLen = 0;
	
    // Check the Data field range.
    int nCount = 0;
    char* p = pszArgv[2];
    while ( *p ) {
        if ( ' ' == *p ) {
            nCount++;
        }
        p++;
    }

    // Convert symbol to standard address format.
    AdrShellToAddr(pszArgv[1], address, SPACE_EXTERNAL);	
    unsigned long ul;
    
    if ( address.adrSpace == SPACE_EXTERNAL ) {
    	ul = m_ulMaxTypeX;
    }                     
    else if ( address.adrSpace == SPACE_INTERNAL ) {
    	ul = m_ulMaxTypeI;
    }    
    else if ( address.adrSpace == SPACE_SFR ) {
    	ul = m_ulMaxTypeR;
    }                    
    else if ( address.adrSpace == SPACE_BIT ) {
    	ul = m_ulMaxTypeB;
    }                    
    else {
    	if ( g_nBankNum == 0 ) {
    		ul = m_ulMaxTypeP;
    	}
    	else if ( g_nBankNum == 2 ) {
       		switch (address.adrSpace) {
       			case SPACE_BANK2:
       				dwBankLen = 0x10000;
       				break;
       		}      
       		ul = 0x1ffff;                         	    
       		address.adrAddress += dwBankLen;                         	
    	}
    	else if ( g_nBankNum == 4 ) {  
    		switch (address.adrSpace) {
       			case SPACE_BANK2:
       				dwBankLen = 0x10000;
       				break;
       			case SPACE_BANK3:
       				dwBankLen = 0x20000;
       				break;
       			case SPACE_BANK4:
       				dwBankLen = 0x30000;
       				break;       				
       		}      				
    	    address.adrAddress += dwBankLen;                         	
    	    ul = 0x3ffff;
    	}                            	
    }    
                
    if ( ul - address.adrAddress + 1 < (unsigned long)(nCount * nDigit) ) {
        return (FALSE);
    }

    return (TRUE);

}   // End of CSyntaxLib::IsDataRange().

BOOL CSyntaxLib::IsFillDataRange(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
	ASSERT( nArgc >= 3 && nArgc <= 5 );

	ADDRESS address1, address2;         
	DWORD dwBankLen = 0;
	int nCount = 0;
	
    // Check the Data field range.
	char* p;
	if ( nArgc == 4 ) {  
		p = pszArgv[3];		
	}                        
	else {
		p = pszArgv[4];
	}
    
    if ( '\"' == *p ) {
    	nCount = strlen(p-2);
    }                      
    else {
	    while ( *p ) {
	        if ( ' ' == *p ) {
	            nCount++;
	        }
	        p++;
	    }
	}
	
    // Convert symbol to standard address format.           
    unsigned long ul;
    if ( nArgc == 4 ) {
	    AdrShellToAddr(pszArgv[1], address1, SPACE_EXTERNAL);		    
	    AdrShellToAddr(pszArgv[2], address2);
	    
	    if ( address2.adrSpace == SPACE_UNDEFINE ) {
	    	address2.adrSpace = address1.adrSpace;	
	    }		    
	    
	    if ( address1.adrSpace == SPACE_EXTERNAL ||
	    	 address1.adrSpace == SPACE_INTERNAL ||
	    	 address1.adrSpace == SPACE_SFR ||
	    	 address1.adrSpace == SPACE_BIT ) {
	    	ul = address2.adrAddress - address1.adrAddress + 1;
	    }                     
	    else {
	    	if ( g_nBankNum == 0 ) {
	    		ul = address2.adrAddress - address1.adrAddress + 1;
	    	}
	    	else if ( g_nBankNum == 2 ) {
	       		switch (address1.adrSpace) {
	       			case SPACE_BANK2:
	       				dwBankLen = 0x10000;
	       				break;
	       		}      	       		
	       		address1.adrAddress += dwBankLen;                         	
	       		dwBankLen = 0;
	       		switch (address2.adrSpace) {
	       			case SPACE_BANK2:
	       				dwBankLen = 0x10000;
	       				break;
	       		}      	       		
	       		address2.adrAddress += dwBankLen;                         	
	       		ul = address2.adrAddress - address1.adrAddress + 1;
	    	}
	    	else if ( g_nBankNum == 4 ) {  
	    		switch (address1.adrSpace) {
	       			case SPACE_BANK2:
	       				dwBankLen = 0x10000;
	       				break;
	       			case SPACE_BANK3:
	       				dwBankLen = 0x20000;
	       				break;
	       			case SPACE_BANK4:
	       				dwBankLen = 0x30000;
	       				break;       				
	       		}      				
	    	    address1.adrAddress += dwBankLen;                         	
	    	    dwBankLen = 0;
	    		switch (address2.adrSpace) {
	       			case SPACE_BANK2:
	       				dwBankLen = 0x10000;
	       				break;
	       			case SPACE_BANK3:
	       				dwBankLen = 0x20000;
	       				break;
	       			case SPACE_BANK4:
	       				dwBankLen = 0x30000;
	       				break;       				
	       		}      				
	    	    address2.adrAddress += dwBankLen;                         	
	    	    ul = address2.adrAddress - address1.adrAddress + 1;
	    	}                            	
	    }    
	}                   
    else if ( nArgc == 5 ) {	    
	    AdrShellToAddr(pszArgv[3], address1);
	    ul = address1.adrAddress;	        
	}                

    if ( ul < (unsigned long)(nCount) ) {
        return (FALSE);
    }                               
    
    return (TRUE);

}   // End of CSyntaxLib::IsFillDataRange().


BOOL CSyntaxLib::IsKeywordInsensitive(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "insensitive".
    if ( 0 == stricmp(pszArgv, "INSENSITIVE") ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }

}   // End of CSyntaxLib::IsKeywordInsensitive().


BOOL CSyntaxLib::IsCaseStringRange(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 5 == nArgc || 6 == nArgc );
    
    // Check the Data field range.
    switch ( nArgc ) {
        case 5:
            if ( StrToVar(pszArgv[3]+2) - StrToVar(pszArgv[2]+2) + 1 < 
                 strlen(pszArgv[4]) - 2 ) {
                return (FALSE);
            }
            break;
        case 6:
            if ( StrToVar(pszArgv[4]) < strlen(pszArgv[5]) - 2 ) {
                return (FALSE);
            }
            break;
        default:
            ASSERT( FALSE );
            return (FALSE);
            break;
    }
    
    return (TRUE);

}   // End of CSyntaxLib::IsCaseStringRange().


BOOL CSyntaxLib::IsKeywordRun(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Run".
    if ( 0 == stricmp(pszArgv, "RUN") ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }

}   // End of CSyntaxLib::IsKeywordRun().


BOOL CSyntaxLib::IsKeywordFrom(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "From".
    if ( 0 == stricmp(pszArgv, "FROM") ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }

}   // End of CSyntaxLib::IsKeywordFrom().


BOOL CSyntaxLib::IsKeywordTill(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "From".
    if ( 0 == stricmp(pszArgv, "TILL") ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }

}   // End of CSyntaxLib::IsKeywordTill().


BOOL CSyntaxLib::IsKeywordOver(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Over".
    return ( 0 == stricmp(pszArgv, "OVER") ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordOver().


BOOL CSyntaxLib::IsKeywordForever(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Over".
    return ( 0 == stricmp(pszArgv, "FOREVER") ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordForever().


BOOL CSyntaxLib::IsKeywordRet(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Over".
    return ( 0 == stricmp(pszArgv, "RET") ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordRet().


BOOL CSyntaxLib::IsKeywordCall(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Over".
    return ( 0 == stricmp(pszArgv, "CALL") ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordCall().


BOOL CSyntaxLib::IsStepCount(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    UINT i; 
    //int nValue;                   
    long lValue;
    char* p = pszArgv;
    
    if( '0' == pszArgv[0] && 'X' == toupper(pszArgv[1])) {
	    if (2 == strlen(pszArgv)) return (FALSE);				    	
	    p += 2;
	    while ( *p ) {
	        if ( !isxdigit(*(p++)) ) {
				//Error handle
				m_nErrorID = COUNT_ERROR;
				//DisplayError();
	            return (FALSE);
	        }
	    }
        for (i=0; i<strlen(pszArgv); i++) {
        	pszArgv[i] = pszArgv[i+2];
        }                               
    }
	else {
		while ( *p ) {
        	if ( !isdigit(*(p++)) ) {
				//Error handle
				m_nErrorID = COUNT_ERROR;
				//DisplayError();
            	return (FALSE);
        	}
    	}              
    	char* pszStopStr;
		lValue = strtol(pszArgv,&pszStopStr, 10);
    	_ltoa(lValue,pszArgv,16);    
    }	                   
    
    // Is "FFFF".
    
    unsigned long ul = StrToVar(pszArgv);
    if ( ul < 0ul || ul > 0x0FFFFul ) {
		//Error handle
		m_nErrorID = COUNT_OUT_OF_RANGE;
		//DisplayError();
        return (FALSE);
    }
    else {
        return (TRUE);
    }

}   // End of CSyntaxLib::IsStepCount().


BOOL CSyntaxLib::IsAddrData(char* pszArgv) 
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    UINT i; 
    //int nValue;       
    long lValue;
    char* p = pszArgv;            

    if( '0' == pszArgv[0] && 'X' == toupper(pszArgv[1])) {
	    if (2 == strlen(pszArgv))
			return (FALSE);				    	
	    p += 2;
	    while ( *p ) {
	        if ( !isxdigit(*(p++)) ) {
				//Error handle
				m_nErrorID = DATA_ERROR;
				//DisplayError();
	            return (FALSE);
	        }
	    }
        for (i=0; i<strlen(pszArgv); i++) {
        	pszArgv[i] = pszArgv[i+2];
        }                               
    }
	else {
	    while ( *p ) {
	        if ( !isdigit(*(p++)) ) {
				//Error handle
				m_nErrorID = DATA_ERROR;
				//DisplayError();
	            return (FALSE);
	        }
	    }           
    	char* pszStopStr;
		lValue = strtol(pszArgv,&pszStopStr, 10);
    	_ltoa(lValue,pszArgv,16);    
    }	                   
    
    // Is "FFFF".     
    /*
    char* p = pszArgv;
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    */
    unsigned long ul = StrToVar(pszArgv);
    if ( ul < 0ul || ul > 0x0FFFFul ) {
		//Error handle
		m_nErrorID = DATA_OUT_OF_RANGE;
		//DisplayError();
        return (FALSE);
    }
    else {
        return (TRUE);
    }

}   // End of CSyntaxLib::IsAddrData().


BOOL CSyntaxLib::IsKeywordInstruction(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "instruction".
    return ( 0 == stricmp(pszArgv, "INSTRUCTION") ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordInstruction().


BOOL CSyntaxLib::IsKeywordStatement(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "statement".
    return ( 0 == stricmp(pszArgv, "STATEMENT") ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordStatement().


BOOL CSyntaxLib::IsKeywordLines(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Line".
    return ( 0 == stricmp(pszArgv, "LINES") ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordLine().


BOOL CSyntaxLib::IsKeywordWith(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "With".
    return ( 0 == stricmp(pszArgv, "WITH") ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordWith().


BOOL CSyntaxLib::IsKeywordClear(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Clear".
    return ( 0 == stricmp(pszArgv, "CLEAR") ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordClear().


BOOL CSyntaxLib::IsEventID(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "1", "2" or "3".
    if ( 0 == stricmp(pszArgv, "1") ||
         0 == stricmp(pszArgv, "2") ||
         0 == stricmp(pszArgv, "3") ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }

}   // End of CSyntaxLib::IsEventID().


BOOL CSyntaxLib::IsKeywordHigh(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "High".
    return ( 0 == stricmp(pszArgv, "HIGH") ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordHigh().


BOOL CSyntaxLib::IsKeywordLow(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Low".
    return ( 0 == stricmp(pszArgv, "LOW") ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordLow().


BOOL CSyntaxLib::IsKeywordRange(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Range".
    return ( 0 == stricmp(pszArgv, "RANGE") ? TRUE : FALSE );

}   // End of CSyntaxLib::IsKeywordRange().


BOOL CSyntaxLib::IsWildcardAddr(char* pszArgv) 
{                              
	UINT i;
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    if ( '(' != pszArgv[0] && ')' != pszArgv[strlen(pszArgv)-1])
    	return (FALSE);        
    else { 
		for (i = 0; i < strlen(pszArgv)-1 ; i++) {
			pszArgv[i] = pszArgv[i+1];
		}
		pszArgv[strlen(pszArgv)-2] = '\0';    
    }                                         	                          
    
    // Binary or Hexadecimal wildcard code.
    if ( 'B' == toupper(*(pszArgv+strlen(pszArgv)-1)) && 17 == strlen(pszArgv)) { 
    //if ( 'B' == toupper(*(pszArgv+strlen(pszArgv)-2)) ) {    
        // Binary code.
        //if ( 17 != strlen(pszArgv) ) {
        //if ( 19 != strlen(pszArgv) ) {
        //    return (FALSE);
        //}
        for ( i = 0; i < 17-1; i++ ) { 
        //for ( i = 1; i < 19-2; i++ ) {
            if ( '0' != pszArgv[i] &&
                 '1' != pszArgv[i] &&
                 'X' != toupper(pszArgv[i]) ) {
                return (FALSE);
            }
        }
        for ( i = 0; i < 17; i++ ) {
        //for ( i = 1; i < 17; i++ ) {
            if ( 'X' == toupper(pszArgv[i]) ) {
                return (TRUE);
            }
            else {
                continue;
            }
        }
        return (FALSE);
    }
    else {
        // Hexidecimal code.   (3XXF)
        if ( 4 != strlen(pszArgv) ) {
        //if ( 6 != strlen(pszArgv) ) {
            return (FALSE);
        }     
        
        char* p = pszArgv;
        while ( *p ) {
            if ( isxdigit(*p) || 'X' == toupper(*p) ) {
                p++;
            }
            else {
                return (FALSE);
            }
        } 
        /*
        for ( i = 1; i < 5; i++) {
	        if (!isxdigit(pszArgv[i]) && 'X' != toupper(pszArgv[i]))
				return (FALSE);        	                                 
        }
        */
        for ( int i = 0; i < 4; i++ ) { 
        //for ( i = 1; i < 5; i++ ) {
            if ( 'X' == toupper(pszArgv[i]) ) {
                return (TRUE);
            }
            else {
                continue;
            }
        }
        return (FALSE);
    }

}   // End of CSyntaxLib::IsWildcardAddr().


BOOL CSyntaxLib::IsWildcardData(char* pszArgv) 
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
	UINT i;
	    
    // Binary or Hexadecimal wildcard code.
    if ( '(' != pszArgv[0] && ')' != pszArgv[strlen(pszArgv)-1])
    	return (FALSE);                                  
    else { 
		for (i = 0; i < strlen(pszArgv)-1 ; i++) {
			pszArgv[i] = pszArgv[i+1];
		}
		pszArgv[strlen(pszArgv)-2] = '\0';    
    }                                         	                          

    if ( 'B' == toupper(*(pszArgv+strlen(pszArgv)-1)) && 9 == strlen(pszArgv)) {    	
    //if ( 'B' == toupper(*(pszArgv+strlen(pszArgv)-2)) ) {
        // Binary code.    (1X001X000B)
        //if ( 9 != strlen(pszArgv) ) { 
        //if ( 11 != strlen(pszArgv) ) {        
        //    return (FALSE);
        //}                                 
        for ( i = 0; i < 9-1; i++ ) {        
        //for ( int i = 1; i < 11-2; i++ ) {
            if ( '0' != pszArgv[i] &&
                 '1' != pszArgv[i] &&
                 'X' != toupper(pszArgv[i]) ) {
                return (FALSE);
            }
        }
        for ( i = 0; i < 9; i++ ) {
        //for ( i = 1; i < 9; i++ ) {        
            if ( 'X' == toupper(pszArgv[i]) ) {
                return (TRUE);
            }
            else {
                continue;
            }
        }
        return (FALSE);
    }
    else {
        // Hexidecimal code. (XF)
        if ( 2 != strlen(pszArgv) ) {
        //if ( 4 != strlen(pszArgv) ) {        
            return (FALSE);
        }
        char* p = pszArgv;
        /*
        if (!isxdigit(pszArgv[1]) && 'X' != toupper(pszArgv[1]))
			return (FALSE);        	
		if (!isxdigit(pszArgv[2]) && 'X' != toupper(pszArgv[2]))
			return (FALSE);        	                                         
        */
        
        while ( *p ) {
            if ( isxdigit(*p) || 'X' == toupper(*p) ) {
                p++;
            }
            else {
                return (FALSE);
            }
        }        
        
        for ( i = 0; i < 2; i++ ) {
        //for ( int i = 1; i < 3; i++ ) {        
            if ( 'X' == toupper(pszArgv[i]) ) {
                return (TRUE);
            }
            else {
                continue;
            }
        }
        return (FALSE);
    }

}   // End of CSyntaxLib::IsWildcardData().


BOOL CSyntaxLib::IsEventData(char* pszArgv) 
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    UINT i; 
    //int nValue;       
    long lValue;
    char* p = pszArgv;            

    if( '0' == pszArgv[0] && 'X' == toupper(pszArgv[1])) {
	    if (2 == strlen(pszArgv)) return (FALSE);				    	
	    p += 2;
	    while ( *p ) {
	        if ( !isxdigit(*(p++)) ) {
				//Error handle
				m_nErrorID = DATA_ERROR;
				//DisplayError();
	            return (FALSE);
	        }
	    }
        for (i=0; i<strlen(pszArgv); i++) {
        	pszArgv[i] = pszArgv[i+2];
        }                               
    }
	else {
	    while ( *p ) {
	        if ( !isdigit(*(p++)) ) {
				//Error handle
				m_nErrorID = DATA_ERROR;
				//DisplayError();
	            return (FALSE);
	        }
	    }           
    	char* pszStopStr;
		lValue = strtol(pszArgv,&pszStopStr, 10);
    	_ltoa(lValue,pszArgv,16);    
    }	                 
                 
    // Is "FF".
    if ( strlen(pszArgv) < 1 || strlen(pszArgv) > 2 ) {
		//Error handle
		m_nErrorID = DATA_OUT_OF_RANGE;
		//DisplayError();
        return (FALSE);
    }   
    /*
    while ( *pszArgv ) {
        if ( !isxdigit(*(pszArgv++)) ) {
            return (FALSE);
        }
    } 
    */
    return (TRUE);

}   // End of CSyntaxLib::IsEventData().


BOOL CSyntaxLib::IsListOption(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     
    
    //Add by Annie, 3/11/96
    // Check "SOURCE", "ASSEMBLE", "MIXED" or "MODULE" or "NUMBER".
    if ( 0 != stricmp(pszArgv, "SOURCE") &&
         0 != stricmp(pszArgv, "ASSEMBLE") &&
         0 != stricmp(pszArgv, "MIXED") &&
         0 != stricmp(pszArgv, "MODULE") &&
         0 != stricmp(pszArgv, "NUMBER")) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

}   // End of CSyntaxLib::IsListOption().


BOOL CSyntaxLib::IsListFrame(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );               
    UINT i; 
    //int nValue;       
    long lValue;
    char* p = pszArgv;            

    if( '0' == pszArgv[0] && 'X' == toupper(pszArgv[1])) {
	    if (2 == strlen(pszArgv)) return (FALSE);				    	
	    p += 2;
	    while ( *p ) {
	        if ( !isxdigit(*(p++)) ) {
	            return (FALSE);
	        }
	    }
        for (i=0; i<strlen(pszArgv); i++) {
        	pszArgv[i] = pszArgv[i+2];
        }                               
    }
	else {
	    while ( *p ) {
	        if ( !isdigit(*(p++)) ) {
	            return (FALSE);
	        }
	    }           
    	char* pszStopStr;
		lValue = strtol(pszArgv,&pszStopStr, 10);
    	_ltoa(lValue,pszArgv,16);    
    }	                   
    
    // Is "7FFF".
	/*
    char* p = pszArgv;
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    */
    unsigned long ul = StrToVar(pszArgv);
    if ( ul < 0ul || ul > 0x07FFFul ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }
}   // End of CSyntaxLib::IsListFrame().


BOOL CSyntaxLib::IsKeywordTrace(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "TRace".
    return ( 0 == stricmp(pszArgv, "TRACE") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordTrace().


BOOL CSyntaxLib::IsKeywordTimer(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "TImer".
    return ( 0 == stricmp(pszArgv, "TIMER") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordTimer().


BOOL CSyntaxLib::IsKeywordOn(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "ON".
    return ( 0 == stricmp(pszArgv, "ON") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordOn().


BOOL CSyntaxLib::IsKeywordOff(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "OFf".
    return ( 0 == stricmp(pszArgv, "OFF") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordOff().


BOOL CSyntaxLib::IsEventSequence(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "ev1 and ev2...".
    const int nMaxSeq = 40;
    char* pszEventSequence[nMaxSeq] = {
        "ev1 ",
        "ev2 ",
        "ev3 ",
        "ev1 and ev2 ",
        "ev1 and ev3 ",
        "ev2 and ev1 ",
        "ev2 and ev3 ",
        "ev3 and ev1 ",
        "ev3 and ev2 ",
        "ev1 or ev2 ",
        "ev1 or ev3 ",
        "ev2 or ev1 ",
        "ev2 or ev3 ",
        "ev3 or ev1 ",
        "ev3 or ev2 ",
        "ev1 and ev2 and ev3 ",
        "ev1 and ev3 and ev2 ",
        "ev2 and ev1 and ev3 ",
        "ev2 and ev3 and ev1 ",
        "ev3 and ev1 and ev2 ",
        "ev3 and ev2 and ev1 ",
        "ev1 or ev2 or ev3 ",
        "ev1 or ev3 or ev2 ",
        "ev2 or ev1 or ev3 ",
        "ev2 or ev3 or ev1 ",
        "ev3 or ev1 or ev2 ",
        "ev3 or ev2 or ev1 ",
        "ev1 and ev2 or ev3 ",
        "ev1 and ev3 or ev2 ",
        "ev2 and ev1 or ev3 ",
        "ev2 and ev3 or ev1 ",
        "ev3 and ev1 or ev2 ",
        "ev3 and ev2 or ev1 ",
        "ev1 or ev2 and ev3 ",
        "ev1 or ev3 and ev2 ",
        "ev2 or ev1 and ev3 ",
        "ev2 or ev3 and ev1 ",
        "ev3 or ev1 and ev2 ",
        "ev3 or ev2 and ev1 ",
        ""
    };
    
    for ( int i = 0; i < nMaxSeq; i++ ) {
        if ( 0 == stricmp(pszArgv, pszEventSequence[i]) ) {
            return (TRUE);
        }
    }
    return (FALSE);

}   // End of CSyntaxLib::IsEventSequence().


BOOL CSyntaxLib::IsKeywordReset(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Reset".
    return ( 0 == stricmp(pszArgv, "RESET") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordReset().


BOOL CSyntaxLib::IsKeywordEa(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Ea".
    return ( 0 == stricmp(pszArgv, "EA") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordEa().


BOOL CSyntaxLib::IsKeywordEnable(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Enable".
    return ( 0 == stricmp(pszArgv, "ENABLE") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordEnable().


BOOL CSyntaxLib::IsKeywordDisable(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Disable".
    return ( 0 == stricmp(pszArgv, "DISABLE") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordDisable().


BOOL CSyntaxLib::IsKeywordBit(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Bit".
    return ( 0 == stricmp(pszArgv, "BIT") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordBit().


BOOL CSyntaxLib::IsKeywordByte(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Byte".
    return ( 0 == stricmp(pszArgv, "BYTE") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordByte().


BOOL CSyntaxLib::IsCpuModule(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "80C32".
    return ( 0 == stricmp(pszArgv, "80C32") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsCpuModule().


BOOL CSyntaxLib::IsPort(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     
    
    //Add by Annie, 3/13/96
    
    UINT nCpuId;
    nCpuId = GetCpuId();
    
    //80C750(38), 83C750(39), 80C751(40), 83C751(41), 80C752(22), 83C752(23)
    //  have not P2
    if (nCpuId == 22 || nCpuId == 23 || nCpuId == 40 || nCpuId == 41 ||
    	nCpuId == 38 || nCpuId == 39)
    	if ( 0 == stricmp(pszArgv, "0") ||
     	     0 == stricmp(pszArgv, "1") ||
         	 0 == stricmp(pszArgv, "3") || 
         	 0 == stricmp(pszArgv, "0x0") ||
     	     0 == stricmp(pszArgv, "0x1") ||
         	 0 == stricmp(pszArgv, "0x3") ) {
         	 return (TRUE);
    	}
    	else {
			//Error handle
			m_nErrorID = PORT_ERROR;
			//DisplayError();
			return (FALSE);	 
    	}	

    if ( 0 == stricmp(pszArgv, "0") ||
         0 == stricmp(pszArgv, "1") ||
         0 == stricmp(pszArgv, "2") ||
         0 == stricmp(pszArgv, "3") ||
		 0 == stricmp(pszArgv, "0x0") ||
     	 0 == stricmp(pszArgv, "0x1") || 
     	 0 == stricmp(pszArgv, "0x2") ||
         0 == stricmp(pszArgv, "0x3") ) {
         	          
        return (TRUE);
    }                     
    //80C152JA(8), 83C152JA(9), 80C152JC(12), 83C152JC(13), 80CL580(48),
    //	83CL580(49) have P0-P4
    else if (nCpuId == 8 || nCpuId == 9|| nCpuId == 12 || nCpuId == 13 ||
    		nCpuId == 48 || nCpuId == 49) {
    	if (0 == stricmp(pszArgv, "4"))
    		return (TRUE);
    	else {
			//Error handle
			m_nErrorID = PORT_ERROR;
			//DisplayError();
			return (FALSE);            
		}	
	}
    //80C552(18), 83C552(19) have P0-P5
	else if (nCpuId == 18 || nCpuId == 19) {		
    	if (0 == stricmp(pszArgv, "4")   ||
    		0 == stricmp(pszArgv, "0x4") ||
    		0 == stricmp(pszArgv, "5")   ||
    		0 == stricmp(pszArgv, "0x5") )
    		return (TRUE);
    	else {
			//Error handle
			m_nErrorID = PORT_ERROR;
			//DisplayError();
			return (FALSE);            
		}	
	}	
    //80C152JB(10), 83C152JB(11), 80C152JD(14), 83C152JD(15) have P0-P6
	else if (nCpuId == 10 || nCpuId == 11 || nCpuId == 14 || nCpuId == 15) {		
    	if (0 == stricmp(pszArgv, "4")   ||
    		0 == stricmp(pszArgv, "5")   ||
         	0 == stricmp(pszArgv, "6")   ||
         	0 == stricmp(pszArgv, "0x4") ||
         	0 == stricmp(pszArgv, "0x5") ||
         	0 == stricmp(pszArgv, "0x6") )
    		return (TRUE);
    	else {
			//Error handle
			m_nErrorID = PORT_ERROR;
			//DisplayError();
			return (FALSE);            
		}	
	}	
    else {                       
		//Error handle
		m_nErrorID = PORT_ERROR;
		//DisplayError();
        return (FALSE);
    }
    
}   // End of CSyntaxLib::IsPort().


BOOL CSyntaxLib::IsBitNo(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "01234567".
    if ( 0 == stricmp(pszArgv, "0") ||
         0 == stricmp(pszArgv, "1") ||
         0 == stricmp(pszArgv, "2") ||
         0 == stricmp(pszArgv, "3") ||
         0 == stricmp(pszArgv, "4") ||
         0 == stricmp(pszArgv, "5") ||
         0 == stricmp(pszArgv, "6") ||
         0 == stricmp(pszArgv, "7") ||
         0 == stricmp(pszArgv, "0x0") ||
         0 == stricmp(pszArgv, "0x1") ||
         0 == stricmp(pszArgv, "0x2") ||
         0 == stricmp(pszArgv, "0x3") ||
         0 == stricmp(pszArgv, "0x4") ||
         0 == stricmp(pszArgv, "0x5") ||
         0 == stricmp(pszArgv, "0x6") ||
         0 == stricmp(pszArgv, "0x7")) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }
    
}   // End of CSyntaxLib::IsBitNo().


BOOL CSyntaxLib::IsBitData(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    // Is "0|1".
    char* p = pszArgv;
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    
    unsigned long ul = StrToVar(pszArgv);
    if ( ul < 0ul || ul > 0x01ul ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

}   // End of CSyntaxLib::IsBitData().


BOOL CSyntaxLib::IsByteData(char* pszArgv) 
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    UINT i; 
    //int nValue;       
    long lValue;
    char* p = pszArgv;                

    if( '0' == pszArgv[0] && 'X' == toupper(pszArgv[1])) {   
    	if (2 == strlen(pszArgv)) return (FALSE);				    	
	    p += 2;
	    while ( *p ) {
	        if ( !isxdigit(*(p++)) ) {
	            return (FALSE);
	        }
	    }
        for (i=0; i<strlen(pszArgv); i++) {
        	pszArgv[i] = pszArgv[i+2];
        }                               
    }
	else {
	    while ( *p ) {
	        if ( !isdigit(*(p++)) ) {
	            return (FALSE);
	        }
	    }
    	char* pszStopStr;
		lValue = strtol(pszArgv,&pszStopStr, 10);
    	_ltoa(lValue,pszArgv,16);    
    }	                   

    // Is "FF".
    /*
    char* p = pszArgv;
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    */
    unsigned long ul = StrToVar(pszArgv);
    if ( ul < 0ul || ul > 0x0FFul ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

}   // End of CSyntaxLib::IsByteData().


BOOL CSyntaxLib::IsKeywordGlobal(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "GLOBAL".
    return ( 0 == stricmp(pszArgv, "GLOBAL") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordGlobal().


BOOL CSyntaxLib::IsLineNo(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "#xxx".
    if ( strlen(pszArgv) < 2 ) {
        return (FALSE);
    }
    
    if ( '#' != pszArgv[0] ) {
        return (FALSE);
    }

    char* p = pszArgv + 1;
    while ( *p ) {
        if ( !isdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    return (TRUE);

}   // End of CSyntaxLib::IsLineNo().


BOOL CSyntaxLib::IsKeywordClose(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Close".
    return ( 0 == stricmp(pszArgv, "CLOSE") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordClose().


BOOL CSyntaxLib::IsKeywordAppend(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Append".
    return ( 0 == stricmp(pszArgv, "APPEND") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordAppend().

BOOL CSyntaxLib::IsKeywordNoappend(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Noappend".
    return ( 0 == stricmp(pszArgv, "NOAPPEND") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordNoappend().


BOOL CSyntaxLib::IsKeywordCommand(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Command".
    return ( 0 == stricmp(pszArgv, "COMMAND") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordCommand().


BOOL CSyntaxLib::IsKeywordLv1(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Lv1".
    return ( 0 == stricmp(pszArgv, "LV1") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordLv1().


BOOL CSyntaxLib::IsKeywordLv2(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Lv2".
    return ( 0 == stricmp(pszArgv, "LV2") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordLv2().


BOOL CSyntaxLib::IsKeywordForward(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Forward".
    return ( 0 == stricmp(pszArgv, "FORWARD") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordForward().


BOOL CSyntaxLib::IsKeywordBackward(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Backward".
    return ( 0 == stricmp(pszArgv, "BACKWARD") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordBackward().


BOOL CSyntaxLib::IsKeywordCenter(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Center".
    return ( 0 == stricmp(pszArgv, "CENTER") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordCenter().


BOOL CSyntaxLib::IsKeywordDelay(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Delay".
    return ( 0 == stricmp(pszArgv, "DELAY") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordDelay().


BOOL CSyntaxLib::IsKeywordThen(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Then".
    return ( 0 == stricmp(pszArgv, "THEN") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordThen().


BOOL CSyntaxLib::IsKeywordModule(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Module".
    return ( 0 == stricmp(pszArgv, "MODULE") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordModule().


BOOL CSyntaxLib::IsCommand(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "command".
    char* p = pszArgv;
    while ( *p ) {
        if ( !isalnum(*p) && '@' != *p && '$' != *p) {
            return (FALSE);
        }
        else {
            p++;
        }
    }
    return (TRUE);

}   // End of CSyntaxLib::IsCommand().


BOOL CSyntaxLib::IsKeywordMonitor(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Module".
    return ( 0 == stricmp(pszArgv, "MONITOR") ) ? TRUE : FALSE;

}   // End of CSyntaxLib::IsKeywordMonitor().


BOOL CSyntaxLib::IsGoMonitorTimer(char* pszArgv) 
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );

    UINT i; 
    //int nValue;                   
    long lValue;
    if( '0' == pszArgv[0] && 'X' == toupper(pszArgv[1])) {
		if (2 == strlen(pszArgv)) return (FALSE);				    	
        for (i=0; i<strlen(pszArgv); i++) {
        	pszArgv[i] = pszArgv[i+2];
        }                               
    }
	else {
    	char* pszStopStr;
		lValue = strtol(pszArgv,&pszStopStr, 10);
    	_ltoa(lValue,pszArgv,16);    
    }	                   
    
    // Is "FF".
    char* p = pszArgv;
    while ( *p ) {
        if ( !isxdigit(*(p++)) ) {
            return (FALSE);
        }
    }
    
    unsigned long ul = StrToVar(pszArgv);
    if ( ul <= 0ul || ul > 0x0FFul ) {
        return (FALSE);
    }
    else {    	
        return (TRUE);
    }

}   // End of CSyntaxLib::IsMonitorTimer().


BOOL CSyntaxLib::IsKeywordControlOption(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Get control option keyword.
    CString strReset, strEa, strEben;
    ::GetControlOption(strReset,strEa,strEben);
    
    // Is "Reset|Ea|Eben".
    if ( !strReset.IsEmpty() && !strReset.CompareNoCase(pszArgv) ) {
        return (TRUE);
    }
    else if ( !strEa.IsEmpty() && !strEa.CompareNoCase(pszArgv) ) {
        return (TRUE);
    }
    else if ( !strEben.IsEmpty() && !strEben.CompareNoCase(pszArgv) ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }
    
}   // End of CSyntaxLib::IsKeywordControlOption().

//Add by Annie, 3/7/96
BOOL CSyntaxLib::IsDiagnosisOption(int nArgc, char* pszArgv[])
{
     // Assertion of the input parameters.
    ASSERT( nArgc > 1 );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    int nPio = FALSE;
    int nMap = FALSE;
	int nEventaddr = FALSE;
	int nEventdata = FALSE;
	int nSpoon = FALSE;
	int nEmulation = FALSE;
	int nTrace = FALSE;
	     
    for ( i = 1; i < nArgc; i++ ) {
        CString str = strupr(pszArgv[i]);
        if ( str == "PIO") {
			if (nPio == FALSE)
				nPio = TRUE;
			else 
				return (FALSE); 
        }
        else if (str == "MAP"){
      		if (nMap == FALSE)
      			nMap = TRUE;		  
			else 
				return (FALSE); 
        }
        else if (str == "EVENTADDR"){ 
        	if (nEventaddr == FALSE)
        		nEventaddr = TRUE;        	 
			else 
				return (FALSE); 
        }
        else if (str == "EVENTDATA"){
        	if (nEventdata == FALSE)
        		nEventdata = TRUE;        	 
			else 
				return (FALSE); 
        }
        else if (str == "SPOON"){
           	if (nSpoon == FALSE)
        		nSpoon = TRUE;        	 
			else 
				return (FALSE); 
		}
        else if (str == "EMULATION"){
           	if (nEmulation == FALSE)
	       		nEmulation = TRUE;        	 
			else 
				return (FALSE); 
        }
        else if (str == "TRACE"){
        	if (nTrace == FALSE)
        		nTrace = TRUE;        	 
			else 
				return (FALSE); 
        }
        else {
            return (FALSE);
        }
    } 
    return (TRUE);
}

BOOL CSyntaxLib::IsKeywordFly(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Run".
    if ( 0 == stricmp(pszArgv, "FLY") ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }

}   // End of CSyntaxLib::IsKeywordFly().

BOOL CSyntaxLib::IsHexAddr(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    char* p = pszArgv;
	
	if ('#' != pszArgv[2]) {
		if ( AdrIsOk(pszArgv)) 
			return (TRUE);
		else return (FALSE);
	}
	else {
	   	return (FALSE);
    }
	return (TRUE);
}   //End of CSyntaxLib::IsHexAddr

BOOL CSyntaxLib::IsMacroName(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );      
    // Is "filename".
    if ( strlen(pszArgv) >= _MAX_PATH ) {
        return (FALSE);
    }

    if ( strchr(pszArgv, ',') ||
         strchr(pszArgv, '=') ||
         strchr(pszArgv, '+') ||
         strchr(pszArgv, '|') ||
         strchr(pszArgv, '[') ||
         strchr(pszArgv, ']') ||
         strchr(pszArgv, ';') ||
         strchr(pszArgv, '\"')||
         strchr(pszArgv, '<') ||
         strchr(pszArgv, '>') ||
         strchr(pszArgv, '*') ||
         strchr(pszArgv, '?') ) {
        return (FALSE);
    }
      
    // Local driver: "..." invalid.
    // Netware driver: "..." valid.
    //if ( strstr(pszArgv, "...") ) {
    //    return (FALSE);
    //}
        
    if ( strstr(pszArgv, "\\\\") ||
         strstr(pszArgv, "//")   ||
         strstr(pszArgv, "\\/")  ||
         strstr(pszArgv, "/\\") ) {
        return (FALSE);
    }
    
    char pszDrive[_MAX_DRIVE];
    char pszDir[_MAX_DIR];
    char pszFname[_MAX_FNAME];
    char pszExt[_MAX_EXT];

    _splitpath(pszArgv, pszDrive, pszDir, pszFname, pszExt);

    //DumpText(pszDrive);
    //DumpText(pszDir);
    //DumpText(pszFname);
    //DumpText(pszExt);

    if ( strchr(pszDir, ':')   ||
         strchr(pszFname, ':') ||
         strchr(pszExt, ':') ) {
        return (FALSE);
    }
    
    if ( *pszDrive && 
         !(*pszDrive >= 'A' && *pszDrive <= 'Z') &&
         !(*pszDrive >= 'a' && *pszDrive <= 'z') ) {
        return (FALSE);
    }
    
    if ( strchr(pszFname, '.') ) {
        return (FALSE);
    }                            
    
    if (strlen(pszFname) > 8 ) {
        return (FALSE);
    }                            
    
    if ( 0 == stricmp(pszFname, "ALL") && !*pszExt) {
		return (FALSE);    
    }
    
    if ( !*pszFname ) {
        return (FALSE);
    }
    
    return (TRUE);

}                    

BOOL CSyntaxLib::IsMacroVarName(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
	
    // Is "$xxx".
    if ( strlen(pszArgv) < 2 ) {
        return (FALSE);
    }
    
    if ( '$' != pszArgv[0] ) {
        return (FALSE);
    }

    if ( !iscsymf(pszArgv[1]) ) {
        return (FALSE);
    }

    if ( '_' == pszArgv[1] && strlen(pszArgv) < 3 ) {
        return (FALSE);
    }
    
    BOOL isUnderscore = FALSE;
    char* p = pszArgv+1;
    if ( '_' == *p ) {
        isUnderscore = TRUE;
    }
            
    while ( *p ) {
        if ( !iscsym(*p) && '?' != *p ) {
            return (FALSE);
        }
        else if ( '_' != *(p++) ) {
            isUnderscore = FALSE;
        }
    }

    if ( isUnderscore ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

}

BOOL CSyntaxLib::IsCommandName(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );         
 	if ( 20 < strlen(pszArgv) ) {
 		return (FALSE);
 	}                  
	
	char* p = pszArgv;
	while (*p) {
	    if ( !isalnum(*p)  ) {
            return (FALSE);
        }
		p++;
	} 	
    return (TRUE);
}    

void CSyntaxLib::DisplayError(void)
{
/*
    // Assertion of the input parameters.
    ASSERT( m_nErrorID > NO_ERROR && m_nErrorID < MAX_ERROR );
    
    // Display the special error message.     
    
    char* pszErrorMsg[] = {
        "",
        "The address is out of range.", 
        "The length is out of range.",
        "The length is invalid.",  
        "The address is invalid.",
        "The address type is error.", 
        "Map address boundary error.",
        "The map attribute is error.",
        "The register name is invalid.",
        "The data is out of range.",
        "The data is invalid.",
        "The file name is invalid.",
        "The module name is invalid.",        
        "The variable name is invalid.",
        "The symbol name is invalid.",        
        "The count is invalid.",
        "The count is out of range.",
		"The port is invalid.",        
    };
    
	
	char* pszErr = new char[260];
    //ErrGetErrorText(ER_LIB_BASE + m_nErrorID, pszErr);
    ShowLine(pszErr);
	delete []pszErr;
	pszErr = 0;

	ShowLine(pszErrorMsg[m_nErrorID]);	    
*/
}   // End of CSyntaxLib:://DisplayError().

BOOL CSyntaxLib::IsEvent3Option(char* pszArgv) 
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     

    //Check "High", "Low"
    if ( 0 != stricmp(pszArgv, "HIGH") &&
         0 != stricmp(pszArgv, "LOW") ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }
                                    
}    //End of CSyntaxLib::IsEvent3Option().


BOOL CSyntaxLib::IsKeywordNumber(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     

    //Check "Buffer2"
    if ( 0 != stricmp(pszArgv, "NUMBER") ) {
        return (FALSE);
    }
    else {
		//g_ListCmdArg.bNumber = TRUE;    	
        return (TRUE);
    }
    
}   //End of CSyntaxLib::IsKeywordNumber(). 

/*
BOOL CSyntaxLib::AddrSfr(char* pszArgv1, char* pszArgv2, int &nRet)                                            
{
    // Assertion of the input parameters.
    
  	ADDR_RETCODE    retCode;
    ADDRESS         address;
    	
	retCode = AdrShellSFR(pszArgv1, address, pszArgv2);
    
    if ( ADR_OK == retCode) {
    	return (TRUE);
    }
    else {
		nRet = SYNTAX_ERROR;
        return (FALSE);
    }
                    
	return (TRUE);
}
*/

BOOL CSyntaxLib::IsKeywordAddress(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     

    //Check "Address"
    if ( 0 != stricmp(pszArgv, "ADDRESS") ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }
    
}   //End of CSyntaxLib::IsKeywordAddress(). 

BOOL CSyntaxLib::IsKeywordDatum(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     

    //Check "Datum"
    if ( 0 != stricmp(pszArgv, "DATUM") ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }
    
}   //End of CSyntaxLib::IsKeywordDatum(). 


BOOL CSyntaxLib::IsKeywordCount(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     

    //Check "Count"
    if ( 0 != stricmp(pszArgv, "COUNT") ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }
    
}   //End of CSyntaxLib::IsKeywordCount(). 


WORD CSyntaxLib::AddrToWord(char* pszArgv)
{

	WORD wAddr ;
	ADDRESS addr;
	
	AdrTextToAddr(pszArgv, addr, 1);
	wAddr = (WORD) addr.adrAddress;
	return wAddr;

}

BOOL CSyntaxLib::IsKeywordSymbols(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     

    //Check "Symbols"
    if ( 0 != stricmp(pszArgv, "SYMBOLS") ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

} 

BOOL CSyntaxLib::IsKeywordNosymbols(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     

    //Check "Nosymbols"
    if ( 0 != stricmp(pszArgv, "NOSYMBOLS") ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

} 


BOOL CSyntaxLib::IsKeywordCode(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     

    //Check "Code"
    if ( 0 != stricmp(pszArgv, "CODE") ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

} 

BOOL CSyntaxLib::IsKeywordNocode(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     

    //Check "Nocode"
    if ( 0 != stricmp(pszArgv, "NOCODE") ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

} 


BOOL CSyntaxLib::IsKeywordWarn(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     

    //Check "Warn"
    if ( 0 != stricmp(pszArgv, "WARN") ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

} 

BOOL CSyntaxLib::IsKeywordNowarn(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     

    //Check "Nowarn"
    if ( 0 != stricmp(pszArgv, "NOWARN") ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

} 


BOOL CSyntaxLib::IsListOptionSub(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     
    
    //Add by Annie, 3/11/96
    // Check "SOURCE", "ASSEMBLE", "MIXED" or "MODULE".
    if ( 0 != stricmp(pszArgv, "SOURCE") &&
         0 != stricmp(pszArgv, "ASSEMBLE") &&
         0 != stricmp(pszArgv, "MIXED") &&
         0 != stricmp(pszArgv, "MODULE") ) {
        return (FALSE);
    }
    else {       
        return (TRUE);
    }

}   // End of CSyntaxLib::IsListOptionSub().

BOOL CSyntaxLib::IsListFrameSub(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );               
    UINT i; 
    //int nValue;       
    long lValue;
    char* p = pszArgv;            

    if( '0' == pszArgv[0] && 'X' == toupper(pszArgv[1])) {
	    if (2 == strlen(pszArgv)) return (FALSE);				    	
	    p += 2;
	    while ( *p ) {
	        if ( !isxdigit(*(p++)) ) {
	            return (FALSE);
	        }
	    }
        for (i=0; i<strlen(pszArgv); i++) {
        	pszArgv[i] = pszArgv[i+2];
        }                               
    }
	else {
	    while ( *p ) {
	        if ( !isdigit(*(p++)) ) {
	            return (FALSE);
	        }
	    }           
    	char* pszStopStr;
		lValue = strtol(pszArgv,&pszStopStr, 10);
    	_ltoa(lValue,pszArgv,16);    
    }	                   
    
    // Is "7FFF".
    unsigned long ul = StrToVar(pszArgv);
    if ( ul < 0ul || ul > 0x07FFFul ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }
}   // End of CSyntaxLib::IsListFrameSub().

BOOL CSyntaxLib::IsKeywordOr(char* pszArgv) 
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     

    //Check "Or"
    if ( 0 != stricmp(pszArgv, "OR") ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }                             

}

BOOL CSyntaxLib::IsEventOption(char* pszArgv)  
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     

    //Check "1" or "2" or "3"
    if ( 0 != stricmp(pszArgv, "1") &&
    	 0 != stricmp(pszArgv, "2") &&
    	 0 != stricmp(pszArgv, "3") ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }                             

}

BOOL CSyntaxLib::IsKeywordMask(char* pszArgv) 
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     

    //Check "Mask"
    if ( 0 != stricmp(pszArgv, "MASK") ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }                             

}

BOOL CSyntaxLib::IsSingleEvent(char* pszArgv) 
{

    if ( 0 != stricmp(pszArgv, "EV1") &&
		 0 != stricmp(pszArgv, "EV2") &&
		 0 != stricmp(pszArgv, "EV3") ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }                             


}	

BOOL CSyntaxLib::IsAddrLen(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
	//Add by Annie, 3/19/96          
    // Is "length".
  	char* p;  
  	ADDR_RETCODE retCode;
  	ADDRESS address;
  	p = new char [ strlen(pszArgv)+1 ];
  	ASSERT( p );
  	strcpy(p,pszArgv);
  	retCode = AdrTextToAddr(p, address,0);
  	if ( p ) {
  		delete []p;
  		p = 0;
  	}	
  	if (ADR_OK == retCode) {
		if (SPACE_UNDEFINE == address.adrSpace )
			return (TRUE);
		else {
			return (FALSE);	          		        
		}	
  	}
  	else {
		return (FALSE);	        
	}	
}

BOOL CSyntaxLib::IsAddrAllP(char* pszArgv) 
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    char szArgv[256];
    strcpy(szArgv, pszArgv);

	if ( szArgv[1] != ':' && szArgv[2] != ':') {
		if ( IsPAddrDefault(szArgv) ) {
			return (TRUE);	
		}
		else {
			return (FALSE);				
		}                 
	}	
	else {
		if ( IsAddr(szArgv) ) {
			return (TRUE);	
		}
		else {
			return (FALSE);				
		}                 
	}
}

BOOL CSyntaxLib::IsAddrAllX(char* pszArgv) 
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    char szArgv[256];
    strcpy(szArgv, pszArgv);

	if ( szArgv[1] != ':' && szArgv[2] != ':') {
		if ( IsXAddrDefault(szArgv) ) {
			return (TRUE);	
		}
		else {
			return (FALSE);				
		}                 
	}	
	else {
		if ( IsAddr(szArgv) ) {
			return (TRUE);	
		}
		else {
			return (FALSE);				
		}                 
	}
}              

BOOL CSyntaxLib::IsAddrPX(char* pszArgv) 
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    char szArgv[256];
    strcpy(szArgv, pszArgv);

	if ( IsPAddrDefault(szArgv) || IsXAddr(szArgv) ) {
		return (TRUE);
	}
	else {
	    return (FALSE);
	}	                                          
}

BOOL CSyntaxLib::IsAddrXP(char* pszArgv) 
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    char szArgv[256];
    strcpy(szArgv, pszArgv);

	if ( IsXAddrDefault(szArgv) || IsPAddr(szArgv) ) {
		return (TRUE);
	}
	else {
	    return (FALSE);
	}	                                          
}

BOOL CSyntaxLib::IsAddrXPI(char* pszArgv) 
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    char szArgv[256];
    strcpy(szArgv, pszArgv);

	if ( IsXAddrDefault(szArgv) || 
		 IsPAddr(szArgv) ||
		 IsIAddr(szArgv) ) {
		return (TRUE);
	}
	else {
	    return (FALSE);
	}	                                          
}
                                      
BOOL CSyntaxLib::IsKeywordStatus(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "Status".
    if ( 0 == stricmp(pszArgv, "STATUS") ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }
}                      

BOOL CSyntaxLib::IsStatusOption(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "S", "F", "R", "W" or "AK".
    if ( 0 == stricmp(pszArgv, "S") ||
    	 0 == stricmp(pszArgv, "F") ||
    	 0 == stricmp(pszArgv, "R") ||
    	 0 == stricmp(pszArgv, "W") ||
    	 0 == stricmp(pszArgv, "AK") ) {
        return (TRUE);
    }
    else {
        return (FALSE);
    }
}                      

BOOL CSyntaxLib::IsMapAttr(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Is "attribute".
    if ( !stricmp(pszArgv, "OVERLAY") ) {
        return (TRUE);
    }
    else if ( !stricmp(pszArgv, "OR")) {
        return (TRUE);
    }
    else if ( !stricmp(pszArgv, "GUARD") ) {
        return (TRUE);
    }
    else if ( !stricmp(pszArgv, "TARGET") ) {
        return (TRUE);
    }
    else if ( !stricmp(pszArgv, "TR") ) {
        return (TRUE);
    }
    else if ( !stricmp(pszArgv, "COMBINATION") ) {
        return (TRUE);
    }
    else if ( !stricmp(pszArgv, "CR") ) {
        return (TRUE);
    }
    else {
		//Error handle
		m_nErrorID = MAP_ATTR_ERROR;
		//DisplayError();
        return (FALSE);
    }
}

BOOL CSyntaxLib::IsKeywordDemand(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     

    //Check "Demand"
    if ( 0 != stricmp(pszArgv, "DEMAND") ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

} 

BOOL CSyntaxLib::IsKeywordNodemand(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     

    //Check "Nodemand"
    if ( 0 != stricmp(pszArgv, "NODEMAND") ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

} 
                                        
                                        
BOOL CSyntaxLib::IsKeywordP(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     

    //Check "P:"
    if ( 0 != stricmp(pszArgv, "P:") ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

} 

BOOL CSyntaxLib::IsKeywordX(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );     

    //Check "X:"
    if ( 0 != stricmp(pszArgv, "X:") ) {
        return (FALSE);
    }
    else {
        return (TRUE);
    }

} 
                                      
BOOL CSyntaxLib::IsLoadOptionSub(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( nArgc > 2 );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    int nSymbols = FALSE, nNoSymbols = FALSE;
    int nCode = FALSE, nNoCode = FALSE;
    int nDemand = FALSE, nNoDemand = FALSE;
    int nWarm = FALSE, nNoWarm = FALSE;
    int nModule = FALSE;
    int nType = FALSE;
    
    // Is "LOAd filename [option]".
    for ( i = 2; i < nArgc; i++ ) {
        CString str = strupr(pszArgv[i]);
        if ( str == "NOSYMBOLS" ) {
            nNoSymbols = TRUE;
        }
        else if ( str == "SYMBOLS" ) {
            nSymbols = TRUE;
        }
        else if ( str == "NOCODE" ) {
            nNoCode = TRUE;
        }
        else if ( str == "CODE" ) {
            nCode = TRUE;
        }
        else if ( str == "NODEMAND" ) {
            nNoDemand = TRUE;
        }
        else if ( str == "DEMAND" ) {
            nDemand = TRUE;
        }
        else if ( str == "NOWARN" ) {
            nNoWarm = TRUE;
        }
        else if ( str == "WARN" ) {
            nWarm = TRUE;
        }
        else if ( str == "MODULE" ) {
			if ( i < nArgc-1 && IsModuleName(pszArgv[i++]) ) {        
            	nModule = TRUE;
            }
            else if ( i == (nArgc-1) ) {
				nModule = TRUE;            
            } 	
            else {
                return (FALSE);
            }
        }
        else if ( IsMapMemType(pszArgv[i]) ) {
            if ( TRUE == nType ) {
                return (FALSE);
            }
            nType = TRUE;
        }
        else {
            return (FALSE);
        }
    }
    if ( nSymbols && nNoSymbols ) {
        return (FALSE);
    }
    if ( nCode && nNoCode ) {
        return (FALSE);
    }
    if ( nDemand && nNoDemand ) {
        return (FALSE);
    }
    if ( nWarm && nNoWarm ) {
        return (FALSE);
    }
    
    return (TRUE);
}

BOOL CSyntaxLib::IsListAddr(char* pszArgv)
{
	if ( pszArgv[0] == 'B' || pszArgv[0] == 'b' ) {
		return  FALSE;
	}	         
	else {
		return TRUE;
	}

}
//////////////////////////////// End of File ////////////////////////////////
