
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/TRCFIDLG.CPP   1.2.1.4   17 Apr 1997 16:06:54   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/TRCFIDLG.CPP  $
** 
**    Rev 1.2.1.4   17 Apr 1997 16:06:54   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:41:46   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:47:36   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:26:46   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:30:04   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:39:24   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:52:38   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:16:52   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 13:00:08   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.1   28 Aug 1996 15:51:00   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:54:50   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:57:50   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:34:40   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:00:06   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:16:40   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:31:00   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:57:44   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:41:26   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:56:24   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:07:42   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:34:10   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:48:22   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:12:42   Shirley
** EasyPack/SLD Version 0.35b
** 
**    Rev 1.18   15 Jan 1996 16:11:32   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:12:30   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:11:48   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:29:04   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:21:18   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:24:34   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:28:52   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:28:12   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:41:26   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:03:24   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:46:34   Shirley
** EasyPack/SLD Version 0.1h
** 
**    Rev 1.7   27 Oct 1995 13:45:34   Shirley
** EasyPack/SLD Version 0.1g
** 
**    Rev 1.4   13 Oct 1995 13:20:46   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:51:32   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:54:34   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:49:04   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:54:12   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  TRCFIDLG.CPP
//
//  Description:The implement file for the class: CTrcFiDlg
//
//  Author:     Lane Li, Chris Fang
//
//  Date:       09/10/95
//
//  Modification:
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

// trcfidlg.cpp : implementation file
//

#include "stdafx.h"
#include "xview.h"
#include "spin.h"
#include "myedit.h"
#include "trcfidlg.h"
#include "trcserve.h"
#include "uicom.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern int SrcIsLoaded(void);

/////////////////////////////////////////////////////////////////////////////
// CTrcFiDlg dialog


CTrcFiDlg::CTrcFiDlg(CWnd* pParent /*=NULL*/)
    : CFileDialog(FALSE, NULL, NULL, OFN_OVERWRITEPROMPT, "Trace Data [*.trc]|*.trc|All File [*.*]|*.*||", pParent)
{
    //{{AFX_DATA_INIT(CTrcFiDlg)
        // NOTE: the ClassWizard will add member initialization here
    //}}AFX_DATA_INIT
    CMyEdit::m_edit1=NULL;
    CMyEdit::m_edit2=NULL;
    m_ofn.lpstrTitle = "Save Trace";
    m_nIDHelp = IDD_SAVE_TRACE;
}                                         

void CTrcFiDlg::DoDataExchange(CDataExchange* pDX)
{
    CFileDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CTrcFiDlg)
        // NOTE: the ClassWizard will add DDX and DDV calls here
    //}}AFX_DATA_MAP
}

void CTrcFiDlg::OnOK()
{   
int i;                
BOOL bOk;
long value;
char buf[20];
char buf2[20];

    i = GetCheckedRadioButton(IDC_SAVETRACEDLG_BUS,
        IDC_SAVETRACEDLG_MIXED);
    if (i==IDC_SAVETRACEDLG_BUS)
        m_nTraceMode=1;
    else if (i==IDC_SAVETRACEDLG_INSTRUCTION)
        m_nTraceMode=2;
    else if (i==IDC_SAVETRACEDLG_SOURCE)
        m_nTraceMode=3;
    else
    	m_nTraceMode=4;
        
    bOk=TRUE;
    GetDlgItemText(IDC_SAVETRACEDLG_EDIT1,buf,10);
    buf[10]='\0';
    if ((buf[0]=='0')&&((buf[1]=='x')||(buf[1]=='X')))
    {
        value = strtol(buf,NULL,16);
        if ((value>0xffff)||(value<0)) bOk = FALSE;
		_ultoa(value,buf2 , 16);
		if (lstrcmpi(buf2,buf+2)!=0)
			bOk = FALSE;
		if (bOk) m_nSaveStart = (int)value;
    }                     
    else
    {
        value = strtol(buf,NULL,10);
        if ((value>0xffff)||(value<0)) bOk = FALSE;
		_ultoa(value,buf2 , 10);
		if (lstrcmpi(buf2,buf)!=0)
			bOk = FALSE;
		if (bOk) m_nSaveStart = (int)value;
//        m_nSaveStart = GetDlgItemInt(IDC_SAVETRACEDLG_EDIT1, &bOk);
    }               
    if (!bOk)
    {
        MessageBox("Input Error","Save Trace",MB_OK|MB_ICONEXCLAMATION);
        m_parseEditStart.SetFocus();
        m_parseEditStart.SetSel(0,-1);
        return;
    }

    bOk=TRUE;
    GetDlgItemText(IDC_SAVETRACEDLG_EDIT2,buf,10);
    buf[10]='\0';
    if ((buf[0]=='0')&&((buf[1]=='x')||(buf[1]=='X')))
    {
        value = strtol(buf,NULL,16);
        if ((value>0xffff)||(value<0)) bOk = FALSE;
		_ultoa(value,buf2 , 16);
		if (lstrcmpi(buf2,buf+2)!=0)
			bOk = FALSE;
		if (bOk) m_nSaveEnd = (int)value;
    }                     
    else
    {
        value = strtol(buf,NULL,10);
        if ((value>0xffff)||(value<0)) bOk = FALSE;
		_ultoa(value,buf2 , 10);
		if (lstrcmpi(buf2,buf)!=0)
			bOk = FALSE;
		if (bOk) m_nSaveEnd = (int)value;
//        m_nSaveEnd = GetDlgItemInt(IDC_SAVETRACEDLG_EDIT2, &bOk);
    }               
    if (!bOk)
    {
        MessageBox("Input Error","Save Trace",MB_OK|MB_ICONEXCLAMATION);
        m_parseEditEnd.SetFocus();
        m_parseEditEnd.SetSel(0,-1);
        return;
    }
                  
    if (m_nSaveStart>m_nSaveEnd)
    {
        MessageBox("Input Error","Save Trace",MB_OK|MB_ICONEXCLAMATION);
        m_parseEditEnd.SetFocus();
        m_parseEditEnd.SetSel(0,-1);
        return;
    }                  
    
    Default();
//  EndDialog(1);
}

BEGIN_MESSAGE_MAP(CTrcFiDlg, CFileDialog)
    //{{AFX_MSG_MAP(CTrcFiDlg)
    ON_WM_CREATE()
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CTrcFiDlg message handlers

int CTrcFiDlg::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    if (CFileDialog::OnCreate(lpCreateStruct) == -1)
        return -1;
    
    // TODO: Add your specialized creation code here
    RECT 	rect;
    long 	x,y;                      
	GetWindowRect(&rect);
	x=rect.right-rect.left;
	y=(rect.bottom-rect.top)*3/2;
    
    m_950125_x=x;
    m_950125_y=y;
    SetWindowPos(NULL, 0,0,int(x), int(y), SWP_NOMOVE | SWP_NOZORDER);

    rect.left =int(x*12/472);
    rect.top = int(y*222/350);
    rect.right = int(x*140/472);
    rect.bottom = int(y*310/350);
    m_frameTraceMode.Create("Trace Mode",
                            WS_VISIBLE | WS_CHILD | SS_BLACKFRAME, 
                            rect,
                            this,
                            IDC_SAVETRACEDLG_TRACEMODE);

    rect.left = int(x*17/472);
    rect.top =  int(y*215/350);
    rect.right = int(x*100/472);
    rect.bottom = int(y*235/350);
    m_frameTraceModeText.Create("Trace Mode",
                            WS_VISIBLE | WS_CHILD | SS_LEFT, 
                            rect,
                            this,
                            IDC_SAVETRACEDLG_TRACEMODE);

    rect.left = int(x*160/472);
    rect.top =  int(y*222/350);
    rect.right = int(x*354/472);
    rect.bottom = int(y*310/350);
    m_frameFrameRange.Create("Frame Range",
                            WS_VISIBLE | WS_CHILD | SS_BLACKFRAME,
                            rect,
                            this,
                            IDC_SAVETRACEDLG_FRAMERANGE);

    rect.left = int(x*165/472);
    rect.top =  int(y*215/350);
    rect.right = int(x*260/472);
    rect.bottom = int(y*235/350);
    m_frameFrameRangeText.Create("Frame Range",
                            WS_VISIBLE | WS_CHILD | SS_LEFT,
                            rect,
                            this,
                            IDC_SAVETRACEDLG_FRAMERANGE);
                            
    rect.left = int(x*185/472);
    rect.top =  int(y*240/350);
    rect.right = int(x*230/472);
    rect.bottom = int(y*265/350);
    m_labelStart.Create("Start",
                            WS_VISIBLE | WS_CHILD,
                            rect,
                            this,
                            IDC_SAVETRACEDLG_START);
                            
    rect.left = int(x*185/472);
    rect.top =  int(y*276/350);
    rect.right = int(x*230/472);
    rect.bottom = int(y*301/350);
    m_labelEnd.Create("End",
                            WS_VISIBLE | WS_CHILD,
                            rect,
                            this,
                            IDC_SAVETRACEDLG_END);

    rect.left = int(x*30/472);
    rect.top =  int(y*235/350);
    rect.right = int(x*130/472);
    rect.bottom = int(y*253/350);
    m_radioBus.Create("Bus",
                      WS_VISIBLE | WS_CHILD | BS_AUTORADIOBUTTON,
                      rect,
                      this,
                      IDC_SAVETRACEDLG_BUS);
                        
    rect.left = int(x*30/472);
    rect.top =  int(y*253/350);
    rect.right = int(x*130/472);
    rect.bottom = int(y*271/350);
    m_radioInstruction.Create("Instruction",
                      WS_VISIBLE | WS_CHILD | BS_AUTORADIOBUTTON,
                      rect,
                      this,
                      IDC_SAVETRACEDLG_INSTRUCTION);

    rect.left = int(x*30/472);
    rect.top =  int(y*271/350);
    rect.right = int(x*130/472);
    rect.bottom = int(y*289/350);
    m_radioSource.Create("Source",
                      WS_VISIBLE | WS_CHILD | BS_AUTORADIOBUTTON,
                      rect,
                      this,
                      IDC_SAVETRACEDLG_SOURCE);

    rect.left = int(x*30/472);
    rect.top =  int(y*289/350);
    rect.right = int(x*130/472);
    rect.bottom = int(y*307/350);
    m_radioMixed.Create("Mixed",
                      WS_VISIBLE | WS_CHILD | BS_AUTORADIOBUTTON,
                      rect,
                      this,
                      IDC_SAVETRACEDLG_MIXED);
                      
    rect.left = int(x*230/472);
    rect.top =  int(y*234/350);
    rect.right = int(x*300/472);
    rect.bottom = int(y*257/350);
    m_parseEditStart.Create(WS_VISIBLE | WS_CHILD | WS_BORDER |WS_TABSTOP,
                       rect,
                       this,
                       IDC_SAVETRACEDLG_EDIT1);

    rect.left = int(x*230/472);
    rect.top =  int(y*271/350);
    rect.right = int(x*300/472);
    rect.bottom = int(y*294/350);
    m_parseEditEnd.Create(WS_VISIBLE | WS_CHILD | WS_BORDER |WS_TABSTOP,
                     rect,
                     this,
                     IDC_SAVETRACEDLG_EDIT2);
                                               
//  SetDlgItemInt(IDC_SAVETRACEDLG_EDIT1,0);                                               
//  SetDlgItemInt(IDC_SAVETRACEDLG_EDIT2,0);                                               
    SetDlgItemText(IDC_SAVETRACEDLG_EDIT1,"0x0");
    SetDlgItemText(IDC_SAVETRACEDLG_EDIT2,"0x0");
    return 0;
}

BOOL CTrcFiDlg::OnInitDialog()
{
    CFileDialog::OnInitDialog();
    CenterWindow();
    
    // TODO: Add extra initialization here 
    char buf[20];
    
    if(SrcIsLoaded())
    {
    	GetDlgItem(IDC_SAVETRACEDLG_MIXED)->EnableWindow(FALSE);
    	GetDlgItem(IDC_SAVETRACEDLG_SOURCE)->EnableWindow(FALSE);
    }
    CheckRadioButton(IDC_SAVETRACEDLG_BUS,
                     IDC_SAVETRACEDLG_MIXED,
                     IDC_SAVETRACEDLG_BUS);

    m_parseEditStart.SubclassEdit2((UINT)IDC_SAVETRACEDLG_EDIT1, this, PES_NUMBERS);
    m_parseEditStart.SetRange(0,100);              
    m_parseEditEnd.SubclassEdit2((UINT)IDC_SAVETRACEDLG_EDIT2, this, PES_NUMBERS);
    m_parseEditEnd.SetRange(0,100);

    UINT lastFrame;
    int nErrorID = ICE_OK;
    if(g_bTraceClear)
    	lastFrame=0;
    else
    	AbiGetTraceLastFrame(&lastFrame);
    if (ICE_OK != nErrorID)
    {
        lastFrame = 0;
    }                     
    if (lastFrame>0) lastFrame--;
    if (lastFrame>32767) lastFrame = 32767;
    if (lastFrame>1) 
    {
        m_parseEditStart.SetRange(0,(int)lastFrame);              
        m_parseEditEnd.SetRange(0,(int)lastFrame);
        sprintf(buf,"0x%x",(int)lastFrame);
        SetDlgItemText(IDC_SAVETRACEDLG_EDIT2,buf);                                               
    }
    else 
    {
        m_parseEditStart.SetRange(0,0);              
        m_parseEditEnd.SetRange(0,0);
        SetDlgItemText(IDC_SAVETRACEDLG_EDIT2,"0x0");                                               
    }


    CRect rect1(int(m_950125_x*300/472),
    			int(m_950125_y*234/350),
    			int(m_950125_x*320/472),
    			int(m_950125_y*257/350));   
    CRect rect2(int(m_950125_x*300/472),
    			int(m_950125_y*271/350),
    			int(m_950125_x*320/472),
    			int(m_950125_y*294/350));   
    m_spinStart.Create(WS_VISIBLE | WS_CHILD | MSS_VERTICAL,
        rect1,this,IDC_SAVETRACEDLG_EDIT1);
    m_spinStart.SetAssociate(&m_parseEditStart);
    m_spinEnd.Create(WS_VISIBLE | WS_CHILD | MSS_VERTICAL,
        rect2,this,IDC_SAVETRACEDLG_EDIT2);
    m_spinEnd.SetAssociate(&m_parseEditEnd);
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}
