
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/TSTHELP.CPP   1.2.1.4   17 Apr 1997 16:08:10   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/TSTHELP.CPP  $
** 
**    Rev 1.2.1.4   17 Apr 1997 16:08:10   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:43:10   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:48:22   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:27:30   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:30:48   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:40:04   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:53:02   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:17:32   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 13:00:46   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:21:52   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:33:20   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 10:00:24   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:50:12   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:54:14   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.7   11 Jun 1996 10:28:38   ZJRD
** EasyPack/SLD Version 1.97
** 
**    Rev 1.5   05 Jun 1996 14:57:16   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:38:00   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:01:16   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:15:32   ZJRD
** EasyPack/SLD Version 1.93
** 
**    Rev 1.1   02 May 1996 10:29:52   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:02:18   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:41:10   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:56:10   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:07:28   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:33:56   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:47:50   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:19:06   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:14:18   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:14:12   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:33:04   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:26:50   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:11:38   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:13:12   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:11:16   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.16   30 Nov 1995 09:15:04   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:29:36   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:21:50   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:23:30   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:34:26   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:32:22   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:41:46   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:07:28   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:47:06   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:48:18   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:29:34   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:48:06   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:21:38   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:53:30   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:58:18   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:12   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:04   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: TSTHELP.CPP
//
//  Description: The implementation file for the class: CHelp.
//
//  Author: Chen Jun
//
//  Date: 06/22/95
//
//  Modification:
//      1. 06/22/95, Initial version of the class: CHelp.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"
                     
#include "shlcom.h"                     
#include "tsthelp.h"
#include "aliaspub.h"
#include "hosterrs.h"

/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.
/*extern struct {
    char* pszCommandName;
    int nMinKeyword;
}extern tagCmdTable CommandRecord[];*/
//Add by Annie, 4/1/96
//extern tagCmdTable* CommandRecord;

// Maximum number of command.
//extern int nMaxCmdNo;


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void HelpCmd(int nArgc, char* pszArgv[]);


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.


/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   HelpCmd().
//
//  Description: The main control routine of Help command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////

void HelpCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 1 == nArgc || 2 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }         
    	    
    // Execute Help command.
    CHelp* pHelp = new CHelp;
    if ( !pHelp ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
        pHelp->HelpAction(nArgc, pszArgv);
        delete pHelp;
    }
    
//    CHelp objHelp;
//    objHelp.HelpAction(nArgc, pszArgv);

}   // End of HelpCmd().


/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CHelp.

// Construction.
CHelp::CHelp()
{
    // Command list help file.
    extern char szAppPath[];
    m_strFileName = szAppPath;
    m_strFileName += "CMDLIST.DAT";
    m_nOpenFlag |= CFile::modeRead;
    
    // Allocate a space.
    m_pszOneLine = new char[maxChar+1];
    if ( !m_pszOneLine ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    
    // Initial.
    m_isSingleCmd = FALSE;
    m_strCommand.Empty();

}   // End of CHelp::CHelp().


// Destruction.
CHelp::~CHelp()
{
    // Release the allocated space.
    if ( m_pszOneLine ) {
        delete []m_pszOneLine;
    }

}   // End of CHelp::~CHelp().


// Help command.
void CHelp::HelpAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 1 == nArgc || 2 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Parse the parameters.
    switch ( nArgc ) {
        case 1:
            break;
        case 2:
            m_isSingleCmd = TRUE;
            m_strCommand = strlwr((pszArgv[1]));
            break;
        default:
            ASSERT( FALSE );
            break;
    }
    
    // Call the Help kernel.
    HelpKernel();

}   // End of CHelp::HelpAction().


// Help kernel routine.
void CHelp::HelpKernel(void)
{
    // Assertion of the input parameters.
    ASSERT( NO_ERROR == m_nErrorID );
    ASSERT( m_pszOneLine );
    if ( !m_pszOneLine ) {
        return;
    }
    
    // Search the command keyword table.
    int nIndex;
    if ( m_isSingleCmd ) {
    /*
        for ( nIndex = 0; nIndex < ::nMaxCmdNo; nIndex++ ) {
            CString strTable(CommandRecord[nIndex].pszCommandName);
            strTable.MakeLower();
            if ( m_strCommand == strTable ) {
                break;
            }
        }
        if ( ::nMaxCmdNo == nIndex ) {
            ShowLine("No such command.");
            return;
        }                           
    }*/
		int nRet = GetCommandId(m_strCommand);
		if (nRet == CCommandSet::NO_COMMAND) {
			//ShowLine("No such command.");
	        char pchText[256];
	        ErrGetErrorText(ER_NO_SUCH_COMMAND, pchText);
	        ShowLine(pchText);

            return;			
		}    	   
		else {
			nIndex = nRet;			
		}               
	}	
    
    // Open the help contents file: CMDLIST.HLP
    OpenFile();
    if ( NO_ERROR != m_nErrorID ) {
        //ShowLine("CMDLIST.DAT cannot be opened.");
        char pchText[256];
        ErrGetErrorText(ER_NO_CMDLIST, pchText);
        ShowLine(pchText);

        return;
    }
    
    // Read one line help contents and display it.
    m_pszLineBuf = m_pszOneLine;
    int nCmdCount = -1;
    do {
        ReadFromFile();
        if ( NO_ERROR != m_nErrorID ) {
            if ( FILE_END != m_nErrorID ) {
                DisplayErrorMessage();
                return;
            }
            break;
        }
        else {
            if ( m_isSingleCmd ) {
                if ( ' ' != *m_pszOneLine ) {
                    nCmdCount++;
                }
                if ( nCmdCount == nIndex ) {
                    ShowLine(m_pszOneLine);
                }
            }
            else {
                ShowLine(m_pszOneLine);
            }
        }
    } while ( TRUE );
    
    // Close the help contents file: CMDLIST.HLP
    m_nErrorID = NO_ERROR;
    CloseFile();

}   // End of CHelp::HelpKernel().


//////////////////////////////// End of File ////////////////////////////////
