
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/ZLIST.H__   1.2.1.4   17 Apr 1997 16:10:08   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/ZLIST.H__  $
** 
**    Rev 1.2.1.4   17 Apr 1997 16:10:08   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:46:28   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:49:56   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:28:56   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:32:16   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:41:24   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:54:08   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:15:44   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:59:00   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:17:10   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:28:42   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:55:46   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:49:32   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:53:46   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:56:54   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:30:24   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:07:42   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:09:14   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:25:10   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:59:50   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:35:10   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:50:24   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:05:06   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:31:40   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:44:50   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:17:38   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:15:46   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:15:40   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:37:36   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:23:04   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:12:32   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:15:32   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:09:18   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.16   30 Nov 1995 09:12:56   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:35:14   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:24:28   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:25:22   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:28:20   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:29:06   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:41:38   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:07:22   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:47:00   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:48:10   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:29:26   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:50:58   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:18:48   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:52:00   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:57:56   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:26   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:55:16   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  ZLIST.H
//
//  Description:The header file for the class: SingleList.
//
//  Author:     Roger Zhang
//
//  Date:       05/06/95
//
//  Modification:
//
//      1. 05/06/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _ZLIST_
#define _ZLIST_

/////////////////////////////////////////////////////////////////////////////
//  for diagnostics
/////////////////////////////////////////////////////////////////////////////
#ifdef _FDEBUG
extern FILE * pSListDebug;             
#endif                                                                       

/////////////////////////////////////////////////////////////////////////////                                      
//  Return Code
/////////////////////////////////////////////////////////////////////////////
enum { ELIST_OK, ELIST_FAIL, ELIST_EMPTY, ELIST_FULL, ELIST_MEM };

/////////////////////////////////////////////////////////////////////////////
//  Single Linked List
/////////////////////////////////////////////////////////////////////////////

/////////////////////////// Element of the list /////////////////////////////
class SListElement
{   
// constructor/destructor
public:
    virtual ~SListElement(void) {}
    
// diagnostics
public:
#ifdef _DEBUG
    virtual void Dump(void) const {}    
#endif
};

///////////////////////// Node of the list //////////////////////////////////
class SListNode
{      
// attributes
public:
    SListNode    * m_pNext;
    SListElement * m_pElem;  
    
// constructor/destructor
public:
    SListNode(void) : m_pNext(0), m_pElem(0) {}
    SListNode(SListElement * pElem) : m_pNext(0), m_pElem(pElem) {}
    virtual ~SListNode(void);
    
// diagnostics
public:
#ifdef _DEBUG
    virtual void Dump(void) const;    
#endif
};

//////////////////////// Class SingleList ///////////////////////////////////
class SingleList
{                       
// attributes
public:
    SListNode    * m_pHead;
    SListNode    * m_pTail;                                  
    
    long    m_lCount;		// number of elements in the list
    long    m_lMax;         // max number of elements allowed          
    
    SListNode   * m_pIdx;	// pointer to the first node
    
// constructor/destructor
public:
    SingleList(long lMax = 0x7FFFFFFFL) 
    : m_lMax(lMax), m_pHead(0), 
      m_pTail(0), m_lCount(0) { }
    virtual ~SingleList();
                                                        
// operations                                                        
public:
    int IsEmpty(void) const { return m_lCount == 0; }
    int IsFull(void) const { return m_lCount == m_lMax; } 
    long GetCount(void) const { return m_lCount; }
    
    int Clean(void);        
    int AddTail(SListElement * pElem);
    
    SListElement * GetFirst(void);
    SListElement * GetNext(void);
    SListElement * Get(void);
    BOOL Set(SListNode * pIdx);
    BOOL Set(long lIdx);

// diagnostics
public:
#ifdef _DEBUG
    virtual void Dump(void) const;    
#endif
};

#endif
///////////////////////////////(EOF)/////////////////////////////////////////
