/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/AA.CPP   1.2.1.5   17 Apr 1997 15:40:24   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/AA.CPP  $
** 
**    Rev 1.2.1.5   17 Apr 1997 15:40:24   ZJRD
** No change.
** 
**    Rev 1.2.1.4   16 Apr 1997 10:10:40   ZJRD
** No change.
** 
**    Rev 1.2.1.3   10 Apr 1997 15:26:12   ZJRD
** 2.09F
** 
**    Rev 1.2.1.1   03 Apr 1997 15:08:20   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:13:04   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:24:06   ZJRD
** Easy Pack SLD 2.09c
** 
**    Rev 1.5.1.0.1.2   09 Dec 1996 10:17:22   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.5.1.0.1.0   11 Nov 1996 13:00:36   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.5.1.4   09 Sep 1996 13:21:28   ZJRD
** No change.
** 
**    Rev 1.5.1.3   05 Sep 1996 11:32:56   ZJRD
** No change.
** 
**    Rev 1.5.1.2   02 Sep 1996 10:00:00   ZJRD
** No change.
** 
**    Rev 1.5.1.1   28 Aug 1996 15:49:48   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.5.1.0   12 Aug 1996 10:53:58   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.2   29 May 1996 09:38:34   ZJRD
** EasyPack/SLD Version 1.95
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// aa.cpp
//
// Roger Zhang
//                                                                           
// 5/2/96
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"

#include "toolopt.h"
#include "aa.h"

/////////////////////////////////////////////////////////////////////////////
// diagnostic
#ifdef _DEBUG
void AATool::Dump(CDumpContext &dc) const
{         
    CToolOption::Dump(dc);
    dc << "m_fCase = " << m_fCase << "\n";
    dc << "m_fDebug = " << m_fDebug << "\n";
    dc << "m_fList = " << m_fList << "\n";
    dc << "m_fListAll = " << m_fListAll << "\n";
    dc << "m_fOptimize = " << m_fOptimize << "\n";
    dc << "m_strMore = " << m_strMore << "\n";
    dc << "m_strPath = " << m_strPath << "\n";   
    dc << "m_incPath = " << m_incPath << "\n";
}
#endif

/////////////////////////////////////////////////////////////////////////////
// operations
void AATool::SetDefault(void)
{
    m_fCase = FALSE;
    m_fDebug = TRUE;
    m_fList = TRUE;
    m_fListAll = FALSE;
    m_fOptimize = FALSE;
    m_strMore = "NOPR";
    m_strPath = "c:\\cc51\\bin";
    m_incPath = "c:\\cc51\\include" ;
}

BOOL AATool::LoadOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 5;
    
    char ach[nCnt];
    
    if(fread(ach, 1, nCnt, fp) != nCnt)
        return FALSE;
        
    m_fCase = ach[0];
    m_fDebug = ach[1];
    m_fList = ach[2];
    m_fListAll = ach[3];
    m_fOptimize = ach[4];
    
    WORD wLen;
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);
    
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);   
    
     if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_incPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_incPath.ReleaseBuffer(wLen);  
    

    
    return TRUE;
}                 

BOOL AATool::SaveOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 5;

    char ach[nCnt];
    
    ach[0] = char(m_fCase);
    ach[1] = char(m_fDebug);
    ach[2] = char(m_fList);
    ach[3] = char(m_fListAll);
    ach[4] = char(m_fOptimize);
    
    if(fwrite(ach, 1, nCnt, fp) != nCnt)
        return FALSE;
             
    WORD wLen = WORD(m_strMore.GetLength());           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
    
              
    wLen =  WORD(m_strPath.GetLength()); 
              
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen); 
    
    wLen =  WORD(m_incPath.GetLength());           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_incPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_incPath.ReleaseBuffer(wLen);

    return TRUE;
}

CString AATool::GetOption(void) const
{
    CString str = " ";
    
    if(m_fCase)
        str += "CA ";
        
    if(!m_fDebug)
        str += "NODB ";
        
    if(!m_fList)
        str += "NOLI ";
        
    if(m_fListAll)   
        str += "LA ";
        
    if(!m_fOptimize)
        str += "NOOP ";
    
    str += m_strMore;
    str += " ";
    
    return str;
}

