/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/ADDRAPI.H__   1.2.1.5   17 Apr 1997 15:40:58   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/ADDRAPI.H__  $
** 
**    Rev 1.2.1.5   17 Apr 1997 15:40:58   ZJRD
** No change.
** 
**    Rev 1.2.1.4   16 Apr 1997 10:11:14   ZJRD
** No change.
** 
**    Rev 1.2.1.3   10 Apr 1997 15:26:44   ZJRD
** 2.09F
** 
**    Rev 1.2.1.1   03 Apr 1997 15:08:50   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:13:48   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:25:08   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:44:14   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:16:56   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 13:00:12   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:20:20   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:31:50   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:58:54   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:51:08   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:54:54   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:57:54   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:34:46   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:00:14   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:16:46   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:31:06   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.1   18 Apr 1996 12:56:22   Shirley
** EasyPack/SLD Version 1.91
** 
**    Rev 1.0   12 Apr 1996 10:35:54   Shirley
** Initial revision.
** 
****************************************************************************/

/****************************************************************************
**
**  Name:      Addrapi.h
**
**  Description: Main file of the address server API
**
**  Status: Initialization
**          1996/03/05        Daniel Lin
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
******************************************************************************/

/**----------------------------------------------------------------------
 **   AdrAddrToHex
 **
 **   addr        Set to the address.
 **   adrstr      Set to the converted address text string .
 **
 **   Remark
 **      Call this function to convert an address to text string. The
 **      address descripted by the ADDRESS struct.
 **      If there is no space, the adrSpace must set to 51SPACE_UNDEFINE.
 **      The result hex string hasn't any leading zero.
 **
 **   Return value
 **      One of the enum of ADDR_RETCODE.
 **      If this return value equal to ADDR_OK, the convert is successful.
 **      (See the defination of the ADDR_RETCODE)
 **
 **      Examples
 **         char         strTemp[150];
 **         ADDR_RETCODE retCode;
 **         ADDRESS      address;
 **
 **         address.adrSpace = SPACE_PROGRAM;
 **         address.address = 100;
 **         retCode = AdrAddrToHex(address, strTemp);
 **         if (ADR_OK == retCode)
 **             // The convert is successful. The address is correct.
 **         else
 **             // The convert is failure. The address has some error
 **
 **         The address of 100 in program area will be converted to the
 **         hex text string strTemp. The parameter strTemp is change to
 **         "P:0x64".
 **----------------------------------------------------------------------*/

#ifndef _ADDRAPI_H_
#define _ADDRAPI_H_

 ADDR_RETCODE
 AdrAddrToHex( const ADDRESS   addr,  LPSTR    adrstr );

 ADDR_RETCODE
 AdrAddrToHex( const ADDRESS   addr,  CString  &adrstr );

 ADDR_RETCODE
 AdrDadAddrToHex( const ADDRESS   addr,  CString  &adrstr );

 ADDR_RETCODE
 AdrDadAddrToHex( const ADDRESS   addr,  LPSTR    adrstr );

/**----------------------------------------------------------------------
 **   AdrAddrToDec
 **
 **   addr     Set to the address.
 **   adrstr   Set to the converted address dec text string .
 **
 **   Remark
 **   Call this function to convert an address to dec text string. The space
 **   style's string will add to the front of the address's string.
 **   The converted address text string will store in the third parameter
 **   (adrstr).
 **   If there is no space, the adrSpace must set to 51SPACE_UNDEFINE.
 **   The result hex string hasn't any leading zero.
 **
 **   Return value
 **   One of the enum of ADDR_RETCODE.
 **   If this return value equal to ADDR_OK, the convert is successful.
 **   (See the defination of the ADDR_RETCODE)
 **
 **   Examples
 **      char         strTemp[150];
 **      ADDR_RETCODE retCode;
 **      ADDRESS      address;
 **
 **      address.adrSpace = SPACE_PROGRAM;
 **      address.address = 100;
 **      retCode = AdrAddrToDec(address, strTemp);
 **      if (ADR_OK == retCode)
 **         // The convert is successful. The address is correct.
 **      else
 **         // The convert is failure. The address has some error
 **
 **   The address of 100 in program area will be converted to the hex text
 **   string strTemp. The parameter strTemp is change to "P:100
 **
 **----------------------------------------------------------------------*/
 ADDR_RETCODE
 AdrAddrToDec( const ADDRESS   addr, LPSTR adrstr );

 ADDR_RETCODE
 AdrAddrToDec( const ADDRESS   addr, CString &adrstr );


/**----------------------------------------------------------------------
 **   AdrTextToAddr
 **
 **   adrstr  Set to the address text string;
 **   addr    Set to the return address(converted address)
 **
 **   Remark
 **   Call this function to convert a hex address text string.
 **   The converted address store in the second parameter(addr).
 **   The address text string will set to hex string or dec string.
 **   Distinguish the two string by the leading char "0x".
 **
 **   Return value
 **   One of the enum of ADDR_RETCODE.
 **   If this return value equal to ADDR_OK, the convert is successful.
 **   (See the defination of the ADDR_RETCODE).
 **
 **   If the address text string soesn't include any space, the field
 **   in ADDRESS (adrSpace) will set to SPACE_UNDEFINE.
 **
 **   Examples
 **       char            *adrStr = "r:0x64";
 **       ADDRESS         address;
 **       ADDR_RETCODE    retCode;
 **
 **       retCode = AdrHexToAddr(adrstr, address);
 **       if (ADR_OK == retCode)
 **           // The convert is successful. The address is correct.
 **       else
 **           // The convert is failure. The address has some error
 **
 **----------------------------------------------------------------------*/
 ADDR_RETCODE
 AdrTextToAddr(const LPSTR  adrstr, ADDRESS &addr, UINT isHex = 1);

 ADDR_RETCODE
 AdrTextToAddr(const CString& adrstr, ADDRESS &addr, UINT isHex = 1);

 // For shell window
 //  
 ADDR_RETCODE
 AdrShellToAddr(const CString& adrstr, ADDRESS &addr, 
                ADDR_SPACE Space = ADDR_SPACE(0));

 ADDR_RETCODE
 AdrShellToAddr(const LPSTR  adrstr, ADDRESS &addr, 
                ADDR_SPACE Space = ADDR_SPACE(0));

/**---------------------------------------------------------------------- 
 **   CheckAddrRange
 ** 
 **   address     Set to the address
 **   
 **   Remark
 **   Call this function to check the address range
 **
 **----------------------------------------------------------------------*/

 BOOL
 AdrCheckAddrRange(ADDRESS address);
   
/**----------------------------------------------------------------------
 **   AdrCheck2Add
 **   adrstr1     Set to the first address 
 **   adrstr2     Set to the second address 
 **
 **   Remark
 **   Call this function to check two address text string.
 **   No converting.
 **
 **   Return value
 **   One of the enum of ADDR_RETCODE.
 **   If this return value equal to ADDR_OK, the convert is successful.
 **   (See the defination of the ADDR_RETCODE).
 **
 **----------------------------------------------------------------------*/
 ADDR_RETCODE
 AdrCheck2Addr(const LPSTR adrstr1, const LPSTR  adrstr2 );

 ADDR_RETCODE
 AdrCheck2Addr(const CString&   adrstr1, const CString&    adrstr2 );

 ADDR_RETCODE
 AdrCheck2Addr(ADDRESS  adddress1, ADDRESS   address2);

/**----------------------------------------------------------------------
 **   AdrShlCheck2Add
 **   adrstr1     Set to the first address 
 **   adrstr2     Set to the second address 
 **
 **   Remark
 **   Call this function to check two address text string. Only for shell
 **   No converting.
 **
 **   Return value
 **   One of the enum of ADDR_RETCODE.
 **   If this return value equal to ADDR_OK, the convert is successful.
 **   (See the defination of the ADDR_RETCODE).
 **
 **----------------------------------------------------------------------*/
 ADDR_RETCODE
 AdrShlCheck2Addr(const LPSTR adrstr1, const LPSTR  adrstr2, ADDR_SPACE space);

 ADDR_RETCODE
 AdrShlCheck2Addr(const CString&   adrstr1, const CString&    adrstr2, ADDR_SPACE space);

 ADDR_RETCODE
 AdrShlCheck2Addr(ADDRESS  adddress1, ADDRESS   address2, ADDR_SPACE space);

/**----------------------------------------------------------------------
 **   adrstr      Set to the address text string;
 **
 **   Remark
 **   Call this function to check the address text string.
 **   No converting.
 **
 **   Return value
 **   True if the address text string is correct.
 **----------------------------------------------------------------------*/
 BOOL
 AdrIsOk(const LPSTR   adrstr);

 BOOL
 AdrIsOk(const CString&  adrstr);


/**----------------------------------------------------------------------
 **   AdrErrorDeal
 **  
 **   Remark
 **   Process the address server's error.
 **   Call this function to display a message box(for general window process) if the callers don't want to process the error by themself.
 **
 **   Return value
 **   none
 **----------------------------------------------------------------------*/
 void
 AdrErrorDeal(ADDR_RETCODE  retCode, CString &error);
 
/**----------------------------------------------------------------------
 **   Remark
 **   Process the address server's error.
 **   Call this function to display a message box(for general window process) if the callers don't want to process the error by themself.
 **
 **   Return value
 **   none
 **----------------------------------------------------------------------*/
 void 
 AdrSetAddrRange();    // Get all address range Max and Min

/**----------------------------------------------------------------------
 **   AdrAddrToSymbol
 **
 **   Symbol  Set to the symbol text string converted from the addr;
 **   addr    Set to the address will be converted
 **
 **   Remark
 **   Call this function to convert a address to a symbol text string.
 **   The Symbol will support the format as "#ModuleName#SymbolName".
 **   This function will call Symbol server.
 **
 **   Return value
 **   True if convert successful.
 **
 **   Examples
 **       CString     sybStr;
 **       ADDRESS     addr;
 **       BOOL        bOk = FALSE;
 **       
 **       addr.adrSpace = ADR_PROGRAME;
 **       addr.adrAddress = 0xFFFF;  
 **       bOk = AdrAddrToSymbol(addr, sybStr);
 **
 **----------------------------------------------------------------------*/
 
BOOL AdrAddrToSymbol(const ADDRESS &addr, LPSTR symbol);

BOOL AdrAddrToSymbol(const ADDRESS &addr, CString& symbol);                        

ADDR_RETCODE AdrShlCheck2ListAddr(const LPSTR adrstr1, const LPSTR  adrstr2);

#endif
