/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/BANKINIT.CPP   1.2.1.5   17 Apr 1997 15:41:34   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/BANKINIT.CPP  $
** 
**    Rev 1.2.1.5   17 Apr 1997 15:41:34   ZJRD
** No change.
** 
**    Rev 1.2.1.4   16 Apr 1997 10:15:36   ZJRD
** No change.
** 
**    Rev 1.2.1.3   10 Apr 1997 15:27:24   ZJRD
** 2.09F
** 
**    Rev 1.2.1.1   03 Apr 1997 15:09:18   ZJRD
** 2.09E
** 
****************************************************************************/

// bankinit.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "uicom.h"
#include "abibase.h"
#include "abitype.h"
#include "abiextfn.h" 
#include "bankinit.h"
#include "hosterrs.h"  
#include "errcodec.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
                                  

extern STATUS AbiInitBank(BANKINIT init);                                  
extern STATUS AbiSelectBank(BYTE nBank);
extern STATUS AbiGetFwId(UCHAR *uchMajor, UCHAR* uchMinor);
/////////////////////////////////////////////////////////////////////////////
//
//  File name:  BANKINIT.CPP
//
//  Description:The implement file for the class: CBankInit
//
//  Author:     Dragon
//
//  Date:       12/19/96
//
//  Copyright (C) 1996 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// CBankInit dialog

int GetBankInfo(BANKINIT& init);
void BankInit(void);
BOOL ISBankInit();
                               
/***************************************************************************
*                                                                          *
*           GLOBLE  FUNCTION                                               *
*  BankInit()                                                              *
*          - initializing bank according to information user specified     *
*  parameter :                                                             *
*       BANKINIT                                                           *
*  No return value :                                                       *
*                                                                          *
***************************************************************************/
STATUS AbiGetCpuStatus(UINT *uCpuStatus);

BOOL IsBankInit()
{
    int errID;
    UCHAR uchMajor,uchMinor; 
 
    errID = AbiGetFwId(&uchMajor, &uchMinor);
    if ( 0 != errID ) {
        return 0;
    }
    if ( uchMajor == 0x05||uchMajor == 0x12||uchMajor == 0x22||
        uchMajor == 0x32||uchMajor == 0x42 ) {
        return 0;
    }
    else if ( (uchMajor==0x06 && uchMinor>=0x020) ||
        (uchMajor>0x06&&uchMajor<0x10) ) {
        UINT uCpuStatus;
        errID = AbiGetCpuStatus(&uCpuStatus);
        if ( 0==errID && uCpuStatus&0x2000 ) 
            return 1;
        else return 0;      
    }
    else return 1;
}
 
void BankInit()
{
 BANKINIT init;
 int err, i=0;
 BOOL flag;
 
 // initializing bank. you will be given three chance.
 if((err = GetBankInfo(init))==0){
    //communicate with hardware 
     AfxGetApp()->DoWaitCursor(1);
     if((AbiInitBank(init))==ICE_OK){
        //initialization of banknum.default value is 0.
         g_nBankNum = AfxGetApp()->GetProfileInt("BankInfo","BankNumber",0);
         g_nPort = AfxGetApp()->GetProfileInt("BankInfo","BankPort",1);
         g_nPortLowBit=AfxGetApp()->GetProfileInt("BankInfo","BankA16",0);
         g_nPortHighBit=AfxGetApp()->GetProfileInt("BankInfo","BankA17",1);
//         g_nSignal=AfxGetApp()->GetProfileInt("BankInfo","BankSignal",1);
         g_nSignal=AfxGetApp()->GetProfileInt("BankInfo","BankSignal",0);
         
         if(g_nBankNum){
            if((AbiSelectBank(1))!=ICE_OK){
                ErrDisplayError(ER_SEL_BANK);
                g_nCurrentBank=1;
            }
         } 
// Modified by Gates Hua , for always display bank init dialog
//         AfxGetApp()->DoWaitCursor(-1);
//         return; 
      }
     AfxGetApp()->DoWaitCursor(-1);
  }
  
 i = 0;
 do{
     if(i == 3) break;
     CBankInit dlg(0);
     if(dlg.DoModal()==IDOK){ 
        flag = dlg.m_nErr;
     }
     i++;
 } while(flag);//end of while
 
 // if you cann't initialize bank according to value you specified
 // for three times. rights will be aborted.
 if(i == 3 ){
    CString str;                    
       
    g_nBankNum = 0;
    str.LoadString(IDS_BANKINIT_NOT_GOOD);
    AfxMessageBox(str);
    return;
  }
  return; 
} //end of BankInit()

/***************************************************************************
*                                                                          *
*           GLOBLE  FUNCTION                                               *
*  GetBankInfo - Get infomation of bank from *.ini                         *
*                                                                          *
*  parameter :                                                             *
*       BANKINIT                                                           *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/

int GetBankInfo(BANKINIT& init)
{
 int BankSize, BankPort, BankA16, BankA17, BankSignal;

 // Get information of bank from epsld52f.ini
 BankSize = AfxGetApp()->GetProfileInt("BankInfo", "BankNumber",-1);

 if(!(BankSize==0||BankSize==2||BankSize==4)){
    return -1;
  }
 if(BankSize==0){
    init.bSignal=0x00;
    init.bSignalPlace = 1;
    return 0;
 }

 BankPort = AfxGetApp()->GetProfileInt("BankInfo", "BankPort",-1 );
 BankSignal=AfxGetApp()->GetProfileInt("BankInfo", "BankSignal",-1 );
 BankA16 = AfxGetApp()->GetProfileInt("BankInfo", "BankA16",-1);
 
 if(!(BankSignal==0||BankSignal==1)){
    return -1;
  }
// Get setup of bank  
 switch(BankSize){
  case 2:
   if(BankSignal)
      init.bSignal = 0x81;
   else
      init.bSignal = 0x01;
   break;
  case 4:
   if(BankSignal)
      init.bSignal = 0x82;
   else
      init.bSignal = 0x02;
   break;            
  default:
   return -1;
 }   

 if(!(BankPort==1||BankPort==3||BankPort==4||BankPort==5)){
    return -1;
 }

 init.bSignalPlace=(BYTE)BankPort;

 if(BankA16>7||BankA16<0){
    return -1;
  } 
 init.bSignalBitLow = (BYTE)(1<<BankA16);

 if(BankSize == 4){
    BankA17 = AfxGetApp()->GetProfileInt("BankInfo", "BankA17",-1);
    if(BankA17>7||BankA17<0||(BankA16==BankA17)){
       return -1;
    }
    init.bSignalBitHigh = (BYTE)(1<<BankA17);  
 }

  return 0;
} //end of GetBankInfo()

// construction function of CBankInit 
   
CBankInit::CBankInit(int n,CWnd* pParent /*=NULL*/)
    : CDialog(CBankInit::IDD, pParent)
{
       m_nConParam = n; 
       if((m_nErr = GetBankInfoFromINI()) != 0){
           Init();
       }
    //{{AFX_DATA_INIT(CBankInit)
        // NOTE: the ClassWizard will add member initialization here
    //}}AFX_DATA_INIT
}

void CBankInit::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CBankInit)
        // NOTE: the ClassWizard will add DDX and DDV calls here
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CBankInit, CDialog)
    //{{AFX_MSG_MAP(CBankInit)
    ON_BN_CLICKED(IDC_BANKINIT_1BANK, OnBankinit1bank)
    ON_BN_CLICKED(IDC_BANKINIT_2BANK, OnBankinit2bank)
    ON_BN_CLICKED(IDC_BANKINIT_4BANK, OnBankinit4bank)
    ON_BN_CLICKED(IDC_BANKINIT_H1, OnBankinitH1)
    ON_BN_CLICKED(IDC_BANKINIT_H2, OnBankinitH2)
    ON_BN_CLICKED(IDC_BANKINIT_H3, OnBankinitH3)
    ON_BN_CLICKED(IDC_BANKINIT_H4, OnBankinitH4)
    ON_BN_CLICKED(IDC_BANKINIT_H5, OnBankinitH5)
    ON_BN_CLICKED(IDC_BANKINIT_H6, OnBankinitH6)
    ON_BN_CLICKED(IDC_BANKINIT_H7, OnBankinitH7)
    ON_BN_CLICKED(IDC_BANKINIT_HIGH, OnBankinitHigh)
    ON_BN_CLICKED(IDC_BANKINIT_L0, OnBankinitL0)
    ON_BN_CLICKED(IDC_BANKINIT_L1, OnBankinitL1)
    ON_BN_CLICKED(IDC_BANKINIT_L2, OnBankinitL2)
    ON_BN_CLICKED(IDC_BANKINIT_L3, OnBankinitL3)
    ON_BN_CLICKED(IDC_BANKINIT_L4, OnBankinitL4)
    ON_BN_CLICKED(IDC_BANKINIT_L5, OnBankinitL5)
    ON_BN_CLICKED(IDC_BANKINIT_L6, OnBankinitL6)
    ON_BN_CLICKED(IDC_BANKINIT_Low, OnBankInitLow)
    ON_BN_CLICKED(IDC_BANKINIT_P1, OnBankinitP1)
    ON_BN_CLICKED(IDC_BANKINIT_P3, OnBankinitP3)
    ON_BN_CLICKED(IDC_BANKINIT_H0, OnBankinitH0)
    ON_BN_CLICKED(IDC_BANKINIT_L7, OnBankinitL7)
    ON_BN_CLICKED(IDC_BANKINIT_P4, OnBankinitP4)
    ON_BN_CLICKED(IDC_BANKINIT_P5, OnBankinitP5)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CBankInit message handlers        
// initializing setup of bank

void CBankInit::Init()
{
    m_nBankNumber = 0;
    m_nBankPort = 1;
//    m_bBankSignal = 1;
    m_bBankSignal = 0;
    m_nHighBit = 1;
    m_nLowBit = 0;
}

BOOL CBankInit::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // TODO: Add extra initialization here
    if(m_nConParam==0){
       GetDlgItem(IDCANCEL)->EnableWindow(FALSE);
       GetDlgItem(IDCANCEL)->ShowWindow(SW_HIDE);
    }
    InitBankNumber();
    CenterWindow();
    if(m_nBankNumber == 0)
       return TRUE;
    InitBankPort();
    InitBankSignal();
    InitBankSelectBit();
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}
    
    
void CBankInit::InitBankNumber()
{    
    switch(m_nBankNumber){
     case 0:
      CheckRadioButton(IDC_BANKINIT_1BANK, IDC_BANKINIT_4BANK, IDC_BANKINIT_1BANK);

      //port signal select bit will becomed greyed
      EnablePortButton(FALSE);
      EnableSignalButton(FALSE);
      EnableHBitButton(FALSE);
      EnableLBitButton(FALSE);
      break;
     case 2:
      CheckRadioButton(IDC_BANKINIT_1BANK, IDC_BANKINIT_4BANK, IDC_BANKINIT_2BANK);

      EnablePortButton(TRUE);
      
      // select high bit will becomed greyed
      EnableHBitButton(FALSE);
      break;
     case 4:
      CheckRadioButton(IDC_BANKINIT_1BANK, IDC_BANKINIT_4BANK, IDC_BANKINIT_4BANK);

      EnablePortButton(TRUE);
      
      break;
     default:
      return ;
    } 
}

// initializing port of bank
void CBankInit::InitBankPort()
{
    switch(m_nBankPort){
     case 1:
      CheckRadioButton(IDC_BANKINIT_P1,IDC_BANKINIT_P5,IDC_BANKINIT_P1);
      break;
     case 3:
      CheckRadioButton(IDC_BANKINIT_P1,IDC_BANKINIT_P5,IDC_BANKINIT_P3);
      break;
     case 4:
      CheckRadioButton(IDC_BANKINIT_P1,IDC_BANKINIT_P5,IDC_BANKINIT_P4);
      break;
     case 5:
      CheckRadioButton(IDC_BANKINIT_P1,IDC_BANKINIT_P5,IDC_BANKINIT_P5);
      break;
     default:
      return;
    }
}

// initializing signal of bank
void CBankInit::InitBankSignal()
{
    switch(m_bBankSignal){
     case 1:
      CheckRadioButton(IDC_BANKINIT_HIGH,IDC_BANKINIT_Low,IDC_BANKINIT_HIGH);
      break;
     case 0:
      CheckRadioButton(IDC_BANKINIT_HIGH,IDC_BANKINIT_Low,IDC_BANKINIT_Low);
      break;
     default:
      return;
    }
}
                                                                          
// initializing bit of port (High and Low)
void CBankInit::InitBankSelectBit()
{   
       
    switch(m_nLowBit){
     case 0:
      CheckRadioButton(IDC_BANKINIT_L0,IDC_BANKINIT_L7,IDC_BANKINIT_L0);
      GetDlgItem(IDC_BANKINIT_H0)->EnableWindow(FALSE);
      break;
     case 1:
      CheckRadioButton(IDC_BANKINIT_L0,IDC_BANKINIT_L7,IDC_BANKINIT_L1);
      GetDlgItem(IDC_BANKINIT_H1)->EnableWindow(FALSE);
      break;
     case 2:
      CheckRadioButton(IDC_BANKINIT_L0,IDC_BANKINIT_L7,IDC_BANKINIT_L2);
      GetDlgItem(IDC_BANKINIT_H2)->EnableWindow(FALSE);
      break;
     case 3:
      CheckRadioButton(IDC_BANKINIT_L0,IDC_BANKINIT_L7,IDC_BANKINIT_L3);
      GetDlgItem(IDC_BANKINIT_H3)->EnableWindow(FALSE);
      break;
     case 4:
      CheckRadioButton(IDC_BANKINIT_L0,IDC_BANKINIT_L7,IDC_BANKINIT_L4);
      GetDlgItem(IDC_BANKINIT_H4)->EnableWindow(FALSE);
      break;
     case 5:
      CheckRadioButton(IDC_BANKINIT_L0,IDC_BANKINIT_L7,IDC_BANKINIT_L5);
      GetDlgItem(IDC_BANKINIT_H5)->EnableWindow(FALSE);
      break;
     case 6:
      CheckRadioButton(IDC_BANKINIT_L0,IDC_BANKINIT_L7,IDC_BANKINIT_L6);
      GetDlgItem(IDC_BANKINIT_H6)->EnableWindow(FALSE);
      break;
     case 7:
      CheckRadioButton(IDC_BANKINIT_L0,IDC_BANKINIT_L7,IDC_BANKINIT_L7);
      GetDlgItem(IDC_BANKINIT_H7)->EnableWindow(FALSE);
      break;                                                          
     default:
      break;
    }
   
   if(m_nBankNumber==2)
      return;
       
    switch(m_nHighBit){
     case 0:
      CheckRadioButton(IDC_BANKINIT_H0,IDC_BANKINIT_H7,IDC_BANKINIT_H0);
      GetDlgItem(IDC_BANKINIT_L0)->EnableWindow(FALSE);
      break;
     case 1:
      CheckRadioButton(IDC_BANKINIT_H0,IDC_BANKINIT_H7,IDC_BANKINIT_H1);
      GetDlgItem(IDC_BANKINIT_L1)->EnableWindow(FALSE);
      break;
     case 2:
      CheckRadioButton(IDC_BANKINIT_H0,IDC_BANKINIT_H7,IDC_BANKINIT_H2);
      GetDlgItem(IDC_BANKINIT_L2)->EnableWindow(FALSE);
      break;
     case 3:
      CheckRadioButton(IDC_BANKINIT_H0,IDC_BANKINIT_H7,IDC_BANKINIT_H3);
      GetDlgItem(IDC_BANKINIT_L3)->EnableWindow(FALSE);
      break;
     case 4:
      CheckRadioButton(IDC_BANKINIT_H0,IDC_BANKINIT_H7,IDC_BANKINIT_H4);
      GetDlgItem(IDC_BANKINIT_L4)->EnableWindow(FALSE);
      break;
     case 5:
      CheckRadioButton(IDC_BANKINIT_H0,IDC_BANKINIT_H7,IDC_BANKINIT_H5);
      GetDlgItem(IDC_BANKINIT_L5)->EnableWindow(FALSE);
      break;
     case 6:
      CheckRadioButton(IDC_BANKINIT_H0,IDC_BANKINIT_H7,IDC_BANKINIT_H6);
      GetDlgItem(IDC_BANKINIT_L6)->EnableWindow(FALSE);
      break;
     case 7:
      CheckRadioButton(IDC_BANKINIT_H0,IDC_BANKINIT_H7,IDC_BANKINIT_H7);
      GetDlgItem(IDC_BANKINIT_L7)->EnableWindow(FALSE);
      break;                                                          
     default:
      return;
    }
}


// check radio button (No bank)                                                                           
void CBankInit::OnBankinit1bank()
{
    // TODO: Add your control notification handler code here
    if(m_nBankNumber == 0)
       return;  
    
    // port signal selectbit will be greyed
    EnablePortButton(FALSE);
    EnableSignalButton(FALSE);
    EnableHBitButton(FALSE);
    EnableLBitButton(FALSE);
    
    m_nBankNumber = 0;
}

//check radio button for 2 banks
void CBankInit::OnBankinit2bank()
{
    // TODO: Add your control notification handler code here
    if(m_nBankNumber == 2)
       return;
    
    if(m_nBankNumber==0){
    //port signal lowbit will be lighted
       EnablePortButton(TRUE); 
       InitBankPort();
       
       EnableSignalButton(TRUE);
       InitBankSignal();
       
       EnableLBitButton(TRUE);
       m_nBankNumber = 2;
       InitBankSelectBit();
    }
    else if(m_nBankNumber==4){
    // high bit ,low bit 7 will be greyed
       m_nBankNumber = 2;
       EnableHBitButton(FALSE);
       //EnableBitButton(1,m_nHighBit);
       //GetDlgItem(IDC_BANKINIT_L7)->EnableWindow(TRUE);
       EnableLBitButton(TRUE);
    }  
    
}

void CBankInit::OnBankinit4bank()
{
    // TODO: Add your control notification handler code here
    if(m_nBankNumber == 4)
       return;
    
    if(m_nBankNumber == 2){
       EnableHBitButton(TRUE);
       m_nBankNumber = 4;
       if(m_nHighBit == m_nLowBit) {
          if(m_nLowBit<=6) m_nHighBit = m_nLowBit+1;
          else m_nHighBit = m_nLowBit-1;
       }
          
       InitBankSelectBit();
    } 
    else if(m_nBankNumber == 0){ 
    // port signal selectbit will be lighted.high bit 0 and low bit 7 greyed
       EnableHBitButton(TRUE);
       EnableLBitButton(TRUE);
       m_nBankNumber = 4;
       
       EnablePortButton(TRUE);
       InitBankPort();
       
       EnableSignalButton(TRUE);
       InitBankSignal();
       InitBankSelectBit();
    }
}
void CBankInit::OnBankinitH0()
{
    // TODO: Add your control notification handler code here 
    if(m_nBankNumber==4&&m_nLowBit==0)  return;
    if(m_nHighBit==0) return;
    
    EnableLBitButton(TRUE);
    //EnableBitButton(1,m_nHighBit);
    m_nHighBit = 0; 
    CheckRadioButton(IDC_BANKINIT_H0,IDC_BANKINIT_H7,IDC_BANKINIT_H0);
    GetDlgItem(IDC_BANKINIT_L0)->EnableWindow(FALSE);
}

void CBankInit::OnBankinitH1()
{
    // TODO: Add your control notification handler code here
    if(m_nBankNumber==4&&m_nLowBit==1)  return;
    if(m_nHighBit==1) return;
    
    EnableLBitButton(TRUE);
    //EnableBitButton(1,m_nHighBit);
    m_nHighBit = 1;
    CheckRadioButton(IDC_BANKINIT_H0,IDC_BANKINIT_H7,IDC_BANKINIT_H1);
    GetDlgItem(IDC_BANKINIT_L1)->EnableWindow(FALSE);
}

void CBankInit::OnBankinitH2()
{
    // TODO: Add your control notification handler code here
    if(m_nBankNumber==4&&m_nLowBit==2)  return;
    if(m_nHighBit==2) return;

    EnableLBitButton(TRUE);
    //EnableBitButton(1,m_nHighBit);
    m_nHighBit = 2;
    CheckRadioButton(IDC_BANKINIT_H0,IDC_BANKINIT_H7,IDC_BANKINIT_H2);
    GetDlgItem(IDC_BANKINIT_L2)->EnableWindow(FALSE);
}

void CBankInit::OnBankinitH3()
{
    // TODO: Add your control notification handler code here
    if(m_nBankNumber==4&&m_nLowBit==3)  return;
    if(m_nHighBit==3) return;

    EnableLBitButton(TRUE);
    //EnableBitButton(1,m_nHighBit);
    m_nHighBit = 3;
    CheckRadioButton(IDC_BANKINIT_H0,IDC_BANKINIT_H7,IDC_BANKINIT_H3);
    GetDlgItem(IDC_BANKINIT_L3)->EnableWindow(FALSE);
}

void CBankInit::OnBankinitH4()
{
    // TODO: Add your control notification handler code here
    if(m_nBankNumber==4&&m_nLowBit==4)  return;
    if(m_nHighBit==4) return;

    EnableLBitButton(TRUE);
    //EnableBitButton(1,m_nHighBit);
    m_nHighBit = 4;
    CheckRadioButton(IDC_BANKINIT_H0,IDC_BANKINIT_H7,IDC_BANKINIT_H4);
    GetDlgItem(IDC_BANKINIT_L4)->EnableWindow(FALSE);
}

void CBankInit::OnBankinitH5()
{
    // TODO: Add your control notification handler code here
    if(m_nBankNumber==4&&m_nLowBit==5)  return;
    if(m_nHighBit==5) return;

    EnableLBitButton(TRUE);
    //EnableBitButton(1,m_nHighBit);
    m_nHighBit = 5;
    CheckRadioButton(IDC_BANKINIT_H0,IDC_BANKINIT_H7,IDC_BANKINIT_H5);
    GetDlgItem(IDC_BANKINIT_L5)->EnableWindow(FALSE);
}

void CBankInit::OnBankinitH6()
{
    // TODO: Add your control notification handler code here
    if(m_nBankNumber==4&&m_nLowBit==6)  return;
    if(m_nHighBit==6) return;

    EnableLBitButton(TRUE);
    //EnableBitButton(1,m_nHighBit);
    m_nHighBit = 6;
    CheckRadioButton(IDC_BANKINIT_H0,IDC_BANKINIT_H7,IDC_BANKINIT_H6);
    GetDlgItem(IDC_BANKINIT_L6)->EnableWindow(FALSE);
}

void CBankInit::OnBankinitH7()
{
    // TODO: Add your control notification handler code here
    if(m_nBankNumber==4&&m_nLowBit==7)  return;
    if(m_nHighBit==7) return;

    EnableLBitButton(TRUE);
    //EnableBitButton(1,m_nHighBit);
    m_nHighBit = 7;
    CheckRadioButton(IDC_BANKINIT_H0,IDC_BANKINIT_H7,IDC_BANKINIT_H7);
    GetDlgItem(IDC_BANKINIT_L7)->EnableWindow(FALSE);
}

void CBankInit::OnBankinitL0()
{
    // TODO: Add your control notification handler code here
    if(m_nBankNumber==4&&m_nHighBit==0)  return;
    if(m_nLowBit==0)  return;
    if(m_nBankNumber==4)
       EnableHBitButton(TRUE);
       //EnableBitButton(0,m_nLowBit);
    m_nLowBit = 0;
    CheckRadioButton(IDC_BANKINIT_L0,IDC_BANKINIT_L7,IDC_BANKINIT_L0);
    GetDlgItem(IDC_BANKINIT_H0)->EnableWindow(FALSE);
}

void CBankInit::OnBankinitL1()
{
    // TODO: Add your control notification handler code here
    if(m_nBankNumber==4&&m_nHighBit==1)  return;
    if(m_nLowBit==1)  return;
    if(m_nBankNumber==4)
       EnableHBitButton(TRUE);
       //EnableBitButton(0,m_nLowBit);
    m_nLowBit = 1;
    CheckRadioButton(IDC_BANKINIT_L0,IDC_BANKINIT_L7,IDC_BANKINIT_L1);
    GetDlgItem(IDC_BANKINIT_H1)->EnableWindow(FALSE);
}

void CBankInit::OnBankinitL2()
{
    // TODO: Add your control notification handler code here
    if(m_nBankNumber==4&&m_nHighBit==2)  return;
    if(m_nLowBit==2) return;
    if(m_nBankNumber==4)
       EnableHBitButton(TRUE);
       //EnableBitButton(0,m_nLowBit);
    m_nLowBit = 2;
    CheckRadioButton(IDC_BANKINIT_L0,IDC_BANKINIT_L7,IDC_BANKINIT_L2);
    GetDlgItem(IDC_BANKINIT_H2)->EnableWindow(FALSE);
}

void CBankInit::OnBankinitL3()
{
    // TODO: Add your control notification handler code here
    if(m_nBankNumber==4&&m_nHighBit==3)  return;
    if(m_nLowBit==3)  return;
    if(m_nBankNumber==4)
       EnableHBitButton(TRUE);
       //EnableBitButton(0,m_nLowBit);
    m_nLowBit = 3;
    CheckRadioButton(IDC_BANKINIT_L0,IDC_BANKINIT_L7,IDC_BANKINIT_L3);
    GetDlgItem(IDC_BANKINIT_H3)->EnableWindow(FALSE);
}

void CBankInit::OnBankinitL4()
{
    // TODO: Add your control notification handler code here
    if(m_nBankNumber==4&&m_nHighBit==4)  return;
    if(m_nLowBit==4)  return;
    if(m_nBankNumber==4)
       EnableHBitButton(TRUE);
       //EnableBitButton(0,m_nLowBit);
    m_nLowBit = 4;
    CheckRadioButton(IDC_BANKINIT_L0,IDC_BANKINIT_L7,IDC_BANKINIT_L4);
    GetDlgItem(IDC_BANKINIT_H4)->EnableWindow(FALSE);
}

void CBankInit::OnBankinitL5()
{
    // TODO: Add your control notification handler code here
    if(m_nBankNumber==4&&m_nHighBit==5) return;
    if(m_nLowBit==5) return;
    if(m_nBankNumber==4)
       EnableHBitButton(TRUE);
       //EnableBitButton(0,m_nLowBit);
    m_nLowBit = 5;
    CheckRadioButton(IDC_BANKINIT_L0,IDC_BANKINIT_L7,IDC_BANKINIT_L5);
    GetDlgItem(IDC_BANKINIT_H5)->EnableWindow(FALSE);
}

void CBankInit::OnBankinitL6()
{
    // TODO: Add your control notification handler code here
    if(m_nBankNumber==4&&m_nHighBit==6)  return;
    if(m_nLowBit==6)  return;
    if(m_nBankNumber==4)
       EnableHBitButton(TRUE);
       //EnableBitButton(0,m_nLowBit);
    m_nLowBit = 6;
    CheckRadioButton(IDC_BANKINIT_L0,IDC_BANKINIT_L7,IDC_BANKINIT_L6);
    GetDlgItem(IDC_BANKINIT_H6)->EnableWindow(FALSE);
}

void CBankInit::OnBankinitL7()
{
    // TODO: Add your control notification handler code here
    if(m_nBankNumber==4&&m_nHighBit==7)  return;
    if(m_nLowBit==7) return;
    if(m_nBankNumber==4)
       EnableHBitButton(TRUE);
       //EnableBitButton(0,m_nLowBit);
    m_nLowBit = 7;
    CheckRadioButton(IDC_BANKINIT_L0,IDC_BANKINIT_L7,IDC_BANKINIT_L7);
    GetDlgItem(IDC_BANKINIT_H7)->EnableWindow(FALSE);
}

void CBankInit::OnBankinitHigh()
{
    // TODO: Add your control notification handler code here
    if( m_bBankSignal== 1) return;
    m_bBankSignal = 1;
}

void CBankInit::OnBankInitLow()
{
    // TODO: Add your control notification handler code here
    if( m_bBankSignal== 0) return;
    m_bBankSignal = 0;
    
}

void CBankInit::OnBankinitP1()
{
    // TODO: Add your control notification handler code here
    if(m_nBankPort==1) return;
    m_nBankPort = 1;
}

void CBankInit::OnBankinitP3()
{
    // TODO: Add your control notification handler code here
    if(m_nBankPort==3) return;
    m_nBankPort = 3;    
}

void CBankInit::OnOK()
{
    // TODO: Add extra validation here  
   //communicate with hardware 

    AfxGetApp()->DoWaitCursor(1);
    if((m_nErr=SetBank())!=0){
        AfxGetApp()->DoWaitCursor(-1);
        goto End;
     }
    AfxGetApp()->DoWaitCursor(-1);

    if(m_nBankNumber == 0){
       AfxGetApp()->WriteProfileInt("BankInfo", "BankNumber", 0);
     }
    else{
       AfxGetApp()->WriteProfileInt("BankInfo", "BankNumber", m_nBankNumber);
       AfxGetApp()->WriteProfileInt("BankInfo", "BankPort", m_nBankPort );
       AfxGetApp()->WriteProfileInt("BankInfo", "BankSignal", m_bBankSignal );
       AfxGetApp()->WriteProfileInt("BankInfo", "BankA16", m_nLowBit);
       if(m_nBankNumber == 4)
          AfxGetApp()->WriteProfileInt("BankInfo", "BankA17", m_nHighBit);
     }
End:
    CDialog::OnOK();
}

/***************************************************************************
*                                                                          *
*  GetBankInfoFromINI - Get infomation of bank from *.ini                  *
*                                                                          *
*  return value :                                                          *
*       0  ---  OK               -1 -2 -3  -4  ---  failure                *
*                                                                          *
***************************************************************************/
int CBankInit::GetBankInfoFromINI()
{                                         
 // Get information of bank from EPSLD52f.ini
 m_nBankNumber = AfxGetApp()->GetProfileInt("BankInfo", "BankNumber",0);
 if(!(m_nBankNumber==0||m_nBankNumber==2||m_nBankNumber==4)){
    return -1;
  }
 
 if(m_nBankNumber==0){
    Init();
    return 0;
  }
    
 m_nBankPort = AfxGetApp()->GetProfileInt("BankInfo", "BankPort",-1 );
 m_bBankSignal = AfxGetApp()->GetProfileInt("BankInfo", "BankSignal", -1);
 m_nLowBit = AfxGetApp()->GetProfileInt("BankInfo", "BankA16",-1);
   
 if(!(m_nBankPort==1||m_nBankPort==3||m_nBankPort==4||m_nBankPort==5)){
    return -2;
  }
 if(!(m_bBankSignal==0||m_bBankSignal==1)){
    return -3;
  }
 if(m_nLowBit>7||m_nLowBit<0){
    return -4;
  }
 if(m_nBankNumber == 2){
    m_nHighBit = m_nLowBit + 1;
    return 0;
  }
 m_nHighBit = AfxGetApp()->GetProfileInt("BankInfo","BankA17",-1);
 if(m_nHighBit>7||m_nHighBit<0||(m_nHighBit == m_nLowBit)){
    return -4;
  }   
 return 0;
}

/***************************************************************************
*                                                                          *
*  SetBank - Set up bank according to infomation user specified            *
*                                                                          *
*  return value :                                                          *
*       0  ---  OK               -1  -2   ---  failure                     *
*                                                                          *
***************************************************************************/
int CBankInit::SetBank()
{ 
 BANKINIT init;
 // Get setup of bank  
 switch(m_nBankNumber){
  case 0: 
   if(m_bBankSignal)
      init.bSignal = 0x80;
   else
      init.bSignal = 0x00;
   break;
  case 2:
   if(m_bBankSignal)
      init.bSignal = 0x81;
   else
      init.bSignal = 0x01;
   break;
  case 4:
   if(m_bBankSignal)
      init.bSignal = 0x82;
   else
      init.bSignal = 0x02;
   break;            
  default:
   return -1;
 }   
  if(m_nBankNumber==0)  goto skip;
   
  ASSERT(m_nBankPort==1||m_nBankPort==3||m_nBankPort==4||m_nBankPort==5);
  init.bSignalPlace=(BYTE)m_nBankPort;

  ASSERT(m_nLowBit<8&&m_nLowBit>-1);
  init.bSignalBitLow = (BYTE)(1<<m_nLowBit);
  
  if(m_nBankNumber==4){
     ASSERT(m_nHighBit<8&&m_nHighBit>-1);
     init.bSignalBitHigh = (BYTE)(1<<m_nHighBit);  
  }

skip:
  if(m_nBankNumber==0) init.bSignalPlace = 1;     
  m_nErr = AbiInitBank(init);
  if(m_nErr == ICE_OK){
     g_nBankNum = m_nBankNumber;
     g_nPort = m_nBankPort;
     g_nPortLowBit=m_nLowBit;
     g_nPortHighBit=m_nHighBit;
     g_nSignal=m_bBankSignal;
     
     if(m_nBankNumber){
        m_nErr = AbiSelectBank((BYTE)1);
        if(m_nErr != ICE_OK){
           return -2;        
        }              
        g_nCurrentBank=1;
      } 
     return 0;
  }
  return -1;
}

// Added by Gates Hua for disable P3 and P4 on other CPU module
BOOL IsSupportP4P5()
{
extern UINT GetCpuId();
    UINT uInt = GetCpuId();

    // 152 , from 8 - 15 ; 552 , from 18,19 ; 580 from 48, 49 ; 739 from 56, 57
    if ( (uInt>=8&&uInt<=15) || (uInt==18||uInt==19) || ( uInt==48||uInt==49) ||
        ( uInt==56||uInt==57 ) ) {
//        CString str;
//        
//        str.Format("TRUE, %d",uInt);
//        
//        AfxMessageBox( str );
//        
        return TRUE;
    }
    return FALSE;
}

// let port button greyed or lighted  
void CBankInit::EnablePortButton(BOOL bEnable)
{
     GetDlgItem(IDC_STATIC_PORT)->EnableWindow(bEnable);
     GetDlgItem(IDC_BANKINIT_P1)->EnableWindow(bEnable);
     GetDlgItem(IDC_BANKINIT_P3)->EnableWindow(bEnable);
     GetDlgItem(IDC_BANKINIT_P4)->EnableWindow(bEnable&&IsSupportP4P5());
     GetDlgItem(IDC_BANKINIT_P5)->EnableWindow(bEnable&&IsSupportP4P5());
} 

// let signal button greyed or lighted  
void CBankInit::EnableSignalButton(BOOL bEnable)
{ 
     GetDlgItem(IDC_STATIC_SIGNAL)->EnableWindow(bEnable);
     GetDlgItem(IDC_BANKINIT_HIGH)->EnableWindow(bEnable);
     GetDlgItem(IDC_BANKINIT_Low)->EnableWindow(bEnable);
}

// let high bit button greyed or lighted  
void CBankInit::EnableHBitButton(BOOL bEnable)
{    
     GetDlgItem(IDC_STATIC_H)->EnableWindow(bEnable);
     GetDlgItem(IDC_BANKINIT_H0)->EnableWindow(bEnable);
     GetDlgItem(IDC_BANKINIT_H1)->EnableWindow(bEnable);
     GetDlgItem(IDC_BANKINIT_H2)->EnableWindow(bEnable);
     GetDlgItem(IDC_BANKINIT_H3)->EnableWindow(bEnable);
     GetDlgItem(IDC_BANKINIT_H4)->EnableWindow(bEnable);
     GetDlgItem(IDC_BANKINIT_H5)->EnableWindow(bEnable);
     GetDlgItem(IDC_BANKINIT_H6)->EnableWindow(bEnable);
     GetDlgItem(IDC_BANKINIT_H7)->EnableWindow(bEnable);
}     

// let low bit button greyed or lighted  
void CBankInit::EnableLBitButton(BOOL bEnable)
{    
     GetDlgItem(IDC_STATIC_SELBIT)->EnableWindow(bEnable);

     GetDlgItem(IDC_STATIC_L)->EnableWindow(bEnable);
     GetDlgItem(IDC_BANKINIT_L0)->EnableWindow(bEnable);
     GetDlgItem(IDC_BANKINIT_L1)->EnableWindow(bEnable);
     GetDlgItem(IDC_BANKINIT_L2)->EnableWindow(bEnable);
     GetDlgItem(IDC_BANKINIT_L3)->EnableWindow(bEnable);
     GetDlgItem(IDC_BANKINIT_L4)->EnableWindow(bEnable);
     GetDlgItem(IDC_BANKINIT_L5)->EnableWindow(bEnable);
     GetDlgItem(IDC_BANKINIT_L6)->EnableWindow(bEnable);
     GetDlgItem(IDC_BANKINIT_L7)->EnableWindow(bEnable);
}            

 ///////////////////////////////////////////////
           
     
     
     
///////////////////////END of File/////////////////////////////////////////////////////     


void CBankInit::OnBankinitP4()
{
    // TODO: Add your control notification handler code here
    if(m_nBankPort==4) return;
    m_nBankPort = 4;

}

void CBankInit::OnBankinitP5()
{
    // TODO: Add your control notification handler code here
    if(m_nBankPort==5) return;
    m_nBankPort = 5;
    
}
