/***************************************************************************
**    $Header:   D:/ECB2S/SRC/LOG/DC.CPP   1.2.1.5   17 Apr 1997 15:47:42   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/DC.CPP  $
** 
**    Rev 1.2.1.5   17 Apr 1997 15:47:42   ZJRD
** No change.
** 
**    Rev 1.2.1.4   16 Apr 1997 10:19:02   ZJRD
** No change.
** 
**    Rev 1.2.1.3   10 Apr 1997 15:30:28   ZJRD
** 2.09F
** 
**    Rev 1.2.1.1   03 Apr 1997 15:11:24   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:16:26   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:27:34   ZJRD
** Easy Pack SLD 2.09c
**
**    $Header:   D:/ECB2S/SRC/LOG/DC.CPP   1.2.1.5   17 Apr 1997 15:47:42   ZJRD  $
**
**    $Log$
** 
**    Rev 1.4.1.0.1.2   09 Dec 1996 10:17:56   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.4.1.0.1.0   11 Nov 1996 13:01:10   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.4.1.4   09 Sep 1996 13:22:52   ZJRD
** No change.
** 
**    Rev 1.4.1.3   05 Sep 1996 11:34:18   ZJRD
** No change.
** 
**    Rev 1.4.1.2   02 Sep 1996 10:01:22   ZJRD
** No change.
** 
**    Rev 1.4.1.1   28 Aug 1996 15:45:06   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.4.1.0   12 Aug 1996 10:50:16   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.1   29 May 1996 09:35:42   ZJRD
** EasyPack/SLD Version 1.95
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// dc.cpp
//
// Michael Long
//                                                                           
// 5/14/96
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"

#include "toolopt.h"
#include "dc.h"

/////////////////////////////////////////////////////////////////////////////
// diagnostic
#ifdef _DEBUG
void DCTool::Dump(CDumpContext &dc) const
{         
    CToolOption::Dump(dc);
    dc << "m_nRegBank = " << m_nRegBank << "\n";
    dc << "m_nMemoryModel = " << m_nMemoryModel << "\n";
    dc << "m_nOptimize = " << m_nOptimize << "\n";
    dc << "m_fDb = " << m_fDb << "\n";
    dc << "m_fNopr = " << m_fNopr << "\n";
    dc << "m_strMore = " << m_strMore << "\n";  
    dc << "m_strPath = " << m_strPath << "\n"; 
    dc << "m_incPath = " << m_incPath << "\n";
}
#endif

/////////////////////////////////////////////////////////////////////////////
// operations
void DCTool::SetDefault(void)
{
    m_nRegBank = 2;     // 0-3
    m_nMemoryModel = 2; // 0 - 2 = s,c,l
    m_nOptimize = 0;    // 0 - 5
    m_fDb = TRUE;
    m_fNopr = TRUE;
    m_strMore = "NOREGPARMS OBJECTEXTEND "; 
    m_strPath = "c:\\omf51\\bin";  
    m_incPath = "c:\\omf51\\inc";
}

BOOL DCTool::LoadOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 5;
    
    char dch[nCnt];
    
    if(fread(dch, 1, nCnt, fp) != nCnt)
        return FALSE;
        
    m_nRegBank = dch[0];
    m_nMemoryModel = dch[1];
    m_nOptimize = dch[2];
    m_fDb = dch[4];
    m_fNopr = dch[3];
       
    WORD wLen;
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
     if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_incPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_incPath.ReleaseBuffer(wLen);  
  
    return TRUE;
}                 

BOOL DCTool::SaveOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 5;

    char dch[nCnt];
    
    dch[0] = (char)m_nRegBank;
    dch[1] = (char)m_nMemoryModel;
    dch[2] = (char)m_nOptimize;
    dch[4] = (char)m_fDb;
    dch[3] = (char)m_fNopr;
    if(fwrite(dch, 1, nCnt, fp) != nCnt)
        return FALSE;
             
    WORD wLen = WORD(m_strMore.GetLength());           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
    
    wLen = WORD(m_strPath.GetLength());           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
    wLen = WORD(m_incPath.GetLength());           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_incPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_incPath.ReleaseBuffer(wLen);  

    return TRUE;
}   
                            
static char * ar1[4] = { "RB(0) ", "RB(1) ", "RB(2) ", "RB(3) " };
static char * ar2[3] = { "SM ", "CP ", "LA "  };
static char * ar3[7] = { "OT(0) ", "OT(1) ", "OT(2) ", "OT(3) ", "OT(4) ", "OT(5) "," " };

CString DCTool::GetOption(void) const
{
    CString str = " ";
    
    str = ar1[m_nRegBank];
    str += ar2[m_nMemoryModel];
    str += ar3[m_nOptimize];
    
    if(m_fDb)
        str += "DB ";
        
    if(m_fNopr)
        str += "NOPR ";
        
    str += m_strMore;
    str += " ";
    
    return str;     
}

