// diagno.cpp : Defines the class behaviors for the application.
//

#include "stdafx.h"
#include "diagno.h"
#include "static.H"
#include "uiserial.h"
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

#include "diagnost.h"
#include "diagnres.h" 
#include "communic.h"
#include <ctype.h>
#include "abibase.h"

extern BOOL SetupCommunication(UINT pData);
extern BOOL SetCommType(int nTempCommType);
extern STATUS AbiGetFwId(UCHAR *uchMajor,  UCHAR *uchMinor);

extern BOOL ReadLoadOption(void);
extern BOOL WriteLoadOption(void);

extern CWnd* pWnd;

CString strAppPath;

extern int nPortAddr;         
extern int nPortType ; // 0 -> Parallel(PCE)
                   // 1 -> LPT1
                   // 2 -> LPT2
                   // 3 -> LPT3          
                   // 4 -> COM1
                   // 5 -> COM2
                   // 6 -> COM3
                   // 7 -> COM4
                   
extern char * PortAddr[8];
extern int nBaudRate ;   
BOOL bNewFrankEric(FALSE);

BOOL g_bEnhanced = 0; // 1;                     
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CommDlg(void)
{
    AfxGetApp()->DoWaitCursor(-1);
    CCommunicationDialog dlg;
    int nRet = dlg.DoModal() == IDOK;
    AfxGetApp()->DoWaitCursor(1);
    return nRet;
}   

/////////////////////////////////////////////////////////////////////////////
// CDiagnoApp

BEGIN_MESSAGE_MAP(CDiagnoApp, CWinApp)
    //{{AFX_MSG_MAP(CDiagnoApp)
    ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
        // NOTE - the ClassWizard will add and remove mapping macros here.
        //    DO NOT EDIT what you see in these blocks of generated code!
    //}}AFX_MSG_MAP
    // Standard file based document commands
    ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
    ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDiagnoApp construction

CDiagnoApp::CDiagnoApp()
{
    // TODO: add construction code here,
    // Place all significant initialization in InitInstance
}

CDiagnoApp::~CDiagnoApp()
{
    if(m_pTheCom)
        delete m_pTheCom;
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CDiagnoApp object

CDiagnoApp NEAR theApp;

/////////////////////////////////////////////////////////////////////////////
// CDiagnoApp initialization
extern BOOL isEpSldRunning;           
extern BOOL isFirstTime;
extern BOOL isOldFw;
extern BOOL isCanHWReset;
extern BOOL CALLBACK EnumWndProcx(HWND hwnd,LPARAM lParam);
extern void ReadCommInfo();

BOOL CheckFile()
{
    OFSTRUCT pof;

    if ( HFILE_ERROR == OpenFile("du23.jed",&pof,OF_PARSE) ) {
        return FALSE;
    }

    if ( HFILE_ERROR == OpenFile("du43.jed",&pof,OF_PARSE) ) {
        return FALSE;
    }

    if ( HFILE_ERROR == OpenFile("du70.jed",&pof,OF_PARSE) ) {
        return FALSE;
    }

    if ( HFILE_ERROR == OpenFile("wu23.jed",&pof,OF_PARSE) ) {
        return FALSE;
    }

    if ( HFILE_ERROR == OpenFile("wu43.jed",&pof,OF_PARSE) ) {
        return FALSE;
    }

    if ( HFILE_ERROR == OpenFile("wu70.jed",&pof,OF_PARSE) ) {
        return FALSE;
    }                              
    
    return TRUE;
}
extern BOOL isBank;           
BOOL CDiagnoApp::InitInstance()
{
    // Standard initialization
    // If you are not using these features and wish to reduce the size
    //  of your final executable, you should remove from the following
    //  the specific initialization routines you do not need.

    SetDialogBkColor();        // Set dialog background color to gray
    LoadIcon (IDR_MAINFRAME);        
   //added by john 
   if (isFirstTime) {
        EnumWindows(EnumWndProcx,NULL);
        if(isEpSldRunning) {                    
            isEpSldRunning = FALSE;
            int nTmp = AfxMessageBox("      EasyPack is being runned!\nDo You Really want to go on with it?",
                                      MB_YESNO);
            if (IDNO == nTmp)   return FALSE;
                else isFirstTime = FALSE;
        }
    }       
   
   
    // Read communication information from the private profile       
    ::ReadCommInfo();
    m_pTheCom = new CWinSerialPICAgreeSetup;
    if (NULL == m_pTheCom) return FALSE;
    
    m_bCanTimer = TRUE;
    
    if (!m_pTheCom->CommInit()) {
        AfxMessageBox("EasyPack/SLD configure failure!");
    }              
 
 //check the fw version;                                    
 BYTE uchMajor,uchMinor;
 if (ICE_OK != AbiGetFwId(&uchMajor,&uchMinor)) {
    AfxMessageBox("Fail in getting FW-ID");
    isOldFw = TRUE;
 } else { 
    if( uchMinor>=0x20 || (uchMajor>=0x05 && uchMajor<=0x10)) { 
        bNewFrankEric = TRUE;
    } else {         
        bNewFrankEric = FALSE;
    }
    
    if(uchMajor >= 0x06&&uchMajor<0x0a) {
        if ( CheckFile() ) g_bEnhanced = 1;
        else g_bEnhanced = 0;
    }
    else g_bEnhanced = 0;
    
    switch(uchMajor) {       
        case 0x13:isCanHWReset = TRUE;
                break;
        case 0x12:if(uchMinor < 0x16) isOldFw = TRUE;
                  if(uchMinor > 0x16) isCanHWReset = TRUE;
                break;
        case 0x22:
        case 0x32:if(uchMinor < 0x13) isOldFw = TRUE;
                  if(uchMinor > 0x12) isCanHWReset = TRUE;
                break;
        case 0x42:if(uchMinor < 0x08) isOldFw = TRUE;     
                  if(uchMinor > 0x07) isCanHWReset = TRUE;
                break;
        case 0x05:
        case 0x06:
        case 0x07:
        case 0x08:
        case 0x09:
        case 0x0a:
        case 0x0b:
        case 0x0c:
        case 0x0d:
        case 0x0e:
        case 0x0f:
        case 0x10:  isCanHWReset = TRUE; 
                    isBank = TRUE; break;
    }
    
    if (isOldFw) AfxMessageBox("Warning: You are using the old FW Version!\nSo Only a part function is supported.");
 }  
 
    CDiagnosticBox *diagnosticBox = new CDiagnosticBox;
    pWnd = diagnosticBox;
    
    diagnosticBox->DoModal();
    delete diagnosticBox;
    pWnd = NULL;  

    ::PostQuitMessage(WM_QUIT);
    return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
    CAboutDlg();

// Dialog Data
    //{{AFX_DATA(CAboutDlg)
    enum { IDD = IDD_ABOUTBOX };
    //}}AFX_DATA

// Implementation
protected:
    virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
    //{{AFX_MSG(CAboutDlg)
        // No message handlers
    //}}AFX_MSG
    DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
    //{{AFX_DATA_INIT(CAboutDlg)
    //}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CAboutDlg)
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
    //{{AFX_MSG_MAP(CAboutDlg)
        // No message handlers
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CDiagnoApp::OnAppAbout()
{
    CAboutDlg aboutDlg;
    aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CDiagnoApp commands
