
/****************************************************************************
**
**  Name:  ERRDISP.CPP
**
**  Description:
**      Entry points for error handling.
**
**  Status:  CODED
**
**  Date:    22 May 1996 8:30:00am   by:  Jamoon Zhou
** Initial revision.
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include "stdafx.h"
#include <stdio.h>
#include <stdarg.h>

#include "hosterrs.h"

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/
extern  HINSTANCE hTextInst;
extern  BOOL bCallInternal;

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/
extern UINT ErrGetStyle(U32 errCode);


/*****************************************************************************
** ErrGetErrorText
**
** Description:
**   Retrieve error text or recover text and plug in optional arguments.  
**	 Optional arguments must fit with the error format string. Refer to 
**	 wvsprintf() window function for the format-control character sequences.
**
** Parameters:
**    input :
**       errCode :   error type, and error number 
**					 or recover type, and recover number
**    output :
**       strError : error string
** Return :
**		GOOD(0) for success    FAILURE(-1) for failure	
*****************************************************************************/
RETCODE EXPORT ErrGetErrorText(U32 errorCode, CString& strError ...)
{
//	LPSTR lpError = strError.GetBuffer(E_ERRSIZE);
	char lpError[E_ERRSIZE];
	
//	int nn = sizeof(strError);
//	char far* lpp = (char far*)&strError + nn;
//	lpp = (char far*)&errorCode + sizeof(errorCode) + 4;
   	va_list marker;
   	va_start( marker, errorCode );     // Initialize variable arguments.
   	marker += sizeof(CString*);
	bCallInternal = TRUE;
   	RETCODE retCode = ErrGetErrorText(errorCode, lpError, (void FAR*)marker);
	bCallInternal = FALSE;
	va_end( marker );
	if ( retCode != GOOD )	return FAILURE;
	else 
		strError = lpError;
//		strError.ReleaseBuffer(lstrlen(lpError) + 1);
	return GOOD;
}


/*****************************************************************************
** ErrGetErrorText
**
** Description:
**   Retrieve error text and recover text and plug in optional arguments.  
**	 Optional arguments must fit with the error format string. Refer to 
**	 wvsprintf() window function for the format-control character sequences.
**
** Parameters:
**    input :
**       errCode :   error type, and error number 
**		 recCode :	 recover type, and recover number
**    output :
**       strError  : error CString
**		 strRecov  : recover CString
** Return :
**		GOOD(0) for success    FAILURE(-1) for failure	
*****************************************************************************/
RETCODE EXPORT ErrGetErrorText(U32 errCode,U32 recCode, 
		CString& strError, CString& strRecov ...)
{
//	LPSTR lpErr = strError.GetBuffer(E_ERRSIZE);
//	LPSTR lpRec = strRecov.GetBuffer(E_ERRSIZE);
	char lpErr[E_ERRSIZE],lpRec[E_ERRSIZE];
	
   	va_list marker;
// 	va_start( marker, strRecov );     // Initialize variable arguments.
   	va_start( marker, recCode );     // Initialize variable arguments.
   	marker += 2*sizeof(CString*);

	bCallInternal = TRUE;
	RETCODE retCode = ErrGetErrorText(errCode, recCode, lpErr, lpRec,marker);
	bCallInternal = FALSE;
	va_end( marker );

	if( retCode != GOOD ) return FAILURE;
	else {
		strError = lpErr;
		strRecov = lpRec;
//		strError.ReleaseBuffer(lstrlen(lpErr)+1);
//		strRecov.ReleaseBuffer(lstrlen(lpRec)+1);
	}
	return GOOD;	
}


/****************************************************************************
**
**  ErrDisplayError
**
**  Description:
**     Obtain and display the error text corresponding to the given error code
**     with MessageBox, optional arguments must fit with the error  format  
**     string. Refer to wvsprintf() window function for the format-control  
**     character sequences.
**
**  Parameters:
**     input:
**        errCode          error code
**        recCode         recovery code
**     output:
**
*****************************************************************************/
RETCODE EXPORT ErrDisplayError(U32 errCode, U32 recCode, ...)
{
//	CString strErrText, strRecText;
	char strErrText[512], strRecText[256];
	va_list marker;
	va_start(marker,recCode);
	bCallInternal = TRUE;
	RETCODE retCode = ErrGetErrorText(errCode, strErrText, marker);
	bCallInternal = FALSE;
	va_end( marker );

   	if ( retCode != GOOD) 
         return FAILURE; 	// ER_ERCODE_NOT_FOUND;
	if( recCode && ErrGetErrorText(recCode, strRecText) == GOOD ) {
//		strErrText += "\n\n";
//		strErrText += strRecText;
		lstrcat(strErrText,"\n\n");
		lstrcat(strErrText,strRecText);
	}
	
	UINT fuStyle = ErrGetStyle(errCode);

//	MessageBox( GetActiveWindow(), strErrText, strCaption, fuStyle );

#ifdef _USRDLL
	MessageBox( GetActiveWindow(), strErrText, "MESSAGE", fuStyle );
#else
	AfxMessageBox( strErrText, fuStyle );
#endif

	return GOOD;
}

RETCODE EXPORT ErrDisplayError(U32 errCode)
{
	return ErrDisplayError( errCode,0);
}

/***************************************************************************
**
**  ErrDisplayError
**
**  Description:
**     Obtain and display the error text corresponding to the given error code
**     with MessageBox, optional arguments must fit with the error  format  
**     string. Refer to wvsprintf() window function for the format-control  
**     character sequences.
**
**  Parameters:
**     input:
**        errCode         error code
**        recCode         recovery code
**        errHandle       E_DIALOG(0) 	MessageBox
**                        E_SHELL		shell window
**     Output:  
**
**  Return :
**		GOOD(0) for success    FAILURE(-1) for failure	
**
***************************************************************************/
RETCODE ErrDisplayError(short errHandle, U32 errCode, U32 recCode, ...)
{
	extern void ShowLine(char *);

	BOOL bRec = FALSE;
	
	CString strErrText, strRecText;
	va_list marker;
	va_start(marker,recCode);
	
	bCallInternal = TRUE;
	RETCODE retCode = ErrGetErrorText(errCode, strErrText, marker);
	bCallInternal = FALSE;
	va_end( marker );

   	if ( retCode != GOOD) 
        return FAILURE; 	// ER_ERCODE_NOT_FOUND;
	if( recCode && ErrGetErrorText(recCode, strRecText) == GOOD ) 
		bRec = TRUE;

	if ( errHandle == E_DIALOG ) {
		UINT fuStyle = ErrGetStyle(errCode);
		if ( bRec ) {
			strErrText += "\n\n";
			strErrText += strRecText;
		}
		AfxMessageBox( strErrText, fuStyle );
	}
	else if ( errHandle = E_SHELL ) {
#ifndef _WINDLL
        ShowLine((LPSTR)(LPCSTR)strErrText);
        if ( bRec ) ShowLine((LPSTR)(LPCSTR)strRecText);
#endif
	}
	return GOOD;
}

/**************************** end of file***********************************/