/***************************************************************************
**               
**    $Header:   D:/ECB2S/SRC/LOG/FWSETUP/ABIREG51.CPP   1.7   17 Apr 1997 16:37:08   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/FWSETUP/ABIREG51.CPP  $
** 
**    Rev 1.7   17 Apr 1997 16:37:08   ZJRD
** No change.
** 
**    Rev 1.6   16 Apr 1997 11:18:00   ZJRD
** No change.
** 
**    Rev 1.5   10 Apr 1997 15:58:54   ZJRD
** 2.09F
** 
**    Rev 1.3   03 Apr 1997 15:36:22   ZJRD
** No change.
** 
**    Rev 1.2   27 Mar 1997 15:21:10   ZJRD
** No change.
** 
**    Rev 1.1   19 Mar 1997 11:49:22   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 15:02:14   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:16:32   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:59:48   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:19:20   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:30:50   ZJRD
** EasyPack/SLD Version 1.9e
** 
**    Rev 1.7.1.2   02 Sep 1996 09:57:54   ZJRD
** EasyPack/SLD Version 1.9d
** 
**    Rev 1.7.1.1   28 Aug 1996 15:47:56   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.7.1.0   12 Aug 1996 10:52:32   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.8   20 Jun 1996 09:29:58   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.7   11 Jun 1996 10:27:14   ZJRD
** EasyPack/SLD Version 1.97
** 
**    Rev 1.5   05 Jun 1996 14:55:52   ZJRD
** EasyPack/SLD Version 1.96
** 
**    Rev 1.4   29 May 1996 09:36:42   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:01:20   ZJRD
** EasyPack/SLD Version 1.94
** 
**    Rev 1.2   10 May 1996 09:15:36   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:29:56   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:02:22   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:41:16   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:56:16   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:07:32   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:34:00   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:47:54   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:19:10   Shirley
** EasyPack/SLD Version 0.35b
** 
**    Rev 1.23   26 Jan 1996 09:14:22   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:14:16   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:33:08   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:26:54   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:11:42   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:13:16   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:11:20   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:08:48   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:31:36   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:18:16   Shirley
** EasyPack/SLD Version 0.31
** 
**    Rev 1.13   13 Nov 1995 09:28:28   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:30:16   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:33:32   Shirley
** EasyPack/SLD Version 0.23
** 
**    Rev 1.10   08 Nov 1995 12:43:14   Shirley
** EasyPack/SLD Version 0.22
** 
**    Rev 1.9   02 Nov 1995 10:05:16   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:51:10   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:54   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:31:18   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:47:12   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:23:36   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:50:04   Shirley
** EasyPack/SLD Version 0.1c
** 
**    Rev 1.2   20 Sep 1995 10:52:22   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:43:28   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:53:16   Shirley
** Initial revision.
**
****************************************************************************/

/***************************************************************************
**
** File name : abireg51.cpp
**
** Description: 
** 
** 
**
** Programmer: Frank Chang
**
**    Copyright (C) 1995 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/
#include "stdafx.h"

#include <stdio.h>

#include "abireg51.h" 
#include "abitype.h"
#include "abimacro.h"
#include <time.h>

static UINT gRegLen = 0x7f;

/////////////////////////////////////////////////////////////////
// ABI rountine part
//
STATUS AbiReset(ADDR addr);

STATUS AbiGetRegLen(UINT *wRegLen);

STATUS AbiGetCpuId(UINT *nCpuId);
STATUS AbiGetFwId(UCHAR *uchMajor,  UCHAR *uchMinor);

/////////////////////////////////////////////////////////////////
// call ABI sub rountine 
//
extern STATUS SendReceive(UINT lp, int tcount);
extern STATUS SendReceiveNoRelink(UINT lp, int tcount);

/****************************************************
**
** Name : AbiGetRegLen()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
****************************************************/
STATUS AbiGetRegLen(UINT *wRegLen)
{  
    STATUS status;
    UINT lp = 0;

    SaveId(FW_GET_REG_LEN,lp);
    status = SendReceive(lp, BASE_TIME);
    
    if (status == ICE_OK) {
        *wRegLen =*((UINT*) &inputStream[1]);
        gRegLen = *((UINT * )&inputStream[1]);
    }
    else
        *wRegLen = 0x7f;
        
    return(status);
}

/****************************************************
**
** Name : AbiGetCpuId()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
****************************************************/
STATUS AbiGetCpuId(UINT *nCpuId)
{
    STATUS status;
    UINT lp;
    UCHAR *uchPtr;
    
    lp = 0;
    SaveId(FW_GET_CPU_ID, lp);
    status = SendReceive(lp, BASE_TIME);

    uchPtr = &inputStream[1];
    *nCpuId = *((UINT*)uchPtr);

    return(status);
}

/****************************************************
**
** Name : AbiGetFwId()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
****************************************************/
STATUS AbiGetFwId(UCHAR *uchMajor,  UCHAR *uchMinor)
{
    STATUS status;
    UINT lp;
    

    lp = 0;
    SaveId(FW_GET_FW_ID, lp);
    status = SendReceive(lp, BASE_TIME);

    *uchMajor = (UCHAR) inputStream[1];
    *uchMinor = (UCHAR) inputStream[2];

    return(status);
}

//added by john 96.6
/****************************************************
**
** Name : AbiIsECB2(BYTE *bResult)
**
** Function : CHECK THE TYPE OF EP BOARD
**
**    Input  :
**
**    Output : *bResult = 1 --> ECB2
**             *bResult = 0 --> ECB     
**
** Notes:
**
****************************************************/
STATUS AbiIsECB2(BYTE *bResult)
{
    STATUS status;
    UINT lp = 0;

    SaveId(FW_IS_ECB2, lp);
    status = SendReceive(lp, BASE_TIME);

    if ( ICE_OK == status ) {      
        *bResult = inputStream[1];
    }
    return status;
}
 
/*****************************************************
**
** Name : AbiSelectBaud()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiSelectBaud(BYTE bOption)
{
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_SELECT_BAUD,uintLoop);      
    SaveVar(bOption, uintLoop, sizeof(BYTE));

    status = SendReceive(uintLoop, BASE_TIME);
    
    return(status);
}

//john 97.2
/*****************************************************
**
** Name : AbiSendProgData()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiSendProgData(WORD wAddr,BYTE bLen,BYTE* pBuff)
{
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_SEND_PROG_DATA,uintLoop);      
    SaveVar(wAddr, uintLoop, sizeof(WORD));
    SaveVar(bLen, uintLoop, sizeof(BYTE));
    SaveBuffer(pBuff,uintLoop,bLen);
    
    status = SendReceive(uintLoop, BASE_TIME);
    
    return(status);
}

/*****************************************************
**
** Name : AbiPrograme()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiProgram(BYTE bType,BYTE bUes)
{
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_PROGRAME,uintLoop);      
    SaveVar(bType, uintLoop, sizeof(BYTE));
    SaveVar(bUes, uintLoop, sizeof(BYTE));
    
    status = SendReceive(uintLoop, BASE_TIME*6);
    
    return(status);
}

/*****************************************************
**
** Name : AbiGetUesData(BYTE bType)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiGetUesData(BYTE bType,BYTE& bLen,BYTE* pBuff)
{
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_GET_UES_DATA,uintLoop);      
    SaveVar(bType, uintLoop, sizeof(BYTE));
    
    status = SendReceive(uintLoop, BASE_TIME);
    
    if (status == ICE_OK){
        bLen =inputStream[1];
        memcpy(pBuff,&inputStream[2],bLen);
    }
    return(status);
}

// Added by Gates Hua, 1/21/98
/*****************************************************
**
** Name : AbiReset()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiReset(ADDR addr)
{
    STATUS status; 
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_RESET,uintLoop);
    SaveVar(addr, uintLoop, sizeof(ADDR));

    // Added by Gates Hua
    if ( addr.addrType == 0x10 )
        status = SendReceive(uintLoop, 60);
    else 
        status = SendReceive(uintLoop, BASE_TIME);
    
    return status;
}

 