
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/GRID.CPP   1.2.1.4   17 Apr 1997 15:52:36   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/GRID.CPP  $
** 
**    Rev 1.2.1.4   17 Apr 1997 15:52:36   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:24:00   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:34:46   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:14:50   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:19:58   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.0   12 Mar 1997 14:46:50   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:14:04   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:57:20   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:13:08   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:24:42   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:51:48   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:43:28   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:49:00   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:51:14   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:28:02   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 08:59:42   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:08:04   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:22:34   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:53:02   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:33:50   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:48:12   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:02:02   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:27:16   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:45:18   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:18:06   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:20:44   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:20:38   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:37:54   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:25:00   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:09:22   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:12:24   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:14:52   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:10:06   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:30:56   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:23:58   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:26:20   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:30:28   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:28:14   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:42:20   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:06:40   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:50:16   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:36   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:31:50   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:47:42   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:23:46   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:50:30   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:55:00   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:44:54   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:55:52   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  GRID.CPP
//
//  Description:The implement file for the class: CGrid
//
//  Author:     Lane Li
//
//  Date:       09/10/95
//
//  Modification:
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"                           

#include "grid.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

CGrid::CGrid()
{   
	m_nMinLines=0;
	m_nMaxLines=100;
	m_nMinRows=0;
	m_nMaxRows=100;
	m_nLines=15;
	m_nRows=16;
	m_nPosX=0;
	m_nPosY=0;
	m_nGridHeight=17;
	m_nGridWidth=30;
	
	m_lpszTitle=new char[100];
	ASSERT(m_lpszTitle!=NULL);
	int i;
	for(i=0;i<=99;i++)
		m_lpszTitle[i]='\0';

//	SetTitle();	

	DoRect();
}

CGrid::~CGrid()
{                             
	if (m_lpszTitle!=NULL)
		delete m_lpszTitle;
}

void CGrid::SetMaxLines(int nLines)
{
	m_nMaxLines = nLines;
}

void CGrid::SetMinLines(int nLines)
{
	m_nMinLines = nLines;
}

void CGrid::SetMaxRows(int nLines)
{
	m_nMaxRows = nLines;
}             

void CGrid::SetMinRows(int nLines)
{
	m_nMinRows = nLines;
}                       

void CGrid::SetPos(int x,int y)
{
	m_nPosX = x;
	m_nPosY = y;
}               

void CGrid::SetLines(int nLines)
{
	m_nLines = nLines;
}                     

void CGrid::SetRows(int nLines)
{
	m_nRows = nLines;
}                    

void CGrid::SetGridHeight(int h)
{
	m_nGridHeight = h;
}                     

void CGrid::SetGridWidth(int w)
{
	m_nGridWidth = w;
}

void CGrid::DeleteLines(int nLines)
{
	m_nLines -= nLines;
	if (m_nLines < m_nMinLines) 
		m_nLines = m_nMinLines;
}                              

void CGrid::DeleteRows(int nLines)
{
	m_nRows -= nLines;
	if (m_nRows < m_nMinRows)
		m_nRows = m_nMinRows;
}

void CGrid::AddLines(int nLines)
{
	m_nLines += nLines;
	if (m_nLines > m_nMaxLines)
		m_nLines = m_nMaxLines;
}

void CGrid::AddRows(int nLines)
{
	m_nRows += nLines;
	if (m_nRows > m_nMaxRows)
		m_nRows = m_nMaxRows;
}                   

void CGrid::DoRect()
{
	m_rectPos.left = m_nPosX;
	m_rectPos.top = m_nPosY;
	m_rectPos.right = m_nPosX + m_nRows * m_nGridWidth;
	m_rectPos.bottom = m_nPosY + m_nLines * m_nGridHeight;
}                                 

void CGrid::SetTitle()
{
	m_lpszTitle[0]='0';
	m_lpszTitle[1]='\0';
	m_lpszTitle[2]='1';
	m_lpszTitle[3]='\0';
	m_lpszTitle[4]='2';
	m_lpszTitle[5]='\0';
	m_lpszTitle[6]='3';
	m_lpszTitle[7]='\0';
	m_lpszTitle[8]='4';
	m_lpszTitle[9]='\0';
	m_lpszTitle[10]='5';
	m_lpszTitle[11]='\0';
	m_lpszTitle[12]='6';
	m_lpszTitle[13]='\0';
	m_lpszTitle[14]='7';
	m_lpszTitle[15]='\0';
	m_lpszTitle[16]='8';
	m_lpszTitle[17]='\0';
	m_lpszTitle[18]='9';
	m_lpszTitle[19]='\0';
	m_lpszTitle[20]='A';
	m_lpszTitle[21]='\0';
	m_lpszTitle[22]='B';
	m_lpszTitle[23]='\0';
	m_lpszTitle[24]='C';
	m_lpszTitle[25]='\0';
	m_lpszTitle[26]='D';
	m_lpszTitle[27]='\0';
	m_lpszTitle[28]='E';
	m_lpszTitle[29]='\0';
	m_lpszTitle[30]='F';
	m_lpszTitle[31]='\0';
}   

void CGrid::Show(CDC* dc,BOOL bBorder)
{
	ASSERT(m_nRows<=m_nMaxRows);
	ASSERT(m_nMinRows<=m_nRows);
	ASSERT(m_nRows>=0);
	ASSERT(m_nLines<=m_nMaxLines);
	ASSERT(m_nMinLines<=m_nLines);
	ASSERT(m_nLines>=0);
	ASSERT(m_nGridHeight>=0);
	ASSERT(m_nGridWidth>=0);
	ASSERT(dc!=NULL);

	if (m_nRows == 0) return;
	if (m_nLines == 0) return;
	if (m_nGridHeight == 0) return;
	if (m_nGridWidth == 0) return;

	CPen pen;
	CPen greyPen;
	CPen whitePen;
	CPen blackPen;
	CPen *oldPen;
	COLORREF oldColor;
	SIZE size;
	RECT rect;
	char* lpszText;
	UINT nCount;
	int addx,addy;
	int i;
	int x,y;
	
	pen.CreatePen(PS_SOLID,1,PALETTEINDEX(7));
	greyPen.CreatePen(PS_SOLID,1,PALETTEINDEX(12));
	whitePen.CreatePen(PS_SOLID,1,PALETTEINDEX(19));
	blackPen.CreatePen(PS_SOLID,1,PALETTEINDEX(0));
	oldPen = dc->SelectObject(&pen);
	
	for(i=0;i<=m_nRows;i++)
	{
		x = m_nPosX + i*m_nGridWidth;
		dc->MoveTo(x,m_nPosY);
		dc->LineTo(x,m_rectPos.bottom);
	}
	
	for(i=0;i<=m_nLines;i++)
	{
		y = m_nPosY + i*m_nGridHeight;
		dc->MoveTo(m_nPosX,y);
		dc->LineTo(m_rectPos.right,y);
	}        

	lpszText = m_lpszTitle;
	dc->SelectStockObject(SYSTEM_FONT);                   
    oldColor = dc->SetBkColor(PALETTEINDEX(7));
	for(i=0;i<m_nRows;i++)
	{         
		rect.top = m_nPosY;
		rect.left = m_nPosX + i*m_nGridWidth;
		rect.bottom = m_nPosY+m_nGridHeight;
		rect.right = m_nPosX + (i+1)*m_nGridWidth;
		
		nCount = strlen(lpszText);
		
	    size = dc->GetOutputTextExtent(lpszText, nCount);
		addx = (rect.right - rect.left - size.cx) / 2;
	    addy = (rect.bottom - rect.top - size.cy) / 2 + 1;
	    dc->ExtTextOut(rect.left+addx, rect.top+addy, 
	        ETO_CLIPPED | ETO_OPAQUE, 
	        &rect, 
	        lpszText, 
	        nCount, 
	        NULL);
	    dc->SelectObject(&blackPen);  
	    dc->MoveTo(rect.left,rect.top);
	    dc->LineTo(rect.right,rect.top);
	    dc->LineTo(rect.right,rect.bottom);
	    dc->LineTo(rect.left,rect.bottom);
	    dc->LineTo(rect.left,rect.top);
	    dc->SelectObject(&whitePen);
	    dc->MoveTo(rect.left+1,rect.top+1);
	    dc->LineTo(rect.right-1,rect.top+1);
	    dc->MoveTo(rect.left+1,rect.top+1);
	    dc->LineTo(rect.left+1,rect.bottom-1);
	    dc->SelectObject(&greyPen);
	    dc->MoveTo(rect.right-1,rect.top+1);
	    dc->LineTo(rect.right-1,rect.bottom-1);
	    dc->LineTo(rect.left+1,rect.bottom-1);
	    lpszText+=nCount;
	    lpszText++;
	}
	
	if (bBorder)
	{
		dc->SelectObject(&blackPen);
		dc->MoveTo(m_rectPos.left,m_rectPos.top);
		dc->LineTo(m_rectPos.right,m_rectPos.top);
		dc->LineTo(m_rectPos.right,m_rectPos.bottom);
		dc->LineTo(m_rectPos.left,m_rectPos.bottom);
		dc->LineTo(m_rectPos.left,m_rectPos.top);
	}   
	
    dc->SetBkColor(oldColor);

	dc->SelectObject(oldPen);
}

RECT CGrid::GetGridRect(int x,int y)
{
	RECT rect;
	rect.left = m_nPosX + x * m_nGridWidth;
	rect.top = m_nPosY + y * m_nGridHeight;
	rect.right = rect.left + m_nGridWidth;
	rect.bottom = rect.top + m_nGridHeight;
	return rect;
}
