
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/MEMGTDLG.CPP   1.2.1.4   17 Apr 1997 15:56:30   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/MEMGTDLG.CPP  $
** 
**    Rev 1.2.1.4   17 Apr 1997 15:56:30   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:27:50   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:38:18   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:17:28   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:22:30   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:32:34   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:48:06   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:14:56   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:58:12   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:15:22   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:26:54   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:54:00   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:47:36   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:52:16   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:55:38   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:38:20   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:00:38   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:15:04   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:22:54   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:02:42   Shirley
** EasyPack/SLD Version 1.91
** 
**    Rev 1.30   12 Apr 1996 10:36:48   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:49:46   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:02:14   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:27:30   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:43:06   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:16:00   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:12:50   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:13:30   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:39:16   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:28:06   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:10:02   Shirley
** EasyPack/SLD Version 0.34b
** 
**    Rev 1.18   15 Jan 1996 16:16:18   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:11:50   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:08:28   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:35:02   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:24:16   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:25:00   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:29:24   Shirley
** EasyPack/SLD Version 0.24
**
**    Rev 1.11   08 Nov 1995 16:32:50   Shirley
** No change.
**
**    Rev 1.10   08 Nov 1995 12:42:12   Shirley
** EasyPack/SLD Version 0.22
**
**    Rev 1.4   13 Oct 1995 13:20:14   Shirley
** No change.
**
**    Rev 1.3   29 Sep 1995 09:49:32   Shirley
** No change.
**
**    Rev 1.2   20 Sep 1995 10:55:50   Shirley
** No change.
**
**    Rev 1.1   15 Sep 1995 09:45:58   Shirley
** EasyPack/SLDV0.1a
**
**    Rev 1.0   07 Sep 1995 09:54:48   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  MEMGTDLG.CPP
//
//  Description:The implement file for the class: CMemGtDlg
//
//  Author:     Lane Li & Daniel Lin
//
//  Modification:
//       
//      5. 03/11/96, 1.0 Version          Daniel Lin
//                 Modify for the Address server. All input address must be 
//          processed by address server.   
//                 modify function:     OnMemGotoButton1()
//
//      4. 10/31/95, 0.1g version.        Daniel Lin
//                 modify function:     OnMemGotoButton1()
//
//      3. 10/24/95, 0.1d version.        Daniel Lin
//                 modify function:     OnMemGotoButton1()
//
//      2. 10/18/95, 0.1d version.        Daniel Lin
//                 modify function:     OnMemGotoButton1()
//
//  Modification:
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

// memgtdlg.cpp : implementation file

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "stdafx.h"
#include "resource.h"
#include "xview.h"
#include "memgtdlg.h"
#include "errno.h"
#include "cpucom.h"
#include "abibase.h"
#include "cpuserve.h"
#include "uicom.h"
#include "hosterrs.h"

// For address server
#include "address.h"
#include "addrapi.h"


                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

//extern int GetMemoryRange(CPUMEMORYRANGE *stRange);
extern ADDR_SIZE  dwpMax;        // program  max address
extern ADDR_SIZE  dwpMin;        // program  min address
extern ADDR_SIZE  dwxMax;        // external max address
extern ADDR_SIZE  dwxMin;        // external min address
extern ADDR_SIZE  dwiMax;        // internal max address
extern ADDR_SIZE  dwiMin;        // internal min address

extern int GetCurrentBank(void);

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

                       /****************************
                        *                          *
                        *       GLOBAL VARS        *
                        *                          *
                        ****************************/

extern long linLastStartAddr;
extern unsigned char    linLastCheck;       

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/
/////////////////////////////////////////////////////////////////////////////
// CMemGtDlg dialog

/****************************************************************************
**  Name: CMemGtDlg
**
**
**  Description:
**        Constructor of CMemGtDlg
**
**  Parameters:
**
*****************************************************************************/
CMemGtDlg::CMemGtDlg(CWnd* pParent /*=NULL*/, BOOL isASM)
        : CDialog(CMemGtDlg::IDD, pParent)
{
    //{{AFX_DATA_INIT(CMemGtDlg)
          m_memdt_edit = "";
        //}}AFX_DATA_INIT
	m_bAsm=isASM;
}

void CMemGtDlg::DoDataExchange(CDataExchange* pDX)
{
        CDialog::DoDataExchange(pDX);
        //{{AFX_DATA_MAP(CMemGtDlg)
        DDX_Text(pDX, IDC_MEM_GOTO_EDIT1, m_memdt_edit);
        DDV_MaxChars(pDX, m_memdt_edit, 10);
        //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMemGtDlg, CDialog)
        //{{AFX_MSG_MAP(CMemGtDlg)
        ON_BN_CLICKED(IDC_MEM_GOTO_BUTTON1, OnMemGotoButton1)
        ON_BN_CLICKED(IDC_MEM_GOTO_BUTTON2, OnMemGotoButton2)
        //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/****************************************************************************
**
**  CMemGtDlg :: OnInitDialog
**
**  Description:
**     Initial the dialog box
**
**  Parameters:
**     input:
**        none
**
**     output:
**        BOOL:
**
*****************************************************************************/

BOOL CMemGtDlg::OnInitDialog()
{
// In this routine, it should be added into some other routine that is what
//    data's address range the cpu supported.
//    CPUMEMORYRANGE stRange;

    CDialog::OnInitDialog();
    CenterWindow();

    // TODO: Add extra initialization here
    char text[20];

    //m_lAddress = linLastStartAddr;
    //m_nSpace = linLastCheck;
    if(m_bAsm)
    	GetDlgItem(IDC_MEM_GOTO_RADIO3)->EnableWindow(FALSE);
    if(g_nBankNum==0)
    {
    	GetDlgItem(IDC_MEM_GOTO_BANK1)->EnableWindow(FALSE);
    	GetDlgItem(IDC_MEM_GOTO_BANK2)->EnableWindow(FALSE);
    	GetDlgItem(IDC_MEM_GOTO_BANK3)->EnableWindow(FALSE);
    	GetDlgItem(IDC_MEM_GOTO_BANK4)->EnableWindow(FALSE);
    }
    else if(g_nBankNum==2)
    {
        GetDlgItem(IDC_MEM_GOTO_RADIO1)->EnableWindow(FALSE);
        GetDlgItem(IDC_MEM_GOTO_BANK3)->EnableWindow(FALSE);
        GetDlgItem(IDC_MEM_GOTO_BANK4)->EnableWindow(FALSE);
    }
    else if(g_nBankNum==4)
    {
        GetDlgItem(IDC_MEM_GOTO_RADIO1)->EnableWindow(FALSE);
    }
    switch (m_nSpace) {
      case 1:
           CheckRadioButton(IDC_MEM_GOTO_RADIO1,
                            IDC_MEM_GOTO_BANK4,
                            IDC_MEM_GOTO_RADIO1);
           break;
      case 2:
           CheckRadioButton(IDC_MEM_GOTO_RADIO1,
                            IDC_MEM_GOTO_BANK4,
                            IDC_MEM_GOTO_RADIO2);
           break;
      case 3:
           CheckRadioButton(IDC_MEM_GOTO_RADIO1,
                            IDC_MEM_GOTO_BANK4,
                            IDC_MEM_GOTO_RADIO3);
           break;
	  case 6:	//bank1
           CheckRadioButton(IDC_MEM_GOTO_RADIO1,
                            IDC_MEM_GOTO_BANK4,
                            IDC_MEM_GOTO_BANK1);
           break;
      case 7:	//bank2
           CheckRadioButton(IDC_MEM_GOTO_RADIO1,
                            IDC_MEM_GOTO_BANK4,
                            IDC_MEM_GOTO_BANK2);
           break;
      case 8:	//bank3
           CheckRadioButton(IDC_MEM_GOTO_RADIO1,
                            IDC_MEM_GOTO_BANK4,
                            IDC_MEM_GOTO_BANK3);
           break;
      
      case 9:	//bank4
           CheckRadioButton(IDC_MEM_GOTO_RADIO1,
                            IDC_MEM_GOTO_BANK4,
                            IDC_MEM_GOTO_BANK4);
           break;
      default:
           break;
    }
   	sprintf(text, "%X", m_lAddress);
    SetDlgItemText(IDC_MEM_GOTO_EDIT1, text);
    CWnd* ctrl;
    ctrl=GetDlgItem(IDC_MEM_GOTO_EDIT1);
    ((CEdit *)ctrl)->SetFocus();
    ((CEdit *)ctrl)->SetSel(0,-1);
    // if the are has a map, remarked by Daniel Lin on 11/10/95
    
    if (dwpMax == 0 && dwpMin == 0) {
       GetDlgItem(IDC_MEM_GOTO_RADIO1)->EnableWindow(FALSE);
       GetDlgItem(IDC_MEM_GOTO_BANK1)->EnableWindow(FALSE);
       GetDlgItem(IDC_MEM_GOTO_BANK2)->EnableWindow(FALSE);
       GetDlgItem(IDC_MEM_GOTO_BANK3)->EnableWindow(FALSE);
       GetDlgItem(IDC_MEM_GOTO_BANK4)->EnableWindow(FALSE);
    }
    if (dwxMax == 0 && dwxMin == 0) {
           GetDlgItem(IDC_MEM_GOTO_RADIO2)->EnableWindow(FALSE);
    }
    if (dwiMax == 0 && dwiMin == 0) {
       GetDlgItem(IDC_MEM_GOTO_RADIO3)->EnableWindow(FALSE);
    }
    
    return FALSE;  // return TRUE  unless you set the focus to a control
}

/****************************************************************************
**
**  CMemGtDlg :: OnMemGotoButton1
**
**  Description:
**     Deal the OK button
**     Modify on 03/11/1996 because all input address field must be processed
**     by Address server
**
**  Parameters:
**     input:
**        none
**
**     output:
**        none
**
*****************************************************************************/

void CMemGtDlg::OnMemGotoButton1()
{
        // TODO: Add your control notification handler code here
        char *buf;
        int iWhichButton;
        CWnd* ctrl;
        
        // Add by Daniel Lin on 03/11/1996
        // For Address server      
        //
        CString       text;
        ADDRESS       startAddress;
        ADDR_RETCODE  retCode;
        CString       error;
                 
        buf = new char[25];
        ASSERT(NULL != buf);
        
        memset(buf, 0, sizeof(buf));
        iWhichButton = GetCheckedRadioButton(IDC_MEM_GOTO_RADIO1,
                                             IDC_MEM_GOTO_BANK4);
        switch ( iWhichButton ) {
          case IDC_MEM_GOTO_RADIO1:
                   if(g_nBankNum)
                   		m_nSpace = BYTE(GetCurrentBank());
                   else
                   		m_nSpace = 1;
                   linLastCheck = m_nSpace;
                   break;
                   
          case IDC_MEM_GOTO_RADIO2:
                   m_nSpace = 2;
                   linLastCheck = 2;
                   break;
                   
          case IDC_MEM_GOTO_RADIO3:
                   m_nSpace = 3;
                   linLastCheck = 3;
                   break;
		  case IDC_MEM_GOTO_BANK1:
                   m_nSpace = 6;
                   linLastCheck = 6;
                   break;
          case IDC_MEM_GOTO_BANK2:
                   m_nSpace = 7;
                   linLastCheck = 7;
                   break;
          case IDC_MEM_GOTO_BANK3:
                   m_nSpace = 8;
                   linLastCheck = 8;
                   break;
          case IDC_MEM_GOTO_BANK4:
                   m_nSpace = 9;
                   linLastCheck = 9;
                   break;
          default:
                   break;
        }
        
        GetDlgItemText( IDC_MEM_GOTO_EDIT1, buf, 20 );
        text = buf;
        retCode = AdrTextToAddr(text, startAddress);
        if (ADR_OK != retCode) {
          MessageBeep(-1);
          AdrErrorDeal(retCode, error);      
          MessageBox(error, "Input Error", MB_OK|MB_ICONEXCLAMATION);
          ctrl = GetDlgItem(IDC_MEM_GOTO_EDIT1);
          ((CEdit *)ctrl)->SetFocus();
          ((CEdit *)ctrl)->SetSel(0, -1);
         
          return;
        }
        
        if (SPACE_UNDEFINE != startAddress.adrSpace) {
        	if(startAddress.adrSpace!=m_nSpace)
        	{
	            MessageBeep(-1);
	            ErrDisplayError(ER_MEMDLG_ERRSPACE);
	            ctrl = GetDlgItem(IDC_MEM_GOTO_EDIT1);
	            ((CEdit *)ctrl)->SetFocus();
	            ((CEdit *)ctrl)->SetSel(0, -1);
	            return;
	        }
        }    
        switch( m_nSpace ) {
             case 1:
             case 6:
             case 7:
             case 8:
             case 9:
                  startAddress.adrSpace = (ADDR_SPACE)m_nSpace;
                  
                  if (!AdrCheckAddrRange(startAddress)) {
                      MessageBeep(-1);
                      ErrDisplayError(ER_MEMDLG_INPUT);
                      ctrl = GetDlgItem(IDC_MEM_GOTO_EDIT1);
                      ((CEdit *)ctrl)->SetFocus();
                      ((CEdit *)ctrl)->SetSel(0, -1);
                      
                      return;
                  }
                  break;
                  
             case 2:
                  startAddress.adrSpace = (ADDR_SPACE)m_nSpace;
                                    
                  if (!AdrCheckAddrRange(startAddress)) {
                      MessageBeep(-1);
                      ErrDisplayError(ER_MEMDLG_INPUT);
                      ctrl = GetDlgItem(IDC_MEM_GOTO_EDIT1);
                      ((CEdit *)ctrl)->SetFocus();
                      ((CEdit *)ctrl)->SetSel(0, -1);
                      
                      return;
                  }
                  break;
                  
             case 3:
                  startAddress.adrSpace = (ADDR_SPACE)m_nSpace;
                                    
                  if (!AdrCheckAddrRange(startAddress)) {
                      MessageBeep(-1);
                      ErrDisplayError(ER_MEMDLG_INPUT);
                      ctrl = GetDlgItem(IDC_MEM_GOTO_EDIT1);
                      ((CEdit *)ctrl)->SetFocus();
                      ((CEdit *)ctrl)->SetSel(0, -1);
                      
                      return;
                  }
                  break;
                  
        }
        m_lAddress = startAddress.adrAddress;
        linLastStartAddr = startAddress.adrAddress;
        
        if (NULL != buf)   delete []buf;
        
        EndDialog(1);
}

/****************************************************************************
**
**  CMemGtDlg :: OnMemGotoButton2
**
**  Description:
**     Deal the Cancel button
**
**  Parameters:
**     input:
**        none
**
**     output:
**        none
**
*****************************************************************************/

void CMemGtDlg::OnMemGotoButton2()
{
    // TODO: Add your control notification handler code here
    EndDialog(0);
}

