
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/SHLCOLOR.CPP   1.2.1.4   17 Apr 1997 15:58:38   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/SHLCOLOR.CPP  $
** 
**    Rev 1.2.1.4   17 Apr 1997 15:58:38   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:30:14   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:40:28   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:19:18   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:24:02   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:34:06   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:49:06   ZJRD
** Initial revision.
** 
**    Rev 1.0.1.2   09 Dec 1996 10:17:28   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.0.1.0   11 Nov 1996 13:00:42   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.4   09 Sep 1996 13:21:42   ZJRD
** No change.
** 
**    Rev 1.3   05 Sep 1996 11:33:10   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 10:00:14   ZJRD
** No change.
** 
**    Rev 1.1   28 Aug 1996 15:50:02   ZJRD
** No change.
** 
**    Rev 1.0   12 Aug 1996 10:54:08   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SHLCOLOR.CPP
//
//  Description:The implement file of the class ShellSyntaxColor
//
//  Author:     Annie Yi
//
//  Date:       07/29/96
//
//  Modification:
//
//      1. 07/29/96, Initial version 
//
//
//  Copyright (C) 1996 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////
                                           
/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include <ctype.h>
#include <direct.h>

#include "colors.h" 
#include "shlsynco.h"
#include "address.h"
#include "addrapi.h"
#include "aliaspub.h"
  
/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
  

/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.     

/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.
extern HintsList* pHintsList;


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.

/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
int GetControlOption(CString &strReset,CString &strEa,CString &strEben);
 

/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

void CSyntaxCheckSub::SetSyntaxColor(int nPos, int& nArgc, SynColor syncolor[])
{

    // Reset the error ID.
    m_nErrorID = 0;
    
    // Dispatch the syntax checking routine.
    switch ( m_nCommandID ) {    
        case CMDID_RUNMACRO:
            SetSyntaxColorRunMacro(nPos, nArgc, syncolor);
            break;
        case CMDID_VARDEFINE:
            SetSyntaxColorVarDefine(nPos, nArgc, syncolor);
            break;          
        case CMDID_ALIAS:
            SetSyntaxColorAlias(nPos, nArgc, syncolor);
            break;  
        case CMDID_ASSEMBLE:
            SetSyntaxColorAssemble(nPos, nArgc, syncolor);
            break;
        case CMDID_BIT:
            SetSyntaxColorBit(nPos, nArgc, syncolor);
            break;                                
        case CMDID_BREAKPOINT:
            SetSyntaxColorBreakpoint(nPos, nArgc, syncolor);
            break;           
        case CMDID_BYTE:
            SetSyntaxColorByte(nPos, nArgc, syncolor);
            break;                                
        case CMDID_CHECKSUM:
            SetSyntaxColorChecksum(nPos, nArgc, syncolor);
            break;
        case CMDID_CLEAR:
            SetSyntaxColorClear(nPos, nArgc, syncolor);
            break;             
        case CMDID_COMPARE:
            SetSyntaxColorCompare(nPos, nArgc, syncolor);
            break;
        case CMDID_CONTROL:
            SetSyntaxColorControl(nPos, nArgc, syncolor);
            break;
        case CMDID_COPY:         
            //The syntax is same as Compare
            SetSyntaxColorCompare(nPos, nArgc, syncolor);
            break;
        case CMDID_CYCLE:         
            SetSyntaxColorCycle(nPos, nArgc, syncolor);
            break;
        case CMDID_DISASSEMBLE:
            SetSyntaxColorDisassemble(nPos, nArgc, syncolor);
            break;          
        case CMDID_DIAGNOSIS:
            //SetSyntaxColorDiagnosis(nPos, nArgc, syncolor);
            break;
        case CMDID_EVENT:
            if ( m_nEvent == 0 )
                SetSyntaxColorEvent(nPos, nArgc, syncolor);
            if ( m_nEvent == 1 )
                SetSyntaxColorEv1(nPos, nArgc, syncolor);
            if ( m_nEvent == 2 )
                SetSyntaxColorEv2(nPos, nArgc, syncolor);
            if ( m_nEvent == 3 )
                SetSyntaxColorEv3(nPos, nArgc, syncolor);                       
            break;
        case CMDID_EV1:  
            SetSyntaxColorEv1(nPos, nArgc, syncolor);
            break;
        case CMDID_EV2:
            SetSyntaxColorEv2(nPos, nArgc, syncolor);
            break;
        case CMDID_EV3:
            SetSyntaxColorEv3(nPos, nArgc, syncolor);
            break;
        case CMDID_FILL:
            SetSyntaxColorFill(nPos, nArgc, syncolor);
            break;
        case CMDID_GO:
            SetSyntaxColorGo(nPos, nArgc, syncolor);
            break;
        case CMDID_HALT:
            SetSyntaxColorHalt(nPos, nArgc, syncolor);
            break;
        case CMDID_HELP:
            SetSyntaxColorHelp(nPos, nArgc, syncolor);
            break;             
        case CMDID_IDENTIFY:
            SetSyntaxColorIdentify(nPos, nArgc, syncolor);
            break;
        case CMDID_INCLUDE:
            SetSyntaxColorInclude(nPos, nArgc, syncolor);                      
            break;
        case CMDID_INPORT:
            SetSyntaxColorInport(nPos, nArgc, syncolor);
            break;
        case CMDID_JUMP:
            SetSyntaxColorJump(nPos, nArgc, syncolor);
            break;             
        case CMDID_LEVEL:         
            SetSyntaxColorLevel(nPos, nArgc, syncolor);
            break;
        case CMDID_LIST:
            SetSyntaxColorList(nPos, nArgc, syncolor);
            break;
        case CMDID_LOG:
            SetSyntaxColorLog(nPos, nArgc, syncolor);
            break;
        case CMDID_LONG:         
            SetSyntaxColorLong(nPos, nArgc, syncolor);
            break;
        case CMDID_LV1:         
            SetSyntaxColorLv1(nPos, nArgc, syncolor);
            break;
        case CMDID_LV2:         
            SetSyntaxColorLv1(nPos, nArgc, syncolor);
            break;
        case CMDID_MACRO:
            SetSyntaxColorMacro(nPos, nArgc, syncolor); 
            break;
        case CMDID_MAP:         
            SetSyntaxColorMap(nPos, nArgc, syncolor);
            break;
        case CMDID_MDEL:
            SetSyntaxColorMdel(nPos, nArgc, syncolor); 
            break;
        case CMDID_MEMORY:
            SetSyntaxColorMemory(nPos, nArgc, syncolor);
            break;
        case CMDID_MEND:
            SetSyntaxColorMend(nPos, nArgc, syncolor); 
            break;
        case CMDID_MLIST:
            SetSyntaxColorMlist(nPos, nArgc, syncolor); 
            break;
        case CMDID_OUTPORT:
            SetSyntaxColorOutport(nPos, nArgc, syncolor);
            break;
        case CMDID_PORT:
            SetSyntaxColorPort(nPos, nArgc, syncolor);
            break;
        case CMDID_QUALIFY:
            SetSyntaxColorEv2(nPos, nArgc, syncolor);
            break;
        case CMDID_REGISTER:
            SetSyntaxColorRegister(nPos, nArgc, syncolor);
            break;
        case CMDID_RESET:
            SetSyntaxColorReset(nPos, nArgc, syncolor);
            break;
        case CMDID_RESTART:
            SetSyntaxColorRestart(nPos, nArgc, syncolor);
            break;
        case CMDID_SAVEDISASM:
            SetSyntaxColorSavedisasm(nPos, nArgc, syncolor);
            break;          
        case CMDID_SEARCH:
            SetSyntaxColorSearch(nPos, nArgc, syncolor);
            break;              
        case CMDID_STEP:
            SetSyntaxColorStep(nPos, nArgc, syncolor);
            break;                      
        case CMDID_TEST:
            SetSyntaxColorTest(nPos, nArgc, syncolor);
            break;
        case CMDID_TIMER:         
            SetSyntaxColorTimer(nPos, nArgc, syncolor);
            break;             
        case CMDID_TRACE:
            SetSyntaxColorTrace(nPos, nArgc, syncolor);
            break;
        case CMDID_TRIGGER:
            SetSyntaxColorTrigger(nPos, nArgc, syncolor);
            break;
        case CMDID_UPLOAD:
            SetSyntaxColorUpload(nPos, nArgc, syncolor);
            break;
        case CMDID_VERIFY:
            SetSyntaxColorVerify(nPos, nArgc, syncolor);
            break;
        case CMDID_WORD:
            SetSyntaxColorWord(nPos, nArgc, syncolor);
            break;
        case CMDID_CREATE:
            SetSyntaxColorCreate(nPos, nArgc, syncolor);
            break;
        case CMDID_DELETE:
            SetSyntaxColorDelete(nPos, nArgc, syncolor);
            break;
        case CMDID_LOAD:
            SetSyntaxColorLoad(nPos, nArgc, syncolor);
            break;
        case CMDID_QUERY:
            SetSyntaxColorQuery(nPos, nArgc, syncolor);
            break;
        case CMDID_SSAVE:
            SetSyntaxColorSsave(nPos, nArgc, syncolor);
            break;
        case CMDID_SRECALL:
            SetSyntaxColorSrecall(nPos, nArgc, syncolor);
            break;
        case CMDID_SYMBOL:
            SetSyntaxColorSymbol(nPos, nArgc, syncolor);
            break;
        case CMDID_WATCH:
            SetSyntaxColorWatch(nPos, nArgc, syncolor);
            break;
        default:
            ASSERT( FALSE );
            break;
    }              

}

void CSyntaxCheckSub::SetSyntaxColorInit(int& nArgc, SynColor syncolor[])
{
    int i;                        
    nArgc = pHintsList[m_nCommandID].nCount;
    for ( i = 0; i < nArgc; i++ ) {
        syncolor[i].nColor = COLOR_BLACK;       
    }
                                                      
    i = 0;                                                    
    POSITION posHead  = pHintsList[m_nCommandID].plistHints->GetHeadPosition();
    while (posHead) {
        syncolor[i].strText = pHintsList[m_nCommandID].plistHints->GetNext(posHead); 
        i++;
    }   
}

void CSyntaxCheckSub::SetControlSyntaxColorInit(int& nArgc, SynColor syncolor[])
{
    int i;                        
    nArgc = pHintsList[m_nCommandID].nCount;
    for ( i = 0; i < nArgc; i++ ) {
        syncolor[i].nColor = COLOR_BLACK;       
    }                                                               

    i = 0;                                                    
    POSITION posHead  = pHintsList[m_nCommandID].plistHints->GetHeadPosition();
    while (posHead) {
        syncolor[i].strText = pHintsList[m_nCommandID].plistHints->GetNext(posHead); 
        i++;               
    }   

    CString strReset, strEa, strEben;
    ::GetControlOption(strReset,strEa,strEben);
    if (strEben.IsEmpty()) {
        nArgc = nArgc - 2;
        for ( int j = 5 ; j < 10 ; j++) {
            syncolor[j] = syncolor[j+2];        
        }                               
    }       
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxCheckSub::SetSyntaxColor***().
//
//  Description: Set Syntax color routine. 51 routines.
//
//  Input:  nPos - The total token number of shell line          
//
//  Output: nArgc - The total token number of hints
//          syncolor - The struct of hints
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////


void CSyntaxCheckSub::SetSyntaxColorRunMacro(int nPos, int& nArgc, 
    SynColor syncolor[])
{                
    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:                          
            //@macroname (arg0,...,arg9)
            syncolor[2].nColor = COLOR_RED;         
            break;
        default:
            break;  
     }      
}


void CSyntaxCheckSub::SetSyntaxColorVarDefine(int /*nPos*/, int& nArgc, 
    SynColor syncolor[])
{                
    SetSyntaxColorInit(nArgc, syncolor);
    
}


void CSyntaxCheckSub::SetSyntaxColorAlias(int nPos, int& nArgc, 
    SynColor syncolor[])
{                
    SetSyntaxColorInit(nArgc, syncolor);
        
    switch (nPos) {
        case 1:                         
            //Alias (original_name)
            syncolor[2].nColor = COLOR_RED;                     
            break;
        case 2:       
            //Alias original_name (new_name)
            syncolor[3].nColor = COLOR_RED;         
            break;
        default:
            break;  
     }      

}

void CSyntaxCheckSub::SetSyntaxColorAssemble(int nPos, int& nArgc, 
    SynColor syncolor[])
{                
    SetSyntaxColorInit(nArgc, syncolor);

    switch (nPos) {
        case 1:                             
            //Assemble (adr)
            syncolor[2].nColor = COLOR_RED;                     
            break;
        default:
            break;  
     }      

}


void CSyntaxCheckSub::SetSyntaxColorBit(int nPos, int& nArgc, 
    SynColor syncolor[])
{                
    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:              
            //Bit (bit_adr)
            syncolor[1].nColor = COLOR_RED;         
            break;
        case 2:         
            //Bit bit_adr (data1)
            syncolor[2].nColor = COLOR_RED;         
            break;
        case 3:               
            //Bit bit_adr data1 (data32)
            syncolor[4].nColor = COLOR_RED;         
            break;          
        default:
            break;  
     }      
}


void CSyntaxCheckSub::SetSyntaxColorBreakpoint(int nPos, int& nArgc, 
    SynColor syncolor[])
{                
    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:            
            //Breakpoint (adr)
            syncolor[2].nColor = COLOR_RED;                     
            break;
        default:
            break;  
     }      

}
                                       
void CSyntaxCheckSub::SetSyntaxColorByte(int nPos, int& nArgc, 
    SynColor syncolor[])
{                
    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:              
            //Byte (adr)
            syncolor[1].nColor = COLOR_RED;         
            break;
        case 2:         
            //Byte adr (data1)
            syncolor[2].nColor = COLOR_RED;         
            break;
        case 3:               
            //Byte adr data1 (data32)
            syncolor[4].nColor = COLOR_RED;         
            break;          
        default:
            break;  
     }      
}
                                       

void CSyntaxCheckSub::SetSyntaxColorChecksum(int nPos, int& nArgc, 
    SynColor syncolor[])
{                
    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:               
            //Checksum (adr1)
            syncolor[1].nColor = COLOR_RED;         
            break;
        case 2:
            //Checksum adr1 (adr2|Length)
            syncolor[3].nColor = COLOR_RED;         
            syncolor[5].nColor = COLOR_RED;         
            break;                       
        case 3:
            //Checksum adr1 Length length
            syncolor[6].nColor = COLOR_RED;         
            break;
        default: 
            break;  
     }      

}


void CSyntaxCheckSub::SetSyntaxColorClear(int nPos, int& nArgc, 
    SynColor syncolor[])
{                
    SetSyntaxColorInit(nArgc, syncolor);

    switch (nPos) {
        case 1:                          
            //Clear (All|adr)
            syncolor[2].nColor = COLOR_RED;             
            syncolor[4].nColor = COLOR_RED;         
            break;
        default:
            break;
    }           
}             

void CSyntaxCheckSub::SetSyntaxColorCompare(int nPos, int& nArgc, 
    SynColor syncolor[])
{                
    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:                  
            //Compare (adr1)
            syncolor[1].nColor = COLOR_RED;         
            break;
        case 2:             
            //Compare adr1 (adr2|Length)                        
            syncolor[3].nColor = COLOR_RED;         
            syncolor[5].nColor = COLOR_RED;         
            break;
        case 3:                         
            //Compare adr1 Length (length)
            syncolor[6].nColor = COLOR_RED;         
            break;
        case 4:                           
            //Compare adr1 adr2 (adr3)
            //Compare adr1 Length length (adr3)
            syncolor[8].nColor = COLOR_RED;                     
        default:
            break;  
     }      


}

void CSyntaxCheckSub::SetSyntaxColorControl(int nPos, int& nArgc, 
    SynColor syncolor[])
{                
    SetControlSyntaxColorInit(nArgc, syncolor);

    CString strReset, strEa, strEben;
    ::GetControlOption(strReset,strEa,strEben);
    
    switch (nPos) {
        case 1:                             
            if (!strEben.IsEmpty()) {
                //Control (Reset|EA|Eben)
                syncolor[2].nColor = COLOR_RED;                     
                syncolor[4].nColor = COLOR_RED;                     
                syncolor[6].nColor = COLOR_RED;                                 
            }
            else {                       
                //Control (Reset|EA)
                syncolor[2].nColor = COLOR_RED;                     
                syncolor[4].nColor = COLOR_RED;                                 
            }   
            break;
        case 2:                      
            if (!strEben.IsEmpty()) {       
                syncolor[8].nColor = COLOR_RED;                     
                syncolor[10].nColor = COLOR_RED;                                    
            }
            else {
                syncolor[6].nColor = COLOR_RED;                     
                syncolor[8].nColor = COLOR_RED;                                 
            }   
            break;
        default:
            break;  
     }      


}

/*
void CSyntaxCheckSub::SetSyntaxColorCopy(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

}
*/                                      

void CSyntaxCheckSub::SetSyntaxColorCycle(int nPos, int& nArgc, 
    SynColor syncolor[])
{                
    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:                          
            break;
        default:
            break;  
     }      
}


void CSyntaxCheckSub::SetSyntaxColorDisassemble(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:                            
            //Disassemble (adr1)
            syncolor[2].nColor = COLOR_RED;         
            break;
        case 2:                 
            //Disassemble adr1 (adr2|Length)
            syncolor[4].nColor = COLOR_RED;         
            syncolor[6].nColor = COLOR_RED;         
            break;
        case 3:                             
            //Disassemble adr1 Length (length)
            syncolor[7].nColor = COLOR_RED;         
            break;
        default: 
            break;  
     }      

}

// Added by Gates Hua , 3/6/98 for dome and ZJ FAE
void CSyntaxCheckSub::SetSyntaxColorSavedisasm(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:                            
            //SAvedisasm adr1
            syncolor[1].nColor = COLOR_RED;         
            break;
        case 2:                 
            //SAvedisasm adr1 {adr2|Length}
            syncolor[3].nColor = COLOR_RED;         
            syncolor[5].nColor = COLOR_RED;         
            break;
        case 3:                             
            //SAvedisasm adr1 Length length
            syncolor[6].nColor = COLOR_RED;         
            break;
        case 4:
            //SAvedisasm adr1 {adr2 |Length length} filename
            syncolor[8].nColor = COLOR_RED;         
            break;
        default: 
            break;  
     }      

}

/*
void CSyntaxCheckSub::SetSyntaxColorDiagnosis(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:
            break;
        case 2:
            break;
        case 3:
            break;
        
        default:
            break;  
     }      

}
*/


void CSyntaxCheckSub::SetSyntaxColorEvent(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:        
            //Event (1|2|3|Clear)
            syncolor[2].nColor = COLOR_RED;         
            syncolor[4].nColor = COLOR_RED;         
            syncolor[6].nColor = COLOR_RED;         
            syncolor[8].nColor = COLOR_RED;         
            break;
        default:
            break;  
     }      

}


void CSyntaxCheckSub::SetSyntaxColorEv1(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    if ( m_nEvent == 1) {   
        syncolor[0].strText = "Event 1 ";
    }   
    
    switch (nPos) {
        case 1:
            //Ev1 (Address|Datum|Status|Count|Clear)
            syncolor[2].nColor = COLOR_RED;   //Address         
            syncolor[12].nColor = COLOR_RED;  //Datum           
            syncolor[22].nColor = COLOR_RED;  //Status          
            syncolor[25].nColor = COLOR_RED;  //Count                       
            syncolor[28].nColor = COLOR_RED;  //Clear               
            break;
        case 2:
            //Ev1 Address (Range|xadr|badrs)
            syncolor[4].nColor = COLOR_RED;   
            syncolor[8].nColor = COLOR_RED;   
            syncolor[10].nColor = COLOR_RED;            
            break;
        case 3:
            //Ev1 Datum (Range|xdata|bdata)
            syncolor[14].nColor = COLOR_RED;      
            syncolor[18].nColor = COLOR_RED;   
            syncolor[20].nColor = COLOR_RED;            
            break;
        case 4:                                   
            //Ev1 Count (data)
            syncolor[26].nColor = COLOR_RED;      
            break;      
        case 5:
            //Ev1 Address Range (adr1)            
            syncolor[5].nColor = COLOR_RED;   
            break;
        case 6:
            //Ev1 Address badrs..
            syncolor[10].nColor = COLOR_RED;        
            break;
        case 7:
            //Ev1 Address xadr (Datum|Status|Count)         
            syncolor[12].nColor = COLOR_RED;  //Datum           
            syncolor[22].nColor = COLOR_RED;  //Status          
            syncolor[25].nColor = COLOR_RED;  //Count           
            break;
        case 8:
            //Ev1 Datum Range (data1)
            syncolor[15].nColor = COLOR_RED;      
            break;  
        case 9:
            //Ev1 Datum (bdata)
            syncolor[20].nColor = COLOR_RED;      
            break;  
        case 10:
            //Ev1 Datum (xdata)
            syncolor[18].nColor = COLOR_RED;      
            break;  
        case 11:
            //Ev1 Count (data)
            syncolor[26].nColor = COLOR_RED;      
            break;  
        case 12:
            //Ev1 Address Range adr1 (adr2)
            syncolor[6].nColor = COLOR_RED;   
            break;  
        case 13:
            //Ev1 Datum Range data1 (data2)
            syncolor[16].nColor = COLOR_RED;      
            break;                              
        case 14:
            //Ev1 Address .. Datum ..(Status|Count)
            syncolor[22].nColor = COLOR_RED;  //Status           
            syncolor[25].nColor = COLOR_RED;  //Count           
            break;                          
        case 15:
            //Ev1 Address ..Count ..(Datum|Status)                              
            syncolor[12].nColor = COLOR_RED;  //Datum            
            syncolor[22].nColor = COLOR_RED;  //Status           
            break;                              
        case 16:
            //Ev1 Datum .. Count .. (Address|Status)                    
            syncolor[2].nColor = COLOR_RED;   //Address         
            syncolor[22].nColor = COLOR_RED;  //Status           
            break;
        case 17:
            //Ev1 Datum ..(Address|Status|Count)                       
            syncolor[2].nColor = COLOR_RED;   //Address         
            syncolor[22].nColor = COLOR_RED;  //Status           
            syncolor[25].nColor = COLOR_RED;  //Count           
            break;
        case 18:
            //Ev1 Count .. (Address|Datum|Status)                   
            syncolor[2].nColor = COLOR_RED;   //Address         
            syncolor[12].nColor = COLOR_RED;  //Datum           
            syncolor[22].nColor = COLOR_RED;  //Status                      
            break;      
        case 19:
            //Ev1 Address (badr..|Datum|Status|Count)           
            syncolor[10].nColor = COLOR_RED;            
            syncolor[12].nColor = COLOR_RED;  //Datum           
            syncolor[22].nColor = COLOR_RED;  //Status           
            syncolor[25].nColor = COLOR_RED;  //Count           
            break;
        case 20:
            //Ev1 Datum ..Address .. (badr..|Status|Count)            
            syncolor[10].nColor = COLOR_RED;        
            syncolor[22].nColor = COLOR_RED;  //Status              
            syncolor[25].nColor = COLOR_RED;  //Count           
            break;                          
        case 21:
            //Ev1 Count ..Address (badr..|Datum|Status)             
            syncolor[10].nColor = COLOR_RED;                            
            syncolor[12].nColor = COLOR_RED;  //Datum
            syncolor[22].nColor = COLOR_RED;  //Status                      
            break;                                              
        case 22:
            //Ev1 Status (status..)             
            syncolor[23].nColor = COLOR_RED;  //status..                        
            break;                                      
        case 23:
            //Ev1 Address.. Status ..(Datum|Count)          
            syncolor[12].nColor = COLOR_RED;  //Datum           
            syncolor[25].nColor = COLOR_RED;  //Count           
            break;
        case 24:
            //Ev1 Address.. Status ..Count..(Datum)         
            syncolor[12].nColor = COLOR_RED;  //Datum           
            break;      
        case 25:
            //Ev1 Count ..Address.. Datum..(Status)             
            syncolor[22].nColor = COLOR_RED;  //Status                      
            break;                                              
        case 26:
            //Ev1 Address.. Status ..Datum..(Count)         
            syncolor[25].nColor = COLOR_RED;  //Count           
            break;
        case 27:
            //Ev1 Datum ..Address (badr..|Status|Count)         
            syncolor[10].nColor = COLOR_RED;                                
            syncolor[22].nColor = COLOR_RED;  //Status           
            syncolor[25].nColor = COLOR_RED;  //Count           
            break;
        case 28:
            //Ev1 Count ..Status.. Address (badr..|Datum)           
            syncolor[10].nColor = COLOR_RED;                                
            syncolor[12].nColor = COLOR_RED;  //Datum            
            break;
        case 29:
            //Ev1 Datum ..Count..Address (badr..|Status)            
            syncolor[10].nColor = COLOR_RED;                                
            syncolor[22].nColor = COLOR_RED;  //Status           
            break;
        case 30:
            //Ev1 Datum ..Status..Address (badr..|Count)            
            syncolor[10].nColor = COLOR_RED;                                
            syncolor[25].nColor = COLOR_RED;  //Count           
            break;
        case 31:
            //Ev1 Datum ..Status..Count..Address (badr..)           
            syncolor[10].nColor = COLOR_RED;                                
            break;
        case 32:
            //Ev1 Datum.. Status(Address|Count)
            syncolor[2].nColor = COLOR_RED;   //Address         
            syncolor[25].nColor = COLOR_RED;  //Count                       
            break;                     
        case 33:
            //Ev1 Datum.. Status..Count(Address)
            syncolor[2].nColor = COLOR_RED;   //Address         
            break;                     
        case 34:
            //Ev1 Status..Count(Address|Datum)          
            syncolor[2].nColor = COLOR_RED;   //Address         
            syncolor[12].nColor = COLOR_RED;  //Datum           
            break;
        case 35:
            //Ev1 Status(Address|Datum|Count)
            syncolor[2].nColor = COLOR_RED;   //Address         
            syncolor[12].nColor = COLOR_RED;  //Datum           
            syncolor[25].nColor = COLOR_RED;  //Count                       
            break;
        default:                                                            
            break;  
     }      

}

void CSyntaxCheckSub::SetSyntaxColorEv2(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);

    if ( m_nEvent == 2) {   
        syncolor[0].strText = "Event 2 ";
    }   
    
    switch (nPos) {
        case 1:
            //Ev2 (Address|Datum|Status|Clear)
            syncolor[2].nColor = COLOR_RED;   //Address         
            syncolor[12].nColor = COLOR_RED;  //Datum           
            syncolor[22].nColor = COLOR_RED;  //Status                      
            syncolor[25].nColor = COLOR_RED;  //Clear               
            break;
        case 2:
            //Ev2 Address (Range|xadr|badrs)
            syncolor[4].nColor = COLOR_RED;   
            syncolor[8].nColor = COLOR_RED;   
            syncolor[10].nColor = COLOR_RED;            
            break;
        case 3:
            //Ev2 Datum (Range|xdata|bdata)
            syncolor[14].nColor = COLOR_RED;      
            syncolor[18].nColor = COLOR_RED;   
            syncolor[20].nColor = COLOR_RED;            
            break;
        case 4:
            //Ev2 Address Range (adr1)            
            syncolor[5].nColor = COLOR_RED;   
            break;
        case 5:
            //Ev2 Address Range adr1 (adr2)
            syncolor[6].nColor = COLOR_RED;   
            break;  
        case 6:
            //Ev2 Address (badrs..)
            syncolor[10].nColor = COLOR_RED;        
            break;
        case 7:
            //Ev2 Address.. (Datum|Status)          
            syncolor[12].nColor = COLOR_RED;  //Datum   
            syncolor[22].nColor = COLOR_RED;  //Status          
            break;         
        case 8:
            //Ev2 Address.. (badrs..|Datum|Status)          
            syncolor[10].nColor = COLOR_RED;        
            syncolor[12].nColor = COLOR_RED;  //Datum           
            syncolor[22].nColor = COLOR_RED;  //Status  
            break;         
        case 9:
            //Ev2 Datum Range (data1)
            syncolor[15].nColor = COLOR_RED;      
            break;  
        case 10:
            //Ev2 Datum Range data1 (data2)
            syncolor[16].nColor = COLOR_RED;      
            break;
        case 11:
            //Ev2 Datum..(Address|Status)                   
            syncolor[2].nColor = COLOR_RED;   //Address         
            syncolor[22].nColor = COLOR_RED;  //Status  
            break;
        case 12:
            //Ev2 Status (status..)                 
            syncolor[23].nColor = COLOR_RED;      //status..
            break;            
        case 13:
            //Ev2 Status (Address|Datum)
            syncolor[2].nColor = COLOR_RED;   //Address         
            syncolor[12].nColor = COLOR_RED;  //Datum           
            break;
        case 14:
            //Ev2 Status.. Address (Datum)            
            syncolor[12].nColor = COLOR_RED;  //Datum           
            break;
        case 15:
            //Ev2 Datum..Address (Status)                   
            syncolor[22].nColor = COLOR_RED;  //Status  
            break;
        case 16:
            //Ev2 Status..Datum (Address)
            syncolor[2].nColor = COLOR_RED;   //Address         
            break;
        case 17:
            //Ev2 Address (badrs..|Datum)
            syncolor[10].nColor = COLOR_RED;                    
            syncolor[12].nColor = COLOR_RED;  //Datum           
            break;
        case 18:
            //Ev2 Address (badrs..|Status)
            syncolor[10].nColor = COLOR_RED;            
            syncolor[22].nColor = COLOR_RED;  //Status  
            break;
        default:
            break;  
     }      

}

void CSyntaxCheckSub::SetSyntaxColorEv3(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);

    if ( m_nEvent == 3) {   
        syncolor[0].strText = "Event 3 ";
    }   
    
    switch (nPos) {
        case 1:                        
            //Ev3 (High|Low)
            syncolor[2].nColor = COLOR_RED;             
            syncolor[4].nColor = COLOR_RED;         
            break;
        default:
            break;  
     }      

}


void CSyntaxCheckSub::SetSyntaxColorFill(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:
            //Fill (adr1)
            syncolor[1].nColor = COLOR_RED;             
            break;
        case 2:          
            //Fill adr1 (adr2|Length)
            syncolor[3].nColor = COLOR_RED;             
            syncolor[5].nColor = COLOR_RED;             
            break;
        case 3:                      
            //Fill adr1 Length (length)
            syncolor[6].nColor = COLOR_RED;                     
            break;
        case 4:                 
            //Fill adr1 ...("string"|data..)
            syncolor[8].nColor = COLOR_RED;             
            syncolor[10].nColor = COLOR_RED;                                    
            break;
        default:                                                
            break;  
     }      

}

void CSyntaxCheckSub::SetSyntaxColorGo(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:               
            //Go (Run|From|Till|Monitor)
            syncolor[2].nColor = COLOR_RED;             
            syncolor[7].nColor = COLOR_RED;             
            syncolor[10].nColor = COLOR_RED;                
            syncolor[13].nColor = COLOR_RED;                
            break;
        case 2: 
            //Go Run (From)
            syncolor[4].nColor = COLOR_RED;                     
            break;
        case 3: 
            //Go From (adr1)
            syncolor[8].nColor = COLOR_RED;                     
            break;    
        case 4:      
            //Go Till (adr2)
            syncolor[11].nColor = COLOR_RED;                            
            break;                                                            
        case 5:      
            //Go Monitor (timer)
            syncolor[14].nColor = COLOR_RED;                            
            break;                                                            
        case 6:
            //Go Run From (adr1)
            syncolor[5].nColor = COLOR_RED;                                     
            break;
        case 7:
            //Go From adr1 (Till)
            syncolor[10].nColor = COLOR_RED;                            
            break;
        case 8:
            //Go From adr1 Till (adr2)
            syncolor[11].nColor = COLOR_RED;                                        
            break;
        default:
            break;  
     }      

}

void CSyntaxCheckSub::SetSyntaxColorHalt(int /*nPos*/, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
}

void CSyntaxCheckSub::SetSyntaxColorHelp(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:                  
            //Help (command)
            syncolor[2].nColor = COLOR_RED;                         
            break;
        default:
            break;  
     }      

}

void CSyntaxCheckSub::SetSyntaxColorIdentify(int /*nPos*/, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
}

void CSyntaxCheckSub::SetSyntaxColorInclude(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:             
            //Include (filename)
            syncolor[1].nColor = COLOR_RED;                                 
            break;
        default:
            break;  
     }      

}

void CSyntaxCheckSub::SetSyntaxColorInport(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:                            
            //Inport (port)
            syncolor[1].nColor = COLOR_RED;         
            break;
        case 2:          
            //Inport port (Bit|byte)
            syncolor[3].nColor = COLOR_RED;
            syncolor[6].nColor = COLOR_RED;
            break;
        case 3:       
            //Inport port Bit (bit_no)
            syncolor[4].nColor = COLOR_RED;
            break;          
        default:
            break;  
     }      

}

void CSyntaxCheckSub::SetSyntaxColorJump(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:                 
            //Jump (adr)
            syncolor[1].nColor = COLOR_RED;                                         
            break;
        default:
            break;  
     }      

}

void CSyntaxCheckSub::SetSyntaxColorLevel(int nPos, int& nArgc, 
    SynColor syncolor[])
{                
    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:                            
            //Level (1|2)
            syncolor[2].nColor = COLOR_RED;     
            syncolor[4].nColor = COLOR_RED;         
            break;    
        case 2:      
            //Level 1 (eventlogic)                               
            syncolor[6].nColor = COLOR_RED;         
            break;
        case 3:      
            //Level 1 eventlogic (Trace|Timer)      
            syncolor[6].nColor = COLOR_RED;                     
            syncolor[8].nColor = COLOR_RED;         
            syncolor[13].nColor = COLOR_RED;                        
            break;
        case 4:      
            //Level 1 eventlogic Trace (On|Off)                               
            syncolor[9].nColor = COLOR_RED;         
            syncolor[11].nColor = COLOR_RED;                        
            break;
        case 5:      
            //Level 1 eventlogic Timer (On|Off)                               
            syncolor[14].nColor = COLOR_RED;            
            syncolor[16].nColor = COLOR_RED;                        
            break;
        case 6:      
            //Level 1 eventlogic Trace On (Timer)
            syncolor[13].nColor = COLOR_RED;            
            break;
                                
        default:
            break;  
     }      
}


void CSyntaxCheckSub::SetSyntaxColorList(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:
            //List (Number|Source|Assemble|Mixed|Module|frame|Address|Datum|Status)
            syncolor[2].nColor = COLOR_RED; //Number
            syncolor[4].nColor = COLOR_RED; //Source
            syncolor[6].nColor = COLOR_RED; //Assemble
            syncolor[8].nColor = COLOR_RED; //Mixed
            syncolor[10].nColor = COLOR_RED;//Module    
            syncolor[12].nColor = COLOR_RED;//frame        
            syncolor[14].nColor = COLOR_RED;//Address
            syncolor[24].nColor = COLOR_RED;//Datum
            syncolor[34].nColor = COLOR_RED;//Status
            break;
        case 2:       
            //List Source (frame|Address|Datum|Status) 
            syncolor[12].nColor = COLOR_RED;//frame        
            syncolor[14].nColor = COLOR_RED;//Address
            syncolor[24].nColor = COLOR_RED;//Datum 
            syncolor[34].nColor = COLOR_RED;//Status
            break;
        case 3:        
            //List frame (Address|Datum|Status)
            syncolor[14].nColor = COLOR_RED;//Address
            syncolor[24].nColor = COLOR_RED;//Datum
            syncolor[34].nColor = COLOR_RED;//Status
            break;
        case 4:        
            //List .. Address (Range|xadr|badrs..)
            syncolor[16].nColor = COLOR_RED;
            syncolor[20].nColor = COLOR_RED;
            syncolor[22].nColor = COLOR_RED;
            break;
        case 5:
            //List .. Datum (Range|xdata|bdata)
            syncolor[26].nColor = COLOR_RED;
            syncolor[30].nColor = COLOR_RED;
            syncolor[32].nColor = COLOR_RED;
            break;              
        case 6:
            //List .. Address Range (adr1)
            syncolor[17].nColor = COLOR_RED;
            break;              
        case 7:        
            //List .. Address (Datum|Status)
            syncolor[24].nColor = COLOR_RED;//Datum
            syncolor[34].nColor = COLOR_RED;//Status
            break;
        case 8:        
            //List .. Address (badrs..|Datum|Status)
            syncolor[22].nColor = COLOR_RED; 
            syncolor[24].nColor = COLOR_RED;//Datum
            syncolor[34].nColor = COLOR_RED;//Status
            break;
        case 9:
            //List .. Datum Range (data1)
            syncolor[27].nColor = COLOR_RED;
            break;              
        case 10:        
            //List .. Address Range adr1 (adr2)
            syncolor[18].nColor = COLOR_RED;
            break;
        case 11:        
            //List .. Datum Range data1 (data2)
            syncolor[28].nColor = COLOR_RED;
            break;
        case 12:        
            //List .. Status (status..)
            syncolor [35].nColor = COLOR_RED;
            break;
        case 13:       
            //List Address (Datum)
            syncolor[24].nColor = COLOR_RED;//Datum 
            break;
        case 14:       
            //List Address (Status)
            syncolor[34].nColor = COLOR_RED;//Status 
            break;
        case 15:        
            //List Status.. Address (badrs..|Datum)
            syncolor[22].nColor = COLOR_RED; 
            syncolor[24].nColor = COLOR_RED;//Datum
            break;
        case 16:        
            //List Datum.. Address (badrs..|Status)
            syncolor[22].nColor = COLOR_RED; 
            syncolor[34].nColor = COLOR_RED;//Status
            break;
        case 17:        
            //List Datum ..Status.. Address (badrs..)
            syncolor[22].nColor = COLOR_RED; 
            break;
        case 18:        
            //List Datum .. (Address|Status)
            syncolor[14].nColor = COLOR_RED;//Address
            syncolor[34].nColor = COLOR_RED;//Status
            break;
        case 19:        
            //List Status..Datum .. (Address)
            syncolor[14].nColor = COLOR_RED;//Address
            break;
        case 20:        
            //List Status .. (Address|Datum)
            syncolor[14].nColor = COLOR_RED;//Address
            syncolor[24].nColor = COLOR_RED;//Datum
            break;

        default:
            break;  
     }      

}

void CSyntaxCheckSub::SetSyntaxColorLog(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:         
            //Log (filename|On|Off|Close)
            syncolor[2].nColor = COLOR_RED; 
            syncolor[8].nColor = COLOR_RED;                                         
            syncolor[10].nColor = COLOR_RED;                                            
            syncolor[12].nColor = COLOR_RED;    
            break;
        case 2:                          
            //Log filename (Command|Append)
            syncolor[4].nColor = COLOR_RED; 
            syncolor[6].nColor = COLOR_RED; 
            break;
        case 3:
            //Log filename Command (Append)
            syncolor[6].nColor = COLOR_RED;                 
        default:
            break;  
     }      

}                                        

void CSyntaxCheckSub::SetSyntaxColorLong(int nPos, int& nArgc, 
    SynColor syncolor[])
{                
    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:              
            //Long (adr)
            syncolor[1].nColor = COLOR_RED;         
            break;
        case 2:         
            //Long adr (data1)
            syncolor[2].nColor = COLOR_RED;         
            break;
        case 3:               
            //Long adr data1 (data8)
            syncolor[4].nColor = COLOR_RED;         
            break;          
        default:
            break;  
     }      
}
                                        
void CSyntaxCheckSub::SetSyntaxColorLv1(int nPos, int& nArgc, 
    SynColor syncolor[])
{                
    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:      
            //Level (eventlogic)                               
            syncolor[2].nColor = COLOR_RED;         
            break;
        case 2:      
            //Level eventlogic (Trace|Timer)      
            syncolor[2].nColor = COLOR_RED;                     
            syncolor[4].nColor = COLOR_RED;         
            syncolor[9].nColor = COLOR_RED;                     
            break;
        case 3:      
            //Level eventlogic Trace (On|Off)                               
            syncolor[5].nColor = COLOR_RED;         
            syncolor[7].nColor = COLOR_RED;                     
            break;
        case 4:      
            //Level eventlogic Timer (On|Off)                               
            syncolor[10].nColor = COLOR_RED;            
            syncolor[12].nColor = COLOR_RED;                        
            break;
        case 5:     
            //Level eventlogic Trace On (Timer)
            syncolor[9].nColor = COLOR_RED;         
            break;                                  
        default:
            break;  
     }      
}

/*                                       
void CSyntaxCheckSub::SetSyntaxColorLv2(int nPos, int& nArgc, 
    SynColor syncolor[])
{                                      

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:                          
            break;
        default:
            break;  
     }      

}
*/                                        

void CSyntaxCheckSub::SetSyntaxColorMacro(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:
            //Macro (macroname)
            syncolor[1].nColor = COLOR_RED;                                         
            break;
        default:
            break;  
     }      

}                                      

void CSyntaxCheckSub::SetSyntaxColorMap(int nPos, int& nArgc, 
    SynColor syncolor[])
{                
    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:                          
            //Map (All|adr1)
            syncolor[2].nColor = COLOR_RED;
            syncolor[5].nColor = COLOR_RED;
            break;    
        case 2:                          
            //Map All (adrtype)
            syncolor[3].nColor = COLOR_RED;
            break;    
        case 3:                          
            //Map adr1 (adr2|Length)
            syncolor[7].nColor = COLOR_RED;
            syncolor[9].nColor = COLOR_RED;
            break;    
        case 4:                          
            //Map All adrtype (map_attribute)
            syncolor[12].nColor = COLOR_RED;
            break;    
        case 5:                          
            //Map adr1 Length (length)
            syncolor[10].nColor = COLOR_RED;
            break;                      
        default:
            break;  
     }      
}


void CSyntaxCheckSub::SetSyntaxColorMdel(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:                
            //Mdel (macroname|All)
            syncolor[1].nColor = COLOR_RED;                                         
            syncolor[3].nColor = COLOR_RED;                                         
            break;
        default:
            break;  
     }      

}

void CSyntaxCheckSub::SetSyntaxColorMemory(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1: 
            //Memory (adr1)
            syncolor[1].nColor = COLOR_RED;         
            break;
        case 2:           
            //Memory adr1 (adr2|Length)
            syncolor[3].nColor = COLOR_RED;         
            syncolor[5].nColor = COLOR_RED;         
            break;
        case 3:                   
            //Memory adr1 Length (length)
            syncolor[6].nColor = COLOR_RED;         
            break;
        default: 
            break;  
     }      

}

void CSyntaxCheckSub::SetSyntaxColorMend(int /*nPos*/, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
}

void CSyntaxCheckSub::SetSyntaxColorMlist(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:                
            //Mlist (macroname)
            syncolor[2].nColor = COLOR_RED;                                         
            break;
        default:
            break;  
     }      

}

void CSyntaxCheckSub::SetSyntaxColorOutport(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:
            //Outport (port)
            syncolor[1].nColor = COLOR_RED;         
            break;
        case 2:  
            //Outport port (Bit|Byte)
            syncolor[3].nColor = COLOR_RED;                     
            syncolor[7].nColor = COLOR_RED;         
            break;
        case 3:       
            //Outport port Bit (bit)
            syncolor[4].nColor = COLOR_RED;         
            break;          
        case 4:       
            //Outport port Bit bit (data1)
            syncolor[5].nColor = COLOR_RED;         
            break;                                  
        case 5:
            //Outport port Byte (data2)
            syncolor[8].nColor = COLOR_RED;                             
        default:
            break;  
     }      

}
                                           
void CSyntaxCheckSub::SetSyntaxColorPort(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:
            //Port (port)
            syncolor[1].nColor = COLOR_RED;         
            break;
        default:
            break;  
    }
}                                              
                                           

void CSyntaxCheckSub::SetSyntaxColorRegister(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:                
            //Register (reg_id)
            syncolor[2].nColor = COLOR_RED;
            break;
        case 2:                
            //Register reg_id (data)            
            syncolor[4].nColor = COLOR_RED;
            break;
        default:
            break;  
     }      

}

void CSyntaxCheckSub::SetSyntaxColorReset(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:                     
            //Reset (adr)
            syncolor[2].nColor = COLOR_RED;                                         
            break;
        default:
            break;  
     }                                                              
}                                 

void CSyntaxCheckSub::SetSyntaxColorRestart(int /*nPos*/, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
}
                                         
void CSyntaxCheckSub::SetSyntaxColorSearch(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:
            //Search (adr1)
            syncolor[1].nColor = COLOR_RED;             
            break;
        case 2:          
            //Search adr1 (adr2|Length)
            syncolor[3].nColor = COLOR_RED;             
            syncolor[5].nColor = COLOR_RED;             
            break;
        case 3:                      
            //Search adr1 Length (length)
            syncolor[6].nColor = COLOR_RED;                     
            break;
        case 4:                 
            //Search adr1 ...(Insensitive|"string"|data..)
            syncolor[8].nColor = COLOR_RED;                         
            syncolor[10].nColor = COLOR_RED;                
            syncolor[12].nColor = COLOR_RED;                    
            break;              
        case 5:
            //Search adr1 adr2 Insensitive ("string")
            syncolor[10].nColor = COLOR_RED;                    
            break;
        default:                                                
            break;  
     }      

}


void CSyntaxCheckSub::SetSyntaxColorStep(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:        
            //Step (Over|count|Forever|adr1|Till|Till)
            syncolor[2].nColor = COLOR_RED;                                         
            syncolor[4].nColor = COLOR_RED;                                         
            syncolor[6].nColor = COLOR_RED;                                         
            syncolor[8].nColor = COLOR_RED;                                         
            syncolor[11].nColor = COLOR_RED;                                             
            syncolor[17].nColor = COLOR_RED;                                            
            break;
        case 2:   
            //Step Over (count|Forever|adr1|Till|Till)
            syncolor[4].nColor = COLOR_RED;                                         
            syncolor[6].nColor = COLOR_RED;                                         
            syncolor[8].nColor = COLOR_RED;                                         
            syncolor[11].nColor = COLOR_RED;
            syncolor[17].nColor = COLOR_RED;                                            
            break;
        case 3:
            //Step adr1 (adr2)
            syncolor[9].nColor = COLOR_RED;                                         
            break;    
        case 4: 
            //Step Till (Ret|Call|@reg|adr)
            syncolor[13].nColor = COLOR_RED;                                            
            syncolor[15].nColor = COLOR_RED;
            syncolor[19].nColor = COLOR_RED;                                            
            syncolor[21].nColor = COLOR_RED;
            break;
        case 5:   
            //Step Over adr1 (adr2) 
            syncolor[9].nColor = COLOR_RED;                                         
            break;  
        case 6:   
            //Step Over Till (Ret|Call|@reg|adr)
            syncolor[13].nColor = COLOR_RED;                                            
            syncolor[15].nColor = COLOR_RED;
            syncolor[19].nColor = COLOR_RED;                                            
            syncolor[21].nColor = COLOR_RED;
            break;  
        case 7:
            //Step Over Till @reg (Is)
            syncolor[23].nColor = COLOR_RED;                                            
            break;  
        case 8:
            //Step Over Till @reg Is (value)
            syncolor[24].nColor = COLOR_RED;                                            
            break;  
        default:
            break;  
     }      

}


void CSyntaxCheckSub::SetSyntaxColorTest(int nPos, int& nArgc, 
    SynColor syncolor[])
{                
    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:          
            //Test (adr1)
            syncolor[1].nColor = COLOR_RED;         
            break;
        case 2:          
            //Test adr1 (adr2|Length)
            syncolor[3].nColor = COLOR_RED;         
            syncolor[5].nColor = COLOR_RED;         
            break;
        case 3:                      
            //Test adr1 Length (length)
            syncolor[6].nColor = COLOR_RED;         
            break;
        
        default:
            break;  
     }                                  

}

void CSyntaxCheckSub::SetSyntaxColorTimer(int nPos, int& nArgc, 
    SynColor syncolor[])
{                
    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:                          
            //Timer (On|Off)
            syncolor[2].nColor = COLOR_RED;         
            syncolor[4].nColor = COLOR_RED;         
            break;
        default:
            break;  
     }      
}


void CSyntaxCheckSub::SetSyntaxColorTrace(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:                        
            //Trace (On|Off|Clear)
            syncolor[2].nColor = COLOR_RED;         
            syncolor[4].nColor = COLOR_RED;         
            syncolor[6].nColor = COLOR_RED;         
            break;
        default:
            break;  
     }      

}

void CSyntaxCheckSub::SetSyntaxColorTrigger(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:    
            //Trigger (Run|Lv1|Lv2|Lv1|On|Off)
            syncolor[2].nColor = COLOR_RED;         
            syncolor[4].nColor = COLOR_RED;         
            syncolor[6].nColor = COLOR_RED;         
            syncolor[8].nColor = COLOR_RED;         
            syncolor[21].nColor = COLOR_RED;            
            syncolor[23].nColor = COLOR_RED;            
            break;
        case 2:                                     
            //Trigger Run (Lv1|Lv2|Lv1)
            syncolor[4].nColor = COLOR_RED;         
            syncolor[6].nColor = COLOR_RED;         
            syncolor[8].nColor = COLOR_RED;         
            break;
        case 3:                                     
            //Trigger Lv1 (Then|Forward|Backward|Center|Delay)
            syncolor[9].nColor = COLOR_RED;         
            syncolor[12].nColor = COLOR_RED;    //Forward
            syncolor[14].nColor = COLOR_RED;    //Backward
            syncolor[16].nColor = COLOR_RED;    //Center
            syncolor[18].nColor = COLOR_RED;    //Delay
            break;
        case 4:                                     
            //Trigger Lv2 (Forward|Backward|Center|Delay)
            syncolor[12].nColor = COLOR_RED;    //Forward
            syncolor[14].nColor = COLOR_RED;    //Backward
            syncolor[16].nColor = COLOR_RED;    //Center
            syncolor[18].nColor = COLOR_RED;    //Delay
            break;
        case 5:                                     
            //Trigger Lv1 Then (Lv2) 
            syncolor[10].nColor = COLOR_RED;    
            break;
        case 6:                                     
            //Trigger Lv1 Delay (count) 
            syncolor[19].nColor = COLOR_RED;    
            break;       
        default:
            break;  
     }      

}

void CSyntaxCheckSub::SetSyntaxColorUpload(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:                             
            //Upload (adr1)
            syncolor[1].nColor = COLOR_RED;         
            break;
        case 2:            
            //Upload adr1 (adr2|Length)                         
            syncolor[3].nColor = COLOR_RED;         
            syncolor[5].nColor = COLOR_RED;         
            break;
        case 3:                        
            //Upload adr1 Length (length)
            syncolor[6].nColor = COLOR_RED;         
            break;
        case 4:                          
            //Upload adr1 adr2 (filename)
            syncolor[8].nColor = COLOR_RED;                     
        default:
            break;  
     }      

}

void CSyntaxCheckSub::SetSyntaxColorVerify(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:                          
            //Verify (On|Off)
            syncolor[2].nColor = COLOR_RED;         
            syncolor[4].nColor = COLOR_RED;         
            break;
        default:
            break;  
     }      

}


void CSyntaxCheckSub::SetSyntaxColorWord(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:              
            //Word (adr)
            syncolor[1].nColor = COLOR_RED;         
            break;
        case 2:         
            //Word adr (data1)
            syncolor[2].nColor = COLOR_RED;         
            break;
        case 3:               
            //Word adr data1 (..data16)
            syncolor[4].nColor = COLOR_RED;         
            break;          
        default:
            break;  
     }      

}

void CSyntaxCheckSub::SetSyntaxColorCreate(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:                        
            //Create (#symbol)             
            syncolor[1].nColor = COLOR_RED;                 
            break;
        case 2:               
            //Create #symbol (adr)
            syncolor[2].nColor = COLOR_RED;                 
            break;
        default:
            break;  
     }      

}

void CSyntaxCheckSub::SetSyntaxColorDelete(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:                   
            //Delete (#symbol|$variable|All)                          
            syncolor[1].nColor = COLOR_RED;                 
            syncolor[3].nColor = COLOR_RED;                 
            syncolor[5].nColor = COLOR_RED;                                                 
            break;
        default:
            break;  
     }      

}

void CSyntaxCheckSub::SetSyntaxColorLoad(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
/*
    switch (nPos) {
        case 1:
            //Load (filename)
            syncolor[1].nColor = COLOR_RED;                 
            break;
        case 2:
            //Load filename (Symbols|Nosymbols|..Code|Nocode|Warn|Nowarn)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[11].nColor = COLOR_RED;    //Module    
            syncolor[14].nColor = COLOR_RED;    //Warn              
            syncolor[16].nColor = COLOR_RED;    //Nowarn                
            syncolor[18].nColor = COLOR_RED;    //P:                
            syncolor[20].nColor = COLOR_RED;    //X:                
            break;
        case 3:   
            //Load filename Symbols (..)        
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[11].nColor = COLOR_RED;    //Module    
            syncolor[14].nColor = COLOR_RED;    //Warn              
            syncolor[16].nColor = COLOR_RED;    //Nowarn                
            syncolor[18].nColor = COLOR_RED;    //P:                
            syncolor[20].nColor = COLOR_RED;    //X:                
            break;
        case 4:
            //Load filename Code (..)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[11].nColor = COLOR_RED;    //Module    
            syncolor[14].nColor = COLOR_RED;    //Warn              
            syncolor[16].nColor = COLOR_RED;    //Nowarn                
            syncolor[18].nColor = COLOR_RED;    //P:                
            syncolor[20].nColor = COLOR_RED;    //X:                
            break;
        case 5:
            //Load filename Symbols Code (..)
            syncolor[11].nColor = COLOR_RED;    //Module    
            syncolor[14].nColor = COLOR_RED;    //Warn              
            syncolor[16].nColor = COLOR_RED;    //Nowarn                
            syncolor[18].nColor = COLOR_RED;    //P:                
            syncolor[20].nColor = COLOR_RED;    //X:                
            break;
        case 6:
            //Load filename (..)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[11].nColor = COLOR_RED;    //Module    
            syncolor[18].nColor = COLOR_RED;    //P:                
            syncolor[20].nColor = COLOR_RED;    //X:                
            break;
        case 7:
            //Load filename Symbols (..)
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[11].nColor = COLOR_RED;    //Module    
            syncolor[14].nColor = COLOR_RED;    //Warn              
            syncolor[16].nColor = COLOR_RED;    //Nowarn                
            syncolor[18].nColor = COLOR_RED;    //P:                
            syncolor[20].nColor = COLOR_RED;    //X:                
            break;
        case 8:
            //Load filename Code (..)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[11].nColor = COLOR_RED;    //Module    
            syncolor[14].nColor = COLOR_RED;    //Warn              
            syncolor[16].nColor = COLOR_RED;    //Nowarn                
            syncolor[18].nColor = COLOR_RED;    //P:                
            syncolor[20].nColor = COLOR_RED;    //X:                
            break;
        case 9:
            //Load filename Symbols Code (..)
            syncolor[11].nColor = COLOR_RED;    //Module    
            syncolor[14].nColor = COLOR_RED;    //Warn              
            syncolor[16].nColor = COLOR_RED;    //Nowarn                
            syncolor[18].nColor = COLOR_RED;    //P:                
            syncolor[20].nColor = COLOR_RED;    //X:                
            break;
        case 10:
            //Load filename Warn (..)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[11].nColor = COLOR_RED;    //Module    
            syncolor[18].nColor = COLOR_RED;    //P:                
            syncolor[20].nColor = COLOR_RED;    //X:                
            break;
        case 11:
            //Load filename Symbols Warn (..)
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[11].nColor = COLOR_RED;    //Module    
            syncolor[18].nColor = COLOR_RED;    //P:                
            syncolor[20].nColor = COLOR_RED;    //X:                
            break;
        case 12:
            //Load filename Code Warn (..)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[11].nColor = COLOR_RED;    //Module    
            syncolor[18].nColor = COLOR_RED;    //P:                
            syncolor[20].nColor = COLOR_RED;    //X:                
            break;
        case 13:
            //Load filename Symbols Code Warn (..)
            syncolor[11].nColor = COLOR_RED;    //Module    
            syncolor[18].nColor = COLOR_RED;    //P:                
            syncolor[20].nColor = COLOR_RED;    //X:                
            break;
        case 14:
            //Load filename Warn (..)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[11].nColor = COLOR_RED;    //Module    
            syncolor[18].nColor = COLOR_RED;    //P:                
            syncolor[20].nColor = COLOR_RED;    //X:                
            break;
        case 15:
            //Load filename Symbols Warn (..)
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[11].nColor = COLOR_RED;    //Module    
            syncolor[18].nColor = COLOR_RED;    //P:                
            syncolor[20].nColor = COLOR_RED;    //X:                
            break;
        case 16:
            //Load filename Code Warn (..)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[11].nColor = COLOR_RED;    //Module    
            syncolor[18].nColor = COLOR_RED;    //P:                
            syncolor[20].nColor = COLOR_RED;    //X:                
            break;
        case 17:
            //Load filename Symbols Code Warn (..)
            syncolor[11].nColor = COLOR_RED;    //Module    
            syncolor[18].nColor = COLOR_RED;    //P:                
            syncolor[20].nColor = COLOR_RED;    //X:                
            break;                      
        case 18:
            //Load filename P: (..)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[11].nColor = COLOR_RED;    //Module    
            syncolor[14].nColor = COLOR_RED;    //Warn              
            syncolor[16].nColor = COLOR_RED;    //Nowarn                
            break;          
        case 19:
            //Load filename Symbols P: (..)
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[11].nColor = COLOR_RED;    //Module    
            syncolor[14].nColor = COLOR_RED;    //Warn              
            syncolor[16].nColor = COLOR_RED;    //Nowarn                
            break;
        case 20:
            //Load filename Code P:
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[11].nColor = COLOR_RED;    //Module    
            syncolor[14].nColor = COLOR_RED;    //Warn              
            syncolor[16].nColor = COLOR_RED;    //Nowarn                
            break;
        case 21:
            //Load filename Symbols Code P:
            syncolor[11].nColor = COLOR_RED;    //Module    
            syncolor[14].nColor = COLOR_RED;    //Warn              
            syncolor[16].nColor = COLOR_RED;    //Nowarn                
            break;
        case 22:
            //Load filename P:
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[11].nColor = COLOR_RED;    //Module    
            syncolor[14].nColor = COLOR_RED;    //Warn              
            syncolor[16].nColor = COLOR_RED;    //Nowarn                
            break;
        case 23:
            //Load filename Symbols P:
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[11].nColor = COLOR_RED;    //Module    
            syncolor[14].nColor = COLOR_RED;    //Warn              
            syncolor[16].nColor = COLOR_RED;    //Nowarn                
            break;
        case 24:
            //Load filename Code P:
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[11].nColor = COLOR_RED;    //Module    
            syncolor[14].nColor = COLOR_RED;    //Warn              
            syncolor[16].nColor = COLOR_RED;    //Nowarn                
            break;
        case 25:
            //Load filename Symbols Code P:
            syncolor[11].nColor = COLOR_RED;    //Module    
            syncolor[14].nColor = COLOR_RED;    //Warn              
            syncolor[16].nColor = COLOR_RED;    //Nowarn                
            break;
        case 26:
            //Load filename Warn P:
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[11].nColor = COLOR_RED;    //Module    
            break;
        case 27:
            //Load filename Symbols Warn P:
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[11].nColor = COLOR_RED;    //Module    
            break;
        case 28:
            //Load filename Code Warn P:
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[11].nColor = COLOR_RED;    //Module    
            break;
        case 29:
            //Load filename Symbols Code Warn P:
            syncolor[11].nColor = COLOR_RED;    //Module    
            break;
        case 30:
            //Load filename Warn P:
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[11].nColor = COLOR_RED;    //Module    
            break;
        case 31:
            //Load filename Symbols Warn P:
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[15].nColor = COLOR_RED;    //Module    
            break;
        case 32:
            //Load filename Code Warn P:
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[11].nColor = COLOR_RED;    //Module    
            break;
        case 33:
            //Load filename Module 
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[14].nColor = COLOR_RED;    //Warn              
            syncolor[16].nColor = COLOR_RED;    //Nowarn                
            syncolor[18].nColor = COLOR_RED;    //P:                
            syncolor[20].nColor = COLOR_RED;    //X:                
            break;          
        case 34:   
            //Load filename Module Symbols (..)     
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[14].nColor = COLOR_RED;    //Warn              
            syncolor[16].nColor = COLOR_RED;    //Nowarn                
            syncolor[18].nColor = COLOR_RED;    //P:                
            syncolor[20].nColor = COLOR_RED;    //X:                
            break;
        case 35:
            //Load filename Module Code (..)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[14].nColor = COLOR_RED;    //Warn              
            syncolor[16].nColor = COLOR_RED;    //Nowarn                
            syncolor[18].nColor = COLOR_RED;    //P:                
            syncolor[20].nColor = COLOR_RED;    //X:                
            break;
        case 36:
            //Load filename Symbols Module Code (..)
            syncolor[14].nColor = COLOR_RED;    //Warn              
            syncolor[16].nColor = COLOR_RED;    //Nowarn                
            syncolor[18].nColor = COLOR_RED;    //P:                
            syncolor[20].nColor = COLOR_RED;    //X:                
            break;
        case 37:
            //Load filename Module (..)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[18].nColor = COLOR_RED;    //P:                
            syncolor[20].nColor = COLOR_RED;    //X:                
            break;
        case 38:
            //Load filename Symbols Module (..)
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[14].nColor = COLOR_RED;    //Warn              
            syncolor[16].nColor = COLOR_RED;    //Nowarn                
            syncolor[18].nColor = COLOR_RED;    //P:                
            syncolor[20].nColor = COLOR_RED;    //X:                
            break;
        case 39:
            //Load filename Code Module (..)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[14].nColor = COLOR_RED;    //Warn              
            syncolor[16].nColor = COLOR_RED;    //Nowarn                
            syncolor[18].nColor = COLOR_RED;    //P:                
            syncolor[20].nColor = COLOR_RED;    //X:                
            break;
        case 40:
            //Load filename Symbols Code Module (..)
            syncolor[14].nColor = COLOR_RED;    //Warn              
            syncolor[16].nColor = COLOR_RED;    //Nowarn                
            syncolor[18].nColor = COLOR_RED;    //P:                
            syncolor[20].nColor = COLOR_RED;    //X:                
            break;
        case 41:
            //Load filename Module Warn (..)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[11].nColor = COLOR_RED;    //Module    
            syncolor[18].nColor = COLOR_RED;    //P:                
            syncolor[20].nColor = COLOR_RED;    //X:                
            break;
        case 42:
            //Load filename Module Symbols Warn (..)
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode                                    
            syncolor[18].nColor = COLOR_RED;    //P:                
            syncolor[20].nColor = COLOR_RED;    //X:                
            break;
        case 43:
            //Load filename Module Code Warn (..)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[18].nColor = COLOR_RED;    //P:                
            syncolor[20].nColor = COLOR_RED;    //X:                
            break;
        case 44:
            //Load filename Symbols Module Code Warn (..)
            syncolor[18].nColor = COLOR_RED;    //P:                
            syncolor[20].nColor = COLOR_RED;    //X:                
            break;
        case 45:
            //Load filename Module Warn (..)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[18].nColor = COLOR_RED;    //P:                
            syncolor[20].nColor = COLOR_RED;    //X:                
            break;
        case 46:
            //Load filename Module Symbols Warn (..)
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[18].nColor = COLOR_RED;    //P:                
            syncolor[20].nColor = COLOR_RED;    //X:                
            break;
        case 47:
            //Load filename Module Code Warn (..)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[18].nColor = COLOR_RED;    //P:                
            syncolor[20].nColor = COLOR_RED;    //X:                
            break;
        case 48:
            //Load filename Module Symbols Code Warn (..)
            syncolor[18].nColor = COLOR_RED;    //P:                
            syncolor[20].nColor = COLOR_RED;    //X:                
            break;                      
        case 49:
            //Load filename Module P: (..)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[14].nColor = COLOR_RED;    //Warn              
            syncolor[16].nColor = COLOR_RED;    //Nowarn                
            break;          
        case 50:
            //Load filename Module Symbols P: (..)
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[14].nColor = COLOR_RED;    //Warn              
            syncolor[16].nColor = COLOR_RED;    //Nowarn                
            break;
        case 51:
            //Load filename Module Code P:
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[14].nColor = COLOR_RED;    //Warn              
            syncolor[16].nColor = COLOR_RED;    //Nowarn                
            break;
        case 52:
            //Load filename Module Symbols Code P:
            syncolor[14].nColor = COLOR_RED;    //Warn              
            syncolor[16].nColor = COLOR_RED;    //Nowarn                
            break;
        case 53:
            //Load filename Module P:
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[14].nColor = COLOR_RED;    //Warn              
            syncolor[16].nColor = COLOR_RED;    //Nowarn                
            break;
        case 54:
            //Load filename Module Symbols P:
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[14].nColor = COLOR_RED;    //Warn              
            syncolor[16].nColor = COLOR_RED;    //Nowarn                
            break;
        case 55:
            //Load filename Module Code P:
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[14].nColor = COLOR_RED;    //Warn              
            syncolor[16].nColor = COLOR_RED;    //Nowarn                
            break;
        case 56:
            //Load filename Module Symbols Code P:
            syncolor[14].nColor = COLOR_RED;    //Warn              
            syncolor[16].nColor = COLOR_RED;    //Nowarn                
            break;
        case 57:
            //Load filename Module Warn P:
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            break;
        case 58:
            //Load filename Module Symbols Warn P:
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            break;
        case 59:
            //Load filename Module Code Warn P:
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            break;
        case 60:
            //Load filename Module Symbols Code Warn P:
            break;
        case 61:
            //Load filename Module Warn P:
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            break;
        case 62:
            //Load filename Module Symbols Warn P:
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            break;
        case 63:
            //Load filename Module Code Warn P:
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            break;
        case 65:
            //Load filename Module (..)
            syncolor[12].nColor = COLOR_RED;    //module_name   
            break;    
        default:                                                    
            break;  
     }      
                                        
*/                                      
    switch (nPos) {
        case 1:
            //Load (filename)
            syncolor[1].nColor = COLOR_RED;                 
            break;
        case 2:
            //Load filename (Symbols|Nosymbols|..Code|Nocode|Warn|Nowarn)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[11].nColor = COLOR_RED;    //Demand            
            syncolor[13].nColor = COLOR_RED;    //Nodemand
            syncolor[15].nColor = COLOR_RED;    //Module    
            syncolor[18].nColor = COLOR_RED;    //Warn              
            syncolor[20].nColor = COLOR_RED;    //Nowarn                
            syncolor[22].nColor = COLOR_RED;    //P:                
            syncolor[24].nColor = COLOR_RED;    //X:                
            break;
        case 3:   
            //Load filename Symbols (..)        
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[11].nColor = COLOR_RED;    //Demand            
            syncolor[13].nColor = COLOR_RED;    //Nodemand  
            syncolor[15].nColor = COLOR_RED;    //Module    
            syncolor[18].nColor = COLOR_RED;    //Warn              
            syncolor[20].nColor = COLOR_RED;    //Nowarn                
            syncolor[22].nColor = COLOR_RED;    //P:                
            syncolor[24].nColor = COLOR_RED;    //X:                
            break;
        case 4:
            //Load filename Code (..)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[11].nColor = COLOR_RED;    //Demand            
            syncolor[13].nColor = COLOR_RED;    //Nodemand
            syncolor[15].nColor = COLOR_RED;    //Module    
            syncolor[18].nColor = COLOR_RED;    //Warn              
            syncolor[20].nColor = COLOR_RED;    //Nowarn                
            syncolor[22].nColor = COLOR_RED;    //P:                
            syncolor[24].nColor = COLOR_RED;    //X:                
            break;
        case 5:
            //Load filename Symbols Code (..)
            syncolor[11].nColor = COLOR_RED;    //Demand            
            syncolor[13].nColor = COLOR_RED;    //Nodemand
            syncolor[15].nColor = COLOR_RED;    //Module    
            syncolor[18].nColor = COLOR_RED;    //Warn              
            syncolor[20].nColor = COLOR_RED;    //Nowarn                
            syncolor[22].nColor = COLOR_RED;    //P:                
            syncolor[24].nColor = COLOR_RED;    //X:                
            break;
        case 6:
            //Load filename Demand (..)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[15].nColor = COLOR_RED;    //Module    
            syncolor[22].nColor = COLOR_RED;    //P:                
            syncolor[24].nColor = COLOR_RED;    //X:                
            break;
        case 7:
            //Load filename Symbols Demand (..)
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[15].nColor = COLOR_RED;    //Module    
            syncolor[18].nColor = COLOR_RED;    //Warn              
            syncolor[20].nColor = COLOR_RED;    //Nowarn                
            syncolor[22].nColor = COLOR_RED;    //P:                
            syncolor[24].nColor = COLOR_RED;    //X:                
            break;
        case 8:
            //Load filename Code Demand (..)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[15].nColor = COLOR_RED;    //Module    
            syncolor[18].nColor = COLOR_RED;    //Warn              
            syncolor[20].nColor = COLOR_RED;    //Nowarn                
            syncolor[22].nColor = COLOR_RED;    //P:                
            syncolor[24].nColor = COLOR_RED;    //X:                
            break;
        case 9:
            //Load filename Symbols Code Demand (..)
            syncolor[15].nColor = COLOR_RED;    //Module    
            syncolor[18].nColor = COLOR_RED;    //Warn              
            syncolor[20].nColor = COLOR_RED;    //Nowarn                
            syncolor[22].nColor = COLOR_RED;    //P:                
            syncolor[24].nColor = COLOR_RED;    //X:                
            break;
        case 10:
            //Load filename Warn (..)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[11].nColor = COLOR_RED;    //Demand            
            syncolor[13].nColor = COLOR_RED;    //Nodemand
            syncolor[15].nColor = COLOR_RED;    //Module    
            syncolor[22].nColor = COLOR_RED;    //P:                
            syncolor[24].nColor = COLOR_RED;    //X:                
            break;
        case 11:
            //Load filename Symbols Warn (..)
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[11].nColor = COLOR_RED;    //Demand            
            syncolor[13].nColor = COLOR_RED;    //Nodemand
            syncolor[15].nColor = COLOR_RED;    //Module    
            syncolor[22].nColor = COLOR_RED;    //P:                
            syncolor[24].nColor = COLOR_RED;    //X:                
            break;
        case 12:
            //Load filename Code Warn (..)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[11].nColor = COLOR_RED;    //Demand            
            syncolor[13].nColor = COLOR_RED;    //Nodemand
            syncolor[15].nColor = COLOR_RED;    //Module    
            syncolor[22].nColor = COLOR_RED;    //P:                
            syncolor[24].nColor = COLOR_RED;    //X:                
            break;
        case 13:
            //Load filename Symbols Code Warn (..)
            syncolor[11].nColor = COLOR_RED;    //Demand            
            syncolor[13].nColor = COLOR_RED;    //Nodemand
            syncolor[15].nColor = COLOR_RED;    //Module    
            syncolor[22].nColor = COLOR_RED;    //P:                
            syncolor[24].nColor = COLOR_RED;    //X:                
            break;
        case 14:
            //Load filename Demand Warn (..)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[15].nColor = COLOR_RED;    //Module    
            syncolor[22].nColor = COLOR_RED;    //P:                
            syncolor[24].nColor = COLOR_RED;    //X:                
            break;
        case 15:
            //Load filename Symbols Demand Warn (..)
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[15].nColor = COLOR_RED;    //Module    
            syncolor[22].nColor = COLOR_RED;    //P:                
            syncolor[24].nColor = COLOR_RED;    //X:                
            break;
        case 16:
            //Load filename Code Demand Warn (..)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[15].nColor = COLOR_RED;    //Module    
            syncolor[22].nColor = COLOR_RED;    //P:                
            syncolor[24].nColor = COLOR_RED;    //X:                
            break;
        case 17:
            //Load filename Symbols Code Demand Warn (..)
            syncolor[15].nColor = COLOR_RED;    //Module    
            syncolor[22].nColor = COLOR_RED;    //P:                
            syncolor[24].nColor = COLOR_RED;    //X:                
            break;                      
        case 18:
            //Load filename P: (..)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[11].nColor = COLOR_RED;    //Demand            
            syncolor[13].nColor = COLOR_RED;    //Nodemand
            syncolor[15].nColor = COLOR_RED;    //Module    
            syncolor[18].nColor = COLOR_RED;    //Warn              
            syncolor[20].nColor = COLOR_RED;    //Nowarn                
            break;          
        case 19:
            //Load filename Symbols P: (..)
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[11].nColor = COLOR_RED;    //Demand            
            syncolor[13].nColor = COLOR_RED;    //Nodemand
            syncolor[15].nColor = COLOR_RED;    //Module    
            syncolor[18].nColor = COLOR_RED;    //Warn              
            syncolor[20].nColor = COLOR_RED;    //Nowarn                
            break;
        case 20:
            //Load filename Code P:
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[11].nColor = COLOR_RED;    //Demand            
            syncolor[13].nColor = COLOR_RED;    //Nodemand
            syncolor[15].nColor = COLOR_RED;    //Module    
            syncolor[18].nColor = COLOR_RED;    //Warn              
            syncolor[20].nColor = COLOR_RED;    //Nowarn                
            break;
        case 21:
            //Load filename Symbols Code P:
            syncolor[11].nColor = COLOR_RED;    //Demand            
            syncolor[13].nColor = COLOR_RED;    //Nodemand
            syncolor[15].nColor = COLOR_RED;    //Module    
            syncolor[18].nColor = COLOR_RED;    //Warn              
            syncolor[20].nColor = COLOR_RED;    //Nowarn                
            break;
        case 22:
            //Load filename Demand P:
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[15].nColor = COLOR_RED;    //Module    
            syncolor[18].nColor = COLOR_RED;    //Warn              
            syncolor[20].nColor = COLOR_RED;    //Nowarn                
            break;
        case 23:
            //Load filename Symbols Demand P:
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[15].nColor = COLOR_RED;    //Module    
            syncolor[18].nColor = COLOR_RED;    //Warn              
            syncolor[20].nColor = COLOR_RED;    //Nowarn                
            break;
        case 24:
            //Load filename Code Demand P:
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[15].nColor = COLOR_RED;    //Module    
            syncolor[18].nColor = COLOR_RED;    //Warn              
            syncolor[20].nColor = COLOR_RED;    //Nowarn                
            break;
        case 25:
            //Load filename Symbols Code Demand P:
            syncolor[15].nColor = COLOR_RED;    //Module    
            syncolor[18].nColor = COLOR_RED;    //Warn              
            syncolor[20].nColor = COLOR_RED;    //Nowarn                
            break;
        case 26:
            //Load filename Warn P:
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[11].nColor = COLOR_RED;    //Demand            
            syncolor[13].nColor = COLOR_RED;    //Nodemand
            syncolor[15].nColor = COLOR_RED;    //Module    
            break;
        case 27:
            //Load filename Symbols Warn P:
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[11].nColor = COLOR_RED;    //Demand            
            syncolor[13].nColor = COLOR_RED;    //Nodemand
            syncolor[15].nColor = COLOR_RED;    //Module    
            break;
        case 28:
            //Load filename Code Warn P:
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[11].nColor = COLOR_RED;    //Demand            
            syncolor[13].nColor = COLOR_RED;    //Nodemand
            syncolor[15].nColor = COLOR_RED;    //Module    
            break;
        case 29:
            //Load filename Symbols Code Warn P:
            syncolor[11].nColor = COLOR_RED;    //Demand            
            syncolor[13].nColor = COLOR_RED;    //Nodemand
            syncolor[15].nColor = COLOR_RED;    //Module    
            break;
        case 30:
            //Load filename Demand Warn P:
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[15].nColor = COLOR_RED;    //Module    
            break;
        case 31:
            //Load filename Symbols Demand Warn P:
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[15].nColor = COLOR_RED;    //Module    
            break;
        case 32:
            //Load filename Code Demand Warn P:
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[15].nColor = COLOR_RED;    //Module    
            break;
        case 33:
            //Load filename Module 
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[11].nColor = COLOR_RED;    //Demand            
            syncolor[13].nColor = COLOR_RED;    //Nodemand  
            syncolor[18].nColor = COLOR_RED;    //Warn              
            syncolor[20].nColor = COLOR_RED;    //Nowarn                
            syncolor[22].nColor = COLOR_RED;    //P:                
            syncolor[24].nColor = COLOR_RED;    //X:                
            break;          
        case 34:   
            //Load filename Module Symbols (..)     
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[11].nColor = COLOR_RED;    //Demand            
            syncolor[13].nColor = COLOR_RED;    //Nodemand  
            syncolor[18].nColor = COLOR_RED;    //Warn              
            syncolor[20].nColor = COLOR_RED;    //Nowarn                
            syncolor[22].nColor = COLOR_RED;    //P:                
            syncolor[24].nColor = COLOR_RED;    //X:                
            break;
        case 35:
            //Load filename Module Code (..)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[11].nColor = COLOR_RED;    //Demand            
            syncolor[13].nColor = COLOR_RED;    //Nodemand
            syncolor[18].nColor = COLOR_RED;    //Warn              
            syncolor[20].nColor = COLOR_RED;    //Nowarn                
            syncolor[22].nColor = COLOR_RED;    //P:                
            syncolor[24].nColor = COLOR_RED;    //X:                
            break;
        case 36:
            //Load filename Symbols Module Code (..)
            syncolor[11].nColor = COLOR_RED;    //Demand            
            syncolor[13].nColor = COLOR_RED;    //Nodemand
            syncolor[18].nColor = COLOR_RED;    //Warn              
            syncolor[20].nColor = COLOR_RED;    //Nowarn                
            syncolor[22].nColor = COLOR_RED;    //P:                
            syncolor[24].nColor = COLOR_RED;    //X:                
            break;
        case 37:
            //Load filename Module Demand (..)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[22].nColor = COLOR_RED;    //P:                
            syncolor[24].nColor = COLOR_RED;    //X:                
            break;
        case 38:
            //Load filename Symbols Module Demand (..)
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[18].nColor = COLOR_RED;    //Warn              
            syncolor[20].nColor = COLOR_RED;    //Nowarn                
            syncolor[22].nColor = COLOR_RED;    //P:                
            syncolor[24].nColor = COLOR_RED;    //X:                
            break;
        case 39:
            //Load filename Code Module Demand (..)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[18].nColor = COLOR_RED;    //Warn              
            syncolor[20].nColor = COLOR_RED;    //Nowarn                
            syncolor[22].nColor = COLOR_RED;    //P:                
            syncolor[24].nColor = COLOR_RED;    //X:                
            break;
        case 40:
            //Load filename Symbols Code Module Demand (..)
            syncolor[18].nColor = COLOR_RED;    //Warn              
            syncolor[20].nColor = COLOR_RED;    //Nowarn                
            syncolor[22].nColor = COLOR_RED;    //P:                
            syncolor[24].nColor = COLOR_RED;    //X:                
            break;
        case 41:
            //Load filename Module Warn (..)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[13].nColor = COLOR_RED;    //Nodemand
            syncolor[15].nColor = COLOR_RED;    //Module    
            syncolor[22].nColor = COLOR_RED;    //P:                
            syncolor[24].nColor = COLOR_RED;    //X:                
            break;
        case 42:
            //Load filename Module Symbols Warn (..)
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[11].nColor = COLOR_RED;    //Demand            
            syncolor[13].nColor = COLOR_RED;    //Nodemand
            syncolor[22].nColor = COLOR_RED;    //P:                
            syncolor[24].nColor = COLOR_RED;    //X:                
            break;
        case 43:
            //Load filename Module Code Warn (..)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[11].nColor = COLOR_RED;    //Demand            
            syncolor[13].nColor = COLOR_RED;    //Nodemand
            syncolor[22].nColor = COLOR_RED;    //P:                
            syncolor[24].nColor = COLOR_RED;    //X:                
            break;
        case 44:
            //Load filename Symbols Module Code Warn (..)
            syncolor[11].nColor = COLOR_RED;    //Demand            
            syncolor[13].nColor = COLOR_RED;    //Nodemand
            syncolor[22].nColor = COLOR_RED;    //P:                
            syncolor[24].nColor = COLOR_RED;    //X:                
            break;
        case 45:
            //Load filename Module Demand Warn (..)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[22].nColor = COLOR_RED;    //P:                
            syncolor[24].nColor = COLOR_RED;    //X:                
            break;
        case 46:
            //Load filename Module Symbols Demand Warn (..)
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[22].nColor = COLOR_RED;    //P:                
            syncolor[24].nColor = COLOR_RED;    //X:                
            break;
        case 47:
            //Load filename Module Code Demand Warn (..)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[22].nColor = COLOR_RED;    //P:                
            syncolor[24].nColor = COLOR_RED;    //X:                
            break;
        case 48:
            //Load filename Module Symbols Code Demand Warn (..)
            syncolor[22].nColor = COLOR_RED;    //P:                
            syncolor[24].nColor = COLOR_RED;    //X:                
            break;                      
        case 49:
            //Load filename Module P: (..)
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[11].nColor = COLOR_RED;    //Demand            
            syncolor[13].nColor = COLOR_RED;    //Nodemand
            syncolor[18].nColor = COLOR_RED;    //Warn              
            syncolor[20].nColor = COLOR_RED;    //Nowarn                
            break;          
        case 50:
            //Load filename Module Symbols P: (..)
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[11].nColor = COLOR_RED;    //Demand            
            syncolor[13].nColor = COLOR_RED;    //Nodemand
            syncolor[18].nColor = COLOR_RED;    //Warn              
            syncolor[20].nColor = COLOR_RED;    //Nowarn                
            break;
        case 51:
            //Load filename Module Code P:
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[11].nColor = COLOR_RED;    //Demand            
            syncolor[13].nColor = COLOR_RED;    //Nodemand
            syncolor[18].nColor = COLOR_RED;    //Warn              
            syncolor[20].nColor = COLOR_RED;    //Nowarn                
            break;
        case 52:
            //Load filename Module Symbols Code P:
            syncolor[11].nColor = COLOR_RED;    //Demand            
            syncolor[13].nColor = COLOR_RED;    //Nodemand
            syncolor[18].nColor = COLOR_RED;    //Warn              
            syncolor[20].nColor = COLOR_RED;    //Nowarn                
            break;
        case 53:
            //Load filename Module Demand P:
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[18].nColor = COLOR_RED;    //Warn              
            syncolor[20].nColor = COLOR_RED;    //Nowarn                
            break;
        case 54:
            //Load filename Module Symbols Demand P:
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[18].nColor = COLOR_RED;    //Warn              
            syncolor[20].nColor = COLOR_RED;    //Nowarn                
            break;
        case 55:
            //Load filename Module Code Demand P:
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[18].nColor = COLOR_RED;    //Warn              
            syncolor[20].nColor = COLOR_RED;    //Nowarn                
            break;
        case 56:
            //Load filename Module Symbols Code Demand P:
            syncolor[18].nColor = COLOR_RED;    //Warn              
            syncolor[20].nColor = COLOR_RED;    //Nowarn                
            break;
        case 57:
            //Load filename Module Warn P:
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[11].nColor = COLOR_RED;    //Demand            
            syncolor[13].nColor = COLOR_RED;    //Nodemand
            break;
        case 58:
            //Load filename Module Symbols Warn P:
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            syncolor[11].nColor = COLOR_RED;    //Demand            
            syncolor[13].nColor = COLOR_RED;    //Nodemand
            break;
        case 59:
            //Load filename Module Code Warn P:
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[11].nColor = COLOR_RED;    //Demand            
            syncolor[13].nColor = COLOR_RED;    //Nodemand
            break;
        case 60:
            //Load filename Module Symbols Code Warn P:
            syncolor[11].nColor = COLOR_RED;    //Demand            
            syncolor[13].nColor = COLOR_RED;    //Nodemand
            break;
        case 61:
            //Load filename Module Demand Warn P:
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            break;
        case 62:
            //Load filename Module Symbols Demand Warn P:
            syncolor[7].nColor = COLOR_RED;     //Code          
            syncolor[9].nColor = COLOR_RED;     //Nocode            
            break;
        case 63:
            //Load filename Module Code Demand Warn P:
            syncolor[3].nColor = COLOR_RED;     //Symbols           
            syncolor[5].nColor = COLOR_RED;     //Nosymbols         
            break;
        case 65:
            //Load filename Module (..)
            syncolor[16].nColor = COLOR_RED;    //module_name   
            break;    
        default:                                                    
            break;  
     }      

}

void CSyntaxCheckSub::SetSyntaxColorQuery(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:                    
            //Query (#symbol|hex_adr)
            syncolor[1].nColor = COLOR_RED;                 
            syncolor[3].nColor = COLOR_RED;                 
            break;
        default:
            break;  
     }      

}

void CSyntaxCheckSub::SetSyntaxColorSsave(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:                      
            //Ssave (filename)      
            syncolor[1].nColor = COLOR_RED;                                         
            break;
        default:
            break;  
     }      

}

void CSyntaxCheckSub::SetSyntaxColorSrecall(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:
            //Srecall (filename)
            syncolor[1].nColor = COLOR_RED;                                 
            break;
        default:
            break;  
     }      

}

void CSyntaxCheckSub::SetSyntaxColorSymbol(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:      
            //Symbol (Global|Module|#module|Lines)
            syncolor[2].nColor = COLOR_RED;                                         
            syncolor[4].nColor = COLOR_RED;                                 
            syncolor[6].nColor = COLOR_RED;                                                         
            syncolor[8].nColor = COLOR_RED;                                             
            break;
        default:
            break;  
     }      

}

void CSyntaxCheckSub::SetSyntaxColorWatch(int nPos, int& nArgc, 
    SynColor syncolor[])
{                

    SetSyntaxColorInit(nArgc, syncolor);
    
    switch (nPos) {
        case 1:                                 
            //Watch ("C-Expression")            
            syncolor[1].nColor = COLOR_RED; 
            break;
        default:
            break;  
     }
}

//////////////////////////////// End of File ////////////////////////////////
