
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/SHLEDIT.CPP   1.2.1.4   17 Apr 1997 15:58:46   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/SHLEDIT.CPP  $
** 
**    Rev 1.2.1.4   17 Apr 1997 15:58:46   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:30:28   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:40:40   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:19:26   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:24:10   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:34:14   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:49:10   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:17:02   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 13:00:18   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:20:46   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:32:16   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:59:20   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:46:16   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:51:14   ZJRD
** No change.
** 
**    Rev 1.7   11 Jun 1996 10:29:26   ZJRD
** EasyPack/SLD Version 1.97
** 
**    Rev 1.5   05 Jun 1996 14:58:04   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:28:38   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:05:54   ZJRD
** EasyPack/SLD Version 1.94
** 
**    Rev 1.2   10 May 1996 09:11:56   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:23:44   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:57:32   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:43:02   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:55:06   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:03:18   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:29:48   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:44:10   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:17:08   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:19:44   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:19:38   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:32:46   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:26:32   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:11:18   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:12:54   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:10:58   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:14:48   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:29:20   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:21:34   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:27:16   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:31:52   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:33:56   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:44:42   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:04:28   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:47:24   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:45:14   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:26:36   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:49:30   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:24:26   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:48:20   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:53:06   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:48:46   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:53:58   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SHLEDIT.CPP
//
//  Description:The implement file for the class: ShellEditor
//
//  Author:     Roger Zhang
//
//  Date:       03/25/95
//
//  Modification:
//
//      1. 03/25/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
       
#include "shlcom.h"       
#include "shledit.h"

/////////////////////////////////////////////////////////////////////////////
//  Set new line to edit
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Set a new line buffer to edit
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void ShellEditor::SetNew(char * pch, int nMax)
{
    ASSERT(pch);
    ASSERT(nMax > 0);
    
    m_pchText = pch;
    m_nLength = 0;
    m_nPos = 0;
    if(nMax > 0)    m_nMaxLen = nMax;
}
        
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Move caret to previous char
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::GotoPrev(void)
{
    if(m_nPos == 0)   return FALSE;
    -- m_nPos;
    return TRUE;
}        
        
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Move caret to next char
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::GotoNext(void)
{
    if(m_nPos == m_nLength) return FALSE;
    ++ m_nPos;
    return TRUE;
}     

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Move caret to the first char
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::GotoHome(void)
{
    if(m_nPos == 0)   return FALSE;
    m_nPos = 0;
    return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Move caret to the next position of the last buffer
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::GotoEnd(void)
{
    if(m_nPos == m_nLength) return FALSE;
    m_nPos = m_nLength;
    return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Move caret to the specified position
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::SetPos(int nIdx)
{
    if(m_nPos == nIdx)    return FALSE;
    if(nIdx < 0)    m_nPos = 0;
    else if(nIdx > m_nLength) m_nPos = m_nLength;
    else m_nPos = nIdx;
    return TRUE;
}   
        
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Insert caret at the current caret position
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::InsChar(char ch)
{           
    if(m_nPos == m_nMaxLen) return FALSE;
    if(m_nLength < m_nMaxLen)   ++ m_nLength;
    if(m_nPos < m_nMaxLen - 1) 
        memmove(m_pchText + m_nPos + 1, m_pchText + m_nPos, 
            m_nMaxLen - m_nPos - 1);
    * (m_pchText + m_nPos++) = ch;
    return TRUE;
}
                
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Overwrite a char at the current caret position
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::OvrChar(char ch)
{           
    if(m_nPos == m_nMaxLen) return FALSE;
    if(m_nPos == m_nLength) ++ m_nLength;
    * (m_pchText + m_nPos++) = ch;
    return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Delete the char at the current caret position
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::DelChar(void)
{           
    if(m_nPos == m_nLength) return FALSE;
    -- m_nLength;
    memmove(m_pchText + m_nPos, m_pchText + m_nPos + 1,
        m_nMaxLen - m_nPos - 1);
    return TRUE;
}               

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Delete the char before the current caret position
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::BackChar(void)
{                           
    if(!GotoPrev())   return FALSE;
    return DelChar();
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Insert a string at the caret caret position
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::InsString(char * pch, int nLen)
{    
    ASSERT(pch);
    
    for(int i = 0; i < nLen; i ++)
        if(InsChar(*pch++) == FALSE)    break;
    if(i == 0)  return FALSE;
    else return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Overwrite a string at the current caret position
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::OvrString(char * pch, int nLen)
{    
    ASSERT(pch);
    
    for(int i = 0; i < nLen; i ++)
        if(OvrChar(*pch++) == FALSE)    break;
    if(i == 0)  return FALSE;
    else return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Delete a string at the current caret position
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::DelString(int nLen)
{    
    for(int i = 0; i < nLen; i ++)
        if(DelChar() == FALSE)    break;
    if(i == 0)  return FALSE;
    else return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Delete the string before the current caret position
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::BackString(int nLen)
{    
    for(int i = 0; i < nLen; i ++)
        if(BackChar() == FALSE)    break;
    if(i == 0)  return FALSE;
    else return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Delete all the chars
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellEditor::Clear(void)
{
    if(m_nLength == 0)    return FALSE;
    m_nLength = 0;
    m_nPos = 0;
    return TRUE;
}

///////////////////////////////////(EOF)/////////////////////////////////////                                  
                
