
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/SRCLIST.H__   1.2.1.4   17 Apr 1997 16:00:52   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/SRCLIST.H__  $
** 
**    Rev 1.2.1.4   17 Apr 1997 16:00:52   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:33:58   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:43:18   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:21:56   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:26:04   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:35:58   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:50:18   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:16:32   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:59:48   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:19:22   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:30:52   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:57:56   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:47:58   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.6   10 Jun 1996 10:24:38   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:36:44   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:01:22   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:15:38   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:29:58   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:03:12   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:37:16   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:50:16   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:02:40   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:27:56   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:43:34   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:16:28   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:19:06   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:19:00   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:35:10   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:25:58   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:10:20   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:17:34   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:12:08   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.16   30 Nov 1995 09:08:46   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:31:34   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:18:12   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:28:26   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:30:14   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:33:30   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:43:12   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:04:02   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:50:40   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:47:04   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:30:02   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:48:32   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:20:34   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:48:42   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:55:16   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:47:38   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:55:02   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SRCLIST.H
//
//  Description:The header file for the class: 
//                  SyntaxColorList
//                  TabExpandList
//                  SourceIndexList
//                  SourceList
//
//  Author:     Roger Zhang
//
//  Date:       06/10/95
//
//  Modification:
//
//      1. 06/10/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _SRCLIST_
#define _SRCLIST_

/////////////////////////////////////////////////////////////////////////////
//  Syntax color list 
/////////////////////////////////////////////////////////////////////////////
class SyntaxColorElement : public SListElement
{
public:                        
    int m_nFirstCol, m_nLastCol;
    int m_nSyntaxType; 
    
    SyntaxColorElement(int nFirst, int nLast, int nType)
    : m_nFirstCol(nFirst), m_nLastCol(nLast), m_nSyntaxType(nType)
    {}   
    #ifdef _DEBUG
        virtual void Dump(void) const;    
    #endif
};                     
                     
class SyntaxColorList : public SingleList                
{
public:                                     
    SyntaxColorList(void) : SingleList() {}
    int AddElement(int nFirst, int nLast, int nType);
    #ifdef _DEBUG
        virtual void Dump(void) const;    
    #endif
};

/////////////////////////////////////////////////////////////////////////////
// Tab expand list 
/////////////////////////////////////////////////////////////////////////////           
class TabExpandElement : public SListElement
{
public:
    int m_nTabPos, m_nTabAdd;
    
    TabExpandElement(int nPos, int nAdd)
    : m_nTabPos(nPos), m_nTabAdd(nAdd)
    {}
    #ifdef _DEBUG
        virtual void Dump(void) const;    
    #endif
};                                

class TabExpandList : public SingleList
{
public:                                             
    TabExpandList(void) : SingleList() {}
    int AddElement(int nPos, int nAdd);
    int Search(int nPos) const;
    int Expand(int nPos) const;
    #ifdef _DEBUG
        virtual void Dump(void) const;    
    #endif
};
                                                         
///////////////////////////////////////////////////////////////////////////// 
// Index list 
/////////////////////////////////////////////////////////////////////////////
class SourceIndexElement : public SListElement 
{
public:                                
    SListNode * m_pSrc;    
    int m_nIdx;
    SourceIndexElement(SListNode * pSrc, int nIdx)
    : m_pSrc(pSrc), m_nIdx(nIdx)
    {}
    #ifdef _DEBUG
        virtual void Dump(void) const;    
    #endif
};                 

class SourceIndexList : public SingleList
{
public:
    enum { INDEX_DELTA = 32 };
    
    SourceIndexList(void) : SingleList() {}
    int AddElement(SListNode * pSrc, int nIdx);
    SourceIndexElement * Search(int nIdx);
    #ifdef _DEBUG
        virtual void Dump(void) const;    
    #endif
};                                        
                                                         
///////////////////////////////////////////////////////////////////////////// 
// Source file list 
/////////////////////////////////////////////////////////////////////////////                 
class SourceElement : public SListElement
{
public:
    SyntaxColorList m_Color;
    TabExpandList   m_Tab;
    char    * m_szLine;
    int     m_nLength;      
             
    SourceElement(void)
    : m_szLine(0), m_nLength(0)
    {}                                    
    virtual ~SourceElement(void); 
    int ExpandTab(int nPos) const { return m_Tab.Expand(nPos); }
    #ifdef _DEBUG
        virtual void Dump(void) const;    
    #endif
};

class SourceList : public SingleList
{
public:
    enum { MAX_LINELEN = 511, MAX_LINES = 32000 };
    
    SourceList(void) : SingleList(MAX_LINES) {}
    SourceElement * Search(SListNode * pIdx, int nDelta);
    #ifdef _DEBUG
        virtual void Dump(void) const;    
    #endif
};
                                           


#endif
/////////////////////////(EOF)///////////////////////////////////////////////
