
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/SRCMDL.H__   1.2.1.4   17 Apr 1997 16:00:58   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/SRCMDL.H__  $
** 
**    Rev 1.2.1.4   17 Apr 1997 16:00:58   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:34:10   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:43:24   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:22:02   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:26:10   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:36:02   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:50:20   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:16:32   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:59:48   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:19:22   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:30:54   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:57:58   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:47:58   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.6   10 Jun 1996 10:24:38   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:36:46   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:01:22   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:15:42   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:30:02   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:54:56   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:33:58   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:48:22   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:03:46   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:31:42   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:44:54   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:17:40   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:15:50   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:15:42   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:35:28   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:26:16   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:14:54   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:17:02   Shirley
** EasyPack/SLD Version 0.34a
** 
**    Rev 1.17   04 Jan 1996 11:14:06   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.16   30 Nov 1995 09:14:22   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:33:16   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:19:10   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:21:52   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:33:28   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:29:58   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:44:04   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:04:58   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:47:58   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:46:00   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:30:12   Shirley
** EasyPack/SLD Version 0.1f
** 
**    Rev 1.5   18 Oct 1995 14:49:46   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:23:24   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:48:42   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:55:16   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:47:38   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:55:02   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SRCMDL.H
//
//  Description:The header file for the class: 
//                  SourceModule
//                  ModuleInfo
//
//  Author:     Roger Zhang
//
//  Date:       06/26/95
//
//  Modification:
//
//      1. 06/26/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _SRCMDL_
#define _SRCMDL_

/////////////////////////////////////////////////////////////////////////////
// SourceModule
/////////////////////////////////////////////////////////////////////////////
class SourceModule 
{
public:                       
    enum { ERR_OK, ERR_FAIL, ERR_LINETOOLONG, ERR_TOOMANYLINE,	// used by loader
        ERR_READFAIL, ERR_OPENFAIL, ERR_EOL, ERR_EOF, ERR_MEM };
    enum { MAX_KEYWORD = 9 };

    SourceList      m_Src;
    SourceIndexList m_Idx;
    CString    m_strFileName;                       

private:    
    enum { FG_NORMAL, FG_COMMENT };	// used on parsing

    SourceElement * m_pLineInfo;    
    char          * m_szBuf;        // buffer to hold a line
    char          * m_szTab;        // buffer to hold the line after 
    								// tab expand
    char            m_szToken[MAX_KEYWORD + 1];
    FILE          * m_Fp;           // file pointer
    int             m_nFirst;       // used on parsing            
    int             m_nCur;         // used on parsing
    int             m_nLine;
    int             m_nEof;
    int             m_nFlag;		// flag used on parsing
	BOOL			m_isAsmLine;
	    
public:    
    SourceModule(void);
    ~SourceModule(void); 
    
    void Clean(void) {
        m_Src.Clean();  m_Idx.Clean();
    }
    
    int Load(const char * pszFileName);
    int Reload(void);
    
    SourceElement * GetLine(int nIdx);
    BOOL SearchAfter(int nLine, int nCol, int nEndLine); 
    BOOL SearchBefore(int nLine, int nCol, int nEndLine);

private:    
    int IsDelimit(char ch) const;
    int SearchKeyword(const char * p) const;
    int ReadLine(void);    
    int ExpandTab(void);
    int ScanString(void);
    int ScanChar(void);
    int ScanCComment(void);
    int ScanCPPComment(void);
    int ScanToken(void);
    int ScanCode(void);
    int ScanDelimit(void);
    int ParseColor(void);
    int ParseLine(void);
	BOOL IsAsmFile(const char * pszFileName) const;
	int SearchString(const char * str1, const char * str2, int nFlag) const;
	int SearchLine(const char * str1, const char * str2, int nCol, 
			int nFlag, BOOL isUp) const;
};

/////////////////////////////////////////////////////////////////////////////
// ModuleInfo
/////////////////////////////////////////////////////////////////////////////
class ModuleInfo
{
public:       
    enum { MAX_MODULE = 5 }; 
    
    SourceModule m_Module[MAX_MODULE];
    int          m_nModuleLoaded[MAX_MODULE];
    int          m_nModuleIdx;       
    unsigned      * m_pModuleValue;
    unsigned long * m_pModule;
    unsigned short m_uModules;
    
    ModuleInfo(void);
    ~ModuleInfo();         
    
    BOOL Init(void);
    BOOL IsModuleOn(void) { return m_nModuleIdx != -1; }
    unsigned long CurModule(void) const;
    int LoadModuleIdx(unsigned long dwModuleIdx);
    int LoadPCModule(void);
    int Reload(void);
    
private:    
    void Clean(void);
    
    CString MakeModulePath(unsigned long dwModuleIdx) const;
    BOOL CleanOldModule(void);
};

extern ModuleInfo MdlInfo;

int SrcReadLine(void);
int SrcOpenFile(DWORD dwModule);

#endif
//////////////////////////////(EOF)//////////////////////////////////////////

