
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/SYMADD.H__   1.2.1.4   17 Apr 1997 16:02:26   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/SYMADD.H__  $
** 
**    Rev 1.2.1.4   17 Apr 1997 16:02:26   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:35:24   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:44:36   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:23:32   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:27:08   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:36:54   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:50:54   ZJRD
** Initial revision.
** 
****************************************************************************/

/****************************************************************************
**
**  Name:  symadd.h
**
**  Description:
**     Prototypes for the functions to add to the symbol memory pool
**
**  Status:  PRELIMINARY
**
**  $Log$
** 
**  $Header:   D:/ECB2S/SRC/LOG/SYMADD.H__   1.2.1.4   17 Apr 1997 16:02:26   ZJRD  $
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/

#ifndef _SYMADD_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "symmanag.h"
#include "symmgr.h"
#include "symblsvr.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
//------------------------------------------------------------------------
// Symbol Server INI setting definitions
#define SAPP_NAME "SymbolInfo"
#define SAPP_LABEL "ConvertLabelsToRanges"

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/***************************************************************************
** InitSymTable
**
** Description: Initializes the symbol table.
**
** Input Parameters:
**    none:
** Output Parameters:
**    none:
** Errors:
**    ER_OUT_OF_MEMORY:
** NOTE: no BaseSymbol is created on initialization.  This means that any
**    loader must first create a base (and its index) before using it.
***************************************************************************/
RETCODE InitSymTable(VOID);

//--------------------------------------------------------------------------
// SymAddGetModuleName
//--------------------------------------------------------------------------
RETCODE SymAddGetModuleName(SYM_DESCRIPTOR module, LPSTR modName);

/****************************************************************************
**
**  SymInitSymServer
**
**  Description:
**     Initializes the symbol server
**     
**  Parameters:
**     input:
**        cliHandle:  the handle of the cli server
**        dllHandle:  the handle of the symbol server
**     output:
**        none:
**        (returns): error code
**
*****************************************************************************/
RETCODE SymInitSymServer(HANDLE cliHandle,HANDLE dllHandle);


#define _SYMADD_
#endif
/******************************** E O F ***********************************/
