
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/SYMCLIPR.H__   1.2.1.4   17 Apr 1997 16:03:30   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/SYMCLIPR.H__  $
** 
**    Rev 1.2.1.4   17 Apr 1997 16:03:30   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:36:28   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:45:26   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:24:34   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:27:50   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:37:30   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:51:22   ZJRD
** Initial revision.
** 
****************************************************************************/

/****************************************************************************
**
**  Name:  symclipr.h
**
**  Description:
**     Prototypes for the routines that print the symbol table to the cli.
**
**  Status:  PRELIMINARY
**
**  $Log$
** 
**  $Header:   D:/ECB2S/SRC/LOG/SYMCLIPR.H__   1.2.1.4   17 Apr 1997 16:03:30   ZJRD  $
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/

#ifndef _SYMCLIPR_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include "symwind.h"
#include "symmanag.h"
#include "symblsvr.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define SYMCLIPR_ADDR_TEXT_WIDTH 40

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

#ifdef __cplusplus
extern "C" {
#endif

RETCODE EXPORT
SymPrintSymbol(TABLE_OFFSET symbol, 
               SYM_DISPLAY_TYPE displayType,
               U16 indentLevel);

RETCODE EXPORT
SymPrintSymbols(SYM_DISPLAY_TYPE displayType);

RETCODE SymPrintLines(SYM_DESCRIPTOR modDesc);

//--------------------------------------------------------------------------
// SymConvSymAddrToText
//
// Output format:
//    Fixed addresses:
//       Displays fixed address as xxx-yyy where xxx is the start address and
//       yyy is the end address; then displays the range as [rrr].
//       Start and end addresses are is hex, the range is in decimal
//    Stack-based addresses:
//       Displays as a single signed decimal number followed by [sss] size.
//
// Input Parameter:
//    symbol: symbol being printed
//
// Output Parameter:
//    str: alloc'ed by caller using size SYMCLIPR_ADDR_TEXT_WIDTH
//--------------------------------------------------------------------------
RETCODE SymConvSymAddrToText(SYM_DESCRIPTOR symbol, LPSTR str);

#ifdef __cplusplus
}
#endif

RETCODE SymPrintBases(SYM_DISPLAY_TYPE displayType);

#define _SYMCLIPR_
#endif
/******************************** E O F ***********************************/
