
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/SYMORDTB.CPP   1.2.1.4   17 Apr 1997 16:04:14   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/SYMORDTB.CPP  $
** 
**    Rev 1.2.1.4   17 Apr 1997 16:04:14   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:38:02   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:46:08   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:25:16   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:28:34   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:38:08   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:51:50   ZJRD
** Initial revision.
** 
****************************************************************************/

/*----------------------------------------------------------------------------
** Name: SYMORDTB.cpp
**
** Title: Ord Table
**
** Purpose:
**  Create and manage the table that holds offsets to symbols in the order
**    they were loaded.  Provides:
**       PutU32 (inherited from MemPool)
**       GetOffset
**       GetOrdinalFromPercent
**
**  Base class = MemPool
**
** Status: PRELIMINARY
**
** $Log$
** 
** $Header:   D:/ECB2S/SRC/LOG/SYMORDTB.CPP   1.2.1.4   17 Apr 1997 16:04:14   ZJRD  $
**
** Copyright (C) 1995 Microtek International.  All rights reserved.
**
**--------------------------------------------------------------------------*/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "stdafx.h"                      
#include "sympool.h"
#include "symord.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define ORDTABLE_INIT_SIZE      (4L * 1024L)
#define ORDTABLE_EXPANSION_SIZE (4L * 1024L)

                       /****************************
                        *                          *
                        *     EXECUTABLE CODE      *
                        *                          *
                        ****************************/

//member functions for OrdinalTable

//------------------------------------------------------------------------
// OrdinalTable::OrdinalTable()     constructor
//------------------------------------------------------------------------
OrdinalTable::OrdinalTable():MemPool()  {

   initialSize = ORDTABLE_INIT_SIZE;
   expandSize  = ORDTABLE_EXPANSION_SIZE;
};  // end of OrdinalTable constructor


//------------------------------------------------------------------------
// OrdinalTable::AddSymOffsetToOT
//------------------------------------------------------------------------
RETCODE
OrdinalTable::AddSymOffsetToOT(TABLE_OFFSET symOffset,
                               ORDINAL_INDEX& ordIndex) {

   RETCODE retCode;
   TABLE_OFFSET offset;
   
   if ((retCode = AllocBytes(sizeof(symOffset), offset)) == SUCCESS) {
      *(TABLE_OFFSET *)GetHugeDataPtr(offset) = symOffset;
      ordIndex = GetOrdinalCount();
   }
   return retCode;
}  // end of AddSymOffsetToOT


//------------------------------------------------------------------------
// OrdinalTable::GetOffset
//
// Purpose:
//    Retrieve offset to symbol table item given the index to the ordinal
//    table.
//
// Input parameters:
//    ordIndex:
//       ORDINAL_INDEX index into ordinal table; the index is an even size
//       of a TABLE_OFFSET
//
// Output parameters:
//    itemOffset:
//       offset into symbol table of item
//
// Error:
//    Reports ER_INDEX_NOT_IN_TABLE if the index field is NULL or
//    Reports ER_INDEX_OUT_OF_BOUNDS if the requested index is larger than
//       last item in the table or larger than the table size
//------------------------------------------------------------------------
RETCODE OrdinalTable::GetOffset(ORDINAL_INDEX ordIndex,
                                TABLE_OFFSET& itemOffset)  {

   if ( ((ordIndex + 1) > (tableSize / (sizeof(TABLE_OFFSET))))
       || (ordIndex + 1 > GetOrdinalCount()) ) {
      return ER_INDEX_OUT_OF_BOUNDS;
   } else {
      itemOffset =
         *(HP_TABLE_OFFSET)GetHugeDataPtr(ordIndex * (sizeof(TABLE_OFFSET)));
      if (!itemOffset)  // if NULL then item not in table
         return ER_INDEX_NOT_IN_TABLE;
      else
         return SUCCESS;
   }
}   // end of OrdinalTable::GetOffset


//------------------------------------------------------------------------
// OrdinalTable::GetOrdinalFromPercent
//------------------------------------------------------------------------
U32 OrdinalTable::GetOrdinalFromPercent(U8 percent)  {

   return ((GetOrdinalCount() * (U32)(min(percent, 100))) / 100L);
}  // end of OrdinalTable::GetOrdinalFromPercent

//------------------------------------------------------------------------
// OrdinalTable::ObliterateTable
//------------------------------------------------------------------------
VOID OrdinalTable::ObliterateTable(VOID) {

   MemPool::ObliterateTable();
   initialSize = ORDTABLE_INIT_SIZE;
   expandSize  = ORDTABLE_EXPANSION_SIZE;
}

/******************************** E O F *************************************/
