
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/SYMPOOL.H__   1.2.1.4   17 Apr 1997 16:04:20   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/SYMPOOL.H__  $
** 
**    Rev 1.2.1.4   17 Apr 1997 16:04:20   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:38:12   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:46:10   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:25:18   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:28:36   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:38:10   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:51:52   ZJRD
** Initial revision.
** 
****************************************************************************/

/*----------------------------------------------------------------------------
** Name: mempool.h
**
** Title: Memory Pool
**
** Purpose:
**  Define the interface for the Memory Pool routines; generic routines used
**  to create, expand, and put data into an expandable pool of memory.
**
** Status: PRELIMINARY
**
** $Log$
** 
** $Header:   D:/ECB2S/SRC/LOG/SYMPOOL.H__   1.2.1.4   17 Apr 1997 16:04:20   ZJRD  $
**
** Copyright (C) 1995 Microtek International.  All rights reserved.
**
**--------------------------------------------------------------------------*/

#ifndef _MEMPOOL_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "symmanag.h"
#include "symutil.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/


                       /**********************************
                        *                                *
                        *   MEMBER FUNCTION PROTOTYPES   *
                        *                                *
                        **********************************/
#ifdef __cplusplus
class MemPool : public Table {

private:
   TABLE_OFFSET availMemOffset;   //acts as pointer to start of available mem
                                  //also equals the number of bytes used
   U16 bytesThrownAway;           //measurement of memory loss

public:
//---------------------------------------------------------------------------
// MemPool constructor
//
// Purpose:
//    Initialize specific table variables for memory management.
//    Insert one byte so that any pointers to table will be non-zero;
//    i.e. non-NULL
//---------------------------------------------------------------------------
MemPool();    // constructor


//------------------------------------------------------------------------
// AllocBytes
//
// Purpose:
//    Allocate 1 to 255 bytes into table.  Returns offset to start of data.
//
// Input parameters:
//    size: number of bytes
//
// Output parameters:
//    tableDataOffset: offset to start of stored bytes.
//
// Error: Reports ER_MEM_OUT_OF_MEMORY if there is not enough memory
//        to hold data
//------------------------------------------------------------------------
RETCODE AllocBytes(U8 size, TABLE_OFFSET& tableDataOffset);


//------------------------------------------------------------------------
// IsValidTableOffset
//
// Purpose:
//    Checks that the input table offset is not larger that the memory
//    allocated in the table thus far.
//
// Input parameters:
//    tableDataOffset: value to be compared with end of memory offset pointer
//
// Output parameters:  returns FALSE if not valid, TRUE if valid
//------------------------------------------------------------------------
BOOLEAN IsValidTableOffset(TABLE_OFFSET tableDataOffset)   {
   return (BOOLEAN)((tableDataOffset >= availMemOffset) ? FALSE : TRUE);
}


//---------------------------------------------------------------------------
// GetAvailMemOffset
//
// Purpose:
//    Return the value of the variable that points to the next available
//    location in the table to add data.
//---------------------------------------------------------------------------
TABLE_OFFSET GetAvailMemOffset() {return availMemOffset;};


//---------------------------------------------------------------------------
// GetBytesThrownAway
//
// Purpose:
//    FOR TESTING.
//    Return the value of the variable holding the number of bytes that were
//    "discarded" when it crossed the allocated boundary (which required
//    ReAlloc)
//---------------------------------------------------------------------------
U16 GetBytesThrownAway() { return bytesThrownAway; };


//---------------------------------------------------------------------------
// GetString
//
// Purpose:
//    Get a name from the symbol table and return it in a standard C string
//    The internal name format is the PASCAL string format:
//        length (U8) followed by that number of characters
//
// Input:
//    tableDataOffset: offset into symbol table
//
// Output:
//    outputString: far pointer to U8 holding the string; max length is 255
//                  256 with NULL termination
//---------------------------------------------------------------------------
VOID GetString(TABLE_OFFSET tableDataOffset, LPU8 outputString);


//---------------------------------------------------------------------------
// ObliterateTable
//
// Purpose:
//    Unlocks, then frees the table to Windows memory.
//---------------------------------------------------------------------------
VOID ObliterateTable(VOID);


//------------------------------------------------------------------------
// PutBytes
//
// Purpose:
//    Insert 1 to 255 bytes into table.  Returns offset to start of data.
//    This routine is used for putting structures into the table by passing
//    a pointer to the structure with size = sizeof(struct).
//
// Input parameters:
//    inputDataPtr: pointer to data.
//    size: number of bytes
//
// Output parameters:
//    tableDataOffset: offset to start of stored bytes.
//
// Error: Reports ER_MEM_OUT_OF_MEMORY if there is not enough memory
//        to hold data
//------------------------------------------------------------------------
RETCODE PutBytes(U8 *inputDataPtr, U8 size,
                    TABLE_OFFSET& tableDataOffset);


//------------------------------------------------------------------------
// PutString
//
// Purpose:
//    Insert string into table.  The maximum storable string is 255 chars.
//    Any string longer will be truncated with no error.
//    The representation of the string is: length, string
//    The stored string is NOT null terminated; rather, the length is the
//    first byte.  This makes string compares much faster (length checked
//    first).
//
// Input parameters:
//    lpString: long pointer to string.  Must be null terminated.
//
// Output parameters:
//    tableDataOffset: offset to start of stored string.  Points to length.
//
// Error: Reports STRING_LENGTH_0 if string is length 0
//        Reports ER_MEM_OUT_OF_MEMORY if there is not enough memory
//        to hold string
//------------------------------------------------------------------------
RETCODE PutString(LPSTR lpString, TABLE_OFFSET& tableDataOffset);


//------------------------------------------------------------------------
// PutU32
//
// Purpose:
//    install a U32 into the table
//------------------------------------------------------------------------
RETCODE PutU32(U32 data);


//---------------------------------------------------------------------------
// SetAvailableMem
//
// Purpose:
//    TESTING ONLY!!  Positions the unused memory pointer to a new location.
//---------------------------------------------------------------------------
VOID SetAvailableMem(U32 setValue) {
	availMemOffset = min(setValue, tableSize);
}

};  // end of class MemPool
#endif

#define _MEMPOOL_
#endif
/******************************** E O F *************************************/
