 
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/SYNCORE2.CPP   1.2.1.4   17 Apr 1997 16:05:42   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/SYNCORE2.CPP  $
** 
**    Rev 1.2.1.4   17 Apr 1997 16:05:42   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:40:10   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:46:52   ZJRD
** 2.09F
** 
**    Rev 1.2.1.1   03 Apr 1997 15:26:02   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:29:16   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:38:44   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:52:16   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:15:30   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:58:48   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:16:42   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:28:14   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:55:20   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:49:04   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:53:22   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.7   11 Jun 1996 10:27:54   ZJRD
** EasyPack/SLD Version 1.97
** 
**    Rev 1.5   05 Jun 1996 14:56:32   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:29:48   ZJRD
** EasyPack/SLD Version 1.95
** 
**    Rev 1.3   16 May 1996 09:07:04   ZJRD
** EasyPack/SLD Version 1.94
** 
**    Rev 1.2   10 May 1996 09:10:04   ZJRD
** EasyPack/SLD Version 1.93
** 
**    Rev 1.1   02 May 1996 10:26:40   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.1   18 Apr 1996 12:54:36   Shirley
** EasyPack/SLD Version 1.91
** 
**    Rev 1.0   12 Apr 1996 10:36:34   Shirley
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SYNCORE2.CPP
//
//  Description: The implementation file for the class: CSyntaxCore.
//
//  Author: Chen Jun
//
//  Date: 05/17/95
//
//  Modification:
//      1. 05/17/95, Initial version of the class: CSyntaxCore.
//      2. 10/10/95, Remove Stepoption command.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"
                       
#include "syncore.h"
//Add by Annie, 3/15/96
#include "address.h"
#include "addrapi.h"
#include "ctype.h"
/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.
extern BOOL isDefineMacro;

/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.


/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

 
/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CSyntaxCore.

// Fill         adr1 {adr2|Length length} {"string"|data..}
void CSyntaxCore::SyntaxCheckFill(void)
{
    ADDR_RETCODE retCode;

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Pre-process the field: "string" & Data.
    if ( m_nArgc < 4 ) {
        m_nErrorID = SYNTAX_ERROR;
        return;
    }
    
    int nArgc;
    if ( IsKeywordLength(m_pszArgv[2]) ) {
        if ( m_nArgc < 5 ) {
            m_nErrorID = SYNTAX_ERROR;
            return;
        }
        nArgc = 4;
    }
    else {
        nArgc = 3;
    }

    if ( !PreStringData(nArgc, 2) ) {
        m_nErrorID = SYNTAX_ERROR;
        return;
    }

	char* szArgv1;
    char* szArgv2;
    szArgv1 = new char[260]; 
    ASSERT(szArgv1);
    szArgv2 = new char[260];         
    ASSERT(szArgv2);

    // Check command syntax.
    switch ( m_nArgc ) {
        case 4:              
        	retCode = AdrShlCheck2Addr(m_pszArgv[1],m_pszArgv[2], 
        							   SPACE_EXTERNAL);	
            if (ADR_OK != retCode) {       
            	//m_nErrorID = SYNTAX_ERROR;
            	m_nErrorID = NOT_SHOW_ERROR;
            	break;                                        
            }	                              
            if (!ConvertAddress(m_pszArgv[1], szArgv1, nRet)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }	
            if (!ConvertAddress(m_pszArgv[2], szArgv2, nRet)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }	                                     
            if (IsBAddr(szArgv1)) {            
            	if( !IsDataBit(m_pszArgv[3])) {
            		m_nErrorID = SYNTAX_ERROR;
                	break;
            	}                  
            }	
            else if ( !IsData(m_pszArgv[3]) && !IsString(m_pszArgv[3])) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            if ( !IsFillDataRange(m_nArgc, m_pszArgv) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            NewMem(m_pszArgv[1], strlen(szArgv1)+1); 
            NewMem(m_pszArgv[2], strlen(szArgv2)+1);
            strcpy(m_pszArgv[1],szArgv1);                                  
            strcpy(m_pszArgv[2],szArgv2); 
            break;
        case 5:
        	if ( !IsKeywordLength(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            	break;
            }
            if ( !IsAddrLen(m_pszArgv[3], nRet) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = nRet;
                break;
            }   
            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = nRet;                
            	break;
            }                     
            if (!ConvertAddress(m_pszArgv[1], szArgv1, nRet, SPACE_EXTERNAL)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }	                                                                
            if (IsBAddr(szArgv1)) {
            	if( !IsDataBit(m_pszArgv[4])) {
            		m_nErrorID = SYNTAX_ERROR;
                	break;
            	}                  
            }	
            else if ( !IsData(m_pszArgv[4]) && !IsString(m_pszArgv[4])) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            if ( !IsFillDataRange(m_nArgc, m_pszArgv) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }

            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
            strcpy(m_pszArgv[1],szArgv1);                                  
            
            ConvertLen(m_pszArgv[3], szArgv1);
           	NewMem(m_pszArgv[3], strlen(szArgv1)+1);
            strcpy(m_pszArgv[3],szArgv1);   
            
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) &&
                 !IsIAddr(m_pszArgv[1]) &&
                 !IsRAddr(m_pszArgv[1]) &&
                 !IsBAddr(m_pszArgv[1]) &&
                 !IsXAddrDefault(m_pszArgv[1]) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = ADDR_TYPE_ERROR;
                break;
            } 
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    if (szArgv1) {
    	delete []szArgv1;    
    	szArgv1 = 0;
    }	
	if (szArgv2) {
		delete []szArgv2;
		szArgv2 = 0;
	}	

}   // End of CSyntaxCore::SyntaxCheckFill().

//Modify by Annie, 3/11/96    
// Go           [[Run][From adr1]|[From adr1][Till adr2]|Monitor timer]
void CSyntaxCore::SyntaxCheckGo(void)
{
	char* szArgv1;
    char* szArgv2;
    szArgv1 = new char[260]; 
    ASSERT(szArgv1);
    szArgv2 = new char[260];         
    ASSERT(szArgv2);

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        case 2:                           
        //Add by Annie, 3/11/96
            if ( !IsKeywordRun(m_pszArgv[1]) ) 
                m_nErrorID = SYNTAX_ERROR;
                break;             
                      
        case 3:
            if ( IsKeywordFrom(m_pszArgv[1]) ||
                 IsKeywordTill(m_pszArgv[1]) ) {
		        if (!ConvertAddress(m_pszArgv[2], szArgv1, nRet)) {
    	          	//m_nErrorID = SYNTAX_ERROR;
    	          	m_nErrorID = nRet;
        	    	break;
            	}
            	NewMem(m_pszArgv[2], strlen(szArgv1)+1);
            	strcpy(m_pszArgv[2],szArgv1);                                  
                if ( !IsPAddr(m_pszArgv[2]) &&
                     !IsPAddrDefault(m_pszArgv[2]) ) {
                    //m_nErrorID = SYNTAX_ERROR;
                    m_nErrorID = ADDR_TYPE_ERROR;
                    break;
                }                
            }
            else if ( !IsKeywordMonitor(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }            
            else if ( !IsGoMonitorTimer(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        case 4:
            if ( IsKeywordRun(m_pszArgv[1])) {
	            if ( !IsKeywordFrom(m_pszArgv[2]) ) {
	                m_nErrorID = SYNTAX_ERROR;
	            }         
	            else if (!ConvertAddress(m_pszArgv[3], szArgv1, nRet, 
	            		SPACE_PROGRAME)) {
	              	//m_nErrorID = SYNTAX_ERROR;
	              	m_nErrorID = nRet;
	            	break;
	            }                           
	            else if ( !IsPAddr(szArgv1) &&
	                      !IsPAddrDefault(szArgv1) ) {
	                //m_nErrorID = SYNTAX_ERROR;
	                m_nErrorID = ADDR_TYPE_ERROR;
	            	break;
	            }
	            NewMem(m_pszArgv[3], strlen(szArgv1)+1);
	            strcpy(m_pszArgv[3],szArgv1);           
	        }                       
            else {
                   m_nErrorID = SYNTAX_ERROR;
            }
            break;
        case 5:
            if ( !IsKeywordFrom(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }       
            else if (!ConvertAddress(m_pszArgv[2], szArgv1, nRet,
            	SPACE_PROGRAME)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }
            else if ( !IsPAddr(szArgv1) &&
                      !IsPAddrDefault(szArgv1) ) {
                //m_nErrorID = SYNTAX_ERROR;   
                m_nErrorID = ADDR_TYPE_ERROR;
                break;
            }
            else if ( !IsKeywordTill(m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }         
            else if (!ConvertAddress(m_pszArgv[4], szArgv2, nRet,
            	SPACE_PROGRAME )) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }
            else if ( !IsPAddr(szArgv2) &&
                      !IsPAddrDefault(szArgv2) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = ADDR_TYPE_ERROR;
            }
            NewMem(m_pszArgv[2], strlen(szArgv1)+1);
            strcpy(m_pszArgv[2],szArgv1);                                  
            NewMem(m_pszArgv[4], strlen(szArgv2)+1);
            strcpy(m_pszArgv[4],szArgv2);                                  
            break;        
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    if (szArgv1) {
    	delete []szArgv1;    
    	szArgv1 = 0;
    }	
	if (szArgv2) {
		delete []szArgv2;
		szArgv2 = 0;
	}	

}   // End of CSyntaxCore::SyntaxCheckGo().


// Halt
void CSyntaxCore::SyntaxCheckHalt(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckHalt().


// Help         [command]
void CSyntaxCore::SyntaxCheckHelp(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        case 2:
            if ( !IsCommand(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckHelp().


// IDentify
void CSyntaxCore::SyntaxCheckIdentify(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckIdentify().


// INclude      filename 
//              [[ arg0][ argv1][ argv2][ argv3][ argv4][ argv5]
//              [ argv6][ argv7][ argv8][ argv9]]
void CSyntaxCore::SyntaxCheckInclude(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }                     
    int nRet;
    // Check command syntax.
    switch ( m_nArgc ) {
        case 2:
            if ( !IsFilename(m_pszArgv[1], nRet) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = nRet;
            }
            break;
/*            
        case 3:
        case 4:
        case 5:
        case 6:
        case 7:
        case 8:
        case 9:
        case 10:
        case 11:
        case 12:
            if ( !IsFilename(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else {
                for ( i = 2; i < m_nArgc; i++ ) {
                    if ( !IsArgument(m_pszArgv[i]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
            }
            break;
*/            
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckInclude().


// Inport       port [Bit bit_no|BYte]
//          ( port = 0, 1, 2, 3,; bit_no = 0 - 7 )
void CSyntaxCore::SyntaxCheckInport(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 2:
            if ( !IsPort(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        case 3:
            if ( !IsPort(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordByte(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        case 4:
            if ( !IsPort(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordBit(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsBitNo(m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckInport().


// Jump         adr
void CSyntaxCore::SyntaxCheckJump(void)
{
	char* szArgv1;
    szArgv1 = new char[260]; 
    ASSERT(szArgv1);

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 2:
	        if (!ConvertAddress(m_pszArgv[1], szArgv1, nRet, SPACE_PROGRAME)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }
            if ( !IsPAddr(szArgv1) && 
                 !IsPAddrDefault(szArgv1) ) {
                //m_nErrorID = SYNTAX_ERROR;        
                m_nErrorID = ADDR_TYPE_ERROR;
                break;
            }
            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
            strcpy(m_pszArgv[1],szArgv1);
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    if (szArgv1) {
    	delete []szArgv1;        
    	szArgv1 = 0;
	}
}   // End of CSyntaxCore::SyntaxCheckJump().


// LEvel        [ {1|2} [ eventlogic  [TRace On|OFf]  [TImer On|OFf] ] ]
void CSyntaxCore::SyntaxCheckLevel(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // check command syntax.
    if ( m_nArgc < 1 ) {
        m_nErrorID = SYNTAX_ERROR;
        return;
    }
    else if ( 1 == m_nArgc ) {
        return;
    }
    else if ( 2 == m_nArgc ) {
        if ( 0 != stricmp(m_pszArgv[1], "1") &&
             0 != stricmp(m_pszArgv[1], "2") ) {
            m_nErrorID = SYNTAX_ERROR;
            return;
        }
        else {
            return;
        }
    }
    else {
        // m_nArgc >= 3.
        char pszEventSeq[255];
        int nIndex = 2;
        memset(pszEventSeq, 0, sizeof(pszEventSeq));
        for ( int i = 2; i < m_nArgc; i++ ) {
            if ( 0 != stricmp(m_pszArgv[i], "TRACE") &&
                 0 != stricmp(m_pszArgv[i], "TIMER") ) {
                strcat(pszEventSeq, m_pszArgv[i]);
                strcat(pszEventSeq, " ");
                nIndex++;
            }
            else {
                break;
            }
        }
        if ( 2 == nIndex ) {
            m_nErrorID = SYNTAX_ERROR;
            return;
        }
        
        // Check Event Sequence.
        if ( !IsEventSequence(pszEventSeq) ) {
            m_nErrorID = SYNTAX_ERROR;
            return;
        }
        
        // Check Trace or Timer.
        switch ( m_nArgc - nIndex ) {
            case 0:
                break;
            case 2:
                if ( IsKeywordTrace(m_pszArgv[nIndex]) ||
                     IsKeywordTimer(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( !IsKeywordOn(m_pszArgv[nIndex]) &&
                         !IsKeywordOff(m_pszArgv[nIndex]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                    }
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                }
                break;
            case 4:
                if ( !IsKeywordTrace(m_pszArgv[nIndex]) &&
                     !IsKeywordTimer(m_pszArgv[nIndex]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( IsKeywordTrace(m_pszArgv[nIndex]) ) {
                    if ( !IsKeywordTimer(m_pszArgv[nIndex+2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                    }
                }
                else if ( IsKeywordTimer(m_pszArgv[nIndex]) ) {
                    if ( !IsKeywordTrace(m_pszArgv[nIndex+2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                    }
                }
                else if ( !IsKeywordOn(m_pszArgv[nIndex+1]) &&
                          !IsKeywordOff(m_pszArgv[nIndex+1]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsKeywordOn(m_pszArgv[nIndex+3]) &&
                          !IsKeywordOff(m_pszArgv[nIndex+3]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                break;
            default:
                m_nErrorID = SYNTAX_ERROR;
                break;
        }
    }

}   // End of CSyntaxCore::SyntaxCheckLevel().


// LV1          [ eventlogic  [TRace On|OFf]  [TImer On|OFf] ]
void CSyntaxCore::SyntaxCheckLv1(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // check command syntax.
    if ( m_nArgc < 1 ) {
        m_nErrorID = SYNTAX_ERROR;
        return;
    }
    else if ( 1 == m_nArgc ) {
        return;
    }
    else {
        char pszEventSeq[255];
        int nIndex = 1;
        memset(pszEventSeq, 0, sizeof(pszEventSeq));
        for ( int i = 1; i < m_nArgc; i++ ) {
            if ( 0 != stricmp(m_pszArgv[i], "TRACE") &&
                 0 != stricmp(m_pszArgv[i], "TIMER") ) {
                strcat(pszEventSeq, m_pszArgv[i]);
                strcat(pszEventSeq, " ");
                nIndex++;
            }
            else {
                break;
            }
        }
        if ( 1 == nIndex ) {
            m_nErrorID = SYNTAX_ERROR;
            return;
        }
        
        // Check Event Sequence.
        if ( !IsEventSequence(pszEventSeq) ) {
            m_nErrorID = SYNTAX_ERROR;
            return;
        }
        
        // Check Trace or Timer.
        switch ( m_nArgc - nIndex ) {
            case 0:
                break;
            case 2:
                if ( IsKeywordTrace(m_pszArgv[nIndex]) ||
                     IsKeywordTimer(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( !IsKeywordOn(m_pszArgv[nIndex]) &&
                         !IsKeywordOff(m_pszArgv[nIndex]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                    }
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                }
                break;
            case 4:
                if ( !IsKeywordTrace(m_pszArgv[nIndex]) &&
                     !IsKeywordTimer(m_pszArgv[nIndex]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( IsKeywordTrace(m_pszArgv[nIndex]) ) {
                    if ( !IsKeywordTimer(m_pszArgv[nIndex+2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                    }
                }
                else if ( IsKeywordTimer(m_pszArgv[nIndex]) ) {
                    if ( !IsKeywordTrace(m_pszArgv[nIndex+2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                    }
                }
                else if ( !IsKeywordOn(m_pszArgv[nIndex+1]) &&
                          !IsKeywordOff(m_pszArgv[nIndex+1]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsKeywordOn(m_pszArgv[nIndex+3]) &&
                          !IsKeywordOff(m_pszArgv[nIndex+3]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                break;
            default:
                m_nErrorID = SYNTAX_ERROR;
                break;
        }
    }

}   // End of CSyntaxCore::SyntaxCheckLv1().


// LV2          [ eventlogic  [TRace On|OFf]  [TImer On|OFf] ]
void CSyntaxCore::SyntaxCheckLv2(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // check command syntax.
    if ( m_nArgc < 1 ) {
        m_nErrorID = SYNTAX_ERROR;
        return;
    }
    else if ( 1 == m_nArgc ) {
        return;
    }
    else {
        char pszEventSeq[255];
        int nIndex = 1;
        memset(pszEventSeq, 0, sizeof(pszEventSeq));
        for ( int i = 1; i < m_nArgc; i++ ) {
            if ( 0 != stricmp(m_pszArgv[i], "TRACE") &&
                 0 != stricmp(m_pszArgv[i], "TIMER") ) {
                strcat(pszEventSeq, m_pszArgv[i]);
                strcat(pszEventSeq, " ");
                nIndex++;
            }
            else {
                break;
            }
        }
        if ( 1 == nIndex ) {
            m_nErrorID = SYNTAX_ERROR;
            return;
        }
        
        // Check Event Sequence.
        if ( !IsEventSequence(pszEventSeq) ) {
            m_nErrorID = SYNTAX_ERROR;
            return;
        }
        
        // Check Trace or Timer.
        switch ( m_nArgc - nIndex ) {
            case 0:
                break;
            case 2:
                if ( IsKeywordTrace(m_pszArgv[nIndex]) ||
                     IsKeywordTimer(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( !IsKeywordOn(m_pszArgv[nIndex]) &&
                         !IsKeywordOff(m_pszArgv[nIndex]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                    }
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                }
                break;
            case 4:
                if ( !IsKeywordTrace(m_pszArgv[nIndex]) &&
                     !IsKeywordTimer(m_pszArgv[nIndex]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( IsKeywordTrace(m_pszArgv[nIndex]) ) {
                    if ( !IsKeywordTimer(m_pszArgv[nIndex+2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                    }
                }
                else if ( IsKeywordTimer(m_pszArgv[nIndex]) ) {
                    if ( !IsKeywordTrace(m_pszArgv[nIndex+2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                    }
                }
                else if ( !IsKeywordOn(m_pszArgv[nIndex+1]) &&
                          !IsKeywordOff(m_pszArgv[nIndex+1]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsKeywordOn(m_pszArgv[nIndex+3]) &&
                          !IsKeywordOff(m_pszArgv[nIndex+3]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                break;
            default:
                m_nErrorID = SYNTAX_ERROR;
                break;
        }
    }

}   // End of CSyntaxCore::SyntaxCheckLv2().


// List         [Source|ASsemble|MIxed|MOdule] [frame] 
//              [ADDRESS Range adr1 adr2|xadr|<10 badrs>] 
//              [DATUM Range data1 data2|xdata|<1 bdata>] 
//              [STATUS <status..>]
//Add by Annie, 3/11/96
// List         [Number]
//              Note: (where <status> is: S, F, R, W, AK)
void CSyntaxCore::SyntaxCheckList(void)
{
	char* szArgv1;
    szArgv1 = new char[260]; 
    ASSERT(szArgv1); 
    ADDR_RETCODE retCode;    

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    if ( m_nArgc < 1 ) {
        m_nErrorID = SYNTAX_ERROR;
        delete []szArgv1;
        return;
    }
    else if ( 1 == m_nArgc ) {
    	delete []szArgv1;
        return;
    }
    else if ( 2 == m_nArgc ) {
        if ( !IsListOption(m_pszArgv[1]) &&
             !IsListFrame(m_pszArgv[1]) ) {
            m_nErrorID = SYNTAX_ERROR;
            delete []szArgv1;
            return;
        }
    }
    else {  // m_nArgc >= 3.
        if ( 3 == m_nArgc ) {
            if ( stricmp(m_pszArgv[1], "NUMBER")==0 ||
            	 stricmp(m_pszArgv[2], "NUMBER")==0) {
            	m_nErrorID = SYNTAX_ERROR; 
            	delete []szArgv1;
            	return;
            }
            else if ( IsListOption(m_pszArgv[1]) &&
                 	  IsListFrame(m_pszArgv[2]) ) {
                // List Source frame 
                delete []szArgv1;
                return;
            }
            else if ( IsListOption(m_pszArgv[2]) &&
                      IsListFrame(m_pszArgv[1]) ) {
                // List frame Source
                delete []szArgv1;
                return;
            }            	
        }
        // Check m_pszArgv[1].
        int nIndex = 0;
        int nPos = ( m_nArgc > 3 ) ? 3 : 2;
        for ( int k = 1; k <= nPos; k++ ) {
            if ( 0 == stricmp(m_pszArgv[k],"ADDRESS") ||
                 0 == stricmp(m_pszArgv[k],"DATUM") ||
                 0 == stricmp(m_pszArgv[k],"STATUS") ) {
                nIndex = k;
                break;
            }
        }
        // Check List Option & List Frame.
        if ( 0 == nIndex ) {
            m_nErrorID = SYNTAX_ERROR;
            delete []szArgv1;
            return;
        }
        else if ( 2 == nIndex ) {
            if ( !IsListOption(m_pszArgv[1]) &&
                 !IsListFrame(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
                delete []szArgv1;
                return;
            }
        }
        else if ( 3 == nIndex ) {
            if ( !IsListOption(m_pszArgv[1]) ||
                 !IsListFrame(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
                delete []szArgv1;
                return;
            }
            else if ( 3 == m_nArgc ) {
            	delete []szArgv1;
                return;
            }
        }
    
        // Check List Qualifier.
        // Initial flag.
        BOOL isA = FALSE;
        BOOL isD = FALSE;
        BOOL isS = FALSE;

        // Check m_pszArgv[].
        while ( nIndex < m_nArgc ) {
            if ( 0 == stricmp(m_pszArgv[nIndex], "ADDRESS") ) {
                // "ADDRESS...".
                if ( isA ) {
                    m_nErrorID = SYNTAX_ERROR;
                    delete []szArgv1;
                    return;
                }
                else {
                    isA = TRUE;
                }
                nIndex++;
                if ( nIndex >= m_nArgc ) {
                    m_nErrorID = SYNTAX_ERROR;
                    delete []szArgv1;
                    return;
                }
                if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        m_nErrorID = SYNTAX_ERROR;
                        delete []szArgv1;
                        return;
                    }
                    retCode = AdrShlCheck2ListAddr(m_pszArgv[nIndex],
                    	m_pszArgv[nIndex+1]);
		            if (ADR_OK != retCode) {       
		            	//m_nErrorID = SYNTAX_ERROR;
		            	m_nErrorID = NOT_SHOW_ERROR;
		            	break;
		            }			        
			        if (!ConvertAddress(m_pszArgv[nIndex], szArgv1, nRet,
			        	SPACE_PROGRAME)) {
		              	//m_nErrorID = SYNTAX_ERROR;
		              	m_nErrorID = nRet;
		              	delete []szArgv1;
		            	return;
		            }		            
		            if ( !IsListAddr(m_pszArgv[nIndex]) ) {
                        m_nErrorID = ADDR_TYPE_ERROR;
                        delete []szArgv1;
                        return;		            
		            }
		            NewMem(m_pszArgv[nIndex], strlen(szArgv1)+1);
		            strcpy(m_pszArgv[nIndex],szArgv1);                                  
                    
                    if ( !IsPAddr(m_pszArgv[nIndex]) &&
                         !IsPAddrDefault(m_pszArgv[nIndex]) ) {
                        //m_nErrorID = SYNTAX_ERROR;
                        m_nErrorID = ADDR_TYPE_ERROR;
                        delete []szArgv1;
                        return;
                    }
                    else {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        }
                        if (!ConvertAddress(m_pszArgv[nIndex], szArgv1, nRet,
                        	SPACE_PROGRAME)) {
			              	//m_nErrorID = SYNTAX_ERROR;
			              	m_nErrorID = nRet;
			              	delete []szArgv1;
			            	return;
			            }		            
			            if ( !IsListAddr(m_pszArgv[nIndex]) ) {
	                        m_nErrorID = ADDR_TYPE_ERROR;
	                        delete []szArgv1;
	                        return;		            
			            }
			            NewMem(m_pszArgv[nIndex], strlen(szArgv1)+1);
			            strcpy(m_pszArgv[nIndex],szArgv1);                                  

                        if ( !IsPAddr(m_pszArgv[nIndex]) &&
                             !IsPAddrDefault(m_pszArgv[nIndex]) ) {
                            //m_nErrorID = SYNTAX_ERROR;
                            m_nErrorID = ADDR_TYPE_ERROR;
                            delete []szArgv1;
                            return;
                        }
                        else {
                            nIndex++;
                        }
                    }
                }
	            else if (ConvertAddress(m_pszArgv[nIndex], szArgv1, nRet,
	            		SPACE_PROGRAME)) {
   		            if ( !IsListAddr(m_pszArgv[nIndex]) ) {
                        m_nErrorID = ADDR_TYPE_ERROR;
                        delete []szArgv1;
                        return;		            
		            }
		            NewMem(m_pszArgv[nIndex], strlen(szArgv1)+1);
		            strcpy(m_pszArgv[nIndex],szArgv1);                                  
                	if ( IsPAddr(m_pszArgv[nIndex]) ||
                         IsPAddrDefault(m_pszArgv[nIndex]) ) {
	                    nIndex++;
	                    if ( nIndex >= m_nArgc ) {
	                    	delete []szArgv1;
	                        return;
	                    }
	                    for ( int i = 2; i <= 10; i++ ) {
							if (!ConvertAddress(m_pszArgv[nIndex], szArgv1, nRet,
								SPACE_PROGRAME)) {
				              	//m_nErrorID = SYNTAX_ERROR;
				            	//return;
				            	break;
				            }	
				            if ( !IsListAddr(m_pszArgv[nIndex]) ) {
		                        m_nErrorID = ADDR_TYPE_ERROR;
		                        delete []szArgv1;
		                        return;		            
				            }				            	            
				            NewMem(m_pszArgv[nIndex], strlen(szArgv1)+1);
				            strcpy(m_pszArgv[nIndex],szArgv1);                                  
	                                            
	                        if ( IsPAddr(m_pszArgv[nIndex]) ||
	                             IsPAddrDefault(m_pszArgv[nIndex]) ) {
	                            nIndex++;
	                            if ( nIndex >= m_nArgc ) {
	                            	delete []szArgv1;
	                                return;
	                            }
	                        }
	                        else {
	                            break;
	                        }
	                   	}                                   
                	}   
                }
                else if ( IsWildcardAddr(m_pszArgv[nIndex]) ) {
                    nIndex++;
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;       
                    delete []szArgv1;
                    return;
                }
            }   // End of "ADDRESS...".

            else if ( 0 == stricmp(m_pszArgv[nIndex], "DATUM") ) {
                // "DATUM...".
                if ( isD ) {
                    m_nErrorID = SYNTAX_ERROR;
                    delete []szArgv1;
                    return;
                }
                else {
                    isD = TRUE;
                }
                nIndex++;
                if ( nIndex >= m_nArgc ) {
                    m_nErrorID = SYNTAX_ERROR;
                    delete []szArgv1;
                    return;
                }
                if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        m_nErrorID = SYNTAX_ERROR;
                        delete []szArgv1;
                        return;
                    }
                    if ( !IsEventData(m_pszArgv[nIndex]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        delete []szArgv1;
                        return;
                    }
                    else {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        }
                        if ( !IsEventData(m_pszArgv[nIndex]) ) {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        }
                        else {
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                            	delete []szArgv1;
                                return;
                            }
                        }
                    }
                }  
                else if ( IsEventData(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {   
                    	delete []szArgv1;
                        return;
                    }
                }     
                else if ( IsWildcardData(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                    	delete []szArgv1;
                        return;
                    }
                } 
                else {
                    m_nErrorID = SYNTAX_ERROR;
                    delete []szArgv1;
                    return;
                }
            }   // End of "DATUM...".

            else if ( 0 == stricmp(m_pszArgv[nIndex], "STATUS") ) {
                // "STATUS...".
                if ( isS ) {
                    m_nErrorID = SYNTAX_ERROR;
                    delete []szArgv1;
                    return;
                }
                else {
                    isS = TRUE;
                }
                nIndex++;
                if ( nIndex >= m_nArgc ) {
                    m_nErrorID = SYNTAX_ERROR;
                    delete []szArgv1;
                    return;
                }
                // Is "S", "F", "R", "W" or "AK".
                BOOL isStatusS = FALSE;
                BOOL isStatusF = FALSE;
                BOOL isStatusR = FALSE;
                BOOL isStatusW = FALSE;
                BOOL isStatusAK = FALSE;

                if ( !stricmp(m_pszArgv[nIndex],"S") && !isStatusS ) {
                    isStatusS = TRUE;
                }
                else if ( !stricmp(m_pszArgv[nIndex],"F") && !isStatusF ) {
                    isStatusF = TRUE;
                }
                else if ( !stricmp(m_pszArgv[nIndex],"R") && !isStatusR ) {
                    isStatusR = TRUE;
                }
                else if ( !stricmp(m_pszArgv[nIndex],"W") && !isStatusW ) {
                    isStatusW = TRUE;
                }
                else if ( !stricmp(m_pszArgv[nIndex],"AK") && !isStatusAK ) {
                    isStatusAK = TRUE;
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                    delete []szArgv1;
                    return;
                }

                nIndex++;
                if ( nIndex >= m_nArgc ) {
                	delete []szArgv1;
                    return;
                }
                for ( int j = 2; j <= 5; j++ ) {
                    if ( 0 == stricmp(m_pszArgv[nIndex], "S") ) {
                        if ( !isStatusS ) {
                            isStatusS = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                            	delete []szArgv1;
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        }
                    }
                    else if ( 0 == stricmp(m_pszArgv[nIndex], "F") ) {
                        if ( !isStatusF ) {
                            isStatusF = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                            	delete []szArgv1;
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        }
                    }
                    else if ( 0 == stricmp(m_pszArgv[nIndex], "R") ) {
                        if ( !isStatusR ) {
                            isStatusR = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                            	delete []szArgv1;
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        }
                    }
                    else if ( 0 == stricmp(m_pszArgv[nIndex], "W") ) {
                        if ( !isStatusW ) {
                            isStatusW = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                            	delete []szArgv1;
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        }
                    }
                    else if ( 0 == stricmp(m_pszArgv[nIndex], "AK") ) {
                        if ( !isStatusAK ) {
                            isStatusAK = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                            	delete []szArgv1;
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        }
                    }
                    else {
                        break;
                    }
                }
            }   // End of "STATUS...".
            
            else {
                // Not "A", "D", or "S".
                m_nErrorID = SYNTAX_ERROR;   
                delete []szArgv1;
                return;
            }
            
        }   // End of while()...
        
    }   // End of else...
    if (szArgv1) {
    	delete []szArgv1;    
    	szArgv1 = 0;
    }	 
}   // End of CSyntaxCore::SyntaxCheckList().


// LOG          {filename [Command] [Append]} | {ON|OFf|Close}
void CSyntaxCore::SyntaxCheckLog(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 2:
            if ( !IsFilename(m_pszArgv[1], nRet) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = nRet;
            }
            break;
        case 3:
            if ( IsKeywordOn(m_pszArgv[1]) ||
                 IsKeywordOff(m_pszArgv[1]) ||
                 IsKeywordClose(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsFilename(m_pszArgv[1], nRet) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = nRet;
            }
            else if ( !IsKeywordCommand(m_pszArgv[2]) &&
                      !IsKeywordAppend(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        case 4:
            if ( IsKeywordOn(m_pszArgv[1]) ||
                 IsKeywordOff(m_pszArgv[1]) ||
                 IsKeywordClose(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsFilename(m_pszArgv[1], nRet) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = nRet;
            }
            else if ( IsKeywordCommand(m_pszArgv[2]) &&
                      IsKeywordAppend(m_pszArgv[3]) ) {
                break;
            }
            else if ( IsKeywordAppend(m_pszArgv[2]) &&
                      IsKeywordCommand(m_pszArgv[3]) ) {
                break;
            }
            else {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckLog().


// LONG         adr data1 [.. data8]
void CSyntaxCore::SyntaxCheckLong(void)
{
	char* szArgv;
    szArgv = new char[260];
    ASSERT(szArgv);
    
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Pre-process the field: "string" & Data.
    if ( m_nArgc < 3 ) {
        m_nErrorID = SYNTAX_ERROR;
        delete []szArgv;
        return;
    }
    
    int nArgc = 2;
    if ( !PreStringData(nArgc, 8) ) {
    	delete []szArgv;
        return;
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 3:
            if (!ConvertAddress(m_pszArgv[1], szArgv, nRet, SPACE_EXTERNAL)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }                
            if (IsBAddr(szArgv)) {
            	if( !IsDataBit(m_pszArgv[2])) {
            		m_nErrorID = SYNTAX_ERROR;
                	break;
            	}                 
            }	
            else if ( !IsDataLong(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            if ( !IsDataRange(m_nArgc, m_pszArgv, 4) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            NewMem(m_pszArgv[1], strlen(szArgv)+1);
            strcpy(m_pszArgv[1],szArgv);
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) &&
                 !IsIAddr(m_pszArgv[1]) &&
                 !IsRAddr(m_pszArgv[1]) &&
                 !IsBAddr(m_pszArgv[1]) &&
                 !IsXAddrDefault(m_pszArgv[1]) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = ADDR_TYPE_ERROR;
                break;
            }                    
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    if (szArgv) {
    	delete []szArgv;
    	szArgv = 0;
    }	
}   // End of CSyntaxCore::SyntaxCheckLong().


// MAp          [{All adrtype}|{adr1 {adr2|Length length}} map-attribute]
void CSyntaxCore::SyntaxCheckMap(void)
{                              
	char* szArgv1;
    char* szArgv2;
    szArgv1 = new char[260]; 
    ASSERT(szArgv1);
    szArgv2 = new char[260];         
    ASSERT(szArgv2);
    ADDR_RETCODE retCode;

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        case 4:
            if ( IsKeywordAll(m_pszArgv[1]) ) {
                if ( !IsMapMemType(m_pszArgv[2]) ||
                     !IsMapAttr(m_pszArgv[2][0], m_pszArgv[3]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            else {                     
	        	retCode = AdrShlCheck2Addr(m_pszArgv[1],m_pszArgv[2],
	        		SPACE_EXTERNAL);
	            if (ADR_OK != retCode) {       
	            	//m_nErrorID = SYNTAX_ERROR;
	            	m_nErrorID = NOT_SHOW_ERROR;
	            	break;
	            }	                              
	            if (!ConvertAddress(m_pszArgv[1], szArgv1, nRet)) {
	              	//m_nErrorID = SYNTAX_ERROR;
	              	m_nErrorID = nRet;
	            	break;
	            }	
	            if (!ConvertAddress(m_pszArgv[2], szArgv2, nRet)) {
	              	//m_nErrorID = SYNTAX_ERROR;
	              	m_nErrorID = nRet;
	            	break;
	            }	                                     
	            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
	            NewMem(m_pszArgv[2], strlen(szArgv2)+1);
	            strcpy(m_pszArgv[1],szArgv1);                                  
	            strcpy(m_pszArgv[2],szArgv2); 
            
                if ( !IsMapStartAddr(m_pszArgv[1]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
                if ( !IsMapEndAddr(m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
                if ( !IsPAddr(m_pszArgv[1]) &&
                	 !IsXAddr(m_pszArgv[1]) &&
                     !IsXAddrDefault(m_pszArgv[1]) ) {
                     //m_nErrorID = SYNTAX_ERROR;
                     m_nErrorID = ADDR_TYPE_ERROR;
                     break;
                }     
                if ( IsXAddrDefault(m_pszArgv[1]) ) {
                    if ( !IsMapAttr('X', m_pszArgv[3]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                }
                else if ( !IsMapAttr(m_pszArgv[1][0], m_pszArgv[3]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            break;
        case 5:
        	if (  !IsKeywordLength(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            	break;
            }
            if ( !IsAddrLen(m_pszArgv[3], nRet) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = nRet;
                break;
            }   
            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = nRet;                
            	break;
            }                     
            if (!ConvertAddress(m_pszArgv[1], szArgv2, nRet, SPACE_EXTERNAL)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }	                                                                
            NewMem(m_pszArgv[1], strlen(szArgv2)+1);
            strcpy(m_pszArgv[1],szArgv2);                                  
            
            ConvertLen(m_pszArgv[3], szArgv1);
           	NewMem(m_pszArgv[3], strlen(szArgv1)+1);
            strcpy(m_pszArgv[3],szArgv1);                                  
        	
            if ( !IsMapStartAddr(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }        
            if ( !IsMapAddrLen(m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            if ( IsXAddrDefault(m_pszArgv[1]) ) {
                if ( !IsMapAttr('X', m_pszArgv[4]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
                break;
            }
            else if ( !IsMapAttr(m_pszArgv[1][0], m_pszArgv[4]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    if (szArgv1) {
    	delete []szArgv1;    
    	szArgv1 = 0;
    }	
	if (szArgv2) {
		delete []szArgv2;
		szArgv2 = 0;
	}	
}   // End of CSyntaxCore::SyntaxCheckMap().

//MACro    macroname
void CSyntaxCore::SyntaxCheckMacro(void)
{                                 
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    // Check command syntax.
    switch ( m_nArgc ) {
        case 2:
            if ( !IsMacroName(m_pszArgv[1]) ) {
            //Annie, 4/18/96      
            //if ( !IsFilename(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckMacro().
           
//MDel        macroname|ALl           
void CSyntaxCore::SyntaxCheckMdel(void)
{                                 
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    // Check command syntax.
    switch ( m_nArgc ) {
        case 2:
            //if ( !IsMacroName(m_pszArgv[1]) &&
            //Annie, 4/18/96              
            if ( !IsFilename(m_pszArgv[1], nRet) && 
            	 !IsKeywordAll(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckMdel().


// Memory       adr1 [adr2|Length length]
void CSyntaxCore::SyntaxCheckMemory(void)
{       
	char* szArgv1;
    char* szArgv2;
    szArgv1 = new char[260]; 
    ASSERT(szArgv1);
    szArgv2 = new char[260];         
    ASSERT(szArgv2);
    ADDR_RETCODE retCode;
        
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
       	case 2:   
	        if (!ConvertAddress(m_pszArgv[1], szArgv1, nRet, SPACE_EXTERNAL)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }
            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
            strcpy(m_pszArgv[1],szArgv1);                                  
            
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) &&
                 !IsIAddr(m_pszArgv[1]) &&
                 !IsBAddr(m_pszArgv[1]) &&
                 !IsRAddr(m_pszArgv[1]) &&
                 !IsXAddrDefault(m_pszArgv[1]) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = ADDR_TYPE_ERROR;
            }
            break;
            
        case 3:                      
        	retCode = AdrShlCheck2Addr(m_pszArgv[1],m_pszArgv[2]
        		, SPACE_EXTERNAL);            
            if (ADR_OK != retCode) {       
            	//m_nErrorID = SYNTAX_ERROR;
            	m_nErrorID = NOT_SHOW_ERROR;
            	break;
            }	                              
            if (!ConvertAddress(m_pszArgv[1], szArgv1, nRet)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }	
            if (!ConvertAddress(m_pszArgv[2], szArgv2, nRet)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }	                

            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
            NewMem(m_pszArgv[2], strlen(szArgv2)+1);
            strcpy(m_pszArgv[1],szArgv1);                                  
            strcpy(m_pszArgv[2],szArgv2); 
			break;                                
        case 4:   
        	if (  !IsKeywordLength(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            	break;
            }
            if ( !IsAddrLen(m_pszArgv[3], nRet) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = nRet;
                break;
            }   
            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = nRet;                
            	break;
            }                     
            if (!ConvertAddress(m_pszArgv[1], szArgv2, nRet, SPACE_EXTERNAL)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }	                                                                
            NewMem(m_pszArgv[1], strlen(szArgv2)+1);
            strcpy(m_pszArgv[1],szArgv2);                                  
            
            ConvertLen(m_pszArgv[3], szArgv1);
           	NewMem(m_pszArgv[3], strlen(szArgv1)+1);
            strcpy(m_pszArgv[3],szArgv1);   
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) &&
                 !IsIAddr(m_pszArgv[1]) &&
                 !IsBAddr(m_pszArgv[1]) &&
                 !IsRAddr(m_pszArgv[1]) &&
                 !IsXAddrDefault(m_pszArgv[1]) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = ADDR_TYPE_ERROR;
            } 
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
       
    }  
    if (szArgv1) {
    	delete []szArgv1;    
    	szArgv1 = 0;
    }	
	if (szArgv2) {
		delete []szArgv2;
		szArgv2 = 0;
	}	

}   // End of CSyntaxCore::SyntaxCheckMemory().

//MENd
void CSyntaxCore::SyntaxCheckMend(void)
{                                 
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.    
    switch ( m_nArgc ) {
        case 1:
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    if ( !isDefineMacro ) {
    	m_nErrorID = SYNTAX_ERROR;
    }

}   // End of CSyntaxCore::SyntaxCheckMend().
     
//MList     
void CSyntaxCore::SyntaxCheckMlist(void)
{                                 
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;          
        case 2:
            if ( !IsFilename(m_pszArgv[1], nRet) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = nRet;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckMlist().
       
//MShow   macroname       
/*
void CSyntaxCore::SyntaxCheckMshow(void)
{                                 
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    // Check command syntax.
    switch ( m_nArgc ) {
        case 2:
            if ( !IsMacroName(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckMshow().
*/

// Outport      port { Bit bit data1 | BYte data2 }
//          ( data1 = 0, 1; data2 =  0 - FF ) 
void CSyntaxCore::SyntaxCheckOutport(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 4:
            if ( !IsPort(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordByte(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsByteData(m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        case 5:
            if ( !IsPort(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordBit(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsBitNo(m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsBitData(m_pszArgv[4]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckOutport().


// POrt         port
void CSyntaxCore::SyntaxCheckPort(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 2:
            if ( !IsPort(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    
}   // End of CSyntaxCore::SyntaxCheckPort().


// QUAlify      [ [ADDRESS {Range adr1 adr2|xadr|badrs..}] 
//              [DATUM {Range data1 data2|xdata|bdatum}] 
//              [STATUS status..] ] |
//              [CLear]
//
//              Note: where <status> is: S, F, R, W, AK; 10 badrs.
void CSyntaxCore::SyntaxCheckQualify(void)
{
	char* szArgv1;
    szArgv1 = new char[260]; 
    ASSERT(szArgv1); 
    ADDR_RETCODE retCode;    

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    if ( m_nArgc < 1 ) {
        m_nErrorID = SYNTAX_ERROR;
        delete []szArgv1;
        return;
    }
    else if ( 1 == m_nArgc ) {
    	delete []szArgv1;
        return;
    }
    else if ( 2 == m_nArgc ) {
        if ( !IsKeywordClear(m_pszArgv[1]) ) {
            m_nErrorID = SYNTAX_ERROR;
        }                
        delete []szArgv1;
        return;
    }
    else {  // m_nArgc >= 3.
        // Check m_pszArgv[1].
        if ( 0 != stricmp(m_pszArgv[1], "ADDRESS") &&
             0 != stricmp(m_pszArgv[1], "DATUM") &&
             0 != stricmp(m_pszArgv[1], "STATUS") ) {
            m_nErrorID = SYNTAX_ERROR;
            delete []szArgv1;
            return;
        }
        
        // Initial flag.
        BOOL isA = FALSE;
        BOOL isD = FALSE;
        BOOL isS = FALSE;
        int nIndex = 1;

        // Check m_pszArgv[].
        while ( nIndex < m_nArgc ) {
            if ( 0 == stricmp(m_pszArgv[nIndex], "ADDRESS") ) {
                // "ADDRESS...".
                if ( isA ) {
                    m_nErrorID = SYNTAX_ERROR;
                    delete []szArgv1;
                    return;
                }
                else {
                    isA = TRUE;
                }
                nIndex++;
                if ( nIndex >= m_nArgc ) {
                    m_nErrorID = SYNTAX_ERROR;
                    delete []szArgv1;
                    return;
                }
                if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        m_nErrorID = SYNTAX_ERROR;
                        delete []szArgv1;
                        return;
                    }     
		        	retCode = AdrShlCheck2Addr(m_pszArgv[nIndex],
		        		m_pszArgv[nIndex+1], SPACE_PROGRAME);
		            if (ADR_OK != retCode) {       
		            	//m_nErrorID = SYNTAX_ERROR;
		            	m_nErrorID = NOT_SHOW_ERROR;
		            	break;
		            }			        
			        if (!ConvertAddress(m_pszArgv[nIndex], szArgv1, nRet
			        	, SPACE_PROGRAME)) {
		              	//m_nErrorID = SYNTAX_ERROR;
		              	m_nErrorID = nRet;
		              	delete []szArgv1;
		            	return;
		            }		            
		            NewMem(m_pszArgv[nIndex], strlen(szArgv1)+1);
		            strcpy(m_pszArgv[nIndex],szArgv1);                                  
                    
                    if ( !IsPAddr(m_pszArgv[nIndex]) &&
                         !IsPAddrDefault(m_pszArgv[nIndex]) ) {
                        //m_nErrorID = SYNTAX_ERROR;
                        m_nErrorID = ADDR_TYPE_ERROR;
                        delete []szArgv1;
                        return;
                    }
                    else {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        } 
                        if (!ConvertAddress(m_pszArgv[nIndex], szArgv1, nRet
                        	, SPACE_PROGRAME)) {
			              	//m_nErrorID = SYNTAX_ERROR;
			              	m_nErrorID = nRet;
			              	delete []szArgv1;
			            	return;
			            }		            
			            NewMem(m_pszArgv[nIndex], strlen(szArgv1)+1);
			            strcpy(m_pszArgv[nIndex],szArgv1);                                  
                    
                        if ( !IsPAddr(m_pszArgv[nIndex]) &&
                             !IsPAddrDefault(m_pszArgv[nIndex]) ) {
                            //m_nErrorID = SYNTAX_ERROR;
                            m_nErrorID = ADDR_TYPE_ERROR;
                            delete []szArgv1;
                            return;
                        } 
                        else {
                            nIndex++;
                        }
                    }                    
                }
	            else if (ConvertAddress(m_pszArgv[nIndex], szArgv1, nRet
	            	, SPACE_PROGRAME)) {
		            NewMem(m_pszArgv[nIndex], strlen(szArgv1)+1);
		            strcpy(m_pszArgv[nIndex],szArgv1);                                  
                	if ( IsPAddr(m_pszArgv[nIndex]) ||
                         IsPAddrDefault(m_pszArgv[nIndex]) ) {
	                    nIndex++;
	                    if ( nIndex >= m_nArgc ) {
	                    	delete []szArgv1;
	                        return;
	                    }
	                    for ( int i = 2; i <= 10; i++ ) {
							if (!ConvertAddress(m_pszArgv[nIndex], szArgv1, nRet
								, SPACE_PROGRAME)) {
				              	//m_nErrorID = SYNTAX_ERROR;
				            	//return;
				            	break;
				            }		            
				            NewMem(m_pszArgv[nIndex], strlen(szArgv1)+1);
				            strcpy(m_pszArgv[nIndex],szArgv1);                                  
	                                            
	                        if ( IsPAddr(m_pszArgv[nIndex]) ||
	                             IsPAddrDefault(m_pszArgv[nIndex]) ) {
	                            nIndex++;
	                            if ( nIndex >= m_nArgc ) {
	                            	delete []szArgv1;
	                                return;
	                            }
	                        }
	                        else {
	                            break;
	                        }
	                   	}                                   
                	}   
                }
                else if ( IsWildcardAddr(m_pszArgv[nIndex]) ) {
                    nIndex++;
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;       
                    delete []szArgv1;
                    return;
                }
            }   // End of "ADDRESS...".

            else if ( 0 == stricmp(m_pszArgv[nIndex], "DATUM") ) {
                // "DATUM...".
                if ( isD ) {
                    m_nErrorID = SYNTAX_ERROR;
                    delete []szArgv1;
                    return;
                }
                else {
                    isD = TRUE;
                }
                nIndex++;
                if ( nIndex >= m_nArgc ) {
                    m_nErrorID = SYNTAX_ERROR;
                    delete []szArgv1;
                    return;
                }
                if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        m_nErrorID = SYNTAX_ERROR;
                        delete []szArgv1;
                        return;
                    }
                    if ( !IsEventData(m_pszArgv[nIndex]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        delete []szArgv1;
                        return;
                    }
                    else {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        }
                        if ( !IsEventData(m_pszArgv[nIndex]) ) {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        }
                        else {
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                            	delete []szArgv1;
                                return;
                            }
                        }
                    }
                }
                else if ( IsEventData(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {   
                    	delete []szArgv1;
                        return;
                    }
                }
                else if ( IsWildcardData(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                    	delete []szArgv1;
                        return;
                    }
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                    delete []szArgv1;
                    return;
                }
            }   // End of "DATUM...".

            else if ( 0 == stricmp(m_pszArgv[nIndex], "STATUS") ) {
                // "STATUS...".
                if ( isS ) {
                    m_nErrorID = SYNTAX_ERROR;
                    delete []szArgv1;
                    return;
                }
                else {
                    isS = TRUE;
                }
                nIndex++;
                if ( nIndex >= m_nArgc ) {
                    m_nErrorID = SYNTAX_ERROR;
                    delete []szArgv1;
                    return;
                }
                // Is "S", "F", "R", "W" or "AK".
                BOOL isStatusS = FALSE;
                BOOL isStatusF = FALSE;
                BOOL isStatusR = FALSE;
                BOOL isStatusW = FALSE;
                BOOL isStatusAK = FALSE;

                if ( !stricmp(m_pszArgv[nIndex],"S") && !isStatusS ) {
                    isStatusS = TRUE;
                }
                else if ( !stricmp(m_pszArgv[nIndex],"F") && !isStatusF ) {
                    isStatusF = TRUE;
                }
                else if ( !stricmp(m_pszArgv[nIndex],"R") && !isStatusR ) {
                    isStatusR = TRUE;
                }
                else if ( !stricmp(m_pszArgv[nIndex],"W") && !isStatusW ) {
                    isStatusW = TRUE;
                }
                else if ( !stricmp(m_pszArgv[nIndex],"AK") && !isStatusAK ) {
                    isStatusAK = TRUE;
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                    delete []szArgv1;
                    return;
                }

                nIndex++;
                if ( nIndex >= m_nArgc ) {
                	delete []szArgv1;
                    return;
                }
                for ( int j = 2; j <= 5; j++ ) {
                    if ( 0 == stricmp(m_pszArgv[nIndex], "S") ) {
                        if ( !isStatusS ) {
                            isStatusS = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                            	delete []szArgv1;
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        }
                    }
                    else if ( 0 == stricmp(m_pszArgv[nIndex], "F") ) {
                        if ( !isStatusF ) {
                            isStatusF = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                            	delete []szArgv1;
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        }
                    }
                    else if ( 0 == stricmp(m_pszArgv[nIndex], "R") ) {
                        if ( !isStatusR ) {
                            isStatusR = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                            	delete []szArgv1;
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        }
                    }
                    else if ( 0 == stricmp(m_pszArgv[nIndex], "W") ) {
                        if ( !isStatusW ) {
                            isStatusW = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                            	delete []szArgv1;
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        }
                    }
                    else if ( 0 == stricmp(m_pszArgv[nIndex], "AK") ) {
                        if ( !isStatusAK ) {
                            isStatusAK = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                            	delete []szArgv1;
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        }
                    }
                    else {
                        break;
                    }
                }
            }   // End of "STATUS...".
            
            else {
                // Not "A", "D", or "S".
                m_nErrorID = SYNTAX_ERROR;   
                delete []szArgv1;
                return;
            }
            
        }   // End of while()...
        
    }   // End of else...
    if (szArgv1) {
    	delete []szArgv1;    
    	szArgv1 = 0;
    }	
}   // End of CSyntaxCore::SyntaxCheckQualify().


// Register     [reg_id] [data]
void CSyntaxCore::SyntaxCheckRegister(void)
{
	char* szArgv1;
    szArgv1 = new char[260]; 
    ASSERT(szArgv1);

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;                   
        case 2:  
            if ( !IsRegName(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }        
        	break;    
        case 3:            
			//IsRegData(m_pszArgv[1], m_pszArgv[2]);        	
            if ( !IsRegName(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsRegData(m_pszArgv[1], m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
	if (szArgv1) {
		delete []szArgv1;
		szArgv1 = 0;
	}	
}   // End of CSyntaxCore::SyntaxCheckRegister().


// RESet        [adr]
void CSyntaxCore::SyntaxCheckReset(void)
{
	char* szArgv1;
    szArgv1 = new char[260]; 
    ASSERT(szArgv1);

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        case 2:
	        if (!ConvertAddress(m_pszArgv[1], szArgv1, nRet, SPACE_PROGRAME)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }
            if ( !IsPAddr(szArgv1) && 
                 !IsPAddrDefault(szArgv1) ) {
                //m_nErrorID = SYNTAX_ERROR;        
                m_nErrorID = ADDR_TYPE_ERROR;
                break;
            }
            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
            strcpy(m_pszArgv[1],szArgv1);
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    if (szArgv1) {
    	delete []szArgv1;    
    	szArgv1 = 0;
    }	
}   // End of CSyntaxCore::SyntaxCheckReset().

//RESTart
void CSyntaxCore::SyntaxCheckRestart(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckRestart().


// SEarch       adr1 {adr2|Length length} {[Insensitive] "string"|data..}
void CSyntaxCore::SyntaxCheckSearch(void)
{
	char* szArgv1;
    char* szArgv2;
    szArgv1 = new char[260]; 
    ASSERT(szArgv1);
    szArgv2 = new char[260];         
    ASSERT(szArgv2);
    ADDR_RETCODE retCode;

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Pre-process the field: "string" & Data.
    if ( m_nArgc < 4 ) {
        m_nErrorID = SYNTAX_ERROR;
        delete []szArgv1;
        delete []szArgv2;
        return;
    }
        
    int nArgc;
    if ( IsKeywordLength(m_pszArgv[2]) ) {
        if ( m_nArgc < 5 ) {
            m_nErrorID = SYNTAX_ERROR;
            delete []szArgv1;
            delete []szArgv2;
            return;
        }
        if ( IsKeywordInsensitive(m_pszArgv[4]) ) {
            if ( m_nArgc < 6 ) {
                m_nErrorID = SYNTAX_ERROR;
                delete []szArgv1;
                delete []szArgv2;
                return;
            }
            else {
                nArgc = 5;
            }
        }
        else {
            nArgc = 4;
        }
    }
    else {
        if ( IsKeywordInsensitive(m_pszArgv[3]) ) {
            if ( m_nArgc < 5 ) {
                m_nErrorID = SYNTAX_ERROR;
                delete []szArgv1;
                delete []szArgv2;
                return;
            }
            else {
                nArgc = 4;
            }
        }
        else {
            nArgc = 3;
        }
    }
        
    if ( !PreStringData(nArgc, 2) ) {
    	delete []szArgv1;
    	delete []szArgv2;
        return;
    }

    // Check command syntax.
    if ( !IsKeywordLength(m_pszArgv[2]) ) {
        switch ( m_nArgc ) {
            case 4:
                // SEarch adr1 adr2 {"string"|data..}
	        	retCode = AdrShlCheck2Addr(m_pszArgv[1],m_pszArgv[2]
	        		, SPACE_EXTERNAL);
	            if (ADR_OK != retCode) {       
	            	//m_nErrorID = SYNTAX_ERROR;
	            	m_nErrorID = NOT_SHOW_ERROR;
	            	break;
	            }	                              
	            if (!ConvertAddress(m_pszArgv[1], szArgv1, nRet)) {
	              	//m_nErrorID = SYNTAX_ERROR;
	              	m_nErrorID = nRet;
	            	break;
	            }	
	            if (!ConvertAddress(m_pszArgv[2], szArgv2, nRet)) {
	              	//m_nErrorID = SYNTAX_ERROR;
	              	m_nErrorID = nRet;
	            	break;
	            }	                                     
	            if ( !IsData(m_pszArgv[3]) && !IsString(m_pszArgv[3])) {
	                m_nErrorID = SYNTAX_ERROR;
	                break;
	            }
	            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
	            NewMem(m_pszArgv[2], strlen(szArgv2)+1);
	            strcpy(m_pszArgv[1],szArgv1);                                  
	            strcpy(m_pszArgv[2],szArgv2); 
	                            
                if ( !IsPAddr(m_pszArgv[1]) &&
                     !IsXAddr(m_pszArgv[1]) &&
                     !IsXAddrDefault(m_pszArgv[1]) ) {
                    //m_nErrorID = SYNTAX_ERROR;
                    m_nErrorID = ADDR_TYPE_ERROR;
                    break;
                }
                break;
            case 5:
                // SEarch adr1 adr2 Insensitive "string"
                if ( !IsKeywordInsensitive(m_pszArgv[3]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
                retCode = AdrShlCheck2Addr(m_pszArgv[1],m_pszArgv[2]
                	, SPACE_EXTERNAL);
	            if (ADR_OK != retCode) {       
	            	//m_nErrorID = SYNTAX_ERROR;
	            	m_nErrorID = NOT_SHOW_ERROR;
	            	break;
	            }	                              
	            if (!ConvertAddress(m_pszArgv[1], szArgv1, nRet)) {
	              	//m_nErrorID = SYNTAX_ERROR;
	              	m_nErrorID = nRet;
	            	break;
	            }	
	            if (!ConvertAddress(m_pszArgv[2], szArgv2, nRet)) {
	              	//m_nErrorID = SYNTAX_ERROR;
	              	m_nErrorID = nRet;
	            	break;
	            }	                                     
	            if ( !IsData(m_pszArgv[4]) && !IsString(m_pszArgv[4])) {
	                m_nErrorID = SYNTAX_ERROR;
	                break;
	            }
	            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
	            NewMem(m_pszArgv[2], strlen(szArgv2)+1);
	            strcpy(m_pszArgv[1],szArgv1);                                  
	            strcpy(m_pszArgv[2],szArgv2); 
	            
                if ( !IsPAddr(m_pszArgv[1]) &&
                     !IsXAddr(m_pszArgv[1]) &&
                     !IsXAddrDefault(m_pszArgv[1]) ) {
                    //m_nErrorID = SYNTAX_ERROR;
                    m_nErrorID = ADDR_TYPE_ERROR;
                }   
                break;
            default:
                m_nErrorID = SYNTAX_ERROR;
                break;
        }
    }
    else {
        switch ( m_nArgc ) {
            case 5:
                // SEarch adr1 Length length {"string"|data..}
               	if ( !IsKeywordLength(m_pszArgv[2]) ) {
	                m_nErrorID = SYNTAX_ERROR;
	            	break;
	            }
	            if ( !IsAddrLen(m_pszArgv[3], nRet) ) {
	                //m_nErrorID = SYNTAX_ERROR;
	                m_nErrorID = nRet;
	                break;
	            }   
	            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {
	                //m_nErrorID = SYNTAX_ERROR;
	                m_nErrorID = nRet;                
	            	break;
	            }                     
	            if (!ConvertAddress(m_pszArgv[1], szArgv2, nRet, SPACE_EXTERNAL)) {
	              	//m_nErrorID = SYNTAX_ERROR;
	              	m_nErrorID = nRet;
	            	break;
	            }	                                                                
	            if ( !IsData(m_pszArgv[4]) && !IsString(m_pszArgv[4])) {
	                m_nErrorID = SYNTAX_ERROR;
	                break;
	            }
	
	            NewMem(m_pszArgv[1], strlen(szArgv2)+1);
	            strcpy(m_pszArgv[1],szArgv2);                                  
	            
	            ConvertLen(m_pszArgv[3], szArgv1);
	           	NewMem(m_pszArgv[3], strlen(szArgv1)+1);
	            strcpy(m_pszArgv[3],szArgv1);                                  
	            if ( !IsPAddr(m_pszArgv[1]) &&
	                 !IsXAddr(m_pszArgv[1]) &&
	                 !IsXAddrDefault(m_pszArgv[1]) ) {
	                //m_nErrorID = SYNTAX_ERROR;
	                m_nErrorID = ADDR_TYPE_ERROR;
	            } 
	            break;

            case 6:
                // SEarch adr1 Length length Insensitive "string"
                if ( !IsKeywordInsensitive(m_pszArgv[4]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }         
               	if ( !IsKeywordLength(m_pszArgv[2]) ) {
	                m_nErrorID = SYNTAX_ERROR;
	            	break;
	            }
	            if ( !IsAddrLen(m_pszArgv[3], nRet) ) {
	                //m_nErrorID = SYNTAX_ERROR;
	                m_nErrorID = nRet;
	                break;
	            }   
	            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {
	                //m_nErrorID = SYNTAX_ERROR;
	                m_nErrorID = nRet;                
	            	break;
	            }                     
	            if (!ConvertAddress(m_pszArgv[1], szArgv2, nRet, SPACE_EXTERNAL)) {
	              	//m_nErrorID = SYNTAX_ERROR;
	              	m_nErrorID = nRet;
	            	break;
	            }	                                                                
				if ( !IsData(m_pszArgv[5]) && !IsString(m_pszArgv[5])) {
	                m_nErrorID = SYNTAX_ERROR;
	                break;
	            }
	
	            NewMem(m_pszArgv[1], strlen(szArgv2)+1);
	            strcpy(m_pszArgv[1],szArgv2);                                  
	            
	            ConvertLen(m_pszArgv[3], szArgv1);
	           	NewMem(m_pszArgv[3], strlen(szArgv1)+1);
	            strcpy(m_pszArgv[3],szArgv1);                                  
	            if ( !IsPAddr(m_pszArgv[1]) &&
	                 !IsXAddr(m_pszArgv[1]) &&
	                 !IsXAddrDefault(m_pszArgv[1]) ) {
	                //m_nErrorID = SYNTAX_ERROR;
	                m_nErrorID = ADDR_TYPE_ERROR;
	            } 
	            break;

            default:
                m_nErrorID = SYNTAX_ERROR;
                break;
        }
    }
                    
    
    if (szArgv1) {
    	delete []szArgv1;    
    	szArgv1 = 0;
    }	
	if (szArgv2) {
		delete []szArgv2;
		szArgv2 = 0;
	}	

}   // End of CSyntaxCore::SyntaxCheckSearch().


// Step         [Over] 
//              [ count | FOrever | adr1 adr2 | 
//              Till { Ret | CAll } | Till {@reg | adr} IS value ]
void CSyntaxCore::SyntaxCheckStep(void)
{
	char* szArgv1;
    char* szArgv2;
    szArgv1 = new char[260]; 
    ASSERT(szArgv1);
    szArgv2 = new char[260];         
    ASSERT(szArgv2);
    ADDR_RETCODE retCode;

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        case 2:
            if ( !IsKeywordOver(m_pszArgv[1]) &&
                 !IsKeywordForever(m_pszArgv[1]) &&
                 !IsStepCount(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        case 3:
            if ( IsKeywordOver(m_pszArgv[1]) ) {
                if ( !IsStepCount(m_pszArgv[2]) &&
                     !IsKeywordForever(m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
            }
            else if ( IsKeywordTill(m_pszArgv[1]) ) {
                if ( !IsKeywordRet(m_pszArgv[2]) &&
                     !IsKeywordCall(m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
            }
            else {
	        	retCode = AdrShlCheck2Addr(m_pszArgv[1],m_pszArgv[2]
	        		, SPACE_PROGRAME);
	            if (ADR_OK != retCode) {       
	            	//m_nErrorID = SYNTAX_ERROR;
	            	m_nErrorID = NOT_SHOW_ERROR;
	            	break;
	            }	                              
	            if (!ConvertAddress(m_pszArgv[1], szArgv1, nRet)) {
	              	//m_nErrorID = SYNTAX_ERROR;
	              	m_nErrorID = nRet;
	            	break;
	            }	
	            if (!ConvertAddress(m_pszArgv[2], szArgv2, nRet)) {
	              	//m_nErrorID = SYNTAX_ERROR;
	              	m_nErrorID = nRet;
	            	break;
	            }	                                     
	            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
	            NewMem(m_pszArgv[2], strlen(szArgv2)+1);
	            strcpy(m_pszArgv[1],szArgv1);                                  
	            strcpy(m_pszArgv[2],szArgv2); 
	            
	            if ( !IsPAddr(m_pszArgv[1]) &&
	                 !IsPAddrDefault(m_pszArgv[1]) ) {
	                //m_nErrorID = SYNTAX_ERROR;
	                m_nErrorID = ADDR_TYPE_ERROR;
	            	break;
	            }
            }
            break;
        case 4:
            if ( !IsKeywordOver(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( IsKeywordTill(m_pszArgv[2]) ) {
                if ( !IsKeywordRet(m_pszArgv[3]) &&
                     !IsKeywordCall(m_pszArgv[3]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
            }
            else {
	        	retCode = AdrShlCheck2Addr(m_pszArgv[2],m_pszArgv[2]
	        		, SPACE_PROGRAME);
	            if (ADR_OK != retCode) {       
	            	//m_nErrorID = SYNTAX_ERROR;
	            	m_nErrorID = NOT_SHOW_ERROR;
	            	break;
	            }	                              
	            if (!ConvertAddress(m_pszArgv[2], szArgv1, nRet)) {
	              	//m_nErrorID = SYNTAX_ERROR;
	              	m_nErrorID = nRet;
	            	break;
	            }	
	            if (!ConvertAddress(m_pszArgv[3], szArgv2, nRet)) {
	              	//m_nErrorID = SYNTAX_ERROR;
	              	m_nErrorID = nRet;
	            	break;
	            }	                                     
	            NewMem(m_pszArgv[2], strlen(szArgv1)+1);
	            NewMem(m_pszArgv[3], strlen(szArgv2)+1);
	            strcpy(m_pszArgv[2],szArgv1);                                  
	            strcpy(m_pszArgv[3],szArgv2); 
	            
	            if ( !IsPAddr(m_pszArgv[2]) &&
	                 !IsPAddrDefault(m_pszArgv[2]) ) {
	                //m_nErrorID = SYNTAX_ERROR;
	                m_nErrorID = ADDR_TYPE_ERROR;
	            	break;
	            }

            }
            break;
        case 5:
            if ( !IsKeywordTill(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( '@' == m_pszArgv[2][0] ) {
                if ( !IsRegName(m_pszArgv[2]+1) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( 0 != stricmp(m_pszArgv[3], "IS") ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsRegData(m_pszArgv[2]+1, m_pszArgv[4]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
            }
            else {
                if ( IsAddr(m_pszArgv[2]) ) {
					if (!ConvertAddress(m_pszArgv[2], szArgv1, nRet
						, SPACE_PROGRAME)) {
	              		//m_nErrorID = SYNTAX_ERROR;
	              		m_nErrorID = nRet;
	            		break;
	            	}	                                     
				    else {                                     
						NewMem(m_pszArgv[2], strlen(szArgv1)+1);
			            strcpy(m_pszArgv[2],szArgv1);                                  
			        }                    
                }   
                else {
                	m_nErrorID = SYNTAX_ERROR;
	            	break;
                }
                if ( !IsPAddr(m_pszArgv[2]) &&
                	 !IsXAddr(m_pszArgv[2]) && 	 
                	 !IsPAddrDefault(m_pszArgv[2]) ) {
                    //m_nErrorID = SYNTAX_ERROR;
                    m_nErrorID = ADDR_TYPE_ERROR;
                }
                else if ( 0 != stricmp(m_pszArgv[3], "IS") ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsAddrData(m_pszArgv[4]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
            }
            break;
        case 6:
            if ( !IsKeywordOver(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordTill(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( '@' == m_pszArgv[3][0] ) {
                if ( !IsRegName(m_pszArgv[3]+1) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( 0 != stricmp(m_pszArgv[4], "IS") ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsRegData(m_pszArgv[3]+1, m_pszArgv[5]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
            }
            else {
                if ( IsAddr(m_pszArgv[2]) ) {
					if (!ConvertAddress(m_pszArgv[2], szArgv1, nRet
						, SPACE_PROGRAME)) {
	              		//m_nErrorID = SYNTAX_ERROR;
	              		m_nErrorID = nRet;
	            		break;
	            	}	                                     
				    else {                                     
						NewMem(m_pszArgv[2], strlen(szArgv1)+1);
			            strcpy(m_pszArgv[2],szArgv1);                                  
			        }                    
                }   
                else {
                	m_nErrorID = SYNTAX_ERROR;
	            	break;
                }
                if ( !IsPAddr(m_pszArgv[2]) &&
                	 !IsXAddr(m_pszArgv[2]) && 	 
                	 !IsPAddrDefault(m_pszArgv[2]) ) {
                    //m_nErrorID = SYNTAX_ERROR;
                    m_nErrorID = ADDR_TYPE_ERROR;
                }
                else if ( 0 != stricmp(m_pszArgv[4], "IS") ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsAddrData(m_pszArgv[5]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    if (szArgv1) {
    	delete []szArgv1;    
    	szArgv1 = 0;
    }	
	if (szArgv2) {
		delete []szArgv2;
		szArgv2 = 0;
	}	
}   // End of CSyntaxCore::SyntaxCheckStep().


// TEst         adr1 {adr2|Length length}
void CSyntaxCore::SyntaxCheckTest(void)
{
	char* szArgv1;
    char* szArgv2;
    szArgv1 = new char[260]; 
    ASSERT(szArgv1);
    szArgv2 = new char[260];         
    ASSERT(szArgv2);
    ADDR_RETCODE retCode;

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 3:
        	retCode = AdrShlCheck2Addr(m_pszArgv[1],m_pszArgv[2]
        		, SPACE_EXTERNAL);
            if (ADR_OK != retCode) {       
            	//m_nErrorID = SYNTAX_ERROR;
            	m_nErrorID = NOT_SHOW_ERROR;
            	break;
            }	                              
            if (!ConvertAddress(m_pszArgv[1], szArgv1, nRet)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }	
            if (!ConvertAddress(m_pszArgv[2], szArgv2, nRet)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }	
            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
            NewMem(m_pszArgv[2], strlen(szArgv2)+1);
            strcpy(m_pszArgv[1],szArgv1);                                  
            strcpy(m_pszArgv[2],szArgv2);
            
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) &&
                 !IsIAddr(m_pszArgv[1]) &&
                 !IsXAddrDefault(m_pszArgv[1]) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = ADDR_TYPE_ERROR;
                break;
            }   
            break;
        case 4:
        	if ( !IsKeywordLength(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            	break;
            }
            if ( !IsAddrLen(m_pszArgv[3], nRet) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = nRet;
                break;
            }   
            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = nRet;                
            	break;
            }                     
            if (!ConvertAddress(m_pszArgv[1], szArgv2, nRet, SPACE_EXTERNAL)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }	                                                                
            NewMem(m_pszArgv[1], strlen(szArgv2)+1);
            strcpy(m_pszArgv[1],szArgv2);                                  
            
            ConvertLen(m_pszArgv[3], szArgv1);
           	NewMem(m_pszArgv[3], strlen(szArgv1)+1);
            strcpy(m_pszArgv[3],szArgv1);                                  
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) &&
                 !IsIAddr(m_pszArgv[1]) &&
                 !IsXAddrDefault(m_pszArgv[1]) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = ADDR_TYPE_ERROR;
            } 
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    if (szArgv1) {
    	delete []szArgv1;    
    	szArgv1 = 0;
    }	
	if (szArgv2) {
		delete []szArgv2;
		szArgv2 = 0;
	}	
}   // End of CSyntaxCore::SyntaxCheckTest().


// TImer        [ON|OFf]
void CSyntaxCore::SyntaxCheckTimer(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        case 2:
            if ( !IsKeywordOn(m_pszArgv[1]) &&
                 !IsKeywordOff(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckTimer().


// TRace        [ON|OFf|Clear]
void CSyntaxCore::SyntaxCheckTrace(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        case 2:
            if ( !IsKeywordOn(m_pszArgv[1]) &&
                 !IsKeywordOff(m_pszArgv[1]) && 
                 !IsKeywordClear(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckTrace().


// Trigger      [ [Run] {LV1|LV2} [Then {LV1|LV2}]
//              [FOrward|BACKward|CENter|DELay count] ] |
//              [ON|OFf]
void CSyntaxCore::SyntaxCheckTrigger(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            // Trigger
            break;
        case 2:
            // Trigger ON|OFf
            // Trigger LV1|LV2
            if ( !IsKeywordOn(m_pszArgv[1]) &&
                 !IsKeywordOff(m_pszArgv[1]) &&
                 !IsKeywordLv1(m_pszArgv[1]) &&
                 !IsKeywordLv2(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        case 3:
            // Trigger Run LV1|LV2
            // Trigger LV1|LV2 FOrward|BACKward|CENter
            if ( IsKeywordRun(m_pszArgv[1]) ) {
                if ( !IsKeywordLv1(m_pszArgv[2]) &&
                     !IsKeywordLv2(m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
            }
            else if ( IsKeywordLv1(m_pszArgv[1]) ||
                      IsKeywordLv2(m_pszArgv[1]) ) {
                if ( !IsKeywordForward(m_pszArgv[2]) &&
                     !IsKeywordBackward(m_pszArgv[2]) &&
                     !IsKeywordCenter(m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
            }
            else {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        case 4:
            // Trigger Run LV1|LV2 FOrward|BACKward|CENter
            // Trigger LV1|LV2 DELay count
            // Trigger LV1 Then LV2
            if ( IsKeywordRun(m_pszArgv[1]) ) {
                if ( !IsKeywordLv1(m_pszArgv[2]) &&
                     !IsKeywordLv2(m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsKeywordForward(m_pszArgv[3]) &&
                          !IsKeywordBackward(m_pszArgv[3]) &&
                          !IsKeywordCenter(m_pszArgv[3]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
            }
            else if ( !IsKeywordLv1(m_pszArgv[1]) &&
                      !IsKeywordLv2(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( IsKeywordDelay(m_pszArgv[2]) ) {
                if ( !IsAddrData(m_pszArgv[3]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
            }
            else if ( IsKeywordThen(m_pszArgv[2]) ) {
                if ( !IsKeywordLv1(m_pszArgv[1]) ||
                     !IsKeywordLv2(m_pszArgv[3]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }    
            }
            else {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        case 5:
            // Trigger Run LV1 Then LV2
            // Trigger Run {LV1|LV2} Delay count 
            // Trigger LV1 Then LV2 FOrward|BACKward|CENter
            if ( IsKeywordRun(m_pszArgv[1]) ) {
                if ( IsKeywordThen(m_pszArgv[3]) ) {
                    if ( !IsKeywordLv1(m_pszArgv[2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                    else if ( !IsKeywordLv2(m_pszArgv[4]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                    else {
                        break;
                    }
                }
                else if ( IsKeywordDelay(m_pszArgv[3]) ) {
                    if ( !IsKeywordLv1(m_pszArgv[2]) &&
                         !IsKeywordLv2(m_pszArgv[2]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                    else if ( !IsAddrData(m_pszArgv[4]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        break;
                    }
                    else {
                        break;
                    }
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                    break;
                }
            }
            else if ( !IsKeywordLv1(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordThen(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordLv2(m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordForward(m_pszArgv[4]) &&
                      !IsKeywordBackward(m_pszArgv[4]) &&
                      !IsKeywordCenter(m_pszArgv[4]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;                                                 
        case 6:
            // Trigger Run LV1 Then LV2 FOrward|BACKward|CENter
            // Trigger LV1 Then LV2 DELay count
            if ( IsKeywordRun(m_pszArgv[1]) ) {
                if ( !IsKeywordLv1(m_pszArgv[2]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsKeywordThen(m_pszArgv[3]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsKeywordLv2(m_pszArgv[4]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
                else if ( !IsKeywordForward(m_pszArgv[5]) &&
                          !IsKeywordBackward(m_pszArgv[5]) &&
                          !IsKeywordCenter(m_pszArgv[5]) ) {
                    m_nErrorID = SYNTAX_ERROR;
                }
            }
            else if ( !IsKeywordLv1(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordThen(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordLv2(m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordDelay(m_pszArgv[4]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsAddrData(m_pszArgv[5]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        case 7:
            // Trigger Run LV1 Then LV2 DELay count
            if ( !IsKeywordRun(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordLv1(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordThen(m_pszArgv[3]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordLv2(m_pszArgv[4]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordDelay(m_pszArgv[5]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsAddrData(m_pszArgv[6]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
            
}   // End of CSyntaxCore::SyntaxCheckTrigger().


// Upload       adr1 {adr2|Length length} filename
void CSyntaxCore::SyntaxCheckUpload(void)
{
	char* szArgv1;
    char* szArgv2;
    szArgv1 = new char[260]; 
    ASSERT(szArgv1);
    szArgv2 = new char[260];         
    ASSERT(szArgv2);
    ADDR_RETCODE retCode;

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 4:
        	retCode = AdrShlCheck2Addr(m_pszArgv[1],m_pszArgv[2]
        		, SPACE_PROGRAME);
            if (ADR_OK != retCode) {       
            	//m_nErrorID = SYNTAX_ERROR;
            	m_nErrorID = NOT_SHOW_ERROR;
            	break;
            }	                              
            if (!ConvertAddress(m_pszArgv[1], szArgv1, nRet)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }	
            if (!ConvertAddress(m_pszArgv[2], szArgv2, nRet)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }	                                     
            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
            NewMem(m_pszArgv[2], strlen(szArgv2)+1);
            strcpy(m_pszArgv[1],szArgv1);                                  
            strcpy(m_pszArgv[2],szArgv2); 

            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsPAddrDefault(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = ADDR_TYPE_ERROR;
            	break;
            } 
            if ( !IsFilename(m_pszArgv[3], nRet) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = nRet;
                break;
            }         
            break;                                  
        case 5:
        	if ( !IsKeywordLength(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            	break;
            }
            if ( !IsAddrLen(m_pszArgv[3], nRet) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = nRet;
                break;
            }   
            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet, SPACE_PROGRAME) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = nRet;                
            	break;
            }                     
            if (!ConvertAddress(m_pszArgv[1], szArgv2, nRet, SPACE_PROGRAME)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }	                                                                
            NewMem(m_pszArgv[1], strlen(szArgv2)+1);
            strcpy(m_pszArgv[1],szArgv2);                                  
            
            ConvertLen(m_pszArgv[3], szArgv1);
           	NewMem(m_pszArgv[3], strlen(szArgv1)+1);
            strcpy(m_pszArgv[3],szArgv1);                                  
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) &&
                 !IsIAddr(m_pszArgv[1]) &&
                 !IsXAddrDefault(m_pszArgv[1]) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = ADDR_TYPE_ERROR;
                break;
            } 
            if ( !IsFilename(m_pszArgv[4], nRet) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = nRet;
            }         
            break;
                            
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    if (szArgv1) {
    	delete []szArgv1;    
    	szArgv1 = 0;
    }	
	if (szArgv2) {
		delete []szArgv2;
		szArgv2 = 0;
	}	

}   // End of CSyntaxCore::SyntaxCheckUpload().


// Verify       [ON|OFf]
void CSyntaxCore::SyntaxCheckVerify(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        case 2:
            if ( !IsKeywordOn(m_pszArgv[1]) &&
                 !IsKeywordOff(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckVerify().


// Word         adr data1 [.. data16]
void CSyntaxCore::SyntaxCheckWord(void)
{
	char* szArgv;
    szArgv = new char[260]; 
    ASSERT(szArgv);

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Pre-process the field: "string" & Data.
    if ( m_nArgc < 3 ) {
        m_nErrorID = SYNTAX_ERROR;
        delete []szArgv;
        return;
    }
    
    int nArgc = 2;
    if ( !PreStringData(nArgc, 4) ) {
    	delete []szArgv;
        return;
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 3:
            if (!ConvertAddress(m_pszArgv[1], szArgv, nRet, SPACE_EXTERNAL)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }                
            if (IsBAddr(szArgv)) {
            	if( !IsDataBit(m_pszArgv[2])) {
            		m_nErrorID = SYNTAX_ERROR;
                	break;
            	}
            }
            else if ( !IsDataWord(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            if ( !IsDataRange(m_nArgc, m_pszArgv, 2) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            NewMem(m_pszArgv[1], strlen(szArgv)+1);
            strcpy(m_pszArgv[1],szArgv);
        	
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) &&
                 !IsIAddr(m_pszArgv[1]) &&
                 !IsRAddr(m_pszArgv[1]) &&
                 !IsBAddr(m_pszArgv[1]) &&
                 !IsXAddrDefault(m_pszArgv[1]) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = ADDR_TYPE_ERROR;
                break;
            } 
            break;
        
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    if (szArgv) {
    	delete []szArgv;    
    	szArgv = 0;
    }	
}   // End of CSyntaxCore::SyntaxCheckWord().


// BAck
void CSyntaxCore::SyntaxCheckBack(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckBack().


// CReate       #symbol adr
void CSyntaxCore::SyntaxCheckCreate(void)
{
	char* szArgv1;
    szArgv1 = new char[260]; 
    ASSERT(szArgv1);

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 3:
            if ( !IsVariableName(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }   
            //if ( '#' != m_pszArgv[2][0]) {
	        	if( !ConvertAddress(m_pszArgv[2], szArgv1, nRet
	        		, SPACE_PROGRAME)) {
              		//m_nErrorID = SYNTAX_ERROR;
              		m_nErrorID = nRet;
            		break;
	            }       
	            NewMem(m_pszArgv[2], strlen(szArgv1)+1);
	            strcpy(m_pszArgv[2],szArgv1);                                  
	            
	            if ( !IsPAddr(m_pszArgv[2]) &&
	                 !IsXAddr(m_pszArgv[2]) &&
	                 !IsIAddr(m_pszArgv[2]) &&
	                 !IsRAddr(m_pszArgv[2]) &&
	                 !IsBAddr(m_pszArgv[2]) &&
	                 !IsPAddrDefault(m_pszArgv[2]) ) {
	                //m_nErrorID = SYNTAX_ERROR;
	                m_nErrorID = ADDR_TYPE_ERROR;
	            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    if (szArgv1) {
    	delete []szArgv1;    
    	szArgv1 = 0;
    }	
   // End of CSyntaxCore::SyntaxCheckCreate().
}

// DElete       #symbol | $variable | All 
void CSyntaxCore::SyntaxCheckDelete(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 2:
            if ( !IsVariableName(m_pszArgv[1]) && 
            	 !IsMacroVarName(m_pszArgv[1]) && 	
                 !IsKeywordAll(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckDelete().


// LOAd         filename 
//              [Symbols|NOSymbols] 
//              [Code|NOCode]
//              [Progress|NOProgress] 
//not support Demand Option
//              [Demand|NODemand]
//              [Module module_name]
//              [Warn|NOWarn] 
//              [Mangle|NOMangle]
//              [p:|x:]
void CSyntaxCore::SyntaxCheckLoad(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 2:
            if ( !IsFilename(m_pszArgv[1], nRet) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = nRet;
            }
            break;
        case 3:
        case 4:
        case 5:
        case 6:
        case 7:
        case 8:
        case 9:
//        case 10:
//        case 11:
            if ( !IsFilename(m_pszArgv[1], nRet) ||
                 !IsLoadOption(m_nArgc, m_pszArgv) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckLoad().


// MODUle
void CSyntaxCore::SyntaxCheckModule(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckModule().


// QUEry        #symbol | #module#line_no | hex_adr
void CSyntaxCore::SyntaxCheckQuery(void)
{
	char* szArgv1;
    szArgv1 = new char[260]; 
    ASSERT(szArgv1);

   // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 2:
            if ( !IsSymbolName(m_pszArgv[1]) &&
                 //!IsLineNo(m_pszArgv[1]) &&
                 //!IsAddr(m_pszArgv[1]) && 
                 !IsHexAddr(m_pszArgv[1]) &&
                 !IsPAddrDefault(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    if (szArgv1) {
    	delete []szArgv1;    
    	szArgv1 = 0;
    }	
}   // End of CSyntaxCore::SyntaxCheckQuery().


// SSave        filename
void CSyntaxCore::SyntaxCheckSsave(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 2:
            if ( !IsFilename(m_pszArgv[1], nRet )) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = nRet;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckSsave().


// SRecall      filename
void CSyntaxCore::SyntaxCheckSrecall(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 2:
            if ( !IsFilename(m_pszArgv[1], nRet) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = nRet;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    
}   // End of CSyntaxCore::SyntaxCheckSrecall().


// SYmbol       [ Global | Module | Lines | #module ]
void CSyntaxCore::SyntaxCheckSymbol(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        case 2:
            if ( !IsKeywordGlobal(m_pszArgv[1]) &&
                 !IsKeywordModule(m_pszArgv[1]) &&
                 !IsKeywordLines(m_pszArgv[1]) &&
                 !IsVariableName(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckSymbol().

void CSyntaxCore::SyntaxCheckWatch(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            m_nErrorID = SYNTAX_ERROR;
            break;
        case 2:                
        {
        	int nStrLen = strlen(m_pszArgv[1]);
        	CString str;
        	//int i;
			
			str = m_pszArgv[1];
			str.TrimLeft();
			str.TrimRight();       	
        	if (str[0] == '\"' && str[str.GetLength()-1] == '\"') {
        		str = str.Left(str.GetLength()-1);
        		str = str.Right(str.GetLength()-1);
        		strcpy(m_pszArgv[1], str);
        		//m_pszArgv[1] = str.GetBuffer(str.GetLength());
        	//	AfxMessageBox(m_pszArgv[1]);
            }
            else
				m_nErrorID = SYNTAX_ERROR;            
            
            break;
        }
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
}   // End of CSyntaxCore::SyntaxCheckWatch().


#ifdef _CHEN_

// Calculate
void CSyntaxCore::SyntaxCheckCalculate(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.

}   // End of CSyntaxCore::SyntaxCheckCalculate().

#endif  // _CHEN_


#ifdef _GATES

// COUNT
void CSyntaxCore::SyntaxCheckCount(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckCount().


// LINE
void CSyntaxCore::SyntaxCheckLine(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckLine().


// STATEMENT
void CSyntaxCore::SyntaxCheckStatement(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckStatement().


// VOID
void CSyntaxCore::SyntaxCheckVoid(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.

}   // End of CSyntaxCore::SyntaxCheckVoid().


// TYPE
void CSyntaxCore::SyntaxCheckType(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckType().

#endif  // _GATES


//////////////////////////////// End of File ////////////////////////////////
