 /***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/UISRLX.CPP   1.2.1.4   17 Apr 1997 16:08:46   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/UISRLX.CPP  $
** 
**    Rev 1.2.1.4   17 Apr 1997 16:08:46   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:44:14   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:48:50   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:27:54   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:31:14   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:40:26   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:53:20   ZJRD
** Initial revision.
** 
**    Rev 1.4   21 Oct 1996 09:19:24   ZJRD
** PIC/SLD Version 0.91
** 
**    Rev 1.3   09 Oct 1996 13:51:48   ZJRD
** PIC/SLD Version 0.90
** 
**    Rev 1.2   23 Sep 1996 10:39:08   ZJRD
** No change.
** 
**    Rev 1.1   06 Sep 1996 13:53:16   ZJRD
** No change.
** 
**    Rev 1.0   02 Sep 1996 11:34:30   ZJRD
** Initial revision.
** 
**    Rev 1.0   13 Aug 1996 09:20:14   ZJRD
** Initial revision.
** 
****************************************************************************/

/***************************************************************************
**
** File name : UISRLX.CPP
** Author:john chow
** Description:
**    Descript the derived class from CWinSerialPICAgree for using in setup
**
**    Finished date: 96.8
**    modifed date:
**
**    Copyright (C) 1995 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

#include "stdafx.h"

#include "uisrlx.h"
#include "conio.h"
#include "resource.h"
#include "communic.h"
#include "abitype.h"

extern int OpenAbiComDlg(int fHelpComm);
extern void ExitEpsld(void);    
extern STATUS AbiSelectBaud(BYTE bOption);
extern BOOL Str2Num(char * psz, DWORD & dwVal);
extern BOOL SetComm(void);
extern char * PortAddr[8];
extern int nPortAddr;         
extern int nPortType; 

extern "C" {
	WORD FAR PASCAL _export WhatCpu();    
}	

int nCommPort = 0;
int nBaudRate = 0;

//implemention of class CWinSerialPICAgree

BOOL CWinSerialPICAgreeSetup::CommInit()
{            
    //read init savings                        
    BYTE bTmpBaudRate;
    m_bPortNum = ReadCommType(); 
	//add by chris:
/*    if(m_bPortNum == COM_PCE) {
    	m_bPortNum=COM_LPT1;
//    	return FALSE;
    }*/
    if( m_bPortNum < COM_PORT_1 && m_bPortNum >=0 ) {
    	//john 97.1 to support parallel 
    	m_wAddr = ReadCommAddr();
    	m_bBaudRate = BAUD_115200;
    } else {
        m_wAddr = 0x200;
	    if(m_bPortNum < COM_PORT_1 || m_bPortNum > COM_PORT_4) {
	        m_bPortNum =  COM_PORT_2;    
	    }
	    
	    m_bBaudRate = ReadCommBaud();
	    if(m_bBaudRate < BAUD_9600 || m_bBaudRate > BAUD_115200) {
	        m_bBaudRate = BAUD_19200;    
	    }                               
	    m_bBaudRate = BAUD_115200;
	    bTmpBaudRate = m_bBaudRate;  
    }        
    
    //try to connect to PIC with the settings
    BOOL isFirst = TRUE;
    while (TRUE) {
    	CCommunicationDialog dlg;
        dlg.m_nType = m_bPortNum;
        dlg.m_nComBaud = m_bBaudRate-1;              
        sprintf(dlg.m_strAddr.GetBuffer(20),"0x%03x",m_wAddr);
        dlg.m_strAddr.ReleaseBuffer();
        char * pEnd;
		for(int i = 0; i < 8; i ++) {          
	    	dlg.m_nPortAddr[i] = (int)strtol(::PortAddr[i], &pEnd, 16);
	    } 
        //dlg.UpdateData(FALSE);
        if ( !isFirst) {         
         dlg.m_nType = m_bPortNum-1;
        	if(dlg.DoModal() != IDOK) return FALSE;
        } else isFirst = FALSE;	
        m_bPortNum = dlg.m_nType;
        
// Modified by Gates Hua   
		if(m_bPortNum < COM_PORT_1) {       
		    DWORD dw;
		    BOOL is = ::Str2Num(dlg.m_strAddr.GetBuffer(10), dw);
		    dlg.m_strAddr.ReleaseBuffer();
		    
		    if(!is || dw > 0xFFF) {
		        AfxMessageBox("Address Error!");
		        continue;
		    }                                
		                
		    ::nPortType = dlg.m_nType;
		    ::nPortAddr = m_wAddr = int(dw);
		    
		    AfxGetApp()->DoWaitCursor(1);
		    is = ::SetComm();
		    AfxGetApp()->DoWaitCursor(-1);
		    if (is) break;
		    m_bPortNum++;
	        if (m_bPortNum > COM_PORT_4) m_bPortNum = COM_PCE;
		    continue;
		} else {
			if ( dlg.m_bChecked ) 
		        m_bBaudRate = bTmpBaudRate = 4;
			else	        
	        	m_bBaudRate = bTmpBaudRate = dlg.m_nComBaud+1;
	        
	        if (!SetSerialOption()) return FALSE;
	        if (SetSerialPortBaud(m_bPortNum,m_bDefaultBaudRate)) {
	            if (Init() || TryInit()) {  
	                if (m_bBaudRate == bTmpBaudRate) break;
	                
	                BYTE bMaxBaudRate = BAUD_115200;
	                switch (WhatCpu()) {
	                	case 1 :
	                	case 2 : bMaxBaudRate = BAUD_19200; break;
	                	case 3 : bMaxBaudRate = BAUD_38400; break;
	                	case 4 : bMaxBaudRate = BAUD_57600; break;
	                	case 5 : 
	                	default: bMaxBaudRate = BAUD_115200; break;
	                }	
	                bTmpBaudRate = (bTmpBaudRate > bMaxBaudRate)
	                			   ? bMaxBaudRate : bTmpBaudRate;
	                m_bBaudRate = bTmpBaudRate;  
	                nCommPort = m_bPortNum;
					    nBaudRate = m_bBaudRate;
	                if (ICE_OK != AbiSelectBaud(m_bBaudRate)) return FALSE;
	                if (SetSerialPortBaud(m_bPortNum,m_bBaudRate) 
	                    && Init()) break;  
	                if ( BAUD_19200 != m_bBaudRate) {
	                    m_bBaudRate--;   
	                    bTmpBaudRate = m_bBaudRate;
	                    continue;
	                }    
	                    
	            }
	        } 
	        
	        m_bPortNum++;
	        if (m_bPortNum > COM_PORT_4) m_bPortNum = COM_PCE;
	    }    
        
    }
      
    WriteCommType(m_bPortNum);
    WriteCommBaud(m_bBaudRate);     
    WriteCommAddr(m_wAddr);

	nCommPort = nPortType = m_bPortNum;
	nBaudRate = m_bBaudRate;
	nPortAddr = m_wAddr;
    return TRUE;
    
 }

BYTE CWinSerialPICAgreeSetup::ReadCommType()
{                             
	return 
		GetPrivateProfileInt("COMM", "Type", COM_PORT_2,"EPSLD52F.INI");	
 }
 
BYTE CWinSerialPICAgreeSetup::ReadCommBaud()
{                             
	return 
		GetPrivateProfileInt("COMM", "BaudRate",BAUD_115200,"EPSLD52F.INI");	
 }      

BYTE CWinSerialPICAgreeSetup::ReadClock()
{ 
	return
		GetPrivateProfileInt("CLOCK", "Type",CLOCK_HS,"EPSLD52F.INI");
 }      
 
BYTE CWinSerialPICAgreeSetup::ReadCpu()
{ 
	return
		GetPrivateProfileInt("CPU", "Type",0,"EPSLD52F.INI");
 }      
 
WORD CWinSerialPICAgreeSetup::ReadCommAddr()
{   
	char szBuf[100];                                
	WORD wTmp;
	GetPrivateProfileString("COMM" , "Addr" , ::PortAddr[nPortType], szBuf,
							sizeof(szBuf),"EPSLD52F.INI" );
	sscanf(szBuf , "%x" , &wTmp);
	
    return wTmp;
 }      
 
 
void CWinSerialPICAgreeSetup::WriteCommType(BYTE bInput) 
{ 
	 char pCharTmp[10];
	 sprintf(pCharTmp,"%X",bInput);
	 WritePrivateProfileString("COMM","Type",pCharTmp,"EPSLD52F.INI");
 }                                                    
 
void CWinSerialPICAgreeSetup::WriteCommBaud(BYTE bInput) 
{ 
	 char pCharTmp[10];
	 sprintf(pCharTmp,"%X",bInput);
	 WritePrivateProfileString("COMM","BaudRate",pCharTmp,"EPSLD52F.INI");
 }                                                    
        
void CWinSerialPICAgreeSetup::WriteClock(BYTE bInput) 
{ 
	 char pCharTmp[10];
	 sprintf(pCharTmp,"%X",bInput);
	 WritePrivateProfileString("CLOCK","Type",pCharTmp,"EPSLD52F.INI");
 }                                                    

void CWinSerialPICAgreeSetup::WriteCpu(BYTE bInput) 
{ 
	 char pCharTmp[10];
	 sprintf(pCharTmp,"%X",bInput);
	 WritePrivateProfileString("CPU","Type",pCharTmp,"EPSLD52F.INI");
 }                     
                                
void CWinSerialPICAgreeSetup::WriteCommAddr(WORD wAddr)
{ 
	char pCharTmp[10];
	 sprintf(pCharTmp,"%X",wAddr);
	 WritePrivateProfileString("COMM","Addr",pCharTmp,"EPSLD52F.INI");
 }
     