
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/VARCAST.CPP   1.2.1.4   17 Apr 1997 16:08:56   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/VARCAST.CPP  $
** 
**    Rev 1.2.1.4   17 Apr 1997 16:08:56   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:44:26   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:48:58   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:28:02   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:31:22   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:40:32   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:53:26   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:17:54   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 13:01:10   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:22:50   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:34:16   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 10:01:20   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:44:36   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:49:54   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:52:04   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:33:42   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:02:18   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:17:06   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:31:28   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:54:50   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:33:54   Shirley
** No change.
** 
**    Rev 1.29   02 Apr 1996 09:29:46   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:48:18   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:05:44   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:32:16   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:46:32   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:20:04   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:16:54   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:16:48   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:34:44   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:25:32   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:07:38   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:16:30   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:08:38   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:09:10   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:31:58   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:18:48   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:27:36   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:31:06   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:34:20   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:44:16   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:05:10   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:51:04   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:48   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:32:04   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:52:04   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:21:44   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:49:58   Shirley
** EasyPack/SLD Version 0.1c
** 
**    Rev 1.2   20 Sep 1995 10:54:56   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:45:50   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:55:48   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: VARCAST.CPP
//
//  Description: The implementation file fore class: CVarTypeCastDialog.
//
//  Author: Chen Jun
//
//  Date: 07/26/95
//
//  Modification:
//      1. 07/26/95, Initial version of the class: CVarTypeCastDialog.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "varcast.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Global variables.
CStringList* pVarTypeCastList;
CStringList* pStkTypeCastList;


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
void VarGetHighlightName(CString& strName);
void StkGetHighlightName(CString& strName);
void VarTypeCast(void);
void StkTypeCast(void);


/////////////////////////////////////////////////////////////////////////////
// External variables.
extern BOOL isVarWindowActive;
extern BOOL isStkLocalActive;


/////////////////////////////////////////////////////////////////////////////
// CVarTypeCastDialog dialog


CVarTypeCastDialog::CVarTypeCastDialog(CWnd* pParent /*=NULL*/)
    : CDialog(CVarTypeCastDialog::IDD, pParent)
{
    //{{AFX_DATA_INIT(CVarTypeCastDialog)
    m_strTypeCast = "";
    m_strVariableName = "";
    //}}AFX_DATA_INIT

    // Initial.
    m_isDropdown = FALSE;
    
    // Point to the relative list.
    if ( ::isVarWindowActive ) {
        m_pList = ::pVarTypeCastList;
    }
    else if ( ::isStkLocalActive ) {
        m_pList = ::pStkTypeCastList;
    }
}

void CVarTypeCastDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CVarTypeCastDialog)
    DDX_Control(pDX, IDC_STATIC_TYPECASE_VARIABLENAME, m_staticVariableName);
    DDX_Control(pDX, IDC_COMBO_TYPECAST_TYPECAST, m_comboTypeCast);
    DDX_CBString(pDX, IDC_COMBO_TYPECAST_TYPECAST, m_strTypeCast);
    DDV_MaxChars(pDX, m_strTypeCast, 80);
    DDX_Text(pDX, IDC_STATIC_TYPECASE_VARIABLENAME, m_strVariableName);
    DDV_MaxChars(pDX, m_strVariableName, 80);
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CVarTypeCastDialog, CDialog)
    //{{AFX_MSG_MAP(CVarTypeCastDialog)
    ON_CBN_DROPDOWN(IDC_COMBO_TYPECAST_TYPECAST, OnDropdownComboTypecast)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CVarTypeCastDialog message handlers

void CVarTypeCastDialog::OnCancel()
{
    // TODO: Add extra cleanup here
    
    CDialog::OnCancel();
}

void CVarTypeCastDialog::OnOK()
{
    // TODO: Add extra validation here
    
    // Detect if it has been dropdown.
    if ( m_isDropdown ) {
        // Add to the global list.
        m_pList->RemoveAll();
        CString str;
        for ( int i = 0; i < m_comboTypeCast.GetCount(); i++ ) {
            m_comboTypeCast.GetLBText(i, str);
            if ( !str.IsEmpty() ) {
                m_pList->AddTail(str);
            }
        }
    }

    // Get from the combo edit box.
    m_comboTypeCast.GetWindowText(m_strTypeCast);
    if ( !m_strTypeCast.IsEmpty() ) {
        m_pList->AddTail(m_strTypeCast);
        // Call the kernel routine.
        if ( ::isVarWindowActive ) {
            ::VarTypeCast();
        }
        else if ( ::isStkLocalActive ) {
            ::StkTypeCast();
        }
    }

    CDialog::OnOK();
}

void CVarTypeCastDialog::OnDropdownComboTypecast()
{
    // TODO: Add your control notification handler code here

    // Get the last entered string from the combo box.
    m_comboTypeCast.GetWindowText(m_strTypeCast);
    
    // Detect if it has been dropdown.
    if ( !m_isDropdown ) {
        // Set the dropdown flag.
        m_isDropdown = TRUE;
        // Get the variable name from the global list.
        if ( !m_pList->IsEmpty() ) {
            m_comboTypeCast.ResetContent();
            POSITION posHead = m_pList->GetHeadPosition();
            while ( posHead ) {
                CString str=(CString)(m_pList->GetNext(posHead));
                m_comboTypeCast.AddString(str);
            }
        }
    }
        
    // Add the last entered string to the combo box.
    m_comboTypeCast.SetWindowText(m_strTypeCast);
}

BOOL CVarTypeCastDialog::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // TODO: Add extra initialization here
    
    // Central the dialog position.
    CenterWindow();
        
    // Get the current highlight variable name.
    if ( ::isVarWindowActive ) {
        ::VarGetHighlightName(m_strVariableName);
    }
    else if ( ::isStkLocalActive ) {
        ::StkGetHighlightName(m_strVariableName);
    }
    m_staticVariableName.SetWindowText(m_strVariableName);
    
    // Get the Type Cast string.
    if ( !m_pList->IsEmpty() ) {
        m_strTypeCast = (CString)(m_pList->GetTail());
    }

    // Show the Type Cast string.
    m_comboTypeCast.SetWindowText(m_strTypeCast);

    // Set the initial value.
    UpdateData(FALSE);

    return TRUE;  // return TRUE  unless you set the focus to a control
}
