/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/ALIASPUB.CPP   1.6.1.0.1.2   09 Dec 1996 10:14:18   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/ALIASPUB.CPP  $
** 
**    Rev 1.6.1.0.1.2   09 Dec 1996 10:14:18   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.6.1.0.1.0   11 Nov 1996 12:57:34   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.6.1.4   09 Sep 1996 13:13:46   ZJRD
** No change.
** 
**    Rev 1.6.1.3   05 Sep 1996 11:25:18   ZJRD
** No change.
** 
**    Rev 1.6.1.2   02 Sep 1996 09:52:26   ZJRD
** No change.
** 
**    Rev 1.6.1.1   28 Aug 1996 15:44:54   ZJRD
** No change.
** 
**    Rev 1.6.1.0   12 Aug 1996 10:50:06   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.6   11 Jun 1996 10:24:32   ZJRD
** EasyPack/SLD Version 1.97
** 
**    Rev 1.4   05 Jun 1996 14:52:16   ZJRD
** No change.
** 
**    Rev 1.3   29 May 1996 09:28:22   ZJRD
** No change.
** 
**    Rev 1.2   16 May 1996 09:08:44   ZJRD
** No change.
** 
**    Rev 1.1   10 May 1996 09:08:16   ZJRD
** No change.
** 
**    Rev 1.0   02 May 1996 10:25:48   ZJRD
** Initial revision.
** 
****************************************************************************/

#include "stdafx.h"
#include "aliaspub.h"    

static CCommandSet *ComSet = NULL;

void MakeHints(void);
void FreeHints(void);

/////////////////////////////////////////////////////////////////////////////
//
//  Name:  MakeTable()  
//
//  Description: create table
//
//  Input:  
//
//  Output: 
//
//  Return: 
//			
//
/////////////////////////////////////////////////////////////////////////////

void MakeTable()
{
	if (ComSet != NULL) delete ComSet;
	ComSet = new CCommandSet();
	MakeHints();
}            

/////////////////////////////////////////////////////////////////////////////
//
//  Name:  FreeTable()  
//
//  Description: free table
//
//  Input:  
//
//  Output: 
//
//  Return: 
//			
//
/////////////////////////////////////////////////////////////////////////////

void FreeTable()
{
	if (ComSet != NULL) delete ComSet;
	FreeHints();	
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:  AliasCmd()  
//
//  Description: list all alias or add a new alias
//
//  Input:  
//
//  Output: 
//
//  Return:
//  
//
/////////////////////////////////////////////////////////////////////////////

void
AliasCmd(int m_nArgc, char* m_pszArgv[])
{
	ASSERT(ComSet != NULL);
	ComSet->AliasCmd(m_nArgc, m_pszArgv);
}
 
/*                              

void
HelpCmd(int m_nArgc, char* m_pszArgv[])
{
	ASSERT(ComSet != NULL);
	ComSet->HelpCmd(m_nArgc, m_pszArgv);
}
*/

/////////////////////////////////////////////////////////////////////////////
//
//  Name:  GetCommandId()  
//
//  Description: find index of the command in command array
//
//  Input:  pszCommand
//
//  Output: 
//
//  Return: index of the command
//			return CCommandSet::NO_COMMAND if the command is not found  
//
/////////////////////////////////////////////////////////////////////////////

int
GetCommandId(const char* pszCommand)
{
	ASSERT(ComSet != NULL);
	return ComSet->GetCommandId(pszCommand);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:  GetTotalCommandId()  
//
//  Description: find index of the command in command array and hiden command array
//
//  Input:  pszCommand
//
//  Output: 
//
//  Return: index of the command
//			return CCommandSet::NO_COMMAND if the command is not found  
//
/////////////////////////////////////////////////////////////////////////////

int
GetTotalCommandId(const char* pszCommand)
{
	ASSERT(ComSet != NULL);
	return ComSet->GetTotalCommandId(pszCommand);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:  SearchCommand()  
//
//  Description: search all match alias and command
//				 store nArgc command at least
//
//  Input:  pszCommand, nArgc, pszArgv[]
//
//  Output: store match number in nArgc
//			store match command name in pszArgv
//
//  Return: TRUE at least one item was found
//  		FALSE no item was found
//
/////////////////////////////////////////////////////////////////////////////

BOOL
SearchCommand(const char* pszCommand, int& nArgc, char* pszArgv[])
{                          
	ASSERT(ComSet != NULL);                                            
	return ComSet->SearchCommand(pszCommand, nArgc, pszArgv);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:  ExpandCommand()  
//
//  Description: expand pszCommand 
//
//  Input:  pszCommand, pszExpand, pszHints
//
//  Output: store complete command name or alias name in pszExpand
//			store command hints in pszHints
//
//  Return: return CCommandSet::ALIAS if pszCommand is alias name
//			return CCommandSet::COMMAND if pszCommand is command name
//  		return CCommandSet::NO_COMMAND if pszCommand is not alias name or command name
//
/////////////////////////////////////////////////////////////////////////////

int  
ExpandCommand(const char* pszCommand, char* pszExpand, char* pszHints)
{                          
	ASSERT(ComSet != NULL);
	return ComSet->ExpandCommand(pszCommand, pszExpand, pszHints);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:  ExpandParameter()  
//
//  Description: expand pszParameter of pszCommand 
//
//  Input: pszCommand, pszParameter, pszExpand 
//
//  Output: store complete parameter in pszExpand
//
//  Return: TRUE if find the parameter
//			FALSE if not find the parameter
//  
//
/////////////////////////////////////////////////////////////////////////////

BOOL 
ExpandParameter(const char* pszCommand, const char* pszParameter, char* pszExpand)
{                          
	ASSERT(ComSet != NULL);
	return ComSet->ExpandParameter(pszCommand, pszParameter, pszExpand);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:  GetEventHints()  
//
//  Description: get pszCommand hints
// 				 special for Event 1|2|3
//
//  Input:  pszCommand, pszHints
//
//  Output: store command hints in pszHints
//
//  Return: return TRUE if sucessful
//  		return FALSE if fail
//
/////////////////////////////////////////////////////////////////////////////

BOOL GetEventHints(const char* pszCommand, char* pszHints)
{
	ASSERT(ComSet != NULL);
	return ComSet->GetEventHints(pszCommand, pszHints);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:  ExpandEventPara()  
//
//  Description: expand pszParameter of pszCommand 
//
//  Input: pszCommand, pszParameter, pszExpand 
//
//  Output: store complete parameter in pszExpand
//
//  Return: TRUE if find the parameter
//			FALSE if not find the parameter
//  
//
/////////////////////////////////////////////////////////////////////////////


BOOL ExpandEventPara(const char* pszCommand, 
	const char* pszParameter, char* pszExpand) 
{                                                      
	ASSERT(ComSet != NULL);
	return ComSet->ExpandEventPara(pszCommand, pszParameter, pszExpand); 
}

/*-------------------------end of file------------------------------*/