/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/ALIB.CPP   1.3.1.0.1.2   09 Dec 1996 10:14:06   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/ALIB.CPP  $
** 
**    Rev 1.3.1.0.1.2   09 Dec 1996 10:14:06   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.3.1.0.1.0   11 Nov 1996 12:57:22   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.3.1.4   09 Sep 1996 13:13:18   ZJRD
** No change.
** 
**    Rev 1.3.1.3   05 Sep 1996 11:24:50   ZJRD
** No change.
** 
**    Rev 1.3.1.2   02 Sep 1996 09:51:56   ZJRD
** No change.
** 
**    Rev 1.3.1.1   28 Aug 1996 15:43:36   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.3.1.0   12 Aug 1996 10:49:04   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.0   29 May 1996 09:35:28   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// al.cpp
//
// Roger Zhang
//                                                                           
// 5/2/96
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "stdlib.h"
#include "toolopt.h"
#include "alib.h"

/////////////////////////////////////////////////////////////////////////////
// diagnostic
#ifdef _DEBUG
void ALIBTool::Dump(CDumpContext &dc) const
{         
    CToolOption::Dump(dc);                    
    dc << "m_nMemoryModel = " << m_nMemoryModel << "\n";
    dc << "m_float = " << m_float << "\n";
    dc << "m_strMore = " << m_strMore << "\n";
    dc << "m_strPath = " << m_strPath << "\n";
}
#endif

/////////////////////////////////////////////////////////////////////////////
// operations
void ALIBTool::SetDefault(void)
{                                                    
    m_nMemoryModel=1;
    m_float   = TRUE;
    m_strMore = "";
    m_strPath = "c:\\cc51\\lib";
}

BOOL ALIBTool::LoadOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 2;
    
    char ach[nCnt];
    
    if(fread(ach, 1, nCnt, fp) != nCnt)
        return FALSE;
        
    m_nMemoryModel = ach[0];
    m_float = ach[1];
   
    
    WORD wLen;
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen); 
     
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen); 
    
    return TRUE;
}                 

BOOL ALIBTool::SaveOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 2;

    char ach[nCnt];
    
    ach[0] = m_nMemoryModel;
    ach[1] = m_float;
        
    if(fwrite(ach, 1, nCnt, fp) != nCnt)
        return FALSE;
             
    WORD wLen = m_strMore.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
    
    wLen = m_strPath.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
    return TRUE;
}
 
static char * ar1[4] = { "c51s.lib ", "c51l.lib " }; 

CString ALIBTool::GetOption(void)
{
    CString str = ""; 
    CString alibstr;
    alibstr = m_strPath;
    if(alibstr[alibstr.GetLength()-1]!='\\')
    alibstr = alibstr + "\\"; 
    str += alibstr;  
    str += ar1[m_nMemoryModel];
   
    if(m_float)
    {
    str +=",";
    str += alibstr;
    str += "float.lib ";
    } 
    
    if(m_strMore=="")
     return str; 

   /* if(m_strMore != "")
     {
      str += ",";
      str += m_strMore;
     } */
    char separation[2];
    LPSTR temp;
        
    separation[0]=',';
    separation[1]='\0';       
    
    
    temp =_fstrtok((LPSTR)(LPCSTR)m_strMore, separation);
    if(temp==NULL)
     return str;
    CString strtemp="";
    CString tempstr=",";
    do
    { 
      strtemp  += tempstr;
      strtemp  += alibstr; 
      strtemp  += temp;
      temp =_fstrtok(NULL, separation);
    }while(temp!=NULL);    
    
    str += strtemp;
    return str;
}      
   


