
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/BASETBL.H__   1.7.1.0.1.2   09 Dec 1996 10:13:50   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/BASETBL.H__  $
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:13:50   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:57:06   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:12:02   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:23:50   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:50:52   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:42:34   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:48:26   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:50:46   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:27:18   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 08:59:00   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:07:32   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:22:02   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:52:14   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:33:10   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:46:10   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:01:14   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:26:38   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:42:02   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:10:36   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:11:24   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:11:44   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:31:10   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:21:30   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:06:48   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:09:42   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:06:58   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:07:32   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:28:34   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:17:30   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:21:06   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:27:42   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:27:16   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:39:00   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:01:54   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:44:34   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:42:42   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:25:22   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:46:26   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:18:20   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:47:44   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:52:28   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:43:34   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:53:18   Shirley
** Initial revision.
**
****************************************************************************/

/****************************************************************************
**
**  Name:  basetbl.h
**
**  Description:
**     Prototypes for the functions to manipulate BASE symbols.
**
**  Status:  PRELIMINARY
**
**  $Log$
** 
**  $Header:   D:/EPSLDV1/SRC/LOG/BASETBL.H__   1.7.1.0.1.2   09 Dec 1996 10:13:50   ZJRD  $
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/

#ifndef _BASETBL_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include "basewind.h"
#include "indextbl.h"
#include "symadd.h"
#include "symutil.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define MAX_BASE_INDEX_SIZE 4095L

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

//-----------------------------------------------------------------------
//  baseSymbol
//
//  Description:
//     Methods for adding BASE information to the symbol pool.
//-----------------------------------------------------------------------

class BaseSymbol {

protected:
   TABLE_OFFSET baseNameOffset;     // st offset to name
   TABLE_OFFSET nextBaseOffset;     // linked list pointer to next base object
   U32          addressMin;         // smallest addr of syms in by-addr table
   U32          addressMax;         // largest addr of syms in by-addr table
   U32          byAddressTableOffset;  // st offset to by-address object
   BASE_ADDRESS baseAddress;        // logical address offset from base value
   U16          GDTsel;             // GDT selector in prot.
   U16          segOrLDTsel;        // segment in real; LDT selector in prot.
   BASE_INDEX   baseIndex;          // store index from bit pointing to this
   U8           baseType;           // CODE, DATA, CODE-DATA, UNKNOWN
   BOOLEAN      addrTableDirty;     // TRUE ==> by-address table not sorted
   U8           segAddrSpace;       // SEG_SPACE_USER, SEG_SPACE_SMM
   U8           symMode;            // SYM_NONE, SYM_REAL, SYM_PROTECTED         
   
//NOTE: baseType is not spec'ed as BASE_TYPE because enums are size int and we
//      want the baseType size to be as small as possible.
//      Same is true for segAddrSpace and symMode

public:
//-----------------------------------------------------------------------
// Parameterized Constructor; returns error code via <err> reference var
//-----------------------------------------------------------------------
BaseSymbol(LPSTR baseName,
           BASE_INDEX baseIndex,
           BASE_ADDRESS baseAddr,
           BASE_TYPE baseTypeParam,
           RETCODE& err);


//-----------------------------------------------------------------------
// operator new
//
// Purpose: allocates memory in st for a new BaseSymbol
//
// Input parameter:
//    size: amount of space to allocate
//
// Output parameter:
//    err: RETCODE from memory allocation
//
// Return parameter:
//    TABLE_OFFSET: offset into st where memory was allocated
//--------------------------------------------------------------------------
VOID *operator new(size_t size);


//--------------------------------------------------------------------------
// CompareAddrVars
//
// Returns TRUE-FALSE whether address in range or not
//--------------------------------------------------------------------------
BOOLEAN CompareAddrVars(OFFSET_ADDR_TYPE offsetAddr)  {
   if ((offsetAddr < addressMin) ||
       (offsetAddr > addressMax)) return FALSE;
   else return TRUE;
}


//--------------------------------------------------------------------------
// GetBaseNameOffset
//
// Returns baseNameOffset
//--------------------------------------------------------------------------
U32 GetBaseNameOffset(VOID)  { return baseNameOffset; }


//--------------------------------------------------------------------------
// GetNextBaseOffset
//
// Returns nextBaseOffset
//--------------------------------------------------------------------------
TABLE_OFFSET GetNextBaseOffset(VOID)  { return nextBaseOffset; }


//--------------------------------------------------------------------------
// GetAddressMin
//
// Returns addressMin
//--------------------------------------------------------------------------
U32 GetAddressMin(VOID)  { return addressMin; }


//--------------------------------------------------------------------------
// GetAddressMax
//
// Returns addressMax
//--------------------------------------------------------------------------
U32 GetAddressMax(VOID)  { return addressMax; }


//--------------------------------------------------------------------------
// GetByAddressTableOffset
//
// Returns the byAddressTableOffset class variable
//--------------------------------------------------------------------------
U32 GetByAddressTableOffset(VOID) { return byAddressTableOffset; }


//--------------------------------------------------------------------------
// GetBaseAddress
//
// Returns baseAddress
//--------------------------------------------------------------------------
BASE_ADDRESS GetBaseAddress(VOID)  { return baseAddress; }


//--------------------------------------------------------------------------
// GetSegOrLDTsel
//
// Returns segOrLDTsel
//--------------------------------------------------------------------------
U16 GetSegOrLDTsel(VOID)  { return segOrLDTsel; }


//--------------------------------------------------------------------------
// GetGDTsel
//
// Returns GDTsel
//--------------------------------------------------------------------------
U16 GetGDTsel(VOID)  { return GDTsel; }


//--------------------------------------------------------------------------
// GetBaseType
//
// Returns baseType
//--------------------------------------------------------------------------
BASE_TYPE GetBaseType(VOID)  { return (BASE_TYPE)baseType; }


//--------------------------------------------------------------------------
// GetBaseIndex
//
// Returns baseIndex
//--------------------------------------------------------------------------
BASE_INDEX GetBaseIndex(VOID)  { return baseIndex; }


//--------------------------------------------------------------------------
// GetAddrTableDirty
//
// Returns addrTableDirty
//--------------------------------------------------------------------------
BOOLEAN GetAddrTableDirty(VOID)  { return addrTableDirty; }


//--------------------------------------------------------------------------
// GetSegAddrSpace
//
// Returns segAddrSpace
//--------------------------------------------------------------------------
SEG_ADDR_SPACE GetSegAddrSpace(VOID)  { return (SEG_ADDR_SPACE)segAddrSpace; }


//--------------------------------------------------------------------------
// GetSymMode
//
// Returns symMode
//--------------------------------------------------------------------------
SYM_MODE GetSymMode(VOID)  { return (SYM_MODE)symMode; }


//--------------------------------------------------------------------------
// SetBaseAddr
//
// Sets the base address of the base object
//--------------------------------------------------------------------------
VOID SetBaseAddr(BASE_ADDRESS baseAddr) { baseAddress = baseAddr; }


//--------------------------------------------------------------------------
// SetAddrTableDirty
//
// Sets the address dirty flag
//--------------------------------------------------------------------------
VOID SetAddrTableDirty(BOOLEAN b) { addrTableDirty = b; }


//--------------------------------------------------------------------------
// SetGDTsel
//
// Sets the GDTsel value
//--------------------------------------------------------------------------
VOID SetGDTsel(U16 passedGDTsel)
   { GDTsel = passedGDTsel; }


//--------------------------------------------------------------------------
// SetSegOrLDTsel
//
// Sets the SegOrLDTsel value
//--------------------------------------------------------------------------
VOID SetSegOrLDTsel(U16 passedSegOrLDTsel)
   { segOrLDTsel = passedSegOrLDTsel; }


//--------------------------------------------------------------------------
// SetSegAddrSpace
//
// Sets segAddrSpace
//--------------------------------------------------------------------------
VOID SetSegAddrSpace(SEG_ADDR_SPACE s)  { segAddrSpace = (U8)s; }


//--------------------------------------------------------------------------
// SetSymMode
//
// Sets symMode
//--------------------------------------------------------------------------
VOID SetSymMode(SYM_MODE s)  { symMode = (U8)s; }


//--------------------------------------------------------------------------
// UpdateAddrVars
//
// update the min and max address vars (uses macros)
//--------------------------------------------------------------------------
VOID UpdateAddrVars(U32 minAddr, U32 maxAddr) {

   addressMin = min(addressMin, minAddr);
   addressMax = max(addressMax, maxAddr);
   }
};  // end of BaseSymbol class functions


//--------------------------------------------------------------------------
// BaseIndexTable CLASS
//--------------------------------------------------------------------------
class BaseIndexTable : public IndexTable {

private:
   TABLE_OFFSET rootBaseSymbolOffset;
   U32          baseCount;  // number of bases loaded so far

public:
   // initialize the starting BaseSymbol "pointer" to null since there are no
   // BaseSymbol objects created until the loader creates one or more

//--------------------------------------------------------------------------
// BaseIndexTable - constructor
//--------------------------------------------------------------------------
BaseIndexTable() {
   rootBaseSymbolOffset = NULL_SYMBOL;
   baseCount = 0L;  // initialize number of bases loaded
   maxIndex = MAX_BASE_INDEX_SIZE;  // reduce default value to restrict
                                    // index size to 12 bits for bases
}

//--------------------------------------------------------------------------
// GetRootBaseSymbolOffset
//--------------------------------------------------------------------------
TABLE_OFFSET GetRootBaseSymbolOffset() { return rootBaseSymbolOffset; }


//--------------------------------------------------------------------------
// BaseAddIndex
//
// Description:
//    Calls TableIndex AddIndex, then if successful,
//    sets the root offset to the first base symbol created
//    It only sets the root offset if it is NULL, otherwise just returns
//--------------------------------------------------------------------------
RETCODE BaseAddIndex(TABLE_INDEX index, TABLE_OFFSET itemOffset);


//---------------------------------------------------------------------------
// ObliterateTable
//
// Purpose:
//    Unlocks, then frees the table to Windows memory.
//---------------------------------------------------------------------------
VOID ObliterateTable(VOID);

//--------------------------------------------------------------------------
// BaseGetBaseCount
//
// Description:
//    returns count of number of bases added.
//--------------------------------------------------------------------------
U32 BaseGetBaseCount(VOID) {return baseCount;}

};  // end of BaseIndexTable class definition and functions
      
                       /*********************************
                        *                               *
                        * NON-CLASS FUNCTION PROTOTYPES *
                        *                               *
                        *********************************/

//--------------------------------------------------------------------------
// Description:
//    Add a symbol offset to the by-address sorted table and update base min
//    and max address values
//--------------------------------------------------------------------------
RETCODE
AddAddrToByAddrTable(BASE_INDEX baseIndex, TABLE_OFFSET symOffset,
                     U32 minAddr, U32 maxAddr);

//--------------------------------------------------------------------------
// Description:
//    Returns the base address of <baseIndex>
//--------------------------------------------------------------------------
RETCODE BaseGetAddr(BASE_INDEX baseIndex, BASE_ADDRESS *baseAddr);


//--------------------------------------------------------------------------
// Description:
//    Modifies the base address of <baseIndex>
//--------------------------------------------------------------------------
RETCODE BaseSetAddr(BASE_INDEX baseIndex, BASE_ADDRESS baseAddr);

//--------------------------------------------------------------------------
// GetBaseOffsetByName
//
// Description:  Given a basename, find the offset in the symbol table of
//               the base.
//
// Inputs:
//       baseName: the name of the base to find.
// Outputs:
//       baseOffset: the offset of the base found.
// Errors:
//       ER_SYMBOL_NOT_FOUND
//--------------------------------------------------------------------------
RETCODE GetBaseOffsetByName(LPSTR baseName, TABLE_OFFSET &baseOffset);

//--------------------------------------------------------------------------
// RemoveAllByAdrTables
//
// Description: Frees the memory that was allocated by the by-address-tables.
//              This allows symbols to be cleanly deleted and all memory 
//              used by bases/base indexes/by address tables to be freed.
//
// Input Parameters:
//    none:
// Output Parameters:
//    none:
// Errors:
//    ER_OUT_OF_MEMORY:
// NOTE: no BaseSymbol is created on initialization.  This means that any
//    loader must first create a base (and its index) before using it.
//--------------------------------------------------------------------------
VOID RemoveAllByAdrTables(VOID);

//--------------------------------------------------------------------------
//  ResetCacheVars
//
//  Description:
//    Re-initialize all cached vars after removal of symbols
//--------------------------------------------------------------------------
VOID BasetblResetCacheVars(VOID);

#define _BASETBL_
#endif
/******************************** E O F ***********************************/
