/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/BLIB.CPP   1.3.1.0.1.2   09 Dec 1996 10:14:08   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/BLIB.CPP  $
** 
**    Rev 1.3.1.0.1.2   09 Dec 1996 10:14:08   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.3.1.0.1.0   11 Nov 1996 12:57:24   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.3.1.4   09 Sep 1996 13:13:20   ZJRD
** No change.
** 
**    Rev 1.3.1.3   05 Sep 1996 11:24:52   ZJRD
** No change.
** 
**    Rev 1.3.1.2   02 Sep 1996 09:51:58   ZJRD
** No change.
** 
**    Rev 1.3.1.1   28 Aug 1996 15:43:40   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.3.1.0   12 Aug 1996 10:49:06   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.0   29 May 1996 09:35:30   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// blib.cpp
//
// Roger Zhang
//                                                                           
// 5/2/96
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "afx.h"
#include "toolopt.h"
#include "blib.h"

/////////////////////////////////////////////////////////////////////////////
// diagnostic
#ifdef _DEBUG
void BLIBTool::Dump(CDumpContext &dc) const
{         
    CToolOption::Dump(dc);                    
    dc << "m_nMemoryModel = " << m_nMemoryModel << "\n";
    dc << "m_strMore = " << m_strMore << "\n";
    dc << "m_strPath = " << m_strPath << "\n";
}
#endif

/////////////////////////////////////////////////////////////////////////////
// operations
void BLIBTool::SetDefault(void)
{                                                    
    m_nMemoryModel=4;
    m_strMore = "";
    m_strPath = "c:\\icc8051\\lib";
}

BOOL BLIBTool::LoadOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 1;
    
    char ach[nCnt];
    
    if(fread(ach, 1, nCnt, fp) != nCnt)
        return FALSE;
        
    m_nMemoryModel = ach[0];
        
    WORD wLen;
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen); 
     
    if(fread(&wLen, 2, 1, fp) != 1)
        return FALSE;
    if(wLen > (WORD)32000)
        return FALSE;
        
    if(fread(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen); 
    
    return TRUE;
}                 

BOOL BLIBTool::SaveOption(FILE * fp)
{
    ASSERT(fp);
    
    const int nCnt = 1;

    char ach[nCnt];
    
    ach[0] = m_nMemoryModel;
    if(fwrite(ach, 1, nCnt, fp) != nCnt)
        return FALSE;
             
    WORD wLen = m_strMore.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strMore.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strMore.ReleaseBuffer(wLen);  
    
    wLen = m_strPath.GetLength();           
    if(fwrite(&wLen, 2, 1, fp) != 1)
        return FALSE;
        
    if(fwrite(m_strPath.GetBuffer(wLen), 1, wLen, fp) != wLen)
        return FALSE;

    m_strPath.ReleaseBuffer(wLen);  
    
    return TRUE;
}
 
static char * ar1[6] = { "CL8051T.R03  ", "CL8051S.R03 ", "CL8051C.R03 ", "CL8051M.R03 ", "CL8051L.R03","CL8051B.R03 " }; 

CString BLIBTool::GetOption(void)
{
    CString str = ""; 
    
    CString blibstr;
    blibstr = m_strPath;
    
    if(blibstr[blibstr.GetLength()-1]!='\\')
    blibstr = blibstr + "\\"; 
    str += blibstr; 
    str += ar1[m_nMemoryModel];
    
  /*  if(m_strMore != "")
    {
     str += ",";
     str += m_strMore;
     str += " ";
    }*/
     if(m_strMore=="")
     return str; 

   /* if(m_strMore != "")
     {
      str += ",";
      str += m_strMore;
     } */
    char separation[2];
    LPSTR temp;
        
    separation[0]=',';
    separation[1]='\0';       
    
    
    temp =_fstrtok((LPSTR)(LPCSTR)m_strMore, separation);
    if(temp==NULL)
     return str;
    CString strtemp="";
    CString tempstr=",";
    do
    { 
     // strtemp  += tempstr;
      strtemp  += blibstr; 
      strtemp  += temp; 
      strtemp  +="\n";
      temp =_fstrtok(NULL, separation);
    }while(temp!=NULL);    
    
    str += strtemp;
    return str;
}

