
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/CTRCBUF.H__   1.4.1.0.1.2   09 Dec 1996 10:15:12   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/CTRCBUF.H__  $
** 
**    Rev 1.4.1.0.1.2   09 Dec 1996 10:15:12   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.4.1.0.1.0   11 Nov 1996 12:58:28   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.4.1.4   09 Sep 1996 13:15:52   ZJRD
** No change.
** 
**    Rev 1.4.1.3   05 Sep 1996 11:27:24   ZJRD
** No change.
** 
**    Rev 1.4.1.2   02 Sep 1996 09:54:30   ZJRD
** No change.
** 
**    Rev 1.4.1.1   28 Aug 1996 15:48:42   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.4   11 Jun 1996 10:27:42   ZJRD
** EasyPack/SLD Version 1.97
** 
**    Rev 1.2   05 Jun 1996 14:56:18   ZJRD
** EasyPack/SLD Version 1.96
** 
**    Rev 1.1   29 May 1996 09:36:26   ZJRD
** EasyPack/SLD Version 1.95
** 
**    Rev 1.0   16 May 1996 09:09:24   ZJRD
** Initial revision.
** 
****************************************************************************/

/***************************************************************************
**
** File name : CTRCBUF.H
** Author: Chris Fang
** Description:
**
**
**    Finished date: Apr. 29, 1996
**    Copyright (C) 1996 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

#include "basictyp.h"

struct FrameC;
class TraceSrcPage;

//interface routines to outside

BOOL ListTrcMixedToWnd(int readDirect,			//2,1,0,-1,-2
					   WORD* beginNo,           //abi frame
					   WORD* endNo,             //not care
        	           WORD* LineCnt,           //viewport lines
            	       FrameC* frameC);         //output buffer(contain c and instruction)

BOOL ListTrcCToWnd(int readDirect,			//2,1,0,-1,-2
				   WORD* beginNo,           //abi frame
				   WORD* endNo,             //not care
                   WORD* LineCnt,           //viewport lines
                   FrameC* frameC);         //output buffer

void ResetTraceBuf(void);

struct HitStatus
	{
		BOOL ishit;
		int	 needline;		//up:
		WORD edgeframe;
		TraceSrcPage* phitpage;
	};
	
struct MRUSrcLine
	{
		U32 moduleDesc;
		U16 linenum;
  		U32 startAddr;
  		U32 endAddr;
		
		public:
		MRUSrcLine(){};
		MRUSrcLine(U32 md, U16 ln, U32 sa, U32 ea)
		{
			moduleDesc=md;
			linenum=ln;
			startAddr=sa;
			endAddr=ea;
		};
		const MRUSrcLine& operator=(const MRUSrcLine src)
		{
			moduleDesc=src.moduleDesc;
			linenum=src.linenum;
			startAddr=src.startAddr;
			endAddr=src.endAddr;
			return *this;
		};
		operator BOOL()
		{
			return (linenum!=0);
		}
		BOOL operator==(MRUSrcLine ob) const
		{
			return ((moduleDesc==ob.moduleDesc)&&(linenum==ob.linenum));
		}
		const MRUSrcLine next(void);
	};
	
class TraceSrcPage : public CDWordArray
{
private:
	
public:
	WORD m_wFirstFrame;
	WORD m_wLastFrame;
	int m_nFrameNum;
	TraceSrcPage* m_pNext;
	TraceSrcPage* m_pPrev;	

public:
	TraceSrcPage(TraceSrcPage* pp=NULL, TraceSrcPage* pn=NULL);
	~TraceSrcPage();
	
	BOOL isinpage(WORD frame, int& index);
	WORD getaddrfromframe(WORD frame);
	void reset(TraceSrcPage* pp=NULL, TraceSrcPage* pn=NULL);
};

class TraceSrcBuf
{
private:
	TraceSrcPage* 	m_pFirstPage;
	TraceSrcPage* 	m_pLastPage;
	HitStatus	m_Hitstatus;
	MRUSrcLine	m_MRUSrcLine[5];
	WORD		m_AddressRange[10];
	MRUSrcLine	m_MRUbak;
	int			m_nARNum;
	WORD		m_wAbiFrameNum;
	BOOL		m_bIncLib;
	BOOL		m_bOldFW;
	
private:
	TraceSrcPage* isinbuf(int readflag, WORD& fromframe,
					int linenum, int& hitindex);
	void addrrange(void);
	void setdata(TraceSrcPage* pPage, int index, FrameC* buf, int linenum);
	void compressmrusrcline(void);					//del repeat and nul data
	TraceSrcPage* addpage(WORD frame);
	int editpage(BOOL isup, WORD fromframe,
					int number, TraceSrcPage* pPage);
	TraceSrcPage* linkpage(TraceSrcPage* pPage, int direct);
	void writetopage(TraceSrcPage* pPage, BYTE& count);
	int checksameline(DWORD first, DWORD second);
	int setfirstsrcframe(WORD& fromframe, WORD toframe, TraceSrcPage* pPage);
    int setsrcframe(WORD& fromframe, WORD toframe, 
    					int number, TraceSrcPage* pPage);
    

public:
	TraceSrcBuf();
	~TraceSrcBuf();
	BOOL getctrace(int readflag, WORD& fromframe, int& linenum, FrameC* buf);
	void reset(void);
};

//export routine
//SpaListSource -- to Chen jun
int SpaListSource(unsigned short uStartAddr, unsigned short uLength,
					CStringList* & pStrlist);
