/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/EDITPROJ.CPP   1.5.1.0.1.2   09 Dec 1996 10:14:28   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/EDITPROJ.CPP  $
** 
**    Rev 1.5.1.0.1.2   09 Dec 1996 10:14:28   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.5.1.0.1.0   11 Nov 1996 12:57:44   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.5.1.4   09 Sep 1996 13:14:12   ZJRD
** No change.
** 
**    Rev 1.5.1.3   05 Sep 1996 11:25:44   ZJRD
** No change.
** 
**    Rev 1.5.1.2   02 Sep 1996 09:52:52   ZJRD
** No change.
** 
**    Rev 1.5.1.1   28 Aug 1996 15:45:38   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.5.1.0   12 Aug 1996 10:50:40   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.2   29 May 1996 09:34:00   ZJRD
** EasyPack/SLD Version 1.95
** 
****************************************************************************/

////////////////////////////////////////////////////////////////////////////
// editproj.cpp
//
// Roger Zhang
//                                                                           
// 5/7/96
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include <direct.h>
#include "editproj.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEditProjectDialog dialog


CEditProjectDialog::CEditProjectDialog(LPCSTR lpcszFile,CStringList * pList, 
    CWnd* pParent /*=NULL*/)
    : CDialog(CEditProjectDialog::IDD, pParent)
{                   
    ASSERT_VALID(pList);
    
    m_pList = pList;
    m_strTitle = lpcszFile;
    //{{AFX_DATA_INIT(CEditProjectDialog)
    m_nFile = -1;
    m_nPath = -1;
    m_nProj = -1;
    m_nType = 0;
    m_nTypeFlag=0;
    //}}AFX_DATA_INIT
    if(::_getcwd(m_strDir.GetBuffer(120), 120) == NULL) {
        AfxMessageBox("Directory too long");
    }
    m_strDir.ReleaseBuffer();
}

void CEditProjectDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CEditProjectDialog)
    DDX_Control(pDX, IDC_PROJEDIT_PROJ, m_lstProj);
    DDX_Control(pDX, IDC_PROJEDIT_PATH, m_lstPath);
    DDX_Control(pDX, IDC_PROJEDIT_FILE, m_lstName);
    DDX_Control(pDX, IDC_PROJEDIT_TYPECOM, m_lstType);
    DDX_LBIndex(pDX, IDC_PROJEDIT_FILE, m_nFile);
    DDX_LBIndex(pDX, IDC_PROJEDIT_PATH, m_nPath);
    DDX_LBIndex(pDX, IDC_PROJEDIT_PROJ, m_nProj);
    DDX_Text(pDX, IDC_PROJEDIT_STC4, m_strDir);
    DDX_CBIndex(pDX, IDC_PROJEDIT_TYPECOM, m_nType);
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CEditProjectDialog, CDialog)
    //{{AFX_MSG_MAP(CEditProjectDialog)
    ON_BN_CLICKED(IDC_PROJEDIT_ADD, OnProjeditAdd)
    ON_BN_CLICKED(IDC_PROJEDIT_DELETE, OnProjeditDelete)
    ON_LBN_DBLCLK(IDC_PROJEDIT_FILE, OnDblclkProjeditFile)
    ON_LBN_DBLCLK(IDC_PROJEDIT_PATH, OnDblclkProjeditPath)
    ON_LBN_DBLCLK(IDC_PROJEDIT_PROJ, OnDblclkProjeditProj)
    ON_CBN_SELCHANGE(IDC_PROJEDIT_TYPECOM, OnSelchangeProjeditTypecom)
	ON_BN_CLICKED(IDC_PROJEDIT_ADDALL, OnProjeditAddall)
//	ON_BN_CLICKED(IDC_PROJEDIT_HELP, OnProjeditHelp)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CEditProjectDialog message handlers

BOOL CEditProjectDialog::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // TODO: Add extra initialization here
    CenterWindow();
    CString str1;
    
    str1 = "Edit - ";
    str1 += m_strTitle ;
    
    SetWindowText (str1);
   
    m_lstName.Dir(0x0000, "*.c");
    m_lstName.Dir(0x0000, "*.asm");
    m_lstPath.Dir(0xC010, "*.*");
    
    POSITION pos;
    CString str;
    
    for(pos = m_pList->GetHeadPosition(); pos != NULL; ) {
        str = m_pList->GetNext(pos);
        m_lstProj.AddString(str);       
    }
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}

void CEditProjectDialog::OnProjeditAdd()
{
    // TODO: Add your control notification handler code here
    OnDblclkProjeditFile();
}

void CEditProjectDialog::OnProjeditDelete()
{
    // TODO: Add your control notification handler code here
    OnDblclkProjeditProj();
}

void CEditProjectDialog::OnDblclkProjeditFile()
{
    // TODO: Add your control notification handler code here
    UpdateData(TRUE);
    
    int nSel = m_lstName.GetCurSel();
    if(nSel == LB_ERR)
        return;

    CString str;
    m_lstName.GetText(nSel, str);   
    
    if(str.GetLength() == 0)
        return;
        
    CString strFile = m_strDir;
    if(strFile[strFile.GetLength()-1] != '\\')
        strFile += '\\';
    strFile += str;
    strFile.MakeLower();
    
    if(m_lstProj.FindStringExact(-1, strFile) != LB_ERR)
        return;
        
    m_lstProj.AddString(strFile);
    UpdateData(FALSE);
}

void CEditProjectDialog::OnDblclkProjeditPath()
{
    // TODO: Add your control notification handler code here
    UpdateData(TRUE);
    
    int nSel = m_lstPath.GetCurSel();
    if(nSel == LB_ERR)
        return;
    
    CString str;
    m_lstPath.GetText(nSel, str);   
    
    if(str.GetLength() == 0)
        return;
        
    CString strDir;
    int nDrive;     
    if(str[1] == '-') { // selected a drive
        nDrive = str[2] - 'a' + 1;
        if(::_chdrive(nDrive) == -1) {
            AfxMessageBox("Change drive error!");
            return;
        }       
    } else {    // select a dir
        if(::_getcwd(strDir.GetBuffer(120), 120) == NULL) {
            AfxMessageBox("Directory too long");
        }
        strDir.ReleaseBuffer();
        if(strDir[strDir.GetLength()-1] != '\\')
            strDir += '\\';
        strDir += str.Mid(1, str.GetLength() - 2);
        if(::_chdir(strDir) == -1) {
            AfxMessageBox("Change directory error!");
            return;
        }                                  
    }                     
    
    if(::_getcwd(m_strDir.GetBuffer(120), 120) == NULL) {
        AfxMessageBox("Directory too long");
    }
    m_strDir.ReleaseBuffer();

    m_lstName.ResetContent();   
    m_lstPath.ResetContent();
    
    switch(m_nType){
    case 0:   
    m_lstName.Dir(0x0000, "*.c");
    m_lstName.Dir(0x0000, "*.asm");
    break;
    case 1:
    m_lstName.Dir(0x0000, "*.obj");
    m_lstName.Dir(0x0000, "*.r03");
    break;
    case 2:
    m_lstName.Dir(0x0000, "*.lib");
    break;
    case 3:
    m_lstName.Dir(0x0000, "*.*");
    break;
    default:
    return;
    }
    m_lstPath.Dir(0xC010, "*.*");
    
    UpdateData(FALSE);
}

void CEditProjectDialog::OnDblclkProjeditProj()
{
    // TODO: Add your control notification handler code here
    UpdateData(TRUE);
                     
    int nSel = m_lstProj.GetCurSel();
    if(nSel == LB_ERR)
        return;
    
    CString str;
    m_lstProj.GetText(nSel, str);   
    
    if(str.GetLength() == 0)
        return;
             
    m_lstProj.DeleteString(nSel);
    
    UpdateData(FALSE);                   
}

void CEditProjectDialog::OnOK()
{
    // TODO: Add extra validation here
    UpdateData(TRUE);

    m_pList->RemoveAll();   
    CString str;
    for(int i = 0; i < m_lstProj.GetCount(); i ++) {
        m_lstProj.GetText(i, str);  
        m_pList->AddTail(str);
    }
    
    CDialog::OnOK();
}

void CEditProjectDialog::OnSelchangeProjeditTypecom()
{
    // TODO: Add your control notification handler code here
   if( m_lstType.GetCurSel()==CB_ERR)
    return; 
   m_nType = m_lstType.GetCurSel();
   if(m_nType==m_nTypeFlag)
    return; 
   m_lstName.ResetContent();      
 
   switch(m_nType){
    case 0:   
    m_lstName.Dir(0x0000, "*.c");
    m_lstName.Dir(0x0000, "*.asm");
    break;
    case 1:
    m_lstName.Dir(0x0000, "*.obj");
    m_lstName.Dir(0x0000, "*.r03");
    break;
    case 2:
    m_lstName.Dir(0x0000, "*.lib");
    break;
    case 3:
    m_lstName.Dir(0x0000, "*.*");
    break;
    default:
    return;
    }  
   m_nTypeFlag = m_nType; 
}

void CEditProjectDialog::OnProjeditAddall()
{
	// TODO: Add your control notification handler code here
        
    int Max  = m_lstName.GetCount(); 
    
    if(Max == LB_ERR)
     return;
    int nSel;
    
    CString str,strFile; 
    
    for(nSel = 0;nSel<Max;nSel++)
     { 
      UpdateData(TRUE);

      m_lstName.GetText(nSel, str);   
    
      if(str.GetLength() == 0)
        return;
      strFile = m_strDir;
      if(strFile[strFile.GetLength()-1] != '\\')
        strFile += '\\';
      strFile += str;
      strFile.MakeLower();
      if(m_lstProj.FindStringExact(-1, strFile) != LB_ERR)
        return;
      m_lstProj.AddString(strFile);
      UpdateData(FALSE);
    }
    
}    

/*void CEditProjectDialog::OnProjeditHelp()
{
	// TODO: Add your control notification handler code here 
	AfxGetApp()->WinHelp(IDD_PROJEDIT);
	
}*/
