#include "stdafx.h"
#include "abibase.h"

//typedef unsigned short PADDR;
unsigned short uTempBp;
BOOL fTempBp = FALSE;

extern BOOL BptSearchBpt(unsigned short addr,BYTE &eFlag);
extern STATUS AbiSetBp(ADDR);
extern STATUS AbiClrBp(ADDR);
 
STATUS EmuSetTempBp(unsigned short uAddr);
STATUS EmuClrTempBp();
ADDR MakeAbiAddr(unsigned short uAddr);

/***************************************************************************
**
**  Name: EmuClrTempBp
**
**  Function: Clear two links.
**            1. index link
**            2. temporary breakpoints link
**
**  Return: the return code from ABI
**
***************************************************************************/

STATUS EmuSetTempBp(unsigned short uAddr)
{
    STATUS status;
    BYTE fEnable;

    if ( !::BptSearchBpt(uAddr, fEnable) ) {
        status = ::AbiSetBp(MakeAbiAddr(uAddr));
        if (status == ICE_OK) {
            fTempBp = TRUE;
            uTempBp = uAddr;
        }
        return status;
    }
    return (ICE_OK);
}

/***************************************************************************
**
**  Name: EmuClrTempBp
**
**  Function: Clear two links.
**            1. index link
**            2. temporary breakpoints link
**
**  Return: the return code from ABI
**
***************************************************************************/
STATUS EmuClrTempBp()
{
    STATUS status = ICE_OK;

    if ( TRUE == fTempBp ) {
        status = AbiClrBp(MakeAbiAddr(uTempBp));
    	fTempBp = FALSE;
    }
    return status;
}            

/***************************************************************************
**
**  Name: MakeAbiAddr
**
**  Function: convert unsigned short address position into struct ADDR
**
**
**
***************************************************************************/
ADDR MakeAbiAddr(unsigned short uAddr)
{
    ADDR structAddr;
    structAddr.addrType = 0x1;
    structAddr.addr = uAddr;
    return (structAddr);
}
