
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/HEAP.H__   1.7.1.0.1.2   09 Dec 1996 10:15:22   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/HEAP.H__  $
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:15:22   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:58:40   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:16:18   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:27:50   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:54:58   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:50:26   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:54:26   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:57:26   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:35:06   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:08:10   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:09:42   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:25:34   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:00:18   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:35:36   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:50:50   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:05:30   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:32:04   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:45:16   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:18:04   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:20:42   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:20:36   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:37:54   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:25:00   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:09:22   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:12:22   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:14:52   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:10:04   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:30:54   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:23:58   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:26:18   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:30:26   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:28:14   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:42:20   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:06:38   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:50:14   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:36   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:31:50   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:47:42   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:23:48   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:50:32   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:55:02   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:44:56   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:55:52   Shirley
** Initial revision.
**
****************************************************************************/

/****************************************************************************
**
**  Name:  heap.h
**
**  Description:
**     prototypes for Malloc() and Free() routines.
**
**  Status:  CODED
**
**  $Log$
** 
**  $Header:   D:/EPSLDV1/SRC/LOG/HEAP.H__   1.7.1.0.1.2   09 Dec 1996 10:15:22   ZJRD  $
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/

#ifndef _HEAP_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "basewind.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
#ifdef __cplusplus
extern "C" {
#endif

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/****************************************************************************
**
**  TFree
**
**  Description:
**     Memory deallocator.  Frees memory associated with a pointer
**     allocated via Malloc() {see below}.
**
**     NOTA BENE:  Freeing an already Free()'ed pointer may corrupt the 
**     heap!!
**
**  Parameters:
**     input:
**        randomPointer: A pointer returned by Malloc().
**     output:
**        SUCCESS or an error (see below)
**
**  Errors:
**     ER_NOT_FOUND       -- could not find pointer info.  Is it ours?
**     ER_HEAP_CORRUPT    -- someone wrote outside of their allocation,
**                           and all over our internal data structures.
**                           This is FATAL for us!!
**
*****************************************************************************/
RETCODE EXPORT TFree( LPSTR randomPointer ) ;



/****************************************************************************
**
**  TMalloc
**
**  Description:
**     Memory ALLOCator.  Given numBytes less than 64K (current limit
**     is 65508), returns a long pointer to the allocated memory. 
**     Zero is returned on failure.  The memory is "locked" in the
**     Window's sense.  This routine should be used for allocating
**     small amounts of memory (incremental overhead is just over 
**     8 bytes per alloc).  It uses very few Window's handles.  There
**     will *never* be a handle associated with the returned pointer
**     {i.e. don't use GlobalHandle() on a pointer returned by this
**     routine}.
**
**     NOTA BENE:  Writing to memory outside the pointer+numBytes range 
**     will corrupt the heap!!
**
**  Parameters:
**     input:
**        numBytes: the number of bytes to allocate (< 64KB)
**     output:
**        return value is zero (0) or a long pointer to alloc'ed memory.
**
*****************************************************************************/
LPSTR EXPORT TMalloc( U32 numBytes ) ;   /* numBytes < 64 KB */


#ifdef __cplusplus
}
#endif

#define _HEAP_
#endif
/******************************** E O F ***********************************/
