
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/MEMMANAG.H__   1.7.1.0.1.2   09 Dec 1996 10:17:02   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/MEMMANAG.H__  $
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:17:02   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 13:00:18   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:20:48   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:32:18   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:59:22   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:46:18   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:51:14   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:53:20   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:32:00   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:03:12   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:14:44   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:29:34   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:01:58   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:40:52   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:54:20   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:07:16   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:32:22   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:46:38   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:20:10   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:17:00   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:16:54   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:37:58   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:25:04   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:09:26   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:12:26   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:14:56   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:10:10   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:30:58   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:24:02   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:22:28   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:34:02   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:34:30   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:44:26   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:05:54   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:48:04   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:46:06   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:30:16   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:51:42   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:20:16   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:49:34   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:55:52   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:00   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:50   Shirley
** Initial revision.
**
****************************************************************************/

/*----------------------------------------------------------------------------
** Name: memmanag.h
**
** Title: Memory Manager header
**
** Purpose:
**  Define the interface for the memory manager routines.
**
** Status: PRELIMINARY
**
** $Log$
** 
** $Header:   D:/EPSLDV1/SRC/LOG/MEMMANAG.H__   1.7.1.0.1.2   09 Dec 1996 10:17:02   ZJRD  $
**
** Copyright (C) 1995 Microtek International.  All rights reserved.
**
**--------------------------------------------------------------------------*/

#ifndef _MEMMANAG_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "basewind.h"
#include "hosterrs.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define INITIAL_TABLE_SIZE (1024L * 8L)
#define MIN_EXPAND_SIZE    (1024L * 8L)

#define NULL_DESCRIPTOR 0L


typedef U32 TABLE_OFFSET;
typedef U8 huge * HPU8;                        // huge pointer to U8
typedef TABLE_OFFSET huge * HP_TABLE_OFFSET;   // huge pointer to TABLE_OFFSET

                       /**********************************
                        *                                *
                        *   MEMBER FUNCTION PROTOTYPES   *
                        *                                *
                        **********************************/
#ifdef __cplusplus
class Table
   {
protected:
   HANDLE tableHandle;        //Windows handle to table memory
   HPU8 hpTableObject;        //huge pointer to top of table memory
   TABLE_OFFSET tableSize;    //how big the table is
   U32 initialSize;           //size of initial GlobalAlloc
   U32 expandSize;            //size of incremental expansion


public:

//---------------------------------------------------------------------------
// Table    // constructor
// Purpose:
//    Table constructor.  Initializes private and protected variables.
//---------------------------------------------------------------------------
Table() {   // constructor
   tableHandle = 0;
   tableSize = 0L;
   initialSize = INITIAL_TABLE_SIZE;
   expandSize = MIN_EXPAND_SIZE;
}; // end of Table constructor


//---------------------------------------------------------------------------
// GetExpandSize
//
// Purpose:
//    Return the value of the variable that holds the amount of bytes to
//    expand the table with a ReAlloc
// 
//---------------------------------------------------------------------------
U32 GetExpandSize() { return expandSize; };


//---------------------------------------------------------------------------
// GetHugeDataPtr
//
// Purpose:
//    Returns a huge pointer to the item in the table referenced from the
//    tableDataOffset offset.  Does the pointer arithmetic.
//---------------------------------------------------------------------------
HPU8 GetHugeDataPtr(TABLE_OFFSET tableDataOffset)  {
   return (hpTableObject + tableDataOffset);
}; // end of GetHugeDataPtr


//---------------------------------------------------------------------------
// GetInitialSize
//
// Purpose:
//    Return the value of the variable that holds the initial size of table
//    allocation
//---------------------------------------------------------------------------
U32 GetInitialSize() { return initialSize; };


//---------------------------------------------------------------------------
// GetTableSize
//
// Purpose:
//    Return the size of the table that has been alloc'ed to date
//---------------------------------------------------------------------------
TABLE_OFFSET GetTableSize() { return tableSize; };

   
//------------------------------------------------------------------------
// InitOrExtendTable
//
// Purpose:
//    Initialize table if tableSize = 0 else
//    extend the table by <expandSize>.
//
// Input parameters:
//    allocFlag:
//       0 if memory does not need to be zeroed upon initialization
//       GMEM_ZEROINIT if memory needs to be zeroed upon initialization
//
// Output parameters: None
//
// Error:
//    Reports ER_SYM_OUT_OF_MEMORY if memory cannot be Alloc'ed or ReAlloc'ed
//------------------------------------------------------------------------
RETCODE InitOrExtendTable(WORD zeroInitFlag);


//---------------------------------------------------------------------------
// ObliterateTable
//
// Purpose:
//    Unlocks, then frees the table to Windows memory.
//---------------------------------------------------------------------------
VOID ObliterateTable(VOID);


//---------------------------------------------------------------------------
// SetExpandSize
//
// Purpose:
//    Sets the amount of size increase of a ReAlloc when the table is full
//---------------------------------------------------------------------------
VOID SetExpandSize(U32 size) { expandSize = size; };


//---------------------------------------------------------------------------
// SetInitialSize
//
// Purpose:
//    Set initial table size
//---------------------------------------------------------------------------
VOID SetInitialSize(U32 size) { initialSize = size; };

};  // end of class Table
#endif

#define _MEMMANAG_
#endif
/******************************** E O F *************************************/
