
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/MEMMAP.CPP   1.7.1.0.1.2   09 Dec 1996 10:17:02   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/MEMMAP.CPP  $
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:17:02   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 13:00:18   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:20:48   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:32:16   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:59:20   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:46:18   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.7.1.0   12 Aug 1996 10:51:14   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:53:18   ZJRD
** EasyPack/SLD Version 1.96
** 
**    Rev 1.4   29 May 1996 09:31:58   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:03:10   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:14:42   ZJRD
** EasyPack/SLD Version 1.93
** 
**    Rev 1.1   02 May 1996 10:29:32   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:01:56   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:40:50   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:54:18   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:07:14   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:32:20   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:46:36   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:20:08   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:16:58   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:16:52   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:37:58   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:25:04   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:09:24   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:12:26   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:14:56   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:10:08   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:30:58   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:24:00   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:22:26   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:34:02   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:34:28   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:44:24   Shirley
** EasyPack/SLD Version 0.22
** 
**    Rev 1.9   02 Nov 1995 10:05:52   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:48:02   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:46:04   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:30:16   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:51:40   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:20:18   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:49:36   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:55:52   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:02   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:50   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMMAP.CPP
//
//  Description: The implementation file for the class: CMemoryMap.
//
//  Author: Daniel Lin
//
//  Date: 04/18/95
//
//  Modification:
//      1. 04/18/95, Initial version of the class: CMemoryMap.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"
#include "address.h"
#include "addrapi.h"

#include "memmap.h"
#include "hosterrs.h"
extern RETCODE EXPORT ErrGetErrorText(U32 errorCode, LPSTR lpszError ...);
extern RETCODE EXPORT ErrGetErrorText(U32 errorCode, CString& strError ...);


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.
// Add by Daniel Lin

extern ADDR_SIZE  dwpMax;        // program  max address
extern ADDR_SIZE  dwpMin;        // program  min address
extern ADDR_SIZE  dwxMax;        // external max address
extern ADDR_SIZE  dwxMin;        // external min address

/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void MapCmd(int nArgc, char* pszArgv[]);
void MemServerSetMap(const unsigned short uStart, const unsigned short uEnd,
    const unsigned char uchType, const char chMapAttr);
BOOL MemServerGetMap(unsigned short& uStart, unsigned short& uEnd,
    unsigned char& uchType, char& chMapAttr);


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
#ifndef _SERVER_NO_ABI
    extern STATUS AbiGetMap(ADDR addr1, ADDR addr2, MAP_INFO* mapInfo);
    extern STATUS AbiSetMap(MAP_INFO mapInfo);
#endif  // _SERVER_NO_ABI

void SrcUpdate(void);
extern BOOL GetCpuStatus(unsigned char&);
extern void ShowLine(char *);



/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   MapCmd().
//
//  Description: The main control routine of Map command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void MapCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 1 == nArgc || 4 == nArgc || 5 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }

    // Execute the MAp command.
    char error[128];
    CMemoryMap* pMemoryMap = new CMemoryMap;
    if ( !pMemoryMap ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
       unsigned char result;         
       if ( ::GetCpuStatus(result) ) {
          if ( 1/*STATUS_GO*/ == result ) {
            //::ShowLine ("EP running. Stop EP first");
            ::ErrGetErrorText(ER_GOFLY_ERR_MSG, error);
            ::ShowLine (error);
          }    
          else {
            pMemoryMap->MapAction(nArgc, pszArgv);
            delete pMemoryMap;
          }           
       }   
    }

}   // End of MapCmd().


// Map server to set map information.
void MemServerSetMap(const unsigned short uStart, const unsigned short uEnd,
    const unsigned char uchType, const char chMapAttr)
{
    // Assertion of the input parameters.

    // Map server to set map information.
    CMemoryMap* pMemoryMap = new CMemoryMap;
    if ( !pMemoryMap ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
        pMemoryMap->MemServerSetMap(uStart, uEnd, uchType, chMapAttr);
        delete pMemoryMap;
    }

}   // End of MemServerSetMap().


// Map server to get map information.
BOOL MemServerGetMap(unsigned short& uStart, unsigned short& uEnd,
    unsigned char& uchType, char& chMapAttr)
{
    // Assertion of the input parameters.

    // Map server to get map information.
    CMemoryMap* pMemoryMap = new CMemoryMap;
    if ( !pMemoryMap ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return (FALSE);
    }
    else {                                
        BOOL bRetValue = 
            pMemoryMap->MemServerGetMap(uStart, uEnd, uchType, chMapAttr);
        delete pMemoryMap;
        return bRetValue;
    }

}   // End of MemServerGetMap().


/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CMemoryMap.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryMap::CMemoryMap().
//
//  Description: The construction of the class: CMemoryMap.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryMap::CMemoryMap()
{

}   // End of CMemoryMap::CMemoryMap().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryMap::~CMemoryMap().
//
//  Description: The destruction of the class: CMemoryMap.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryMap::~CMemoryMap()
{

}   // End of CMemoryMap::~CMemoryMap().


// Execute the MAp command.
void CMemoryMap::MapAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 1 == nArgc || 4 == nArgc || 5 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }

    // Execute the MAp command.
    if ( 1 == nArgc ) { 
        // Get the current Map setting.
        GetMap();
    }
    else if ( 4 == nArgc || 5 == nArgc ) {  
        // Set the Map setting.
        SetMap(nArgc, pszArgv);
    }
    else {
        ASSERT( FALSE );
    }

}   // End of CMemoryMap::MapAction().



/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryMap::GetMap().
//
//  Description: Get the current Map setting.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryMap::GetMap(void)
{
    // Assertion of the input parameters.

    // Display the header message.
    DisplayMapHead();
    
    // Pass through all the P: & X: memory space.
    for ( int i = MEM_PROGRAM; i <= MEM_EXTERNAL; i++ ) {
        GetMapInfo(i);
    }
    
}   // End of CMemoryMap::GetMap().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryMap::GetMapInfo().
//
//  Description: Get the current Map setting.
//
//  Input:  nMemType - Memory space.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryMap::GetMapInfo(int nMemType)
{
    // Pass through all the PROGRAM & EXTERNAL memory space.
    // The switch statemaent is added by Daniel Lin on 1996.03.25.
    // For the map must between the memory range
    //
    switch (nMemType) {
      case  MEM_PROGRAM :
            SetAddrVar(nMemType, (unsigned long)dwpMin, m_StartAddr);
            SetAddrVar(nMemType, (unsigned long)dwpMax, m_EndAddr);
            break;

      case  MEM_EXTERNAL:
            SetAddrVar(nMemType, (unsigned long)dwxMin, m_StartAddr);
            SetAddrVar(nMemType, (unsigned long)dwxMax, m_EndAddr);
            break;
      default:
            return;
   }
    
#ifdef _SERVER_NO_ABI
    unsigned uTest = 0;
#endif  // _SERVER_NO_ABI
    
    // Add by Daniel Lin for map range
    //
    if ( m_StartAddr == 0 && m_EndAddr == 0 && m_StartAddr == m_EndAddr)
      return;
          
    do {

        #ifdef _SERVER_NO_ABI
            m_MapInfo.StartAddr.m_uAddr = uTest;
            m_MapInfo.EndAddr.m_uAddr = uTest + 0x07F;
            m_MapInfo.StartAddr.chType = (char) nMemType;
            m_MapInfo.uchMapAttr = MAP_IR;
            uTest += 0x080;
        #else                          
            m_nErrorID = AbiGetMap((ADDR&)m_StartAddr, (ADDR&)m_EndAddr,
                                   (MAP_INFO*)&m_MapInfo);
            // FW BUG: m_MapInfo.EndAddr.m_uchType has no meaning.
            m_MapInfo.EndAddr.m_uchType = m_MapInfo.StartAddr.m_uchType;
        #endif  // _SERVER_NO_ABI

        if ( 0 != m_nErrorID ) {
            DisplayErrorMessage();
            return;
        }
        else {
            FormatMapInfo();
            ShowLine(m_pszResult);
            m_StartAddr = m_MapInfo.EndAddr + 1;
        }

    } while ( m_MapInfo.EndAddr < m_EndAddr );

}   // End of CMemoryMap::GetMapInfo().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryMap::DisplayMapHead().
//
//  Description: Display the header message.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryMap::DisplayMapHead(void) const
{
    // Assertion of the input parameters.

    // Display the Map head.
    char* p = "Emulation Memory Size = 128 KB.";
    ShowLine(p);
    p = "Map Resolution = 128 Bytes.";
    ShowLine(p);
    p = "-------------------------------";
    ShowLine(p);
    p = "Start   End     Attr   Space";
    ShowLine(p);

}   // End of CMemoryMap::DisplayMapHead().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryMap::FormatMapInfo().
//
//  Description: Format the Map information.
//
//  Input:  None.
//
//  Output: m_pszResult - To store the Map information.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryMap::FormatMapInfo(void)
{
    // Assertion of the input parameters.
    ASSERT( m_pszResult );
    memset(m_pszResult, 0, sizeof(m_pszResult));
    
    // Get the Map value.
    unsigned uStartAddr = m_MapInfo.StartAddr.m_uAddr;
    unsigned uEndAddr = m_MapInfo.EndAddr.m_uAddr;
    unsigned long uSize =(unsigned long)uEndAddr-(unsigned long)uStartAddr+1;
    char chAttr = m_MapInfo.chMapAttr;
    char chSpace = m_MapInfo.StartAddr.m_uchType;
    
    // Convert to string.
    char* p = "%04s    %04s    %-2s     %-1s";
    
    char pszBuf1[5];
    char pszBuf2[5];
//    char pszBuf3[5];
    char pszBuf4[3];
    char pszBuf5[2];
    
    memset(pszBuf1, 0, sizeof(pszBuf1));
    memset(pszBuf2, 0, sizeof(pszBuf2));
//    memset(pszBuf3, 0, sizeof(pszBuf3));
    memset(pszBuf4, 0, sizeof(pszBuf4));
    memset(pszBuf5, 0, sizeof(pszBuf5));
    
    VarToStr((unsigned long) uStartAddr);
    strcpy(pszBuf1, strupr(m_pszVar));
               
    VarToStr((unsigned long) uEndAddr);
    strcpy(pszBuf2, strupr(m_pszVar));

//    VarToStr((unsigned long) uSize);
//    strcpy(pszBuf3, m_pszVar);

    switch ( chAttr ) {
        case MAP_I:
            strcpy(pszBuf4, "O");
            break;
        case MAP_IR:
            strcpy(pszBuf4, "OR");
            break;
        case MAP_E:
            strcpy(pszBuf4, "T");
            break;
        case MAP_ER:
            strcpy(pszBuf4, "TR");
            break;
        case MAP_C:
            strcpy(pszBuf4, "C");
            break;
        case MAP_CR:
            strcpy(pszBuf4, "CR");
            break;
        case MAP_G:
            strcpy(pszBuf4, "G");
            break;
        default:
            ASSERT( FALSE );
            break;
    }
                
    switch ( chSpace ) {
        case MEM_PROGRAM:
            strcpy(pszBuf5, "P");
            break;
        case MEM_EXTERNAL:
            strcpy(pszBuf5, "X");
            break;
        default:
            ASSERT( FALSE );
            break;
    }

    wsprintf(m_pszResult, p, pszBuf1, pszBuf2, pszBuf4, pszBuf5);
    
}   // End of CMemoryMap::FormatMapInfo().



/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryMap::SetMap().
//
//  Description: Set the current Map setting.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryMap::SetMap(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 4 == nArgc || 5 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Map setting.
    if ( 4 == nArgc ) {
        if ( 3 == strlen(pszArgv[1]) && strstr(strupr(pszArgv[1]),"ALL") ) {
            // MAp All adrtype attr.
            if ( 'P' == toupper(pszArgv[2][0]) ) {
                SetAddrVar("P:0", m_StartAddr);
                SetAddrVar("P:FFFF", m_EndAddr);
            }
            else {
                SetAddrVar("X:0", m_StartAddr);
                SetAddrVar("X:FFFF", m_EndAddr);
            }
            SetMapAttr(pszArgv[3]);

            // Set the default memory space.
            if ( ':' != pszArgv[2][1] ) {
                m_StartAddr.m_uchType = MEM_EXTERNAL;
            }
            m_EndAddr.m_uchType = m_StartAddr.m_uchType;
        }
        else {
            // MAp adr1 adr2 attr.
            SetAddrVar(pszArgv[1], m_StartAddr);
            SetAddrVar(pszArgv[2], m_EndAddr);
            SetMapAttr(pszArgv[3]);

            // Set the default memory space.
            if ( ':' != pszArgv[1][1] ) {
                m_StartAddr.m_uchType = MEM_EXTERNAL;
            }
            m_EndAddr.m_uchType = m_StartAddr.m_uchType;
        }
    }
    else if ( 5 == nArgc ) {
        // MAp adr1 Length length attr.
        SetAddrVar(pszArgv[1], m_StartAddr);
        SetAddrVar(pszArgv[1], pszArgv[3], m_EndAddr);
        SetMapAttr(pszArgv[4]);
        // Set the default memory space.
        if ( ':' != pszArgv[1][1] ) {
            m_StartAddr.m_uchType = MEM_EXTERNAL;
        }
        m_EndAddr.m_uchType = m_StartAddr.m_uchType;
    }
    else {
        ASSERT( FALSE );
        return;
    }

    // Send to ABI.    
    SetMapInfo();
    m_nErrorID = AbiSetMap((MAP_INFO&)m_MapInfo);

    // Update Source window.
    if ( MEM_PROGRAM == m_StartAddr.m_uchType ) {
        ::SrcUpdate();
    }

    if ( ICE_OK != m_nErrorID ) {
        DisplayErrorMessage();
    }

}   // End of CMemoryMap::SetMap().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryMap::SetMapAttr().
//
//  Description: Set the current Map attribute.
//
//  Input:  pszArgv - "IR', "ER", etc.
//
//  Output: m_ulVar - Value to indicate the Map attribute.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryMap::SetMapAttr(char* pszArgv)
{
    // Assertion of the input parameters.
    ASSERT( pszArgv );
    
    // Decide the Map attribute.
    if ( !stricmp(pszArgv, "Overlay") ) {
        m_ulVar = MAP_I;
    }
    else if ( !stricmp(pszArgv, "OR") ) {
        m_ulVar = MAP_IR;
    }
    else if ( !stricmp(pszArgv, "Guard") ) {
        m_ulVar = MAP_G;
    }
    else if ( !stricmp(pszArgv, "Target") ) {
        m_ulVar = MAP_E;
    }
    else if ( !stricmp(pszArgv, "TR") ) {
        m_ulVar = MAP_ER;
    }
    else if ( !stricmp(pszArgv, "Combination") ) {
        m_ulVar = MAP_C;
    }
    else if ( !stricmp(pszArgv, "CR") ) {
        m_ulVar = MAP_CR;
    }
    else {
        ASSERT( FALSE );
        m_ulVar = MAP_I;
    }

}   // End of CMemoryMap::SetMapAttr().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryMap::SetMapInfo().
//
//  Description: Set the current Map setting data.
//
//  Input:  m_StartAddr, m_EndAddr, m_ulVar.
//
//  Output: m_MapInfo.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryMap::SetMapInfo(void)
{
    // Assertion of the input parameters.
    
    // Set tagMapInfo structure.
    m_MapInfo.StartAddr = m_StartAddr;
    m_MapInfo.EndAddr = m_EndAddr;
    m_MapInfo.chMapAttr = (char) m_ulVar;

}   // End of CMemoryMap::SetMapInfo().


// Map server to set map information.
void CMemoryMap::MemServerSetMap(const unsigned short uStart, 
    const unsigned short uEnd, const unsigned char uchType, 
    const char chMapAttr)
{
    // Assertion of the input parameters.
    ASSERT( uchType >= MEM_PROGRAM && uchType <= MEM_EXTERNAL );
    ASSERT( chMapAttr >= MAP_I && chMapAttr <= MAP_G );

    // Set the Server flag.
    m_isServer = TRUE;

    // Set Map address.
    m_StartAddr = CMemoryAddr(uStart, uchType);
    m_EndAddr = CMemoryAddr(uEnd, uchType);

    // Set Map attribute.
    m_ulVar = chMapAttr;
    
    // Set tagMapInfo structure.
    SetMapInfo();

    // Call ABI routine.
    m_nErrorID = AbiSetMap((MAP_INFO&)m_MapInfo);

    // Update Source window.
    if ( MEM_PROGRAM == m_StartAddr.m_uchType ) {
        ::SrcUpdate();
    }

    if ( ICE_OK != m_nErrorID ) {
        DisplayErrorMessage();
    }

}   // End of CMemoryMap::MemServerSetMap().


// Map server to get map information.
BOOL CMemoryMap::MemServerGetMap(unsigned short& uStart, 
    unsigned short& uEnd, unsigned char& uchType, char& chMapAttr)
{
    // Assertion of the input parameters.
    ASSERT( uchType >= MEM_PROGRAM && uchType <= MEM_EXTERNAL );

    // Set the Server flag.
    m_isServer = TRUE;
    
    // Set Map address.
    switch (uchType) {
      case  MEM_PROGRAM:
            m_StartAddr = CMemoryAddr(uStart, uchType);
            m_EndAddr = CMemoryAddr((unsigned short)dwpMax, uchType);
            break;

      case  MEM_EXTERNAL:
            m_StartAddr = CMemoryAddr(uStart, uchType);
            m_EndAddr = CMemoryAddr((unsigned short)dwxMax, uchType);
            break;

      default:
            return FALSE;
    }

    // Call ABI routine.
    m_nErrorID = AbiGetMap((ADDR&)m_StartAddr, (ADDR&)m_EndAddr,
                           (MAP_INFO*)&m_MapInfo);
    if ( 0 != m_nErrorID ) {
        DisplayErrorMessage();
        return (FALSE);
    }
    else {
        uStart = m_MapInfo.StartAddr.m_uAddr;
        uEnd = m_MapInfo.EndAddr.m_uAddr;
        uchType = m_MapInfo.StartAddr.m_uchType;
        chMapAttr = m_MapInfo.chMapAttr;
        return (TRUE);
    }

}   // End of MemServerGetMap().

//////////////////////////////// End of File ////////////////////////////////
