
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/MEMSCHDG.CPP   1.7.1.0.1.2   09 Dec 1996 10:14:12   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/MEMSCHDG.CPP  $
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:14:12   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:57:28   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:13:30   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:25:04   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:52:10   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:44:38   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:49:54   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:52:04   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:28:06   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:08:28   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:08:58   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:24:54   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:00:36   Shirley
** EasyPack/SLD Version 1.91
** 
**    Rev 1.30   12 Apr 1996 10:37:40   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:52:10   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:06:42   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:33:12   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:48:08   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:12:28   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:12:10   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:12:52   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:36:28   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:24:52   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:09:14   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:12:16   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:14:44   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:09:58   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:30:48   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:23:52   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:26:12   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:30:20   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:33:36   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:43:18   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:05:22   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:49:28   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:46:46   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:30:50   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:46:56   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:18:50   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:52:02   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:58:00   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:28   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:55:22   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  MEMSCHDG.CPP
//
//  Description:The implement file for the class: CMemSearchDlg
//
//  Author:     Lane Li
//
//  Date:       09/10/95
//
//  Modification:
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

// memschdg.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "xview.h"   
// For address server
//
#include "address.h"
#include "addrapi.h"
#include "memschdg.h"
#include "ctype.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern int GetTokenNum(char* string);
extern BOOL MemServerSearch(unsigned short uStart, 
                            unsigned short uEnd,
                            unsigned char uchType, 
                            char* pszPattern, 
                            int nInsensitive,
                            unsigned short& uRetAddr);

/////////////////////////////////////////////////////////////////////////////
// CMemSearchDlg dialog
//

CMemSearchDlg::CMemSearchDlg(CWnd* pParent /*=NULL*/)
   : CDialog(CMemSearchDlg::IDD, pParent)
{
   //{{AFX_DATA_INIT(CMemSearchDlg)
      // NOTE: the ClassWizard will add member initialization here
   //}}AFX_DATA_INIT
}

void CMemSearchDlg::DoDataExchange(CDataExchange* pDX)
{
   CDialog::DoDataExchange(pDX);
   //{{AFX_DATA_MAP(CMemSearchDlg)
      // NOTE: the ClassWizard will add DDX and DDV calls here
   //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMemSearchDlg, CDialog)
   //{{AFX_MSG_MAP(CMemSearchDlg)
   ON_BN_CLICKED(IDC_MEMSRH_CANCEL, OnMemsrhCancel)
   ON_BN_CLICKED(IDC_MEMSRH_OK, OnMemsrhOk)
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CMemSearchDlg message handlers

void CMemSearchDlg::OnMemsrhCancel()
{
   // TODO: Add your control notification handler code here
   EndDialog(0);
}

void CMemSearchDlg::OnMemsrhOk()
{
   // TODO: Add your control notification handler code here
   char text[200];
   char input[100], input2[100];
   BOOL bOK;
   int len;
   CWnd* ctrl;
   unsigned short addr;

   char separation[3];
   char str1[200];
   char* temp;
   int i;
   char strToken[6];
   
   bOK=TRUE;
   
   GetDlgItemText(IDC_MEMSRH_EDIT1, text, 190);
   len = strlen(text);
   if ( len <= 0 ) bOK=FALSE;
   input[0]='\0';
   
   if (bOK) {
      if (text[0]=='"') {
         if (text[len-1]=='"') {
            if (len > 32 || len < 3)
               bOK=FALSE;
            else {
               lstrcpy(input, text);
               input[len]='\0';
            }  
         }
         else
            bOK = FALSE;
      }
      else {
         len = GetTokenNum(text);
         if ((len <= 0) || (len > 32))
            bOK=FALSE;
         else {
            separation[0]=' ';
            separation[1]=',';
            separation[2]='\0';       
            
            strcpy(str1, text);
            
            //
            // The tokens is by hexdecimal(default)
            // No leading '0x'
            // In the input radix is changed to the hexidecimal must have
            // leading '0x', the following statment must change
            //
            
            temp = strtok(str1, separation);
            i = strlen(temp);
            
            if (i > 4) bOK=FALSE;
            else {
              ADDRESS  token;
              if (ADR_OK != AdrTextToAddr(temp, token, 0))  // For data
                 bOK = FALSE;
              token.adrSpace = SPACE_UNDEFINE;
              if (ADR_OK != AdrAddrToHex(token, strToken))
                 bOK = FALSE;
            }
            
            strcpy(input, strToken+2);
            strcpy(input2, strToken);
            i = lstrlen(input);
            input[i]=' ';
            input[i+1]='\0';
            i = lstrlen(input2);
            input2[i]=' ';
            input2[i+1]='\0';
            
            while(temp!=NULL) {
               temp = strtok(NULL, separation);
               if (temp==NULL) break;
               i = strlen(temp);
               if (i > 4) bOK=FALSE;
               else {
                 ADDRESS  token;
                 if (ADR_OK != AdrTextToAddr(temp, token, 0))    // For data
                   bOK = FALSE;
                 token.adrSpace = SPACE_UNDEFINE;
                 if (ADR_OK != AdrAddrToHex(token, strToken))
                   bOK = FALSE;
               }  
               
               strcat(input, strToken+2);
               strcat(input2, strToken);
               i = strlen(input);
               input[i]=' ';
               input[i+1]='\0';
               i = strlen(input2);               
               input2[i]=' ';
               input2[i+1]='\0';
            }    
         }
      }
   }
      
   if (bOK) {
      BeginWaitCursor();
      strcpy(m_str, input2);
      
#ifndef _NOABI
       // Has ABI
      if (!MemServerSearch(m_StartAddress,
                           0xFFFF,
                           m_nSpaceType,
                           input,
                           0, 
                           addr))
         m_lFindAddress = -1;
      else
         m_lFindAddress = (long)addr;
#endif   // _NOABI
         
      EndWaitCursor();
      EndDialog(1);
   }
   else {
      MessageBox("Input Error",NULL, MB_OK | MB_ICONEXCLAMATION);
      ctrl=GetDlgItem(IDC_MEMSRH_EDIT1);
      ctrl->SetFocus();
      ((CEdit *)ctrl)->SetSel(0,-1);
   }
}

BOOL CMemSearchDlg::OnInitDialog()
{
   CDialog::OnInitDialog();
   CenterWindow();
   
   // TODO: Add extra initialization here
   SetDlgItemText(IDC_MEMSRH_EDIT1,m_str);
   
   return TRUE;  // return TRUE  unless you set the focus to a control
}

//////////////////////(EOF of MEMSCHDG.CPP)///////////////////////////

