 
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/MEMTEST.CPP   1.7.1.0.1.2   09 Dec 1996 10:16:08   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/MEMTEST.CPP  $
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:16:08   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:59:24   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:18:12   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:29:42   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:56:48   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:51:18   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:55:00   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:58:04   ZJRD
** EasyPack/SLD Version 1.96
** 
**    Rev 1.4   29 May 1996 09:28:38   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:05:52   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:11:54   ZJRD
** EasyPack/SLD Version 1.93
** 
**    Rev 1.1   02 May 1996 10:23:44   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:57:32   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:43:00   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:55:04   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:03:18   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:29:48   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:44:10   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:17:06   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:19:42   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:19:36   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:32:44   Shirley
** EasyPack/SLD Version 0.34d
** 
**    Rev 1.20   23 Jan 1996 11:26:30   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:15:10   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:17:16   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:14:22   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:14:36   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:29:08   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:21:22   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:24:38   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:28:54   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:31:48   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:40:22   Shirley
** EasyPack/SLD Version 0.22
** 
**    Rev 1.9   02 Nov 1995 10:07:38   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:50:50   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:47:14   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:31:28   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:51:38   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:21:08   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:53:26   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:55:32   Shirley
** EasyPack/SLD Version 0.1b
** 
**    Rev 1.1   15 Sep 1995 09:48:26   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:53:46   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMTEST.CPP
//
//  Description: The implementation file for the class: CMemoryTest.
//
//  Author: Chen Jun
//
//  Date: 04/29/95
//
//  Modification:
//      1. 04/29/95, Initial version of the class: CMemoryTest.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "memtest.h"
#include "hosterrs.h"
extern RETCODE EXPORT ErrGetErrorText(U32 errorCode, LPSTR lpszError ...);
extern RETCODE EXPORT ErrGetErrorText(U32 errorCode, CString& strError ...);


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void TestCmd(int nArgc, char* pszArgv[]);
BOOL MemServerTest(unsigned short uStartAddr, unsigned short uEndAddr, 
                   unsigned char uchType, unsigned short& uFailAddr);


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
#ifndef _SERVER_NO_ABI
    extern STATUS AbiTest(ADDR addr1, ADDR addr2);
    extern ADDR AbiGetErrorAddr();
#endif  // _SERVER_NO_ABI

void SrcUpdate(void);
extern BOOL GetCpuStatus(unsigned char &);
extern void ShowLine(char *);


/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   TestCmd().
//
//  Description: The main control routine of Test command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void TestCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 3 == nArgc || 4 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Test EMM.
    char error[128];
    CMemoryTest* pMemoryTest = new CMemoryTest;
    if ( !pMemoryTest ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
       unsigned char result;         
       if ( ::GetCpuStatus(result) ) {
          if ( 1/*STATUS_GO*/ == result ) {
            //::ShowLine ("EP running. Stop EP first");
            ::ErrGetErrorText(ER_GOFLY_ERR_MSG, error);
            ::ShowLine (error);
          }    
          else {
           pMemoryTest->TestAction(nArgc, pszArgv);
           delete pMemoryTest;
          }           
       }   
    }

//    CMemoryTest objTest;
//    objTest.MemoryTest(nArgc, pszArgv);

}   // End of TestCmd().


BOOL MemServerTest(unsigned short uStartAddr, unsigned short uEndAddr, 
                   unsigned char uchType, unsigned short& uFailAddr)
{
    // Assertion of the input parameters.
    
    // Test EMM.
    CMemoryTest* pMemoryTest = new CMemoryTest;
    if ( !pMemoryTest ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return (TRUE);
    }
    else {
        BOOL isOK = 
           pMemoryTest->MemServerTest(uStartAddr,uEndAddr,uchType,uFailAddr);
        delete pMemoryTest;
        return (isOK);
    }

}   // End of MemServerTest().
                   

/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CMemoryTest.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryTest::CMemoryTest().
//
//  Description: The construction of the class: CMemoryTest.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryTest::CMemoryTest()
{

}   // End of CMemoryTest::CMemoryTest().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryTest::~CMemoryTest().
//
//  Description: The destruction of the class: CMemoryTest.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryTest::~CMemoryTest()
{

}   // End of CMemoryTest::~CMemoryTest().



/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryTest::TestAction().
//
//  Description: Test EMM.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryTest::TestAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 3 == nArgc || 4 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Set Start address & End address.
    if ( 3 == nArgc ) {
        // Test adr1 adr2.
        SetAddrVar(pszArgv[1], m_StartAddr);
        SetAddrVar(pszArgv[2], m_EndAddr);
    }
    else if ( 4 == nArgc ) {
        // Test adr1 Length length.
        SetAddrVar(pszArgv[1], m_StartAddr);
        SetAddrVar(pszArgv[1], pszArgv[3], m_EndAddr);
    }
    else {
        ASSERT( FALSE );
        return;
    }
    
    // Set the default memory space.
    if ( ':' != pszArgv[1][1] ) {
        m_StartAddr.m_uchType = MEM_EXTERNAL;
    }
    m_EndAddr.m_uchType = m_StartAddr.m_uchType;
    
    // Memory Test kernel routine.
    MemoryTestKernel();
        
}   // End of CMemoryTest::TestAction().


void CMemoryTest::MemoryTestKernel(void)
{
    // Assertion of the input parameters.
    
    // Call Abi routine.
    m_nErrorID = AbiTest((ADDR&) m_StartAddr, (ADDR&) m_EndAddr);

    // Update Source window.
    if ( MEM_PROGRAM == m_StartAddr.m_uchType ) {
        ::SrcUpdate();
    }
    
    if ( ICE_OK == m_nErrorID ) {
        m_bServerRet = TRUE;
        ShowLine("Memory test completed - no failure found.");
    }
    else if ( ICE_FAIL_MEM_WRITE == m_nErrorID ) {
        m_FailAddr = (CMemoryAddr&) AbiGetErrorAddr();
        m_bServerRet = FALSE;
        char chType;
        switch ( m_FailAddr.m_uchType ) {
            case MEM_UNDEFINE:
                switch ( m_StartAddr.m_uchType ) {
                    case MEM_PROGRAM:
                        chType = 'P';
                        break;
                    case MEM_EXTERNAL:
                        chType = 'X';
                        break;
                    case MEM_INTERNAL:
                        chType = 'I';
                        break;
                    default:
                        ASSERT( FALSE );
                        break;
                }
                break;
            case MEM_PROGRAM:
                chType = 'P';
                break;
            case MEM_EXTERNAL:
                chType = 'X';
                break;
            case MEM_INTERNAL:
                chType = 'I';
                break;
/*            
            case MEM_SFR:
                chType = 'R';
                break;
            case MEM_BIT:
                chType = 'B';
                break;
*/                
            default:
                ASSERT( FALSE );
                break;
        }
                                    
        wsprintf(m_pszResult, "Memory test terminated - failure at %c:%04X.",
                    chType, m_FailAddr.m_uAddr);
        ShowLine(m_pszResult);
    }
    else {
        DisplayErrorMessage();
        m_bServerRet = TRUE;
    }
        
}   // End of CMemoryTest::MemoryTestKernel().


// Memory Test server.
BOOL CMemoryTest::MemServerTest(unsigned short uStartAddr,
    unsigned short uEndAddr,unsigned char uchType,unsigned short& uFailAddr)
{
    // Assertion of the input parameters.
    ASSERT( uchType >= MEM_PROGRAM && uchType <= MEM_BIT );

    // Set the server flag.
    m_isServer = TRUE;
        
    // Set the parameters.
    m_StartAddr = CMemoryAddr(uStartAddr, uchType);
    m_EndAddr = CMemoryAddr(uEndAddr, uchType);
    
    // Memory Test kernel routine.
    MemoryTestKernel();
    uFailAddr = m_FailAddr.m_uAddr;
    return (m_bServerRet);

}   // End of CMemoryTest::MemServerTest().

//////////////////////////////// End of File ////////////////////////////////
