
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/MEMWORD.CPP   1.7.1.0.1.2   09 Dec 1996 10:15:00   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/MEMWORD.CPP  $
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:15:00   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:58:16   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:15:32   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:27:04   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:54:12   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:47:46   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:52:24   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:55:44   ZJRD
** EasyPack/SLD Version 1.96
** 
**    Rev 1.4   29 May 1996 09:38:30   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:00:48   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:15:14   ZJRD
** EasyPack/SLD Version 1.93
** 
**    Rev 1.1   02 May 1996 10:23:10   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:03:02   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:37:06   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:50:04   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:02:30   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:27:46   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:43:24   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:16:16   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:13:08   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:13:46   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:39:34   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:28:22   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:08:54   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:11:54   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:14:24   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:14:38   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:29:10   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:21:24   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:24:40   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:28:56   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:31:58   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:45:50   Shirley
** EasyPack/SLD Version 0.22
** 
**    Rev 1.9   02 Nov 1995 10:08:00   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:45:18   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:47:36   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:30:26   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:51:50   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:22:48   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:49:46   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:55:34   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:48:30   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:53:48   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMWORD.CPP
//
//  Description: The implementation file for the class: CMemoryWord.
//
//  Author: Chen Jun
//
//  Date: 06/20/95
//
//  Modification:
//      1. 06/20/95, Initial version of the class: CMemoryWord.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "memword.h"
#include "hosterrs.h"
extern RETCODE EXPORT ErrGetErrorText(U32 errorCode, LPSTR lpszError ...);
extern RETCODE EXPORT ErrGetErrorText(U32 errorCode, CString& strError ...);


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void WordCmd(int nArgc, char* pszArgv[]);


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
#ifndef _SERVER_NO_ABI
    extern STATUS AbiSetMemN(ADDR addr, char* pchBuff, UINT uPatternLen);
#endif  // _SERVER_NO_ABI

void SrcUpdate(void);
extern BOOL GetCpuStatus(unsigned char&);
extern void ShowLine(char *);



/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   WordCmd().
//
//  Description: The main control routine of Word command.
//
//  Input:  nArgc - Number of input parameters.
//          pszArgv - Input parameters.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void WordCmd(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 3 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Word to EMM.
    char error[128];    
    CMemoryWord* pMemoryWord = new CMemoryWord;
    if ( !pMemoryWord ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
       unsigned char result;         
       if ( ::GetCpuStatus(result) ) {
          if ( 1/*STATUS_GO*/ == result ) {
            //::ShowLine ("EP running. Stop EP first");
            ::ErrGetErrorText(ER_GOFLY_ERR_MSG, error);
            ::ShowLine (error);
          }    
          else {
           pMemoryWord->WordAction(nArgc, pszArgv);
           delete pMemoryWord;
          }           
       }   
    }

//    CMemoryWord objWord;
//    objWord.SetWord(nArgc, pszArgv);

}   // End of WordCmd().



/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CMemoryWord.

// The construction of the class: CMemoryWord.
CMemoryWord::CMemoryWord()
{

}   // End of CMemoryWord::CMemoryWord().


// The destruction of the class: CMemoryWord.
CMemoryWord::~CMemoryWord()
{

}   // End of CMemoryWord::~CMemoryWord().


// Set the Word value to EMM.
void CMemoryWord::WordAction(int nArgc, char* pszArgv[])
{
    // Assertion of the input parameters.
    ASSERT( 3 == nArgc );
    for ( int i = 0; i < nArgc; i++ ) {
        ASSERT( pszArgv[i] );
    }
    
    // Set address & pattern.
    if ( 3 == nArgc ) {
        // Word adr data.
        SetAddrVar(pszArgv[1], m_Addr);
        SetPattern(pszArgv[2]);
    }
    else {
        ASSERT( FALSE );
        return;
    }
    
    // Set the default memory space.
    if ( ':' != pszArgv[1][1] ) {
        m_Addr.m_uchType = MEM_EXTERNAL;
    }
    
    // Memory Word kernel routine.
    MemoryWordKernel();
        
}   // End of CMemoryWord::WordAction().


void CMemoryWord::SetPattern(char* pszPattern)
{
    // Assertion of the input parameters.
    ASSERT( pszPattern );
    
    // Set the pattern buffer.
    m_uPatternLen = 0;
    while ( *pszPattern ) {
        char pszData[5];
        memset(pszData, 0, sizeof(pszData));
        for ( int i = 0; i <= 4; i++ ) {
            if ( ' ' != *pszPattern ) {
                pszData[i] = *pszPattern++;
            }
            else {
                pszPattern++;
                break;
            }
        }
        StrToVar(pszData);
        ((WORD*) m_pchByte)[m_uPatternLen/2] = (WORD) m_ulVar;
        m_uPatternLen += 2;
    }

}   // End of CMemoryWord::SetPattern().


void CMemoryWord::MemoryWordKernel(void)
{
    // Assertion of the input parameters.
    
    // Call Abi routine.
    m_nErrorID = AbiSetMemN((ADDR&) m_Addr, m_pchByte, m_uPatternLen);

    // Update Source window.
    if ( MEM_PROGRAM == m_Addr.m_uchType ) {
        ::SrcUpdate();
    }
    
    if ( 0 != m_nErrorID ) {
        DisplayErrorMessage();
    }
        
}   // End of CMemoryWord::MemoryDumpKernel().


//////////////////////////////// End of File ////////////////////////////////
