/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/PROJMGR.CPP   1.5.1.0.1.2   09 Dec 1996 10:14:28   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/PROJMGR.CPP  $
** 
**    Rev 1.5.1.0.1.2   09 Dec 1996 10:14:28   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.5.1.0.1.0   11 Nov 1996 12:57:44   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.5.1.4   09 Sep 1996 13:14:12   ZJRD
** No change.
** 
**    Rev 1.5.1.3   05 Sep 1996 11:25:44   ZJRD
** No change.
** 
**    Rev 1.5.1.2   02 Sep 1996 09:52:52   ZJRD
** EasyPack/SLD Version 1.9d
** 
**    Rev 1.5.1.0   12 Aug 1996 10:50:38   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.2   29 May 1996 09:34:00   ZJRD
** EasyPack/SLD Version 1.95
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// projmgr.cpp
//
// Roger Zhang
//
// 4/30/96
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "resource.h"
#include "uicom.h"
               
#include "toolopt.h"                 
#include "aa.h"
#include "ac.h"
#include "al.h"
#include "alib.h"
#include "ae.h"
                   
#include "projopt.h"
#include "aopt.h" 
#include "ba.h"
#include "bc.h"
#include "bl.h"
#include "blib.h"
#include "be.h"
                   
#include "bopt.h" 
#include "ca.h"
#include "cc.h"
#include "cl.h"
#include "ce.h"
#include "copt.h" 
#include "da.h"
#include "dc.h"
#include "dl.h"
#include "de.h"
#include "dlib.h"
                  
#include "dopt.h"
#include "projmgr.h"
#include "newproj.h"
#include "editproj.h"

/////////////////////////////////////////////////////////////////////////////
CProjectManager mgrProj;

/////////////////////////////////////////////////////////////////////////////
BOOL NewProject(CWnd *pParent)
{
    return mgrProj.NewProject(pParent);
}

BOOL EditProject(CWnd *pParent)
{
    return mgrProj.EditProject(pParent);
}

BOOL OpenProject(CWnd *pParent)
{
    return mgrProj.OpenProject(pParent);
}

BOOL CloseProject(void)
{
    return mgrProj.CloseProject();
}

void SetOption(CWnd *pParent)
{
    mgrProj.SetOption(pParent);
}

void BuildProject(void)
{
    mgrProj.Build();
}

void EditorProject(void)
{
    mgrProj.Editor();
}

BOOL ProjectValid(void)
{
    return mgrProj.m_fValid;
}

/*BOOL EditorValid(void)
{
    return mgrProj.m_fEditorValid;
} */
    

/////////////////////////////////////////////////////////////////////////////
// constructor
CProjectManager::CProjectManager()
{
    m_fp = NULL;
    m_fValid = FALSE;
  //  m_fEditorValid=FALSE;
    m_pOption = NULL;
}

CProjectManager::~CProjectManager()
{
    CloseProject(); 
}

/////////////////////////////////////////////////////////////////////////////
// implementation
BOOL CProjectManager::SaveCompilerType(void)
{
    ASSERT(m_fp);
    
    return fwrite(&m_nCompilerType, 2, 1, m_fp) == 1;
}

BOOL CProjectManager::LoadCompilerType(void)
{
    ASSERT(m_fp);
    
    return fread(&m_nCompilerType, 2, 1, m_fp) == 1;
}               

BOOL CProjectManager::SaveFileList(void)
{
    ASSERT(m_fp);
    
    int nCnt = m_FileList.GetCount();
    if(fwrite(&nCnt, 2, 1, m_fp) != 1)
        return FALSE;
        
    CString str;
    POSITION pos;
    int nLen;

    for(pos = m_FileList.GetHeadPosition(); pos != NULL; ) {
        str = m_FileList.GetNext(pos);
        nLen = str.GetLength();
        if(fwrite(&nLen, 2, 1, m_fp) != 1)
            return FALSE;
        if(fwrite(str.GetBuffer(nLen), 1, nLen, m_fp) != (size_t)nLen)
            return FALSE;
        str.ReleaseBuffer(nLen);
    }
    
    return TRUE;    
}

BOOL CProjectManager::LoadFileList(void)
{
    ASSERT(m_fp);
    
    WORD wCnt;
    if(fread(&wCnt, 2, 1, m_fp) != 1)
        return FALSE;
    if(wCnt > (WORD)32000)
        return FALSE;
        
    CString str;      
    WORD wLen;

    m_FileList.RemoveAll();
    for(WORD w = 0; w < wCnt; w++) {
        if(fread(&wLen, 2, 1, m_fp) != 1)
            return FALSE;
        if(wLen > (WORD)32000)
            return FALSE;
        if(fread(str.GetBuffer(wLen), 1, wLen, m_fp) != wLen)
            return FALSE;
        str.ReleaseBuffer(wLen);
        m_FileList.AddTail(str);
    }
    
    return TRUE;    
}                        

BOOL CProjectManager::SaveOption(void)
{
    ASSERT(m_fp);   
    ASSERT(m_pOption);
  
    return m_pOption->SaveOption(m_fp);
}

BOOL CProjectManager::LoadOption(void)
{
    ASSERT(m_fp);   
    ASSERT(m_pOption);
    return m_pOption->LoadOption(m_fp);
}

BOOL CProjectManager::SaveProject(void)
{                
    m_fp = fopen(m_strProjName, "wb");
    if(!m_fp) 
        goto SAVEFAIL;
        
    if(!SaveCompilerType())
        goto SAVEFAIL;
        
    if(!SaveFileList())
        goto SAVEFAIL;
        
    if(!SaveOption())
        goto SAVEFAIL;
  /*  if(!m_pOption->m_fValid)
    m_fEditorValid=FALSE;
    else
    m_fEditorValid=TRUE;*/
        
    fclose(m_fp);
    m_fp = NULL;
    return TRUE;

SAVEFAIL:      
    AfxMessageBox("Save project error!");
    if(m_fp)
        fclose(m_fp);                        
    m_fp = NULL;
    return FALSE;
}

BOOL CProjectManager::LoadProject(void)
{
    m_fp = fopen(m_strProjName, "rb");
    if(!m_fp) 
        goto LOADFAIL;
        
    if(!LoadCompilerType())
        goto LOADFAIL;
        
    NewOption();
        
    if(!LoadFileList())
        goto LOADFAIL;
        
    if(!LoadOption())
        goto LOADFAIL;
 /*   if(!m_pOption->m_fValid)
    m_fEditorValid=FALSE;
    else
    m_fEditorValid=TRUE;  */
        
    fclose(m_fp);
    m_fp = NULL;
    return TRUE;

LOADFAIL:      
    AfxMessageBox("Load project error!");
    if(m_fp)
        fclose(m_fp);                        
    m_fp = NULL;
    return FALSE;
}

void CProjectManager::NewOption(void)
{
    ASSERT(m_pOption == NULL);
    
    switch(m_nCompilerType) {
        case BSO: 
            m_pOption = new AOption; 
            break;
        case IAR:
            m_pOption = new BOption;
            break;
        case AD2500:
            m_pOption = new COption;
            break;
        case OMF51:                 
            m_pOption = new DOption;
            break;
        default:
            return;
    }
}

/////////////////////////////////////////////////////////////////////////////
// operation
BOOL CProjectManager::NewProject(CWnd *pParent)
{
    CNewProjectDialog   dlg1(pParent);
    if(dlg1.DoModal() != IDOK)
        return FALSE;
        
    CloseProject();
     
    char path[_MAX_PATH], drive[_MAX_DRIVE], dir[_MAX_DIR];
    char fname[_MAX_FNAME],  ext[_MAX_EXT];
   
    _splitpath(dlg1.m_strName, drive, dir, fname, ext);
    _makepath(path, drive, dir, fname, ".prj");
    
    m_strProjName = path;
    m_nCompilerType = dlg1.m_nCompiler;
    
    NewOption();

    m_FileList.RemoveAll();                    
    
    _splitpath(dlg1.m_strName, NULL, NULL, fname, ext);
    _makepath(path, NULL, NULL, fname, ".prj");
    m_strFileName = path;
    m_strFileName.MakeUpper();
    CEditProjectDialog dlg2(m_strFileName,&m_FileList, pParent);
    dlg2.DoModal();
    
    m_fValid = SaveProject();   
    
    return m_fValid;
}
 
 void CProjectManager::Editor(void)
{ 
  
    ASSERT(m_pOption);
    
    m_pOption->Editor(m_strProjName); 
 
 }
    
BOOL CProjectManager::EditProject(CWnd *pParent)
{
    if(!m_fValid) {
        AfxMessageBox("No project opened");
        return FALSE;    
    }

    CEditProjectDialog dlg(m_strFileName,&m_FileList, pParent);
    if(dlg.DoModal() == IDOK) {
        return SaveProject();
    }
    
    return FALSE;
}
                      
static char BASED_CODE szFilter[] = 
    "Project (*.prj)|*.prj|All Files (*.*)|*.*||";                      
BOOL CProjectManager::OpenProject(CWnd *pParent)
{
    CFileDialog dlg(TRUE, NULL, "*.prj", 
        OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT, szFilter, pParent);
        
    dlg.SetHelpID(IDD_IDEOPEN);
    dlg.m_ofn.nFilterIndex = 0;
    dlg.m_ofn.lpstrTitle = "Open Project";
        
    if(dlg.DoModal() == IDCANCEL)
        return FALSE;

    CloseProject();
            
    m_strProjName = dlg.GetPathName();
    
    char path[_MAX_PATH];
    char fname[_MAX_FNAME],  ext[_MAX_EXT];
    _splitpath(dlg.GetPathName(), NULL, NULL, fname, ext);
    _makepath(path, NULL, NULL, fname, ".prj");
    m_strFileName = path;
            
    m_strFileName.MakeUpper();
    m_fValid = LoadProject();
    
    return m_fValid;
}                                                 

BOOL CProjectManager::CloseProject(void)
{
    if(m_fValid) {
        m_fValid = FALSE;
    }
  /*  if(m_fEditorValid){
        m_fEditorValid=FALSE;
    } */
    if(m_pOption) {
        delete m_pOption;
        m_pOption = NULL;
    }
    return m_fValid;
}                    

void CProjectManager::SetOption(CWnd *pParent)
{
    if(!m_fValid) {
        AfxMessageBox("No project opened");
        return;    
    }

    ASSERT(m_pOption);
    
    m_pOption->SetOption(pParent);  
    
    SaveProject();
}

void CProjectManager::Build(void)
{
    if(!m_fValid) {
        AfxMessageBox("No project opened");
        return;    
    }

    ASSERT(m_pOption);

    m_pOption->Build(m_FileList, m_strProjName);    
}                                             
