
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SHLBUF.CPP   1.7.1.0.1.2   09 Dec 1996 10:14:20   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SHLBUF.CPP  $
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:14:20   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:57:34   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:13:48   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:25:20   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:52:28   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:44:54   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.7.1.0   12 Aug 1996 10:50:08   ZJRD
** No change.
** 
**    Rev 1.7   11 Jun 1996 10:25:32   ZJRD
** EasyPack/SLD Version 1.97
** 
**    Rev 1.5   05 Jun 1996 14:53:18   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:31:58   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:03:10   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:14:42   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:29:32   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:01:56   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:38:52   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:51:46   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:06:16   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:32:46   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:47:00   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:13:36   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:17:48   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:17:44   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:37:10   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:27:40   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:09:36   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:11:22   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:12:18   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.16   30 Nov 1995 09:09:36   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:30:28   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:20:08   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:22:50   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:33:22   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:29:52   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:43:58   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:04:54   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:47:48   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:45:50   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:27:24   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:51:34   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:24:24   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:48:18   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:53:04   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:48:44   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:53:56   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SHLBUF.CPP
//
//  Description:The implement file for the class: ShellBuffer
//
//  Author:     Roger Zhang
//
//  Date:       03/22/95
//
//  Modification:
//
//      1. 03/22/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include "shlcom.h"
#include "shlbuf.h"

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//              Implement of the class : ShellBufLine                      //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
ShellBufLine::ShellBufLine()
: m_nLength(0), m_isOK(TRUE)
{ }        

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
ShellBufLine::ShellBufLine(char * pch, int nLen)
: m_nLength(0), m_isOK(TRUE)
{
    ASSERT(pch);
    ASSERT(nLen >= 0);

    if(nLen == 0)   return;
    if(nLen > MAX_SHELL_LEN)    nLen = MAX_SHELL_LEN;
    if((m_pchLine = new char [nLen])==0)  m_isOK = FALSE;
    else {
        memcpy(m_pchLine, pch, nLen);
        m_nLength = nLen;    
    }
}                                          

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
ShellBufLine::~ShellBufLine()
{
    if(m_isOK && m_nLength) delete [] m_pchLine;
}                                

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: make the buffer size equal to the text length
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void ShellBufLine::Shrink(void)
{             
    if(m_nLength == 0)    delete [] m_pchLine;
    else {
        char * pch = new char [m_nLength+1];
        if(!pch) {
            AfxMessageBox(IDS_ERR_MEM);
            return;
        }
        memcpy(pch, m_pchLine, m_nLength+1);
        delete [] m_pchLine;
        m_pchLine = pch;
    }
}
                                                  
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//              Implement of the class: ShellBuffer                        //            
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
   
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
ShellBuffer::ShellBuffer()
: m_nLines(0), m_isOK(TRUE)
{                                                 
}       

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
ShellBuffer::~ShellBuffer()
{              
    for(int i = 0; i < m_nLines; i ++)    delete m_LinePtr[i];
}                                

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellBuffer::AddLine(char * pch, int nLen)
{                                                 
	ASSERT(nLen >= 0);
	
    if(m_nLines == MAX_SHELL_LINES) {
        delete m_LinePtr[0];
        for(int i = 0; i < m_nLines - 1; i ++)
            m_LinePtr[i] = m_LinePtr[i+1];        
    } else  ++ m_nLines;
    m_LinePtr[m_nLines - 1] = new ShellBufLine(pch, nLen);
    if(!m_LinePtr[m_nLines - 1] || !( * m_LinePtr[m_nLines - 1])) {
        -- m_nLines;
        return FALSE;
    } /*else*/
     return TRUE;
}
              
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellBuffer::AddInputLine(void)
{
    if(!AddLine(PromptStr[nShellPrompt], MAX_SHELL_LEN))    return FALSE;
    m_LinePtr[m_nLines - 1]->m_nLength = PromptLen[nShellPrompt];
    return TRUE;
}
      
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellBuffer::AddDispLine(char * pch, int nLen, BOOL isWS)
{
	ASSERT(nLen >= 0);
	
    if(nLen > MAX_SHELL_LEN - 1)    nLen = MAX_SHELL_LEN - 1;
    if(isWS) {
        if(!AddLine(" ", nLen + 1))    return FALSE;
        memcpy(m_LinePtr[m_nLines - 1]->m_pchLine + 1, pch, nLen);
    } else {
        if(!AddLine(pch, nLen + 1))    return FALSE;
    }
    return TRUE;
}              

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL ShellBuffer::OvrDispLine(char * pch, int nLen)
{
	ASSERT(nLen >= 0);
	
    if(m_nLines == 0) return FALSE;
    delete m_LinePtr[--m_nLines];
    return AddDispLine(pch, nLen);    
}

///////////////////////////////(EOF)/////////////////////////////////////////
