
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SHLMACRO.H__   1.7.1.0.1.2   09 Dec 1996 10:15:22   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SHLMACRO.H__  $
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:15:22   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:58:40   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:16:20   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:27:52   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:54:58   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:50:28   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:54:26   ZJRD
** No change.
** 
**    Rev 1.7   11 Jun 1996 10:28:50   ZJRD
** EasyPack/SLD Version 1.97
** 
**    Rev 1.5   05 Jun 1996 14:57:26   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:35:08   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:08:10   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:09:42   ZJRD
** EasyPack/SLD Version 1.93
** 
**    Rev 1.1   02 May 1996 10:26:18   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.1   18 Apr 1996 12:54:10   Shirley
** EasyPack/SLD Version 1.91
** 
**    Rev 1.0   12 Apr 1996 10:36:16   Shirley
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SHLMACRO.H
//
//  Description: The header file for the class: CMacroFile.
//
//  Author: Annie Yi
//
//  Date: 04/02/96
//
//  Modification:
//      1. 04/02/96, Initial version of the class: CMacroFile.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _SHLMACRO_
#define _SHLMACRO_

#include "tstbase.h"


/////////////////////////////////////////////////////////////////////////////
// CMacroFile class.
class CMacroFile : public CFileBase
{
// Construction & Destruction.
public:
    CMacroFile();
    ~CMacroFile();
    
// Member variables.
private:
    char m_pszOneLine[maxChar+1];
    enum { TOKEN_KEY = 0x20 };

    // Parameter token.
    int m_nArgc;
    char* m_pszMacroArgv[10];  //Macro Argument(0-9)
    
    char* m_pszArgv[(maxChar+1)/2];
    
    // Inner error.
    int m_nCommandID;
    enum { minInner = 0,
           MACRO_IF = minInner,
           MACRO_IFNOT,
		   MACRO_ELSE,
           MACRO_BEGINMARK,
           MACRO_ENDMARK,
           MACRO_WHILE,
           MACRO_REM,
           MACRO_BELL,
           MACRO_ERROR,
           MACRO_GOTO,
           MACRO_LOOP,
           MACRO_LOOPEND,
           MACRO_PAUSE,
           MACRO_WAIT,
           maxInner = MACRO_WAIT
    };
    
    // Error.
    BOOL m_isStop;

    // Goto Label.
    char m_pszLabel[maxChar-5+1];
    
    // Loop & Loopend.
    enum { maxLoop = 256 };
    long m_lLoopIndex;
    long m_lLoopCount[maxLoop];
    DWORD m_dwLoopPos[maxLoop];

    // If, If_not & Else.
    char m_pszCondition[maxChar+1];
    BOOL m_isMatchedIF;
    BOOL m_isMatchedELSE;
    BOOL m_isSkipELSE;

    // { & }.
    BOOL m_isMatchedBegin;

// While 
	BOOL m_isSkipWhile;
	
public:
    BOOL m_isEOF;                       
    enum { maxFileNo = 5};//20 };
    
// Implementations.
private:
    void CheckInnerCommand(char* pszIncLine);
    BOOL CommandParse(void);
    void CommandKernel(void);
    void ExecuteInnerCommand(void);

    void MacroIf(void);
    void MacroIfnot(void);
    void MacroElse(void);
    void MacroWhile(void);
    void MacroBeginMark(void);
    void MacroEndMark(void);
    void MacroRem(void);
    void MacroBell(void);
    void MacroError(void);
    void MacroGoto(void);
    void MacroLoop(void);
    void MacroLoopend(void);
    void MacroPause(void); 
    void MacroWait(void);

    BOOL IsLabel(char* pszArgv) const;
    
    void GotoLabel(void);

    BOOL JudgeCondition(void);
    void PassBlockBranch(void);
    BOOL SearchELSE(void);
    void SkipELSE(void);

    int TestKey(WORD wKey);
    
public:
    BOOL MacroAction(int nArgc, char* pszArgv[]);

    void ReadOneLine(char* pszBuf);
    BOOL MacroFilter(char* pszMacroLine);
    void CreateMacro(char* pszMacroName);
    void CloseMacro();
    void DefineMacro(char* pszBuf);
    void DelMacro(char* pszMacroName);
	BOOL ShowMacro(char* pszMacroName);
	
};  // End of class: CMacroFile.

#endif
//////////////////////////////// End of File ////////////////////////////////
    
