
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SHLWIN.H__   1.7.1.0.1.2   09 Dec 1996 10:14:18   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SHLWIN.H__  $
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:14:18   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:57:32   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:13:42   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:25:16   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:52:22   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:44:50   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:50:04   ZJRD
** No change.
** 
**    Rev 1.7   11 Jun 1996 10:24:30   ZJRD
** EasyPack/SLD Version 1.97
** 
**    Rev 1.5   05 Jun 1996 14:52:12   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:28:18   ZJRD
** EasyPack/SLD Version 1.95
** 
**    Rev 1.3   16 May 1996 09:08:40   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:08:10   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:25:38   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:03:10   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:37:14   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:50:12   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:02:40   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:27:56   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:43:32   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:16:26   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:19:04   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:18:58   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:35:08   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:25:56   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:08:00   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:17:08   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:14:14   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.16   30 Nov 1995 09:14:30   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:35:08   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:24:24   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:25:06   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:29:32   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:32:58   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:44:56   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:04:42   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:47:36   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:45:28   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:26:50   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:49:44   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:23:22   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:48:30   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:53:14   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:47:56   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:22   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SHLWIN.H
//
//  Description:The header file for the class: CShellWindow
//
//  Author:     Roger Zhang
//
//  Date:       03/10/95
//
//  Modification:
//
//      1. 03/10/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _SHLWIN_
#define _SHLWIN_

/////////////////////////////////////////////////////////////////////////////
// CShellWindow frame

class CShellWindow : public CMDIChildWnd
{
    DECLARE_DYNCREATE(CShellWindow)
public:
    CShellWindow();         
    BOOL Create(LPCSTR szTitle, LONG style = 0,
        const RECT& rect = rectDefault, CMDIFrameWnd * pParent = NULL );

// Attributes
public:
    enum { MSGBARHT = 20 };
    enum { SHLHZEDGE = 4, SHLVTEDGE = 4 };
// Operations
public:
    void AddDispLine(char * pch, int nLen, BOOL isWS);
    void OvrDispLine(char * pch, int nLen);
    void StopAsm();
    void RunInclude(const char * pszFileName);
    void RunMacro(const char * pszFileName, int nLen);    

// Implementation
protected:
    static CMenu NEAR m_menu;
    CMessageBar m_MsgBar;
    HistoryList m_Hist;
    ShellBuffer m_Buf;

	// Rabit
    ShellEditor1 m_SEdit;
    //ShellEditor m_SEdit;

    int m_nFont;
    CSize m_szFont;    
    CSize m_szClient;
    CRect m_rectScroll;
    CPoint m_ptBuf;
    BOOL m_isCaretOn;
    BOOL m_isCaretVisible;    
    BOOL m_isScrolling;      
    BOOL m_isEdting;  
    BOOL m_isAsm; 
    int m_nRsv;       

    virtual ~CShellWindow();
    
	void ShowHints(void);
    void AddCommand(char * pch, int nLen);
    void SetCaret();
    void ScrollHorz(int nIdx);
    void ScrollVert(int nIdx);    
    BOOL IsHorzIn(void);
    BOOL IsVertIn(void);  
    void RestoreInput(void);  
    void HorzAjust(void);
    void VertAjust(void);
    void RedrawEdit(void);  
    void OnReturn(void);
    void OnMoveCaret(void);        
    void AddInputLine(void);
    void SwitchCaret(void);
    BOOL RecallPrev(void);
    BOOL RecallNext(void);
    
    // Generated message map functions
    //{{AFX_MSG(CShellWindow)
    afx_msg void OnChildActivate();
    afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
    afx_msg void OnPaint();
    afx_msg void OnSize(UINT nType, int cx, int cy);
    afx_msg void OnKillFocus(CWnd* pNewWnd);
    afx_msg void OnSetFocus(CWnd* pOldWnd);
    afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
    afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
    afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
    afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
    afx_msg void OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI);
    afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
    afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
    afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
    afx_msg void OnMDIActivate(BOOL bActivate, CWnd* pActivateWnd, CWnd* pDeactivateWnd);
    afx_msg void OnFileOpenlogfile();
    afx_msg void OnFileLoggingoff();
    afx_msg void OnUpdateFileLoggingoff(CCmdUI* pCmdUI);
    afx_msg void OnFileLoggingon();
    afx_msg void OnUpdateFileLoggingon(CCmdUI* pCmdUI);
    afx_msg void OnUpdateFileOpenlogfile(CCmdUI* pCmdUI);
    afx_msg void OnFileCloselogfile();
    afx_msg void OnUpdateFileCloselogfile(CCmdUI* pCmdUI);
    afx_msg void OnOptionsSethistorysize();
    //}}AFX_MSG
    DECLARE_MESSAGE_MAP()
};

#endif
//////////////////////////////(EOF)//////////////////////////////////////////
