/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SPABP.CPP   1.3.1.0.1.2   09 Dec 1996 10:16:06   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SPABP.CPP  $
** 
**    Rev 1.3.1.0.1.2   09 Dec 1996 10:16:06   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.3.1.0.1.0   11 Nov 1996 12:59:22   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.3.1.4   09 Sep 1996 13:18:06   ZJRD
** No change.
** 
**    Rev 1.3.1.3   05 Sep 1996 11:29:38   ZJRD
** No change.
** 
**    Rev 1.3.1.2   02 Sep 1996 09:56:42   ZJRD
** No change.
** 
**    Rev 1.3.1.1   28 Aug 1996 15:52:32   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.3.1.0   12 Aug 1996 10:56:00   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.3   11 Jun 1996 10:24:46   ZJRD
** EasyPack/SLD Version 1.97
** 
**    Rev 1.1   05 Jun 1996 14:52:32   ZJRD
** EasyPack/SLD Version 1.96
** 
**    Rev 1.0   29 May 1996 09:36:08   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SPABP.CPP
//
//  Description: The implementation file for the class: CSpaBpSetDlg.
//
//  Author: Chen Jun
//
//  Date: 05/27/96
//
//  Modification:
//      1. 05/27/96, Initial version of the class: CSpaBpSetDlg.
//
//  Copyright (C) 1996 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include "spagrp.h"
#include "spabp.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// External variables.
int SrcIsLoaded(void);
int SpaGetModule(CStringList* &pList);
int SpaGetFunction(const CString& strModule, CStringList* &pList);


/////////////////////////////////////////////////////////////////////////////
// CSpaBpSetDlg dialog

CSpaBpSetDlg::CSpaBpSetDlg(CSpaGroupSheet* pSheet, CWnd* pParent /*=NULL*/)
	: CDialog(CSpaBpSetDlg::IDD, pParent),
	m_pSheet(pSheet)
{
	//{{AFX_DATA_INIT(CSpaBpSetDlg)
	m_strBp = _T("");
	m_nFunction = -1;
	m_nModule = -1;
	//}}AFX_DATA_INIT

	pSheet->m_nErrorID = pSheet->errOK;
}


void CSpaBpSetDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSpaBpSetDlg)
	DDX_Control(pDX, IDC_STATIC_MODULE, m_staticModule);
	DDX_Control(pDX, IDC_STATIC_FUNCTION, m_staticFunction);
	DDX_Control(pDX, IDC_BUTTON_SPA_APPLY, m_btnApply);
	DDX_Control(pDX, IDC_LIST_SPA_BROWSE_MODULE, m_listModule);
	DDX_Control(pDX, IDC_LIST_SPA_BROWSE_FUNCTION, m_listFunction);
	DDX_Text(pDX, IDC_EDIT_SPA_BP, m_strBp);
	DDV_MaxChars(pDX, m_strBp, 80);
	DDX_LBIndex(pDX, IDC_LIST_SPA_BROWSE_FUNCTION, m_nFunction);
	DDX_LBIndex(pDX, IDC_LIST_SPA_BROWSE_MODULE, m_nModule);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSpaBpSetDlg, CDialog)
	//{{AFX_MSG_MAP(CSpaBpSetDlg)
	ON_LBN_SELCHANGE(IDC_LIST_SPA_BROWSE_MODULE, OnSelchangeListSpaBrowseModule)
	ON_BN_CLICKED(IDC_BUTTON_SPA_APPLY, OnButtonSpaApply)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSpaBpSetDlg common routines

void CSpaBpSetDlg::UpdateModuleInfo(void)
{
	// Get the module info from Symbol server.
	m_nModule = 0;
	m_listModule.ResetContent();

	CStringList* pList = new CStringList;
	if ( 0 == ::SpaGetModule(pList) ) {
	    if ( !pList->IsEmpty() ) {
	        POSITION posHead = pList->GetHeadPosition();
	        while ( posHead ) {
	            m_listModule.AddString(pList->GetNext(posHead));
	        }
	    }
			
		if ( m_listModule.GetCount() > 0 ) {
			m_nModule = 0;
			m_listModule.SetCurSel(m_nModule);
		}
	}

	pList->RemoveAll();
	delete pList;
}

void CSpaBpSetDlg::UpdateFunctionInfo(void)
{
	// Get the current module.
	if ( m_listModule.GetCount() > 0 ) {
		CString strModule;
		m_listModule.GetText(m_nModule, strModule);

		// Get the function info from Symbol server.
		m_nFunction = 0;
		m_listFunction.ResetContent();
	
		CStringList* pList = new CStringList;
		if ( 0 == ::SpaGetFunction(strModule, pList) ) {
		    if ( !pList->IsEmpty() ) {
		        POSITION posHead = pList->GetHeadPosition();
		        while ( posHead ) {
		            m_listFunction.AddString(pList->GetNext(posHead));
		        }
		    }
				
			if ( m_listFunction.GetCount() > 0 ) {
				m_nFunction = 0;
				m_listFunction.SetCurSel(m_nFunction);
			}
		}
		pList->RemoveAll();
		delete pList;
	}
}

void CSpaBpSetDlg::CheckInputSyntax(void)
{
	// No any error now.
	ASSERT(m_pSheet->errOK == m_pSheet->m_nErrorID);

	// Check Define Range.
	m_strBp.TrimLeft();
	m_strBp.TrimRight();
	if ( m_strBp.IsEmpty() || m_strBp.GetLength() > 80 ) {
		m_pSheet->m_nErrorID = m_pSheet->errInput;
		return;
	}
	
	if ( !m_pSheet->IsValidAddr(m_strBp) ) {
		m_pSheet->m_nErrorID = m_pSheet->errInput;
		return;
	}
}

void CSpaBpSetDlg::DisableControl(void)
{
	// Disable controls.
	m_listModule.EnableWindow(FALSE);
	m_listFunction.EnableWindow(FALSE);
	m_staticModule.EnableWindow(FALSE);
	m_staticFunction.EnableWindow(FALSE);
	m_btnApply.EnableWindow(FALSE);
}


/////////////////////////////////////////////////////////////////////////////
// CSpaBpSetDlg message handlers

BOOL CSpaBpSetDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	
    // Centering dialog box.
    CenterWindow();
    const int cxExtent = 200;
    m_listModule.SetHorizontalExtent(cxExtent);
    m_listFunction.SetHorizontalExtent(cxExtent);

    HFONT hFont = (HFONT)::GetStockObject(ANSI_FIXED_FONT);
    CFont font;
	m_listModule.SetFont(font.FromHandle(hFont));
	m_listFunction.SetFont(font.FromHandle(hFont));

	// Get the module info from Symbol server.
	if ( 0 == ::SrcIsLoaded() ) {
		UpdateModuleInfo();
		UpdateFunctionInfo();
		if ( m_listModule.GetCount() <= 0 &&
			 m_listFunction.GetCount() <= 0 ) {
			DisableControl();
		}
	}
	else {
		DisableControl();
	}
		
    UpdateData(FALSE);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSpaBpSetDlg::OnOK() 
{
	// TODO: Add extra validation here

	// Check input syntax.
	UpdateData();
	CheckInputSyntax();
	if ( m_pSheet->errOK != m_pSheet->m_nErrorID ) {
		m_pSheet->DisplayErrorMessage();
		return;
	}

	CDialog::OnOK();
}

void CSpaBpSetDlg::OnSelchangeListSpaBrowseModule() 
{
	// TODO: Add your control notification handler code here
	
	// Get the function info according to the module ID.
	UpdateData();
	UpdateFunctionInfo();
	UpdateData(FALSE);
}

void CSpaBpSetDlg::OnButtonSpaApply() 
{
	// TODO: Add your control notification handler code here
	
	// Connect with symbol server.
	UpdateData();

	if ( m_listModule.GetCount() > 0 && m_listFunction.GetCount() > 0 ) {
		// Get the start address of the function.
		m_strBp = _T("");
		CString str;
		m_listModule.GetText(m_nModule, str);
		m_strBp += '#';
		m_strBp += str;

		m_listFunction.GetText(m_nFunction, str);
		m_strBp += '#';
		m_strBp += str;
	}

	UpdateData(FALSE);
}
