/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SPAFRM.CPP   1.0.1.2   09 Dec 1996 10:16:20   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SPAFRM.CPP  $
** 
**    Rev 1.0.1.2   09 Dec 1996 10:16:20   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.0.1.0   11 Nov 1996 12:59:36   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.4   09 Sep 1996 13:18:44   ZJRD
** No change.
** 
**    Rev 1.3   05 Sep 1996 11:30:14   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 09:57:18   ZJRD
** No change.
** 
**    Rev 1.1   28 Aug 1996 15:52:34   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.0   12 Aug 1996 10:56:00   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SPAFRM.CPP
//
//  Description: The implementation file for the class: CSpaCodeFrame.
//
//  Author: Chen Jun
//
//  Date: 06/19/96
//
//  Modification:
//      1. 06/19/96, Initial version of the class: CSpaCodeFrame.
//
//  Copyright (C) 1996 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include "spamsg.h"
#include "spafrm.h"
#include "spaline.h"
#include "spatdoc.h"
#include "spatvw.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Global variables.
CMultiDocTemplate* pSpaDocTemplate;
CSpaCodeFrame* pSpaCodeWnd = 0;

int SpaGetModule(CStringList* &pList);
CString SrcGetModuleFullName(const char * pszModuleName);


/////////////////////////////////////////////////////////////////////////////
// Public function
void OpenCodeCoverageWindow(void)
{
	// Open the code coverage window.
	ASSERT(!::pSpaCodeWnd);
	::pSpaDocTemplate->OpenDocumentFile(NULL);
}

void CloseCodeCoverageWindow(void)
{
	// Close the code coverage window.
	ASSERT(::pSpaCodeWnd);
	::pSpaCodeWnd->SendMessage(WM_CLOSE);
}

void UpdateCodeCoverageWindow(const COVERAGEGETINFO& CodeData)
{
	// Update the code coverage window.
	ASSERT(::pSpaCodeWnd);
	::pSpaCodeWnd->UpdateCoverageWindow(CodeData);
}


/////////////////////////////////////////////////////////////////////////////
// CSpaCodeFrame

IMPLEMENT_DYNCREATE(CSpaCodeFrame, CMDIChildWnd)

CSpaCodeFrame::CSpaCodeFrame()
{
	// Point to this frame window.
	::pSpaCodeWnd = this;
}

CSpaCodeFrame::~CSpaCodeFrame()
{
	// Point to NULL.
	::pSpaCodeWnd = 0;
}


BEGIN_MESSAGE_MAP(CSpaCodeFrame, CMDIChildWnd)
	//{{AFX_MSG_MAP(CSpaCodeFrame)
	ON_WM_CREATE()
	ON_WM_SETCURSOR()
	ON_CBN_SELCHANGE(IDC_COMBO_SPA_MESSAGEBAR_MODULE, OnSelchangeComboSpaMessagebarModule)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSpaCodeFrame common routine

void CSpaCodeFrame::UpdateCoverageWindow(const COVERAGEGETINFO& CodeData)
{   
	// Transfer data from FW.
	((CSpaTextDoc*)GetActiveDocument())->SetCoverageData(CodeData);
	
	// Update the view.
	OnSelchangeComboSpaMessagebarModule();
}

void CSpaCodeFrame::UpdateMessageBar(void)
{
	// Update module info.
	UpdateModuleInfo();
}

void CSpaCodeFrame::UpdateModuleInfo(void)
{
	// Set the module info.
	CComboBox* pWnd = (CComboBox*)m_wndMsgBar.GetDlgItem(IDC_COMBO_SPA_MESSAGEBAR_MODULE);
	pWnd->ResetContent();

	CStringList* pList = new CStringList;
	if ( 0 == ::SpaGetModule(pList) ) {
	    if ( !pList->IsEmpty() ) {
	        POSITION posHead = pList->GetHeadPosition();
	        while ( posHead ) {
	            pWnd->AddString(pList->GetNext(posHead));
	        }
	    }
			
		if ( pWnd->GetCount() > 0 ) {
			pWnd->SetCurSel(0);
		}
	}
	pList->RemoveAll();
	delete pList;
}


/////////////////////////////////////////////////////////////////////////////
// CSpaCodeFrame message handlers

int CSpaCodeFrame::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CMDIChildWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
	
    // Create the message bar.
    if ( !m_wndMsgBar.Create(this, IDD_SPA_MESSAGEBAR, CBRS_TOP, IDD_SPA_MESSAGEBAR) ) {
        return -1;
    }
    else {
		// Set the combo box contents.
		UpdateMessageBar();
	}

	return 0;
}

BOOL CSpaCodeFrame::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) 
{
	// TODO: Add your message handler code here and/or call default
	
    // Disable parent window from pre-handling the WM_RBUTTONDOWN message.
    // MAINFRM latch WM_RBUTTONDOWN to implement local menu.
    if ( WM_RBUTTONDOWN == message ) {
        return FALSE;
    }

	return CMDIChildWnd::OnSetCursor(pWnd, nHitTest, message);
}

void CSpaCodeFrame::OnSelchangeComboSpaMessagebarModule() 
{
	// TODO: Add your control notification handler code here

	// Get from the combo box.
	CString str;
	CComboBox* pModule = (CComboBox*)m_wndMsgBar.GetDlgItem(IDC_COMBO_SPA_MESSAGEBAR_MODULE);
	pModule->GetWindowText(str);

	// Convert the full path name.
	str = ::SrcGetModuleFullName(str);

	// Set the module path.
	CEdit* pPath = (CEdit*)m_wndMsgBar.GetDlgItem(IDC_EDIT_SPA_MESSAGEBAR_PATH);
	pPath->SetWindowText(str);
	
	// Update the view.
	BeginWaitCursor();
	((CSpaTextView*)GetActiveView())->UpdateCoverageInfo(str);
	EndWaitCursor();
}
