
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SPIN.H__   1.7.1.0.1.2   09 Dec 1996 10:16:50   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SPIN.H__  $
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:16:50   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 13:00:04   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:20:02   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:31:32   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:58:36   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:50:52   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:54:42   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:57:44   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:34:30   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 08:59:56   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:16:30   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:30:50   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:55:58   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:34:58   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:49:26   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:04:52   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:31:28   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:46:18   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:19:50   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:16:42   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:16:36   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:34:30   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:25:18   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:08:02   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:17:10   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:14:16   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:14:30   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:35:10   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:24:26   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:25:08   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:29:34   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:33:00   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:44:58   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:04:44   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:47:38   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:45:30   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:26:50   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:49:46   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:23:22   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:48:28   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:53:16   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:47:56   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:22   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SPIN.H
//
//  Description:The header file for the class: CSpinControl
//
//  Author:     Roger Zhang
//
//  Date:       03/08/95
//
//  Modification:
//
//      1. 03/08/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#ifndef _SPIN_
#define _SPIN_

//Control-specific messages
#define MSM_HWNDASSOCIATESET  (WM_USER+1)
#define MSM_HWNDASSOCIATEGET  (WM_USER+2)
#define MSM_DWRANGESET        (WM_USER+3)
#define MSM_DWRANGEGET        (WM_USER+4)
#define MSM_WCURRENTPOSSET    (WM_USER+5)
#define MSM_WCURRENTPOSGET    (WM_USER+6)
#define MSM_FNOPEGSCROLLSET   (WM_USER+7)
#define MSM_FNOPEGSCROLLGET   (WM_USER+8)
#define MSM_FINVERTRANGESET   (WM_USER+9)
#define MSM_FINVERTRANGEGET   (WM_USER+10)
#define MSM_CRCOLORSET        (WM_USER+11)
#define MSM_CRCOLORGET        (WM_USER+12)

//Message API Functions
HWND     FAR PASCAL MSHAssociateSet(HWND hWnd, HWND hWndAssociate);
HWND     FAR PASCAL MSHAssociateGet(HWND hWnd);
DWORD    FAR PASCAL MSDwRangeSet(HWND hWnd, WORD iMin, WORD iMax);
DWORD    FAR PASCAL MSDwRangeGet(HWND hWnd);
WORD     FAR PASCAL MSWCurrentPosSet(HWND hWnd, WORD iPos);
WORD     FAR PASCAL MSWCurrentPosGet(HWND hWnd);
BOOL     FAR PASCAL MSFNoPegScrollSet(HWND hWnd, BOOL fNoPegScroll);
BOOL     FAR PASCAL MSFNoPegScrollGet(HWND hWnd);
BOOL     FAR PASCAL MSFInvertRangeSet(HWND hWnd, BOOL fInvertRange);
BOOL     FAR PASCAL MSFInvertRangeGet(HWND hWnd);
COLORREF FAR PASCAL MSCrColorSet(HWND hWnd, WORD iColor, COLORREF cr);
COLORREF FAR PASCAL MSCrColorGet(HWND hWnd, WORD iColor);

//Notification codes sent via WM_COMMAND from the control.
#define MSN_ASSOCIATEGAIN   1
#define MSN_ASSOCIATELOSS   2
#define MSN_RANGECHANGE     3

//Color indices for MSM_COLORSET/GET and MSCrColorSet/Get
#define MSCOLOR_FACE        0
#define MSCOLOR_ARROW       1
#define MSCOLOR_SHADOW      2
#define MSCOLOR_HIGHLIGHT   3
#define MSCOLOR_FRAME       4

#define CCOLORS             5

//Control specific styles.
#define MSS_VERTICAL        0x0001L
#define MSS_HORIZONTAL      0x0002L
#define MSS_NOPEGSCROLL     0x0004L
#define MSS_TEXTHASRANGE    0x0008L
#define MSS_INVERTRANGE     0x0010L

class CSpinControl : public CWnd
{
    DECLARE_DYNAMIC(CSpinControl)

// Constructors
public:
    CSpinControl();
    BOOL Create(DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID);

// Attributes
    CWnd* GetAssociate();
    void SetAssociate(CWnd* pNew);
    void GetRange(UINT& iMin, UINT& iMax);
    void SetRange(UINT iMin, UINT iMax);
    UINT GetCurrentPos();
    void SetCurrentPos(UINT iPos);
    // there are more APIs not wrapped here

// Implementation
protected:
    virtual WNDPROC* GetSuperWndProcAddr();
};

/////////////////////////////////////////////////////////////////////////////
// inlines
inline CSpinControl::CSpinControl() {}
inline CWnd* CSpinControl::GetAssociate()
{ return CWnd::FromHandle((HWND)SendMessage(MSM_HWNDASSOCIATEGET)); }
inline void CSpinControl::SetAssociate(CWnd* pNew)
{ SendMessage(MSM_HWNDASSOCIATESET, (UINT)pNew->GetSafeHwnd()); }
inline void CSpinControl::GetRange(UINT& iMin, UINT& iMax)
{ DWORD dw = SendMessage(MSM_DWRANGEGET);
        iMin = LOWORD(dw); iMax = HIWORD(dw);
}
inline void CSpinControl::SetRange(UINT iMin, UINT iMax)
{ SendMessage(MSM_DWRANGESET, 0, MAKELONG(iMin, iMax)); }
inline UINT CSpinControl::GetCurrentPos()
{ return (UINT)SendMessage(MSM_WCURRENTPOSGET); }
inline void CSpinControl::SetCurrentPos(UINT iPos)
{ SendMessage(MSM_WCURRENTPOSSET, iPos); }

#endif

//////////////////////////////(EOF)//////////////////////////////////////////
