
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SRCLIST.CPP   1.7.1.0.1.2   09 Dec 1996 10:17:06   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SRCLIST.CPP  $
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:17:06   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 13:00:22   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:20:54   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:32:22   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:59:28   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:46:24   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.6   10 Jun 1996 10:21:44   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:32:04   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:03:16   ZJRD
** EasyPack/SLD Version 1.94
** 
**    Rev 1.1   02 May 1996 10:24:00   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:53:06   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:39:56   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:53:34   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:10:20   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:36:42   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:50:58   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:12:14   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:15:20   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:15:12   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:38:48   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:23:58   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:08:42   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:13:36   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:07:58   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:10:30   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:31:20   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:18:42   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:27:30   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:32:56   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:31:20   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:42:54   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:03:46   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:50:24   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:42   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:31:58   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:47:50   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:20:34   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:48:40   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:55:16   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:47:36   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:55:02   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SRCLIST.CPP
//
//  Description:The implement file for the class: 
//                  SyntaxColorList
//                  TabExpandList
//                  SourceIndexList
//                  SourceList
//
//  Author:     Roger Zhang
//
//  Date:       06/10/95
//
//  Modification:
//
//      1. 06/10/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include "zqueue.h"                                      
#include "srccom.h"                                      
#include "zlist.h"                    
#include "srclist.h"

///////////////////////////////////////////////////////////////////////////// 
// Syntax color list 
/////////////////////////////////////////////////////////////////////////////
#ifdef _DEBUG
void SyntaxColorElement::Dump(void) const
{         
    #ifdef _FDEBUG
        fprintf(pSListDebug, "m_nFirstCol = %n, m_nLastCol = %n\n", 
            m_nFirstCol, m_nLastCol);
        if(m_nSyntaxType == CSYN_CODE)
            fprintf(pSListDebug, "Syntax Type : Code\n");    
        else if(m_nSyntaxType == CSYN_KEYWORD)
            fprintf(pSListDebug, "Syntax Type : Keyword\n");    
        if(m_nSyntaxType == CSYN_COMMENT)
            fprintf(pSListDebug, "Syntax Type : Comment\n");    
    #else
        TRACE("m_nFirstCol = %n, m_nLastCol = %n\n", m_nFirstCol, m_nLastCol);
        if(m_nSyntaxType == CSYN_CODE)
            TRACE("Syntax Type : Code\n");    
        else if(m_nSyntaxType == CSYN_KEYWORD)
            TRACE("Syntax Type : Keyword\n");    
        if(m_nSyntaxType == CSYN_COMMENT)
            TRACE("Syntax Type : Comment\n");    
    #endif
}
#endif

#ifdef _DEBUG
void SyntaxColorList::Dump(void) const
{                                
    #ifdef _FDEBUG
        fprintf(pSListDebug, "--Dump Syntax Color List--\n");
    #else
        TRACE("--Dump Syntax Color List--\n");
    #endif
    SingleList::Dump();
}
#endif

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
int SyntaxColorList::AddElement(int nFirst, int nLast, int nType)
{   
    ASSERT(nFirst <= nLast);
    
    SyntaxColorElement * p;
    
    if(IsFull())  return ELIST_FULL;                            
    if(!IsEmpty()) {
        p = (SyntaxColorElement *)(m_pTail->m_pElem);
        if(p->m_nSyntaxType == nType) {
            p->m_nLastCol = nLast;  return ELIST_OK;
        }
    }
    p = new SyntaxColorElement(nFirst, nLast, nType);
    if(!p)  return  ELIST_MEM;
    else    return  AddTail(p);
}                              

///////////////////////////////////////////////////////////////////////////// 
// Tab Expand List 
/////////////////////////////////////////////////////////////////////////////
#ifdef _DEBUG
void TabExpandElement::Dump(void) const
{                            
    #ifdef _FDEBUG
        fprintf(pSListDebug, "m_nTabPos = %n, m_nTabAdd = %n\n", 
            m_nTabPos, m_nTabAdd);
    #else
        TRACE("m_nTabPos = %n, m_nTabAdd = %n\n", m_nTabPos, m_nTabAdd);
    #endif
}
#endif

#ifdef _DEBUG
void TabExpandList::Dump(void) const
{       
    #ifdef _FDEBUG
        fprintf(pSListDebug, "--Dump Tab Expand List--\n");
    #else
        TRACE("--Dump Tab Expand List--\n");
    #endif
    SingleList::Dump();
}
#endif

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
int TabExpandList::AddElement(int nPos, int nAdd)
{
    if(IsFull())  return ELIST_FULL;
    TabExpandElement * p = new TabExpandElement(nPos, nAdd);
    if(!p)  return  ELIST_MEM;
    else    return  AddTail(p);
}                                   
 
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: Search nPos in the List
//
//  Input:  
//
//  Output: 
//
//  Return: nTabAdd -- expanded number 
//
/////////////////////////////////////////////////////////////////////////////
int TabExpandList::Search(int nPos) const
{
    if(IsEmpty()) return  0;
    SListNode * p = m_pHead;              
    TabExpandElement * p1;
    do {   
        p1 = (TabExpandElement *)(p->m_pElem);
        if(p1->m_nTabPos == nPos)   return  p1->m_nTabAdd;
    } while((p = p->m_pNext)!=0);                         
    return  0;
}
 
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: position after expanded 
//
/////////////////////////////////////////////////////////////////////////////
int TabExpandList::Expand(int nPos) const
{
    if(IsEmpty()) return  nPos;
    SListNode * p = m_pHead;              
    TabExpandElement * p1;
    int n = nPos;
    do {   
        p1 = (TabExpandElement *)(p->m_pElem);
        if(p1->m_nTabPos < nPos) n += p1->m_nTabAdd;   
        else break;
    } while((p = p->m_pNext)!=0);                         
    return  n;
}
                    
///////////////////////////////////////////////////////////////////////////// 
// Source index list 
/////////////////////////////////////////////////////////////////////////////
#ifdef _DEBUG
void SourceIndexElement::Dump(void) const
{       
    #ifdef _FDEBUG
        fprintf(pSListDebug, "m_pSrc = %p, m_nIdx = %ld\n", m_pSrc, m_nIdx);
    #else  
        TRACE("m_pSrc = %p, m_nIdx = %ld\n", m_pSrc, m_nIdx);
    #endif
}
#endif

#ifdef _DEBUG
void SourceIndexList::Dump(void) const
{       
    #ifdef _FDEBUG
        fprintf(pSListDebug, "--Dump Source Index List--\n");
    #else
        TRACE("--Dump Source Index List--\n");
    #endif
    SingleList::Dump();
}
#endif

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
int SourceIndexList::AddElement(SListNode * pSrc, int nIdx)
{
    ASSERT(pSrc);
    
    if(IsFull())  return ELIST_FULL;
    SourceIndexElement * p = new SourceIndexElement(pSrc, nIdx);
    if(!p)  return  ELIST_MEM;
    else    return  AddTail(p);
} 

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
SourceIndexElement * SourceIndexList::Search(int nIdx)
{
    SourceIndexElement * p = (SourceIndexElement *)GetFirst();
    while(p) {
        if(nIdx >= p->m_nIdx && nIdx < p->m_nIdx + INDEX_DELTA)
            return p;
        p = (SourceIndexElement *)GetNext();
    }
    return  0;
}

///////////////////////////////////////////////////////////////////////////// 
// Source List 
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
SourceElement::~SourceElement(void)
{
    if(m_nLength)    delete [] m_szLine;
}

#ifdef _DEBUG
void SourceElement::Dump(void) const
{       
    #ifdef _FDEBUG
        if(m_nLength > 0)
            fprintf(pSListDebug, "m_szLine = %s, m_nLength = %n\n", 
                m_szLine, m_nLength);
        else
            fprintf(pSListDebug, "m_szLine = (null), m_nLength = 0\n");
    #else  
        if(m_nLength > 0)
            TRACE("m_szLine = %s, m_nLength = %n\n", m_szLine, m_nLength);
        else
            TRACE("m_szLine = (null), m_nLength = 0\n");
    #endif    
    m_Color.Dump();
    m_Tab.Dump();
}
#endif

#ifdef _DEBUG
void SourceList::Dump(void) const
{       
    #ifdef _FDEBUG
        fprintf(pSListDebug, "--Dump Source List--\n");
    #else
        TRACE("--Dump Source List--\n");
    #endif
    SingleList::Dump();
}
#endif

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
SourceElement * SourceList::Search(SListNode * pIdx, int nDelta)
{
    Set(pIdx);
    SourceElement * p = (SourceElement *)Get();
    while(nDelta--) p = (SourceElement *)GetNext();
    return p;
}
        

/////////////////////////////(EOF)///////////////////////////////////////////
