
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/STKLOCAL.H__   1.7.1.0.1.2   09 Dec 1996 10:14:02   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/STKLOCAL.H__  $
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:14:02   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:57:18   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:13:08   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:24:40   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:51:46   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:43:28   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:48:58   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:51:14   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:28:00   ZJRD
** EasyPack/SLD Version 1.95
** 
**    Rev 1.3   16 May 1996 08:59:42   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:08:02   ZJRD
** EasyPack/SLD Version 1.93
** 
**    Rev 1.1   02 May 1996 10:22:34   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:53:00   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:33:48   Shirley
** No change.
** 
**    Rev 1.29   02 Apr 1996 09:22:28   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:48:12   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:02:02   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:27:16   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:42:54   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:11:30   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:12:02   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:12:42   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:36:20   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:24:46   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:09:08   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:12:08   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:14:38   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:09:50   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:30:40   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:20:20   Shirley
** EasyPack/SLD Version 0.31
** 
**    Rev 1.13   13 Nov 1995 09:23:02   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:32:04   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:34:08   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:44:54   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:04:40   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:47:36   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:45:26   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:26:48   Shirley
** EasyPack/SLD Version 0.1f
** 
**    Rev 1.5   18 Oct 1995 14:49:42   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:18:58   Shirley
** EasyPack/SLD Version 0.1d
** 
**    Rev 1.3   29 Sep 1995 09:48:50   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:57:14   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:52   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:53:36   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: STKLOCAL.H
//
//  Description: The header file for the class: CStackLocalView.
//
//  Author: Chen Jun
//
//  Date: 07/18/95
//
//  Modification:
//      1. 07/18/95, Initial version of the class: CStackLocalView.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _STKLOCAL_
#define _STKLOCAL_


/////////////////////////////////////////////////////////////////////////////
// CStackLocalView view

class CStackLocalView : public CView
{
    DECLARE_DYNCREATE(CStackLocalView)
public:
    CStackLocalView();          // protected constructor used by dynamic creation
    void InitialMember(void);
    void ClearMember(void);

// Attributes
public:
    CStackDoc* GetDocument();

public:
    int m_nMaxRow;
    int m_nMaxCol;

    int m_nCurRow;
    int m_nCurCol;

	int m_nRowSize;
	int m_nColSize;

	int m_nStartRow;
	int m_nStartCol;
		
    CRect m_rectClient;

private:
    int m_nClientLine;  // Indicate the start line in the client area.
    int m_nFocus;
    
private:
    enum { bottomHeight = 20 };
    int m_nFontWidth;
    int m_nFontHeight;

private:
    enum { caretWidth = 2 };
    int m_xCaret;
    int m_yCaret;

// Operations
private:
    enum {
        noError = 0,        // No error.
        insufficientMemory, // Insufficient memory.
        bmpLoad,            // Cannot load VAR_xxx bitmap.
        invalidLevel,
        hasError,
        maxError = 10       // Limition of error ID.
    };
    BOOL m_nErrorID;
    
    void DisplayErrorMessage(void) const;

private:
    enum { 
        pageUnit = 30,
        lineUnit = 1,
        pageScroll = 1,
        limitRow = 400,
        limitColumn = 400
    };
    int m_nLimitLine;
    int m_nLimitColumn;
//    void UpdateScrollSizes(void);

private:
    enum {
        bmpWidth = 16,
        bmpHeight = 13,
    };
    CBitmap m_bmpInvalid;
    CBitmap m_bmpSimple;
    CBitmap m_bmpOpen;
    CBitmap m_bmpClose;
    
    BOOL AllocateBitmap(void);
    void ReleaseBitmap(void);
    void DisplayBitmap(CDC* pDC, const int xPos, const int yPos);

public:
    enum {
        invalidSign = 0,
        simpleSign,
        openSign,
        closeSign
    };
    int m_nBmpStatus;
    void DetectVarFormat(void);

private:
    CString m_strName;
    CString m_strValue;
    CString m_strResult;

public:
    struct VarNode* m_pVarNode;
    void OutputAllVariable(CDC* pDC);
	void OutputOneVariable(CDC* pDC , int nLine);
    void UpdateBottomPane(void);

//private:
//    void UpdateModifiedRegion(BOOL bAdjustScrollRange);
//    void UpdateMarkLine(int nMarkLine);
//    void UpdateToLine(int nLine);
        
private:
    BOOL m_bCaretOn;
    void TurnOnCaret(void);
    void TurnOffCaret(void);
        
private:
    int m_nScrollBox;
    BOOL m_bAdjustScrollBox;
    BOOL m_bAdjustScrollRange;
    int m_nHScroll;
    int m_nVScroll;   

    void ResizeScroll();        
    void ResizeScrollBarRange();        

//    void AssumeScrollBox(void);
//    void RestoreScrollBox(void);
// Implementation
public:
    // Public function.
    void UpdateLocalWindow(int nLevel);
    void UpdateLocalWindow(void);
    
    void DeleteOneNode(void);
    BOOL IsEmpty(void);
    void GetHighlightName(CString& strName);
    void GetHighlightValue(CString& strValue);
    void SearchToken(CString& strToken);
    void SearchNextToken(CString& strToken);
    BOOL ModifyValue(CString& strNewValue);
    void TypeCast(CString& strTypeCast);
    
protected:
    virtual ~CStackLocalView();    // protected destructor

    // Standard overrides of MFC classes.
    virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
    virtual void OnDraw(CDC* pDC);      // overridden to draw this view
    virtual void OnInitialUpdate();     // first time after construct
    virtual void OnPrepareDC(CDC* pDC, CPrintInfo* pInfo = NULL);

    // Generated message map functions
    //{{AFX_MSG(CStackLocalView)
    afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
    afx_msg void OnSize(UINT nType, int cx, int cy);
    afx_msg void OnSetFocus(CWnd* pOldWnd);
    afx_msg void OnKillFocus(CWnd* pNewWnd);
    afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
    afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
    afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
    afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message);
    afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
    afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
    afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
    afx_msg void OnPaint();
    //}}AFX_MSG
    DECLARE_MESSAGE_MAP()
};

#endif
//////////////////////////////// End of File ////////////////////////////////
