
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SYMBLSVR.H__   1.7.1.0.1.2   09 Dec 1996 10:16:02   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SYMBLSVR.H__  $
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:16:02   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:59:18   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:17:52   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:29:22   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:56:26   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:52:16   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:55:48   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:58:48   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:31:20   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:04:36   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:13:28   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:24:02   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:53:10   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:39:58   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:53:38   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:08:56   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:35:20   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:49:38   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:14:06   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:20:00   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:19:54   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:36:12   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:24:38   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:09:00   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:12:02   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:14:30   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.16   30 Nov 1995 09:09:42   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:30:34   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:20:12   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:22:54   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:31:58   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:34:02   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:44:48   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:04:34   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:47:28   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:45:20   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:26:42   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:49:36   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:21:18   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:49:16   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:56:50   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:49:30   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:53:28   Shirley
** Initial revision.
**
****************************************************************************/

/*----------------------------------------------------------------------------
** Name: symblsvr.h
**
** Title: Symbol Server
**
** Purpose:
**  External declarations of routines and data structures for loading
**  and accessing symbols included by all servers that access symbols
**  and by the loader for loading symbols.
**
** Status: PRELIMINARY
**
** $Log$
**
** $Header:   D:/EPSLDV1/SRC/LOG/SYMBLSVR.H__   1.7.1.0.1.2   09 Dec 1996 10:16:02   ZJRD  $
**
** Copyright (C) 1995 Microtek International.  All rights reserved.
**
**--------------------------------------------------------------------------*/

#ifndef _SYMBLSVR_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include "basewind.h"
#include <stdio.h>
#include "errcodec.h"

                       /****************************
                        *                          *
                        *      # DEFINITIONS       *
                        *                          *
                        ****************************/
#ifdef __cplusplus
extern "C" {
#endif


#define NULL_SYMBOL 0L     /* used to define the null pointer for symbol */
                           /* offsets */

#define MAX_SYMNAME_LENGTH 256  /* use for defining (LPSTR) string allocation
                                   size */
#define MAX_PATH_LENGTH    256
#define MAX_MODULE_NAME_LEN   64 

#define SYM_MAX_COLUMN 65535
#define DEFAULT_START_ADDR 0xFFFFFFFF
#define DEFAULT_END_ADDR   0
                       /**************************
                        *                        *
                        *    TYPE DEFINITIONS    *
                        *                        *
                        **************************/
typedef enum {
   DEBUG_DISPLAY,
   USER_DISPLAY,
   MODULE_DISPLAY,
   FUNCTION_DISPLAY,
   PUBLIC_DISPLAY,
   LINES_DISPLAY,
   VARLIFE_DISPLAY
} SYM_DISPLAY_TYPE;

/*  basic type  definitions */
typedef char FAR *LPSTR;
typedef U16 LINENUM_TYPE;
typedef U16 COLUMN_TYPE;
typedef U32 OFFSET_ADDR_TYPE;
typedef U32 VAR_SIZE;       /* represents the size in MAUs of the variable */
typedef U32 STATIC_VAR_ADDR;     /* ATN 3: logical address of static var */
typedef U32 GLOBAL_VAR_ADDR;     /* ATN 8: logical address of global var */
typedef S32 AUTO_VAR_OFFSET;     /* ATN 1: automatic var offset */

typedef struct {          /* NOTE: this is different than the ADDR_PAIR */
    OFFSET_ADDR_TYPE offsetStartAddr;
    OFFSET_ADDR_TYPE offsetEndAddr;
} OFFSET_ADDR_RANGE_TYPE;

/* a SYM_DESCRIPTOR is an abstract index, or pointer, to a symbol; also called
   an opaque structure.  It can refer to a first-level symbol such as a
   module, to the next level such as a function, or to a lower level such as a
   local variable within a function. */

typedef U32 SYM_DESCRIPTOR;
                      /* magic cookie for accessing any created symbol */

typedef U32 LINENUM_DESCRIPTOR;  /* access to a line number */

typedef U32 BASE_ADDRESS;  /* ADDRESS OF BASE */

typedef U16 BASE_INDEX;

typedef enum {      /* types of base addresses that will relocate */
                    /* modules based on the codeBase value */
    BASE_UNKNOWN,
    BASE_CODE,
    BASE_DATA,
    BASE_CODE_DATA
} BASE_TYPE;

typedef enum {
   SYM_CODE_ADDR,
   SYM_DATA_ADDR,
   SYM_UNKNOWN_ADDR
} BASIC_SYM_ADDR_TYPE;

typedef enum {
    SEG_UNTYPED,
    SEG_CODE,
    SEG_DATA,
    SEG_XDATA,
    SEG_BIT,
    SEG_REGISTER,
    SEG_CONST
} SEGMENTTYPE;

typedef enum {
    CT_MODULE,
    CT_FUNCTION,
    CT_LINENUM,
    CT_UNKNOWN
} CODE_CLASS;

typedef enum {
    ST_UNDEFINED,
    ST_BREAK,
    ST_CONTINUE,
    ST_DO_WHILE,
    ST_FOR_INIT,
    ST_FOR_COND,
    ST_FOR_UPDATE,
    ST_GOTO,
    ST_IF,
    ST_RETURN,
    ST_SWITCH,
    ST_WHILE,
    ST_EXPRESSION,
    ST_IMP_RETURN,
    ST_FUNC_BEGIN,
    ST_UNKNOWN
} STATEMENT_TYPE;

typedef enum {    /* For 8051 only */
    NONE_51,
    IDATA_51,
    XDATA_51,
    PDATA_51,
    DATA_51,
    CODE_51,
    UNKNOWN_51
} MEMORY_TYPE;

typedef struct {
    SEGMENTTYPE      segType;
    OFFSET_ADDR_TYPE addr;
} ADDRESS_TYPE;

typedef struct {
   COLUMN_TYPE columnStart;
   COLUMN_TYPE columnEnd;
} COLUMN_RANGE_TYPE;

typedef struct {
   LINENUM_TYPE lineNumStart;
   COLUMN_TYPE  columnStart;
   LINENUM_TYPE lineNumEnd;
   COLUMN_TYPE columnEnd;
} SOURCE_RANGE_TYPE;

// list of built-in types supported and their value assignments; defined
// in IEEE695 document, pp A-6..A-7
typedef enum {
   BI_UNKNOWN        =  0,     // ?
   BI_VOID           =  1,     // V
   BI_S8_SCHAR       =  2,     // B
   BI_U8_UCHAR       =  3,     // C
   BI_S16_SINT       =  4,     // H
   BI_U16_UINT       =  5,     // I
   BI_S32_SLONG      =  6,     // L
   BI_U32_ULONG      =  7,     // M
   BI_S64_SLONG      =  8,     // W
   BI_U64_ULONG      =  9,     // Y
   BI_F32            = 10,     // F
   BI_F64            = 11,     // D
   BI_F_EXTEND       = 12,     // K F80 or F96 (uP dependent)
   BI_F128           = 13,     // Q
   BI_STRING         = 14,     // QUOTED STRING
   BI_JUMP           = 15,     // J JUMP TO (LABEL)
   BI_STACK_INT      = 16,     // INT
   BI_STACK_U        = 17,     // UNSIGNED
   BI_STACK_UINT     = 18,     // UNSIGNED INT
   BI_S8_CHAR        = 19,     // CHAR
   BI_S32_LONG       = 20,     // LONG
   BI_S16_SHORT      = 21,     // SHORT
   BI_S16_USHORT     = 22,     // UNSIGNED SHORT
   BI_S16_SHORTINT   = 23,     // SHORTINT
   BI_S16_SSHORT     = 24,     // SIGNED SHORT
   BI_F64_BCD        = 25,     // BCD FLOAT
   BI_BIT            = 26,     // 51 SBIT   

   BI_P_UNKNOWN      = 32,     // POINTER to UNKNOWN
   BI_P_VOID         = 33,     // P to PROC RETURNING VOID
   BI_P_S8_SCHAR     = 34,     // P to ...
   BI_P_U8_UCHAR     = 35,     //
   BI_P_S16_SINT     = 36,     //
   BI_P_U16_UINT     = 37,     //
   BI_P_S32_SLONG    = 38,     //
   BI_P_U32_ULONG    = 39,     //
   BI_P_S64_SLONG    = 40,     //
   BI_P_U64_ULONG    = 41,     //
   BI_P_F32          = 42,     //
   BI_P_F64          = 43,     //
   BI_P_F_EXTEND     = 44,     // P to F80 or F96 (uP dependent)
   BI_P_F128         = 45,     //
   BI_P_STRING       = 46,     // P to QUOTED STRING
   BI_P_JUMP         = 47,     // P to INSTRUCTION ADDRESS
   BI_P_STACK_INT    = 48,     // P to INT
   BI_P_STACK_U      = 49,     // P to UNSIGNED
   BI_P_STACK_UINT   = 50,     // P to UNSIGNED INT
   BI_P_S8_CHAR      = 51,     // P to CHAR
   BI_P_S32_LONG     = 52,     // P to LONG
   BI_P_S16_SHORT    = 53,     // P to SHORT
   BI_P_S16_USHORT   = 54,     // P to UNSIGNED SHORT
   BI_P_S16_SHORTINT = 55,     // P to SHORTINT
   BI_P_S16_SSHORT   = 56,     // P to SIGNED SHORT
   BI_P_F64_BCD      = 57,     // P to BCD FLOAT

} BUILT_IN_TYPE;

// list of complex types supported and their value assignments; defined
// in IEEE695 document, pp A-1..A-4
typedef enum {
   TY_16_16_PTR   = 0x00,  // new value for Intel ptr type with
                           // 16 bit segment/selector, 16 bit offset
   TY_16_32_PTR   = 0x01,  // new value for Intel ptr type with
                           // 16 bit selector, 32 bit offset
   TY_REGISTER    = 0x02,  // register type for OMF86/386

   TY_ATTRIBUTE   = 0x03,  // special types for UBROF format
   TY_DPTR0       = 0x04,
   TY_DPTR1       = 0x05,
   TY_DPTR2       = 0x06,
   TY_DPTR3       = 0x07,
   TY_DPTR4       = 0x08,
   TY_DPTR5       = 0x09,
   TY_DPTR6       = 0x0A,
   TY_DPTR7       = 0x0B,
   TY_CPTR0       = 0x0C,
   TY_CPTR1       = 0x0D,
   TY_CPTR2       = 0x0E,
   TY_CPTR3       = 0x0F,
   TY_OMF51_ARRAY = 0x10,
   TY_OMF51_PTR   = 0x11,

   TY_UNKNOWN     = 0x21,  // ! IEEE-695
   TY_ENUM_PASCAL = 0x45,  // E
   TY_GENERAL     = 0x47,  // G
   TY_ENUM_C      = 0x4E,  // N
   TY_SMALL_PTR   = 0x4F,  // O
   TY_LARGE_PTR   = 0x50,  // P
   TY_RANGE       = 0x52,  // R
   TY_STRUCT      = 0x53,  // S
   TY_TYPE        = 0x54,  // T
   TY_UNION       = 0x55,  // U
   TY_VOID        = 0x56,  // V
   TY_FUNC_NODEP  = 0x58,  // X
   TY_C_ARRAY     = 0x5A,  // Z
   TY_BITFIELD    = 0x67,  // g
   TY_FUNC_DEP    = 0x78,  // x,  TY_FUNCTION
} COMPLEX_TYPE;

typedef U8 SCALAR_TYPE;
/* Holds instance of the scalar type; IEEE695 defines 57 (with gaps), with
   reserved types up to 255.  Could become an enum with a large number of
   components. */

// based on UBROF
//typedef enum {
//   TY_UNDEFINED   =  0,
//   TY_U8_UCHAR    =  1,
//   TY_S8_SCHAR    =  2,
//   TY_U16_USHORT  =  3,
//   TY_S16_SHORT   =  4,
//   TY_U16_UINT    =  5,
//   TY_S16_SINT    =  6,
//   TY_U32_ULONG   =  7,
//   TY_S32_SLONG   =  8,
//   TY_F32_FLOAT   =  9,
//   TY_F64_DOUBLE  = 10,
//   TY_F_EXTEND    = 11,   // long double
//   TY_VOID        = 12,
//   TY_ADDRESS     = 14,
//   TY_POINTER     = 15,
//   TY_ARRAY       = 16,
//   TY_STRUCT      = 17,
//   TY_UNION       = 18,
//   TY_BITFIELD    = 19,
//   TY_FUNCTION    = 20,
//   TY_ATTRIBUTE   = 21,
//   TY_DPTR0       = 23,
//   TY_DPTR1       = 24,
//   TY_DPTR2       = 25,
//   TY_DPTR3       = 26,
//   TY_DPTR4       = 27,
//   TY_DPTR5       = 28,
//   TY_DPTR6       = 29,
//   TY_DPTR7       = 30,
//   TY_CPTR0       = 31,
//   TY_CPTR1       = 32,
//   TY_CPTR2       = 33,
//   TY_CPTR3       = 34,
//   TY_ENUM        = 40, // not defined by UBROF
//   TY_TYPE        = 41, // not defined by UBROF
//   TY_LONGJUMP    = 42, // not defined by UBROF
//   TY_SHORTJUMP   = 43, // not defined by UBROF
//   TY_F128        = 44, // not defined by UBROF
//} DATA_TYPE;

typedef enum{       /* two types of constants */
    CONST_NUMERIC,
    CONST_STRING
} CONSTANT_TYPE;

typedef enum {
    FUNC_GLOBAL,
    FUNC_LOCAL
} FUNC_CLASS;

typedef struct {
    SEGMENTTYPE       segType;
    OFFSET_ADDR_TYPE  startAddr;
    OFFSET_ADDR_TYPE  endAddr;
} ADDR_RANGE_TYPE;

typedef enum {
    CODE_ADDR, DATA_ADDR, STACK_ADDR, HEAP_ADDR, ILLEGAL_ADDR, UNDEFINED_ADDR
} MEM_ADDR_CLASS;

typedef struct {
    OFFSET_ADDR_TYPE startAddr;      /* symbol address */
    OFFSET_ADDR_TYPE endAddr;        /*     "        */
    BOOLEAN          startValid;     /* whether startAddr is to be stored or not */
    BOOLEAN          endValid;       /* whether endAddr is to be stored or not */
} QUAL_ADDR_RANGE_TYPE;

typedef struct {        /* open-ended list */
    U16 itemCount;
    ADDR_RANGE_TYPE addrRange;    /* may be more than one */
} RANGE_LIST_TYPE;

typedef U8 SIMPLE_TYPE;   /* holds the simple "built-in" type number */

typedef enum {    /* this list may change */
    SYM_ROOT = 0,
    SYM_MODULE,
    SYM_FUNCTION,
    SYM_BLOCK,
    SYM_GLOBAL_VAR,
    SYM_LOCAL_VAR,
    SYM_LABEL,
    SYM_CONSTANT,
    SYM_TYPE,
    SYM_USER_DEFINED_VAR,
    SYM_USER_DEFINED_LABEL,
    SYM_PUBLIC_VAR,
    SYM_PUBLIC_LABEL,
    SYM_PUBLIC_UNKNOWN,
    SYM_MACRO,
    SYM_MISCELLANEOUS,
    SYM_UNDEFINED,
    MAX_SYM_TYPE   /* This must always be the last enum element */
} SYM_TYPE_TYPE;

typedef enum {
    SIMPLE_TYPE_CLASS, /* 695 calls these build-in types; e.g. int, char... */
    COMPLEX_TYPE_CLASS /* called high-level types; e.g. struct, enum */
} TYPE_CLASS;

typedef struct {
    U16 year;
    U8  month;
    U8  day;
    U8  hour;
    U8  minute;
    U8  second;
} TIMESTAMP_TYPE;

typedef U32 TYPE_INDEX;      /* index value into type table */

typedef struct {
    TYPE_INDEX typeIndex;
    SEGMENTTYPE segType;
} TYPE_TYPE;

/* common information at head of each TYPE */
typedef struct {
    TYPE_CLASS typeChoice;   /* determines access to union */
    union {
        SIMPLE_TYPE simpleType;
        COMPLEX_TYPE complexType;
    } t;
    U32 sizeInMAUs;          /* number of MAUs that make up the type */
    LPSTR typeName;          /* empty string if type doesn't have name */
    BOOLEAN sizeCalculated;  /* flag to indicate that MAU is known for type */
} TYPE_HEADER_TYPE;       /* use MAX_SYMNAME_LENGTH */

/* (G) data structure containing bit fields type */
typedef struct {
    LPSTR name;              /* name of field; use MAX_SYMNAME_LENGTH */
    TYPE_INDEX typeIndex;    /* index to type */
    U16 bitOffset;           /* bit offset */
    U16 bitSize;             /* number of bits */
} TYPE_G_STRUCT;

/* (g) bitfield type */
typedef struct {
    U8  bitfieldSigned;         /* 0=signed, 1=unsigned */
    U8  offset;                 /* offset int type */
    U16 size;                   /* size in bits, 1 thru n */
    TYPE_INDEX baseTypeIndex;   /* base index type */
} TYPE_BITFIELD_STRUCT;

/* (R) Range of another type structure */
typedef struct {
    S32 lowBound;
    S32 highBound;
    U8  rangeSigned;        /* 0=unsigned, 1=signed */
} TYPE_R_STRUCT;

/* (S,U) data structure and union types */
typedef struct {
    LPSTR name;             /* name of field; use MAX_SYMNAME_LENGTH */
    TYPE_INDEX typeIndex;   /* index to type */
    U16 offset;             /* offset; for (S), if typeIndex is (g), offset*/
                            /* is in bits, otherwise in MAUs */
} TYPE_S_U_STRUCT;

/* (Z) C array with lower bound = 0 structure */
typedef struct {
    TYPE_INDEX typeIndex;
    S32 highBound;          /* When upper limit unknown (e.g. externals) */
                            /* highBound should be set to -1 */
} TYPE_C_ARRAY_STRUCT;

typedef struct {
    TYPE_INDEX typeIndex;
    U8  dim;                /* number of dimensions */
} TYPE_OMF51_ARRAY_STRUCT;

typedef U16 DIMENSION;

typedef TYPE_C_ARRAY_STRUCT TYPE_Z_STRUCT ;

/* OMF51 Pointer structure */
typedef struct {
    TYPE_INDEX  typeIndex;
    U8          attribute; // 1: 3-byte ptr, 2: spaced ptr, 3: 3-byte reverse ptr
    U8          ptrSpec;   // 1: data ptr, 2: function ptr, 4: huge ptr;
    MEMORY_TYPE memSpace;
} TYPE_OMF51_PTR_STRUCT;

/* variable address types (address is an abstract term here). These map to the
   address field of the variable record */

/* Variable lifetime typedefs */
typedef enum {
   LIVE,   /* indicates that register variable is valid */
   DEAD    /*            "                        invalid */
} VAR_LIFETIME_STATE;

typedef struct {
   AUTO_VAR_OFFSET autoVarOffset;
   VAR_SIZE        autoVarSize;
   VAR_LIFETIME_STATE lifetimeState;
} GET_AUTO_VAR;

typedef U16 REG_INDEX;

typedef REG_INDEX VAR_LIVING_REG;  /* ATN 2: index of living register */
                                   /* the value is processor dependent */
typedef struct {
   VAR_LIVING_REG     varLivingReg;
   VAR_SIZE           varSize;
   VAR_LIFETIME_STATE lifetimeState;
} GET_VAR_LIVING_REG;

typedef struct {                 /* ATN 10: locked register var */
   REG_INDEX       regIndex;
   AUTO_VAR_OFFSET autoVarOffset;
} VAR_LOCKED_REG;

typedef struct {                 /* ATN 10: locked register var */
   VAR_LOCKED_REG  getRegIndex;
   VAR_SIZE        varSize;
   AUTO_VAR_OFFSET autoVarOffset;
   VAR_LIFETIME_STATE lifetimeState;
} GET_VAR_LOCKED_REG;

typedef struct {             /* ATN 12: based variable */
    U32 offsetVal;
    U32 baseSize;            /* interpreted by controlNum */
    U8  controlNum;          /* values 0-4 defined */
    U8  publicLocal;         /* 0=local, 1=public */
    U8  memorySpace;         /* memory space indicator value */
} VAR_BASED_VAR;

typedef struct {
   VAR_BASED_VAR basedVar;
   VAR_SIZE      varSize;
   VAR_LIFETIME_STATE lifetimeState;
} GET_VAR_BASED_VAR;

typedef union {
   GET_AUTO_VAR       getAutoVar;
   GET_VAR_LIVING_REG getRegisterIndex;
   GET_VAR_LOCKED_REG getLockedReg;
   GET_VAR_BASED_VAR  getBasedVar;
} GET_VAR_ADDR_UNION;

typedef struct {
   ADDR_RANGE_TYPE    fixedAddr;
   GET_VAR_ADDR_UNION addrData;
} GET_VAR_ADDR_STRUCT;    /* used to pass address information to caller */

typedef union {
   U32             fixedAddr;   /* covers both global and static vars */
   AUTO_VAR_OFFSET autoVar;
   VAR_LIVING_REG  registerIndex;
   VAR_LOCKED_REG  lockedReg;
   VAR_BASED_VAR   basedVar;
   ADDRESS_TYPE    addr;
} ADD_VAR_ADDR_UNION;    /* used to pass address information to caller */

typedef enum{
    AUTO_VAR_CLASS,
    STATIC_VAR_CLASS,
    GLOBAL_VAR_CLASS,
    BASED_VAR_CLASS,
    UNKNOWN_VAR_CLASS
} VAR_STORAGE_CLASS;

typedef enum{
    NOT_REG,
    LIVING_REG,
    SHADOW_REG,
    LOCKED_REG
} VAR_REGISTER_CLASS;

typedef struct {
    ADDRESS_TYPE          lifetimeAddr;
    VAR_LIFETIME_STATE lifetimeClass;
} VAR_LIFETIME_INFO;

typedef enum{
    SEG_SPACE_USER,
    SEG_SPACE_SMM
} SEG_ADDR_SPACE;  // defines the two types of segment spaces

typedef enum {  // defines 2 Intel modes and Moto
    SYM_REAL,
    SYM_PROTECTED,
    SYM_NONE    // Moto mode
} SYM_MODE;

typedef enum {
   NEAR_16,
   FAR_16,
   INTERRUPT_286,
   NEAR_32,
   FAR_32,
   INTERRUPT_386
}  INTEL_FUNC_RETURN_ATTRIB;

                        /****************************
                         *                          *
                         *        PROTOTYPES        *
                         *                          *
                         ****************************/

/*************************
 ** SYMBOL ADD ROUTINES **
 *************************/
/* These include any routines that add symbol information to the database */

/*******************************************
 ** ADD: BASE: CLOSE, CREATE, SET ADDRESS **
 *******************************************/

/*--------------------------------------------------------------------------*/
/* SymAddBaseCreate
**
** Purpose:
**    Create a new base with its base address.                              
**
** Input parameters:
**    baseName: name of base to be created; can be empty;
**       use MAX_SYMNAME_LENGTH
**    baseIndex: reference to base record including base address          
**    baseAddress: address of the base; if not known, set to 0
**    baseTypeParam: type of base address
**
** Output parameters:
**
** Error: report error if baseIndex already defined
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddBaseCreate(LPSTR        baseName,
                 BASE_INDEX   baseIndex, 
                 BASE_ADDRESS baseAddress,
                 BASE_TYPE    baseTypeParam);

/************************
 ** GET: BASE ROUTINES **
 ************************/

/*--------------------------------------------------------------------------*/
/* SymGetBaseAddress
**
** Purpose: Get the address of the base with index <baseIndex>
**
** Input parameters:
**    baseIndex: index that references the desired base
**
** Output parameters:
**    baseAddress: address of the base                        
**
** Error: Reports error if <baseIndex> not valid.
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetBaseAddress(BASE_INDEX       baseIndex,
                  BASE_ADDRESS FAR *baseAddress);

//--------------------------------------------------------------------------
// SymUpdateSymbolBase
//
// Purpose:
//    Update each symbol base when the base is a protected mode selector.
//    The update calls the address server which goes out to target
//    memory GDT/LDT tables and retrieves the base address of selector.
//
// Input parameters:  None
//
// Output parameters:
//    basecount: number of protected mode bases found and updated during
//               scan
//
// Error: Report error if no bases present; return any error from addr server
//
//--------------------------------------------------------------------------  
RETCODE EXPORT
SymUpdateSymbolBases(U16 *baseCount);

   
/***************************************************************************
** SymGetEndList
**
** Description: Gets the descriptor of the last element in the 
**              label/var/const/misc linked lists.
**
** Input Parameters:
**    inputSymbol:  descriptor to the parent module/block/func.
**    symType: type of list to be searched.
** Output Parameters:
**    endList: descriptor of the variable at the end of the linked list.
** Errors:
**    ER_NOT_A_MODULE:  if the inputSymbol does not point to a 
**                      func/block/module/root.
***************************************************************************/
RETCODE EXPORT
SymGetEndList(SYM_DESCRIPTOR     inputSymbol, 
              SYM_TYPE_TYPE      symType,
              SYM_DESCRIPTOR FAR *endList);


/***************************
 *** ADD: FUNCTION CLOSE ***
 ***************************/

/*--------------------------------------------------------------------------*/
/* SymAddFuncClose
**
** Purpose: Closes the open function context
**
** Parameters:
**
** Error:
**   reports error if open context is not a function
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddFuncClose(void);


/****************************
 *** ADD: FUNCTION CREATE ***
 ****************************/

/*--------------------------------------------------------------------------*/
/* SymAddFuncCreate
**
** Purpose:
**    Creates and opens a function for symbol entry.  No descriptor is being
**    returned; this assumes that the loader knows the nesting context and
**    does the correct "close" operation. If another function is already open,
**    this function is nested inside the previous function.  Notice that the
**    database holds the nesting context internally, therefore the loader does
**    not have to keep track of it.
**
** Input parameters:
**    funcName: name of function; use MAX_SYMNAME_LENGTH
**    funcClass: class of function - global or local
**    stackSize: size of local stack in MAUs
**    codeAddrRange: address range of function's code; if not known, set to 0
**    funcInSource: function range(start/end line/column) in the source file.
**    typeIndex:    type index.
**
** Output parameters:
**
** Error:
**    Reports error if:
**        previous open context doesn't support opening a new function
**        functionName already exists in this module or as a global name
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddFuncCreate(LPSTR                  funcName,
                 FUNC_CLASS             funcClass,
                 U32                    stackSize,
                 ADDR_RANGE_TYPE        *codeAddrRange,
//               SOURCE_RANGE_TYPE      *funcInSource,
                 TYPE_INDEX             typeIndex);


/*--------------------------------------------------------------------------*/
/* SymAddFuncOpen
**
** Purpose:
**    Open an existing function <funcName> for adding symbols to it
**    Symbols added must be placed at the end of the linked list for each
**    type; e.g. vars, labels, constants.  Nested functions and nested blocks
**    can also be added.
**
** Input parameter:
**    funcName: name of function to open; use MAX_SYMNAME_LENGTH
**
** Error: reports error if:
**      <funcName> not found within the open module context.
**      A module context is not already open.
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddFuncOpen(LPSTR funcName);


/****************
 ** ADD: LABEL **
 ****************/

/*--------------------------------------------------------------------------*/
/* SymAddLabel
**
** Purpose:
**    Add a label to the open context.
**
** Input parameters:
**    labelName: name of label; use MAX_SYMNAME_LENGTH
**    addr: logical address of label
**
** Output parameters:
**
** Error:  None
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddLabel(LPSTR            labelName,
            OFFSET_ADDR_TYPE addr);


/*--------------------------------------------------------------------------*/
/* SymAddLabelPublic
**
** Purpose:
**    Add a public label, independent of the context (added at root level).
**    SYM_TYPE_TYPE will be set to SYM_PUBLIC_LABEL.  The public name is added
**    to the global hash table list.  Its address range is added to the
**    by-address lookup table. The purpose of loading publics is:
**       - add symbols defined in libraries or modules with no debug records
**    If the symbol name already exists, the call is ignored.
**
** Input parameter:
**    labelName: name of label; use MAX_SYMNAME_LENGTH
**    labelAddr: global address range of public label
**
** Output parameters: NONE
**
** Error:
**    Returns SUCCESS (or GOOD) if this is a new name
**    Returns ER_PUBLIC_IGNORED if the variable name exists and its address
**       field is valid as defined by isValidAddr.  This occurs often when
**       loading the publics.
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddLabelPublic(LPSTR              labelName,
                  OFFSET_ADDR_TYPE   labelAddr);


/**************************
 ** LINENUM ADD ROUTINES **
 **************************/
/*--------------------------------------------------------------------------*/
/* SymAddLinenum
**
** Purpose:
**    Add a line number to the open context.
**
** Input parameters:
**    linenum: (binary) line number
**    column: column number from 695
**    addr: logical address of line number
**
** Output parameters:
**
** Error:  Standard "out of memory" if no room for line number
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddLinenum(LINENUM_TYPE     linenum,
              U8               column,
              OFFSET_ADDR_TYPE addr);

/*--------------------------------------------------------------------------*/
/* SymAddLinenumEnd
**
** Purpose:
**    Complete the addition of line numbers.
**
** Input parameters:
**
** Output parameters:
**
** Error:  None
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddLinenumEnd(void);


/*--------------------------------------------------------------------------*/
/* SymAddLinenumStart
**
** Purpose:
**    Create ("open") a context for adding line numbers.  Must specify the
**    module descriptor.
**
** Input parameters:
**    moduleDescriptor: module  descriptor.
**
** Output parameters: None
**
** Error:  None
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddLinenumStart(SYM_DESCRIPTOR moduleDescriptor);


/**********************************
 *** ADD: START AND END LOADING ***
 **********************************/

/*--------------------------------------------------------------------------*/
/* SymAddLoadStart
**
** Purpose: Starts the loading process; called either for complete or
**    incremental loading
**
** Input parameters:
**    filename: path and filename of OMF file to be incrementally loaded;
**              use MAX_SYMNAME_LENGTH
**    onDemand: TRUE -> loading only local vars and linenums for already-
**                      existing module
**              FALSE -> start of a load for all globals, modules, etc
**    timestamp: timestamp of the OMF file being loaded.
**
** Output parameters: none
**
** Error: None
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddLoadStart(LPSTR          filename,
                BOOLEAN        onDemand,
                TIMESTAMP_TYPE *timestamp);


/*--------------------------------------------------------------------------*/
/* SymAddLoadEnd
**
** Purpose: Ends the loading process; called either for complete or
**    incremental loading.  Used by symbol server to close and sort tables
**
** Parameters:
**
** Error: None
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddLoadEnd(void);

/*******************
 *** ADD: MACRO
 *******************/

/*--------------------------------------------------------------------------*/
/* SymAddMacro
**
** Purpose: Add macro
**
** Input Parameter:
**    macroName: Macro Name.
**    macroDefinition: the string that the macro is defined to.
**
** Output Parameter:
**    none
**
** Error: reports error if there is no module to close
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddMacro(LPSTR macroName, LPSTR macroDefinition);

/*******************************************************************
 *** ADD: MODULE CREATE, OPEN, CLOSE, INVALIDATE, FILE REFERENCE ***
 *******************************************************************/

/*--------------------------------------------------------------------------*/
/* SymAddModuleClose
**
** Purpose: Closes the opened context module
**
** Input Parameter:
**    localsLoaded: TRUE if the module load included locals and linenums
**                  FALSE if load was on-demand and did not load locals
**
** Error: reports error if there is no module to close
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddModuleClose(BOOLEAN localsLoaded);

/*--------------------------------------------------------------------------*/
/* SymAddModuleCreate
**
** Purpose:
**    Creates and opens a module for symbol entry.  This version stays open
**    and assumes symbols will follow, therefore it sets the load status field
**    to Loaded.  Supports multiple same-name modules.  They are distinguished
**    by the moduleReference (path).
**
** Input parameters:
**    moduleName: name assigned to module
**    moduleReference: string holding source file reference (path)
**    timestamp:
**        time when module created; fields set to 0 if timestamp not
**        available; pass by reference to save stack space
**    codeAddrRange:
**       address range of code; pass by reference to save stack
**       if value not known, use DEFAULT_START_ADDR and DEFAULT_END_ADDR
**       constants
**    moduleOffset: file offset location of module for later on-demand
**                  symbol loading
**    onDemand: TRUE if more symbols are to be loaded later for this module
**              FALSE if user chose to load all symbols initially
**    typeDelta:
**       generated by loader and saved in symbol table for later retrieval to
**       be used for on-demand loading.  The value is the offset (or delta) of
**       the type index for the specific module loaded.  (Module types all
**       start with T100, but the symbol table type indices must be unique,
**       therefore, the loader renumbers them to make them sequential and
**       unique.  This offset is the adjustment that removes the overlap.)
**
** Output parameter:
**    moduleDescriptor: reference descriptor for user to make other calls to
**                      this module
**
** Error:
**    Reports error if another module is already open (two modules
**    cannot be opened for symbol entry at the same time).
*/
/*-------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddModuleCreate(LPSTR                  moduleName,
                   TIMESTAMP_TYPE         *timestamp,
                   ADDR_RANGE_TYPE        *codeAddrRange,
                   U32                    moduleOffset,
                   BOOLEAN                onDemand,
                   U32                    typeDelta,
                   SYM_DESCRIPTOR         *moduleDescriptor);

/*--------------------------------------------------------------------------*/
/* SymAddModuleOpen
**
** Purpose: Open an existing module <moduleName> for adding symbols
**
** Input parameter:
**    moduleName: name of module to open
**    moduleReference: path of module; ignored if null string, used to find
**    unique module when multiple same names exist.
**
** Output parameter:
**    fileOffset: a pointer to a file.  This is used by the loader.
**    typeDelta: this is a fixup to the type numbers that were originally
**    loaded into this module.
**
** Error: reports error if:
**      <moduleName> not found
**      a module context is already open (which can include functions,etc)
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddModuleOpen(LPSTR moduleName, LPSTR moduleReference,
                 U32 FAR *fileOffset, U32 FAR *typeDelta);

/*--------------------------------------------------------------------------*/
/* SymAddModuleOpenByDesc
**
** Purpose: Open an existing module <moduleDesc> for adding symbols
**
** Input parameter:
**    moduleDesc: Descriptor of module to open
**
** Output parameter:
**    fileOffset: a pointer to a file.  This is used by the loader.
**    typeDelta: this is a fixup to the type numbers that were originally
**    loaded into this module.
**
** Error: reports error if:
**      <moduleDesc> not found
**      a module context is already open (which can include functions,etc)
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddModuleOpenByDesc(SYM_DESCRIPTOR moduleDesc,
                 U32 FAR *fileOffset, U32 FAR *typeDelta);

/*--------------------------------------------------------------------------*/
/* SymAddModuleReference
**
** Purpose: Add a module path name to the modules symbol table entry
**
** Input parameter:
**    moduleDescriptor: a descriptor to the module to be updated
**    moduleReference: path of module; used to find
**    unique module when multiple same names exist.
**
** Output parameter:
**    none:
**
** Error: reports error if:
**      <moduleDescriptor> does not point to a module entry
**      <moduleReference> does not have a valid entry
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT SymAddModuleReference(SYM_DESCRIPTOR moduleDescriptor,
                                     LPSTR moduleReference);

/*--------------------------------------------------------------------------*/
/* SymAddSourceState
**
** Purpose:
**    Add a source statement information to the open context (for IAR's UBROF).
**
** Input parameters:
**    srcStatement: the source statement information.
**    codeAddrRange: address range of the statement's code; if not known, set to 0
**
** Output parameters:
**    none:
**
** Error:  Standard "out of memory" if no room for source statement
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddSourceState(SOURCE_RANGE_TYPE *srcStatement,
                      ADDR_RANGE_TYPE   *codeAddrRange);

RETCODE EXPORT
SymAddModuleSourceFilePosition( SYM_DESCRIPTOR  moduleDescriptor ,
                                U32             srcFileOffset);
/*********************************
 ** GENERIC SYMBOL ADD ROUTINES **
 *********************************/

/*--------------------------------------------------------------------------*/
/* SymAddSymbolSetAddr
**
** Purpose:
**    Fills in the address range of the open context symbol.  Overwrites if
**    already exists.  (Design note: this function allows the loader to
**    delay the address entry until it receives the end address from
**    the OMF stream, normally just before it closes the context).
**
** Input parameters:
**    qualAddrRange:
**        data structure with start, end abstract addresses and validity
**        flags.  The <startValid> and <endValid> are used by the caller to
**        indicate which of the addresses to be stored in the symbol record.
**        With these flags, the loader can enter the start address at a
**        different time than the end address.
**
** Error:
**    Reports error if <symbol> is not an open context or if the
**    symbol type does not accept an address (e.g. a type)
**
**    This function is called after the module/function/block has just been
**    closed.  This makes sure "prevSym" points to the symbol context just
**    closed.  Once the symbol context has been closed the function updates
**    the address range of the symbols base. ;
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddSymbolSetAddr(QUAL_ADDR_RANGE_TYPE *qualAddrRange);


    /****************************
    ** ADD: TYPE INFORMATION ***
    ****************************/


/**************************************
 ** CONTEXT-DEPENDENT TYPE ADDITIONS **
 **************************************/

/***********************
 ** (g) BITFIELD TYPE **
 ***********************/

/*--------------------------------------------------------------------------*/
/* SymAddTypeBitfield
**
** Purpose:
**    Given a type index, add a (g) bitfield component.  SW must increment
**    the local component count.
**
** Input parameters:
**    typeIndex: index of type
**    bitfieldStruct: structure holding information about the bitfield
**
** Output parameters: None
**
** Error: Reports error if:
**    <typeIndex> doesn't point to a (g) bitfield type
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddTypeBitfield(TYPE_INDEX           typeIndex,
                   TYPE_BITFIELD_STRUCT *bitfieldStruct);


/**************************************
 ** (Z) C ARRAY with lower bound = 0 **
 **************************************

/*--------------------------------------------------------------------------*/
/* SymAddTypeCArray
**
** Purpose:
**    Given a type index to a C array with lower bound=0, add the type
**    index of the array elements and its high bounds.
**
** Input parameters:
**    typeIndex: index of type
**    cArrayStruct: structure holding information about C array type
**
** Output parameters: None
**
** Error: Reports error if:
**    <typeIndex> doesn't point to a (Z) range type
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddTypeCArray(TYPE_INDEX           typeIndex,
                 TYPE_C_ARRAY_STRUCT *cArrayStruct);

/****************************************
 ** Array functions defined for OMF51  **
 ****************************************
/*--------------------------------------------------------------------------*/
/* SymAddTypeArray51
**
** Purpose:
**    Add the type index of the array elements and its dimension count.
**    The dimension size will be added with SymAddTypeArrayDimSize
**
** Input parameters:
**    typeIndex: index of type
**    arrayStruct: structure holding information about OMF51 array type
**
** Output parameters: None
**
** Error: Reports error if:
**    <typeIndex> doesn't point to an OMF51 array type
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddTypeArray51(TYPE_INDEX               typeIndex,
                  TYPE_OMF51_ARRAY_STRUCT  *arrayStruct);

/*---------------------------------------------------------------------------
** SymAddTypeArrayDimSize
**
** Purpose:
**    Given the type index to an array, add the dimension size of this array.
**
** Input parameters:
**    typeIndex: type index to the array
**    dimSize  : dimension size of the array.
**
** Output parameters: None
**
** Error: Reports error if:
**    <typeIndex> doesn't point to an OMF51 array type
**--------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddTypeArrayDimSize(TYPE_INDEX typeIndex,
                       DIMENSION  dimSize);


/*************************************
 ** (N) C language ENUMERATION TYPE **
 *************************************/

/*--------------------------------------------------------------------------*/
/* SymAddTypeEnum
**
** Purpose:
**    Given a type index, add an enumeration component to the enumeration
**    type.  SW must increment the local component count.
**
** Input parameters:
**    typeIndex: index to enum type
**    enumValue: 32 bit value to be added
**    enumName: name representing <enumValue>
**
** Output parameters: None
**
** Error:
**    Reports error if typeIndex doesn't point to an (N) enum type
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddTypeEnum(TYPE_INDEX typeIndex,
               U32        enumValue,
               LPSTR      enumName);


/******************************
 ** ADD: FUNCTION TYPE INFO ***
 ******************************/

/*--------------------------------------------------------------------------*/
/* SymAddTypeFunc
**
** Purpose:
**    Given a type index, add fixed data items to function type.
**    The information is from the type (X) or (x) of 695.
**
** Input parameter:
**    typeIndex: index to function type for adding info
**    attribute: bit mask of attributes (page A-5 of 695 document)
**    frameType: type of frame as defined in 695.  default or no value=0
**    pushMask: bit mask representing registers saved by routine; 0=none
**    returnType: a type index to an already defined (return) type;
**       can be a built-in or a complex type.
**    argCount: number of passed parameters
**    level: nesting level of function/procedure; default=0
**    fatherName: the home of the uplevel routine; default = 0 length;
**                use MAX_SYMNAME_LENGTH for string allocation
**
** Output parameter:
**
** Error:
**    Returns error if <indexType> doesn't point to a function type.
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddTypeFunc(TYPE_INDEX       typeIndex,
               U32              attribute,
               U8               frameType,
               U32              pushMask,
               TYPE_INDEX       returnType,
               U8               argCount,
               U8               level,
               LPSTR            fatherName);


/*--------------------------------------------------------------------------*/
/* SymAddTypeFuncParam
**
** Purpose:
**    Given a type index to a function, add a parameter type index; in other
**    words, add a reference to the parameter type.  SW must increment the
**    parameter count.
**
** Input parameters:
**    typeIndex: the function type to be added to
**    paramTypeIndex: the type index of the parameter to be added
**
** Output parameters:
**
** Error:
**    Reports error if:
**        typeIndex doesn't reference a function type
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddTypeFuncParam(TYPE_INDEX typeIndex,
                    TYPE_INDEX paramTypeIndex);


/******************************************
 ** ADD: CONTEXT-INDEPENDENT TYPE HEADER **
 ******************************************/

/*--------------------------------------------------------------------------*/
/* SymAddTypeHeader
**
** Purpose:
**    Add a common header <typeHeader> for index <typeIndex>.
**    Required before specific type information can be added.
**
** Input parameters:
**    typeIndex: index into type table
**    typeHeader:
**       structure containing the type of type and its size in MAUs
**
** Output parameters:
**
** Error:
**    Reports error if <typeIndex> is an already-created type.
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddTypeHeader(TYPE_INDEX       typeIndex,
                 TYPE_HEADER_TYPE *typeHeader);


/*--------------------------------------------------------------------------*/
/* SymAddTypeOverwriteSize
**
** Purpose:
**    Overwrite the size of a built-in type.  The <typeIndex> must
**    be between 0 and 255.  Used by the loader to set indexes 16, 17, 18
**    "ints" which size is defined as "16 or 32 bit unsigned stack push".
**
** Input parameters:
**    typeIndex: built-in type index (0-255)
**    typeSize:
**       size of the type
**
** Output parameters: NONE
**
** Error: NONE
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddTypeOverwriteSize(U8 typeIndex,
                        U8 typeSize);


/*****************************************
 ** (O,P) SMALL AND LARGE POINTER TYPES **
 *****************************************/

/*--------------------------------------------------------------------------*/
/* SymAddTypePointerTypeIndex
**
** Purpose:
**    Given an index to a small (O) pointer or large (P) type, add the
**    type index to the pointer's type.
**
** Input parameters:
**    typeIndex: index of type
**    pointerTypeIndex: type index to pointer's type
**
** Output parameters:
**
** Error: Reports error if:
**    <typeIndex> doesn't point to a pointer type
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddTypePointerTypeIndex(TYPE_INDEX typeIndex,
                           TYPE_INDEX pointerTypeIndex);

/**************************
 ** OMF51 Pointer type   **
 **************************/
/*--------------------------------------------------------------------------*/
/* SymAddTypePointer51
**
** Purpose:
**    Add OMF51 space pointer type.
**
** Input parameters:
**    typeIndex: Type index that the pointer points to.
**    ptrStruct: OMF51 generic pointer type information
**
** Output parameters:
**
** Error: Reports error if:
**    <typeIndex> doesn't exist.
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT SymAddTypePointer51(TYPE_INDEX typeIndex,
                                   TYPE_OMF51_PTR_STRUCT *ptrStruct);


/******************************
 ** (S,U) STRUCTURE OR UNION **
 ******************************/

/*--------------------------------------------------------------------------*/
/* SymAddTypeStructUnion
**
** Purpose:
**    Given a type index, add a structure or union component.  SW must
**    increment local component count.
**
** Input parameters:
**    typeIndex: index of type
**    structOrUnion: 3 elements making up the component
**
** Output parameters:
**
** Error: Reports error if:
**    <typeIndex> doesn't point to an entry in the type table or to a
**      (S) or (U) type
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddTypeStructUnion(TYPE_INDEX      typeIndex,
                      TYPE_S_U_STRUCT *structOrUnion);


/******************************
 ** (T) TYPE NAME DEFINITION **
 ******************************/

/*--------------------------------------------------------------------------*/
/* SymAddTypeTypeIndex
**
** Purpose:
**    Given a type index to a (T) type name definition, add its type index.
**
** Input parameters:
**    typeIndex: index of type
**    typeTypeIndex: type index to type's type
**
** Output parameters:
**
** Error: Reports error if:
**    <typeIndex> doesn't point to a type type
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddTypeTypeIndex(TYPE_INDEX typeIndex,
                    TYPE_INDEX typeTypeIndex);
RETCODE EXPORT SymAddTypeTypeType(TYPE_INDEX typeIndex,
                                  TYPE_INDEX typeTypeIndex,
                                  SEGMENTTYPE segType );


/*********************
 *** ADD: VARIABLE ***
 *********************/

/*--------------------------------------------------------------------------*/
/* SymAddVar
**
** Purpose:
**    Add a variable to the present context.  <storageClass> indicates where
**    to store the variable.
**
** Input parameter:
**    varName: name of variable; use MAX_SYMNAME_LENGTH for allocation
**    typeIndex: index to the variable type, size, etc.
**    storageClass: form of variable; used to interpret varAddr
**    registerClass: class of register if it is a register variable
**    varAddr:
**        union of all possible variable address types; the union choice
**        is based on storageClass and registerClass.
**        NOTE: varAddr is undefined if isValidAddr is FALSE
**    isConst: TRUE if variable is constant - i.e. read only; FALSE otherwise
**    isValidAddr: TRUE if address is valid; FALSE if address not known
**
** Output parameters:
**    varDesc:
**        descriptor of the variable created.  This is needed for
**        subsequent calls to add lifetime information (ATN 9).
**
** Error:
**    Returns error if <typeIndex> is not an already-defined type.
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddVar(LPSTR              varName,
          TYPE_INDEX         typeIndex,
          VAR_STORAGE_CLASS  storageClass,
          VAR_REGISTER_CLASS registerClass,
          ADD_VAR_ADDR_UNION FAR *varAddr,
          BOOLEAN            isConst,
          BOOLEAN            isValidAddr,
          SYM_DESCRIPTOR FAR *varDesc);


/*--------------------------------------------------------------------------*/
/* SymAddVarPublic
**
** Purpose:
**    Add a public variable, independent of the context (added at root level).
**    SYM_TYPE_TYPE will be set to SYM_PUBLIC_VAR.  A public name is added to
**    the global hash table list.  Its address range is added to the
**    by-address lookup table. The purpose of loading publics is:
**       - add symbols defined in libraries or modules with no debug records
**       - fix up global variables which are declared in one module and used
**          in another, where the address is not in the module symbol records
**          where it was declared.  In this case, the address is found in the
**          public record.
**    The typeIndex is used to determine the range of the variable.
**    If the variable already exists, only the varAddr is used.
**
** Input parameter:
**    varName: name of variable; use MAX_SYMNAME_LENGTH for allocation
**    typeIndex: index to the variable type, size, etc.; if var already exist
**               with isValidAddr FALSE, typeIndex must be ignored.
**    varAddr: global address of public variable; if var already exist
**             with isValidAddr FALSE, varAddr must replace the var address
**
** Output parameters: NONE
**
** Error:
**    Returns SUCCESS (or GOOD) if this is a new name
**    Returns ER_INDEX_NOT_IN_TABLE if <typeIndex> is not an already-defined
**       type.
**    Returns ER_NOT_A_VARIABLE if the symbol name match is not a variable.
**    Returns ER_ADDRESS_UPDATED if the variable name exists and its
**       isValidAddr field is FALSE.  (The variable's start address is
**       updated with the correct value, and the boolean set TRUE).
**       This is more a message returned than an error.
**    Returns ER_PUBLIC_IGNORED if the variable name exists and its address
**       field is valid as defined by isValidAddr.  This occurs often when
**       loading the publics.
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymAddVarPublic(LPSTR            varName,
                TYPE_INDEX       typeIndex,
                ADDRESS_TYPE     varAddr);


/**************************************
 *** ADD: LIFETIME INFO TO VARIABLE ***
 **************************************/

/*--------------------------------------------------------------------------*/
/* SymAddVarLifetimeInfo
**
** Purpose:
**    Add to a variable lifetime register information, consisting of a
**    logical address and the register state at that point on - live or dead.
**    The variable record, for a register type, has a linked list chained off
**    it to which the lifetimeVarInfo is added.
**
** Input parameter:
**    variable: pointer to variable to add information to
**    lifetimeVarInfo: structure holding the lifetime information
**
** Output parameters: None
**
** Error:
**    Returns error if <variable> is not a register variable type
*/
/*--------------------------------------------------------------------------*/

/*----------------------*/
/*   NOT IMPLEMENTED    */
/*----------------------*/
RETCODE EXPORT
SymAddVarLifetimeInfo(SYM_DESCRIPTOR    variable,
                      VAR_LIFETIME_INFO *lifetimeVarInfo);


//--------------------------------------------------------------------------
// SymCheckForNoSymbols
//
// Purpose:
//    Checks to see if any symbols have been loaded
//
// Output parameter:
//    noSymbolsLoaded: TRUE if none loaded, FALSE otherwise
//--------------------------------------------------------------------------
RETCODE EXPORT SymCheckForNoSymbols(BOOLEAN *noSymbolsLoaded);


/******************************************************
 ** GET: PARSING ROUTINE(S) TO GET ADDRESS FROM NAME **
 ******************************************************/

/*--------------------------------------------------------------------------*/
/* SymGetAddrFromName
**
** Purpose:
**    Given a string, parse it into hierarchical symbol components, then
**    find the address for that symbol and return it.
**
** Input parameters:
**    nameStr:
**       string of characters making up a symbol.  Valid inputs are:
**          #<funcOrLabel>
**          #123
**          #123#20
**          #<module>#<funcOrLabel>
**          #<module>#123
**          #<module>#123#20
**          #<module>#func#label
**
**       Current context is used if not specified
**       in the string sequence.  Line number addresses are looked up by
**       line number only (no statement) if the column entry is not there,
**       otherwise a statement-level lookup is used.
**    requestedAddrType:
**       type of address requested.  If unknown, no checks; otherwise if
**       found address type does not match, error is returned.
**
** Output parameters:
**    lpSymFoundDesc:
**       descriptor of symbol found
**    lpAddress:
**        The address range is filled in.
**    lpActualLinenum:
**       Line number that matches the found address; 0 ==> not found
**    lpActualColumnRange:
**       range making up statement.  0,0 ==> linenum not found;
**                                   1,255 ==> line lookup (not stmt)
**
** Error:
**    reports ER_SYMBOL_NOT_FOUND if the symbol is not found.
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetAddrFromName(LPSTR                 nameStr,
                   BASIC_SYM_ADDR_TYPE   requestedAddrType,
                   SYM_DESCRIPTOR    FAR *lpSymFoundDesc,
                   ADDR_RANGE_TYPE   FAR *lpAddrRange,
                   LINENUM_TYPE      FAR *lpActualLinenum,
                   COLUMN_RANGE_TYPE FAR *lpActualColumnRange);

/*********************************
 *** FUNCTION ACCESS ROUTINES  ***
 *********************************/
/* Included are access routines used to disassemble the stack frame */

/*--------------------------------------------------------------------------*/
/* SymGetFunc
**
** Purpose:
**    Given a function descriptor, get basic function information.
**
** Input parameter:
**    inputSymbol: descriptor to function
**
** Output parameters:
**    funcName: function name; use MAX_SYMNAME_LENGTH for allocation
**    funcClass: class of function - global or local
**    stackSize: size of local stack in MAUs
**    codeAddrRange: address range of function's code
**
** Error:
**    Reports error if <inputSymbol> does not point to a function (defensive
**    programming).
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetFunc(SYM_DESCRIPTOR inputSymbol,
           LPSTR          funcName,
           FUNC_CLASS FAR *funcClass,
           U32        FAR *stackSize,
           ADDR_RANGE_TYPE FAR    *codeAddrRange,
           SOURCE_RANGE_TYPE      *funcInSource,
           TYPE_INDEX             typeIndex);


/*--------------------------------------------------------------------------*/
/* SymGetFuncByName
**
** Purpose: Find a function descriptor given a name to that function.
**
** Input Parameters:
**    inputSymbol: a symbol descriptor that points to a module symbol.
**    funcName:  the name of the function to find; use MAX_SYMNAME_LENGTH for
**               allocation
**
** Output Parameters:
**    symDesc: symbol descriptor
**
** Error:
**    ER_SYMBOL_NOT_A_MODULE: if descriptor doesn't point to a module
**    ER_SYMBOL_NOT_FOUND:
**       if inputsymbol does not have a function, or if the function name
**       was not found
**
** Notes:
**    The function must get passed a descriptor to a module symbol.
**    Once it has that descriptor it finds that modules first child
**    function.  It then tries to match the function name passed in
**    with the modules first child function.  Failing a match it will
**    only search the sibling functions of the first function.  This
**    routine does not search any other sub functions for a match.
**    This routine is expected to be used primarily for testing and
**    for a cli command search where the user EXACTLY specifies the
**    path to the symbol he is interested in.  By using this function
**    in combination with SymGetModuleDescNth, and SymGet(Sibling/Child/
**    Parent) the appropriate variable can be extracted.  This function
**    was not made more comprehensive because of the problem of dealing
**    with sub-functions that may have duplicate names.  While this is
**    not a problem with "C" it is a problem in other languages.
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetFuncByName(SYM_DESCRIPTOR     inputSymbol,
                 LPSTR              funcName,
                 SYM_DESCRIPTOR FAR *symDesc);


/*--------------------------------------------------------------------------*/
/* SymGetFuncParamNth
**
** Purpose:
**    Retrieve the basic type information for the Nth parameter of the
**    function referenced by <functionSymbol>.
**
** Input parameters:
**    functionSymbol: descriptor to function
**    n: parameter number where 1 is first
**
** Output parameters:
**    typeHeader:
**       structure containing the type of type and its size in MAUs
**       use MAX_SYMNAME_LENGTH for allocation
**
** Error:
**    Reports error if:
**        <inputSymbol> doesn't point to a function.
**        n doesn't reference a parameter
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetFuncParamNth(SYM_DESCRIPTOR       functionSymbol,
                   U8                   n,
                   TYPE_HEADER_TYPE FAR *typeHeader);



/*--------------------------------------------------------------------------*/
/* SymGetFuncType
**
** Purpose:
**    Returns the type information of the function specified with descriptor
**    <inputSymbol>.  The information is from the type (X) or (x) of 695.
**
** Input parameter:
**    inputSymbol: descriptor to function
**
** Output parameter:
**    attribute: bit mask of attributes (page A-5 of 695 document)
**    frameType: type of frame as defined in 695.
**    pushMask: bit mask representing registers saved by routine; 0=none
**    returnType:
**        structure containing scalar type, size, and name (initialized
**        to VOID type); use MAX_SYMNAME_LENGTH for allocation
**    argCount: number of passed parameters
**    level: nesting level of function/procedure; default=0
**    fatherName: the home of the uplevel routine; default = NULL
**
** Error:
**    Returns error if <inputSymbol> doesn't point to a function.
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetFuncType(SYM_DESCRIPTOR       inputSymbol,
               U32              FAR *attribute,
               U8               FAR *frameType,
               U32              FAR *pushMask,
               TYPE_HEADER_TYPE FAR *returnType,
               U8               FAR *argCount,
               U8               FAR *level,
               LPSTR                fatherName);


//--------------------------------------------------------------------------
// SymGetFuncVarHeadList
//
// Purpose:
//    Does on-demand load of local variables of <funcDesc> if needed
//    Should be called first before attempting to access local variables
//
// Input parameters:
//    funcDesc: descriptor of function from which to get variable head desc
//
// Output parameters:
//    varList: descriptor to first variable of variables in the scope of this
//             function;  NULL_SYMBOL if no variables
//    listCount: number of variables inside this function's scope
//
// Error:
//    ER_INVALID_SYM_DESCRIPTOR: checks for invalid symbol descriptor
//    ER_SYMBOL_NOT_A_FUNCTION: if symbol type is not a function
//    other errors from on-demand loading
//--------------------------------------------------------------------------
RETCODE EXPORT
SymGetFuncVarHeadList(SYM_DESCRIPTOR     funcDesc,
                      SYM_DESCRIPTOR FAR *varList,
                      U16            FAR *listCount);


/************************
 ** LABEL GET ROUTINES **
 ************************/

/*--------------------------------------------------------------------------*/
/* SymGetLabel
**
** Purpose:
**    Given a label descriptor, get basic label information.
**
** Input parameter:
**    inputSymbol: descriptor to label
**
** Output parameters:
**    labelName: label name; use MAX_SYMNAME_LENGTH for allocation
**    codeAddrRange: address range of function's code
**
** Error:
**    Reports error if <inputSymbol> does not point to a label (defensive
**    programming).
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetLabel(SYM_DESCRIPTOR inputSymbol,
            LPSTR          labelName,
            ADDR_RANGE_TYPE  FAR *codeAddrRange);

/************************
 **  LDR GET ROUTINES  **
 ************************/

/*--------------------------------------------------------------------------*/
/* SymGetLdrStats
**
** Purpose:
**    Fill in the current module name and number of symbols loaded, in
**    a loader status block.
**
** Input parameter:
**
** Output parameters:
**    moduleName: pointer to current module
**    numSymbols: pointer to number of symbols currently loaded
**    numModules: pointer to number of modules currently loaded
**    numTypes: pointer to number of types currently loaded
**
** Error:
**    Reports error if module does not have name (should not happen)
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetLdrStats(LPSTR moduleName, U32 FAR *numSymbols, U16 FAR *numModules,
               U32 FAR *numTypes);


/**************************
 ** LINENUM GET ROUTINES **
 **************************/

/*--------------------------------------------------------------------------*/
/* SymGetLinenum
**
** Purpose:
**    Given a module descriptor and line number, return the actual line number
**    found and its address range, where the end of range is the largest end
**    address of an entry with the same line number (there can be more than
**    one entry with the same line number).
**    The match algorithm is the closest line number in the table greater
**    than or equal to requested line number.
**    Also returned is a descriptor to the next entry (i.e. with a larger
**    address) with a line number different from the one requested.
**
** Input parameters:
**    module:  descriptor to parent module
**    linenum: requested line number
**
** Output parameters:
**    addrRange: address range of the entire line number; i.e. may include
**       multiple statements (table entries) that make up one whole line
**    actualLinenum: the closest line number found (may be same as requested)
**    actualColumn: column number for line number
**    nextIndex: index to the next entry in table different from requested
**       line number.
**
** Error:
**    reports error if:
**        requested line number is greater than largest line number in list
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetLinenum(SYM_DESCRIPTOR         module,
              LINENUM_TYPE           linenum,
              ADDR_RANGE_TYPE    FAR *addrRange,
              LINENUM_TYPE       FAR *actualLinenum,
              COLUMN_TYPE        FAR *actualColumn,
              LINENUM_DESCRIPTOR FAR *nextIndex);

/*--------------------------------------------------------------------------*/
/* SymGetLinenumInOrder
**
** Purpose:
**    Given a module descriptor and line number, return the actual line number
**    found and its address range, where the end of range is the largest end
**    address of an entry with the same line number (there can be more than
**    one entry with the same line number).
**    The match algorithm is the closest line number in the table greater
**    than or equal to requested line number start from the 1st entry.
**    Also returned is a descriptor to the next entry (i.e. with a larger
**    address) with a line number different from the one requested.
**    NOTES: This routine is private to the Source Presenter to fix
**    PPR 7517 and 7520. DO NOT USE.
**
** Input parameters:
**    module:  descriptor to parent module
**    linenum: requested line number
**
** Output parameters:
**    addrRange: address range of the entire line number; i.e. may include
**       multiple statements (table entries) that make up one whole line
**    actualLinenum: the closest line number found (may be same as requested)
**    nextIndex: index to the next entry in table different from requested
**       line number.
**
** Error:
**    reports error if:
**        requested line number is greater than largest line number in list
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetLinenumInOrder(SYM_DESCRIPTOR         module,
                     LINENUM_TYPE           linenum,
                     ADDR_RANGE_TYPE    FAR *addrRangeDesc,
                     LINENUM_TYPE       FAR *actualLinenum,
                     LINENUM_DESCRIPTOR FAR *nextIndex);

/*--------------------------------------------------------------------------*/
/* SymGetLinenumbyIndex
**
** Purpose:
**    Given a module pointer and a valid index into the line number
**    table, retrieve the line number information for that index, and return
**    an index to the next address in the list whose line number is not the
**    same as the one retrieved.  This routine is used to single step
**    by LINE NUMBER (not statement).
**
** Input parameters:
**    module: descriptor to parent module
**    index: index into line number table; a reference for getting the next
**           address
**
** Output parameters:
**    addrRangeDesc: address range of the line number in the sorted list
**                   pointed to by <index>
**    nextIndex: index into the line number table; points to next address
**               in list whose line number is not the same as one retrieved
**    linenum: line number corresponding to the address
**    column: starting column for line
**
** Error:
**    reports error if:
**        input index is out of range
**        <module> does not have module type
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetLinenumByIndex(SYM_DESCRIPTOR         module,
                     LINENUM_DESCRIPTOR     index,
                     ADDR_RANGE_TYPE    FAR *addrRange,
                     LINENUM_DESCRIPTOR FAR *nextIndex,
                     LINENUM_TYPE       FAR *linenum,
                     COLUMN_TYPE        FAR *column);


/*--------------------------------------------------------------------------*/
/* SymGetLinenumStmt
**
** Purpose:
**    Given a module descriptor, line number, and column number, return the
**    actual line number and column range that surrounds and most closely
**    matches the request.  Also return the address range of that statement
**    and descriptor to the next sequential address in the line number table.
**
** Input parameters:
**    module:  descriptor to parent module
**    linenum: requested line number
**    column:  position in column for matching source statement
**
** Output parameters:
**    addrRangeDesc: address range of statement.
**    actualLinenum: the closest line number found (may be same as requested)
**    columnRange: column numbers that surround requested column
**    nextIndex: index into the line number table; points to next statement
**
** Error:
**    reports error if:
**        requested line number is greater than largest line number in list
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetLinenumStmt(SYM_DESCRIPTOR         module,
                  LINENUM_TYPE           linenum,
                  COLUMN_TYPE            column,
                  ADDR_RANGE_TYPE    FAR *addrRangeDesc,
                  LINENUM_TYPE       FAR *actualLinenum,
                  COLUMN_RANGE_TYPE  FAR *columnRange,
                  LINENUM_DESCRIPTOR FAR *nextIndex);


/*--------------------------------------------------------------------------*/
/* SymGetLinenumStmtByIndex
**
** Purpose:
**    Given a module pointer and a valid index into the line number
**    table, retrieve the line number information for that index, and return
**    an index to the next address.  This routine is used to single step
**    by STATEMENT (not line number).
**
** Input parameters:
**    module: descriptor to parent module
**    index: index into line number table; a reference for getting the linenum
**           information
**
** Output parameters:
**    addrRange: address range of statement.
**    linenum: the closest line number found (may be same as requested)
**    columnRange: column numbers that surround requested column
**    nextIndex: index into the line number table; points to next statement
**
** Error:
**    reports error if:
**        input index is out of range
**        <module> does not have module type
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetLinenumStmtByIndex(SYM_DESCRIPTOR         module,
                         LINENUM_DESCRIPTOR     index,
                         ADDR_RANGE_TYPE    FAR *addrRangeDesc,
                         LINENUM_TYPE       FAR *linenum,
                         COLUMN_RANGE_TYPE  FAR *columnRange,
                         LINENUM_DESCRIPTOR FAR *nextIndex);


//------------------------------------------------------------------------
// SymGetRawLinenumByIndex
//
// Purpose: return basic info on linenum; return next index.  If index
//          out of bounds, return error
//
// Input parameters:
//    module: which module to get linenums from
//    index:  opaque value of linenum index from which to get info from
//
// Output parameters:
//    linenumAddr: addr mapped to the line number index
//    linenum: linenum stored at <index>
//    column : column stored at <index>
//    nextIndex: next index in linenum sequence.  Used for subsequent
//               calls to this function (passed in as <index>)
//
// Error: returns ER_LINENUM_INDEX_TOO_LARGE when the input index is
//        beyond the end of the table; this is used to test for the end
//        of iteration
//------------------------------------------------------------------------
RETCODE EXPORT
SymGetRawLinenumByIndex(SYM_DESCRIPTOR     module,
                        LINENUM_DESCRIPTOR index,
                        ADDR_RANGE_TYPE    FAR  *linenumAddrRange,
                        LINENUM_TYPE       FAR  *linenum,
                        COLUMN_TYPE        FAR  *column,
                        LINENUM_DESCRIPTOR FAR  *nextIndex);


//------------------------------------------------------------------------
// SymGetLinenumFirstIndex
//
// Purpose: Returns the index to the first linenum in module table
//
// Input parameter:
//    module: module from which to get linenum start index
//
// Output parameter:
//    nextIndex: index to get info on first linenum
//
// Error: returns warning if there are no linenums
//------------------------------------------------------------------------
RETCODE EXPORT
SymGetLinenumFirstIndex(SYM_DESCRIPTOR     module,
                        LINENUM_DESCRIPTOR FAR *nextIndex);


/*************************
 ** MODULE GET ROUTINES **
 *************************/

/*--------------------------------------------------------------------------*/
/* SymGetModuleListHead
**
** Purpose:
**    Get the module descriptor for the first element in the module
**    descriptor linked list.
**
** Input parameter:
**          none:
**
** Output parameter:
**       moduleDescriptor: a descriptor that points to a module
**
** Error:
**    Returns error if <moduleName> can't be found.
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT SymGetModuleListHead(SYM_DESCRIPTOR FAR *moduleDescriptor);

/*--------------------------------------------------------------------------*/
/* SymGetModule
**
** Purpose:
**    Given a descriptor to a module, get its stored information which
**    includes its name and address range.
**
** Input parameter:
**    inputModule: points to module
**
** Output parameters:
**    moduleName: string of module name; use MAX_SYMNAME_LENGTH for allocation
**    moduleAddrRange: address object
**
** Error:
**    reports ER_DESCRIPTOR_NOT_VALID error if the descriptor does not point
**       to a module
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetModule(SYM_DESCRIPTOR inputModule,
             LPSTR          moduleName,
             ADDR_RANGE_TYPE FAR *moduleAddrRange);


/*--------------------------------------------------------------------------*/
/* SymGetModuleDesc
**
** Purpose:
**    Get a module descriptor given the name and path.
**
** Input parameter:
**       moduleName: a string containing the name to be found
**       pathName:
**          string containing path. If the length is 0, return descriptor of
**          the first module that matches the name
**
** Output parameter:
**       moduleOffset: a descriptor that points to a module
**
** Error:
**    Returns error if <moduleName> can't be found.
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetModuleDesc(LPSTR              moduleName,
                 LPSTR              pathName,
                 SYM_DESCRIPTOR FAR *moduleOffset);


/*--------------------------------------------------------------------------*/
/* SymGetModuleDescNth
**
** Purpose:
**    Get a module descriptor given the name.  Since there can be multiple
**    instances of the same name the call provides the means to get the Nth
**    duplicate name.
**
** Input parameter:
**       moduleName: a string containing the name to be found
**       entry: which of multiple names to get
**
** Output parameter:
**       moduleOffset: a descriptor that points to a module
**
** Error:
**    Returns error if <modulename> can't be found.
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetModuleDescNth(LPSTR              moduleName,
                    U8                 entry,
                    SYM_DESCRIPTOR FAR *moduleOffset);

/*--------------------------------------------------------------------------*/
/* SymGetModuleRef
**
** Purpose:
**    Get a module's source file reference, given a descriptor to it.
**
** Input parameter:
**       inputSymbol: descriptor to function
**
** Output parameter:
**       moduleReference: string holding source file reference (path);
**                        use MAX_SYMNAME_LENGTH for allocation
**
** Error:
**    Returns error if <inputSymbol> doesn't point to a module.
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetModuleRef(SYM_DESCRIPTOR inputSymbol,
                LPSTR          moduleReference);

/*--------------------------------------------------------------------------*/
/* SymGetModuleSourceFilePosition
**
** Purpose:
**    Get a module's source file position, given a descriptor to it.
**
** Input parameter:
**       inputSymbol: descriptor to module
**
** Output parameter:
**       srcFileOffset: U32 holding source file position.
**
** Error:
**    Returns error if <inputSymbol> doesn't point to a module.
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetModuleSourceFilePosition(SYM_DESCRIPTOR inputSymbol,
                               U32            *srcFileOffset);


/*--------------------------------------------------------------------------*/
/* SymGetModuleTimestamp
**
** Purpose:
**    Get a module's timestamp information, given a descriptor to it.
**
** Input parameter:
**       inputSymbol: descriptor to function
**
** Output parameter:
**       timestamp: structure holding module's timestamp
**
** Error:
**    Returns error if <inputSymbol> doesn't point to a module.
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetModuleTimestamp(SYM_DESCRIPTOR     inputSymbol,
                      TIMESTAMP_TYPE FAR *timestamp);

/*--------------------------------------------------------------------------*/
/* SymGetSourceStatement
**
** Purpose:
**    Retrieve source statement information from symbol table (for IAR's UBROF).
**
** Input parameters:
**    srcStatement: the source statement information.
**    codeAddrRange: address range of the statement's code; if not known, set to 0
**
** Output parameters:
**    none:
**
** Error:  Standard "out of memory" if no room for source statement
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetSourceStatement(SOURCE_RANGE_TYPE *srcStatement,
                      ADDR_RANGE_TYPE *codeAddrRange);

/***************************
 ** GENERAL SYMBOL ACCESS **
 ***************************/

/*--------------------------------------------------------------------------*/
/* SymGetSymbolFromContext
**
** Purpose:
**    Given a descriptor into the symbol table, look up an item with the
**    name <symName> and type <symType>.  Return a descriptor to it, its
**    type, and whether it is global or not.  This routine is used to look up
**    a symbol local to an already-established context, esp. after a
**    breakpoint.
**
** Input parameters:
**    inputSymbol:
**        base level context from which to search; could be module, function,
**        or even variable.
**    symName:
**        long pointer to the name to be looked up.
**    symType:
**        indicates the type to be looked up.  If set to SYM_UNDEFINED, then
**        also used as an output for the type found that matches the name.
**
** Output parameters:
**    symType:
**        If set to SYM_UNDEFINED on entry to the function, used as output
**        to hold the type found that matches the name.  If name not found,
**        value stays SYM_UNDEFINED.
**    outputSymbol:
**        descriptor to symbol found; it can
**        be used in subsequent call to get detailed information.
**    isGlobal:
**        TRUE if either the symbol found is global or there is
**        a matching global symbol name; otherwise it is FALSE
**
** Error:
**    reports ER_SYMBOL_NOT_FOUND if the symbol is not found.
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetSymbolFromContext(SYM_DESCRIPTOR     inputSymbol,
                        LPSTR              symName,
                        SYM_TYPE_TYPE  FAR *symType,
                        SYM_DESCRIPTOR FAR *outputSymbol,
                        BOOLEAN        FAR *isGlobal);


/********************************************************
 *** ROUTINES TO ACCESS AND WALK THE TABLE OF SYMBOLS ***
 ********************************************************/
/* These routines are used for displaying successive symbols or for access
   to the next symbol after a lookup (e.g. function parameters and locals) */


/*--------------------------------------------------------------------------*/
/* SymGetSymbolAddress
**
** Purpose:
**    Get the address range of the (generic) symbol.
**
** Input parameter:
**    inputSymbol: symbol descriptor
**
** Output parameters:
**    symbolAddress: caller alloc's memory for address; this function fills
**      in the value
**
** Error: none
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetSymbolAddress(SYM_DESCRIPTOR inputSymbol,
                    ADDR_RANGE_TYPE *symbolAddrRange);


/*--------------------------------------------------------------------------*/
/* SymGetSymbolChild
**
** Purpose:
**    Get child of <inputSymbol>.  Return it in <nextSymbol> and its type in
**    <symType>.
**
** Input parameter:
**    inputSymbol: symbol for which to get child
**
** Output parameters:
**    symType: type of child; invalid if nextSymbol = NULL_SYMBOL
**    nextSymbol: descriptor to child found; NULL_SYMBOL if none exists
**
** Error: none
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetSymbolChild(SYM_DESCRIPTOR     inputSymbol,
                  SYM_TYPE_TYPE  FAR *symType,
                  SYM_DESCRIPTOR FAR *nextSymbol);


/*--------------------------------------------------------------------------*/
/* SymGetSymbolHeadList
**
** Purpose:
**    Get a descriptor to the head of a linked list stored in <inputSymbol>
**    and of type <basicSymType>. Return descriptor to the first element of
**    linked list plus a count of the number of items in the linked list.
**    This routine only works for symbol types which have linked lists of
**    other symbols off it such as modules, functions, and blocks.
**    For example, need to get each item from subtype of a given function -
**    i.e. labels, vars, constants, etc.
**
** Input parameter:
**    inputSymbol: descriptor of parent symbol from where to access child
**    basicSymType: the desired list; e.g. vars, labels, constants
**
** Output parameters:
**    list:
**        descriptor to the requested list; list is empty if descriptor is
**        NULL_SYMBOL or childCount = 0
**    listCount: number of items in list of parent symbol
**
** Error:
**    Returns error if <basicSymType> is not a valid type for the type of
**    <inputSymbol>.
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetSymbolHeadList(SYM_DESCRIPTOR     inputSymbol,
                     SYM_TYPE_TYPE      basicSymType,
                     SYM_DESCRIPTOR FAR *list,
                     U16            FAR *listCount);


/*--------------------------------------------------------------------------*/
/* SymGetSymbolName
**
** Purpose:
**    Get the name of the (generic) symbol.
**
** Input parameter:
**    inputSymbol: symbol descriptor
**
** Output parameters:
**    symbolName: pointer to descriptor that is TMalloc'ed.  This function
**       alloc's the memory for the name.  Caller is responsible for TFree'ing
**    NOTE: if the input descriptor is invalid, the function still alloc's
**          a minimum of one byte, puts NULL in it, and puts the pointer to
**          the memory in the return parameter.
**
** Error: none
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetSymbolName(SYM_DESCRIPTOR     inputSymbol,
                 LPSTR              *symbolName);


/*--------------------------------------------------------------------------*/
/* SymGetSymbolParent
**
** Purpose:
**    Get parent of <inputSymbol>, return it in <nextSymbol> and its type in
**    <symType>.
**
** Input parameter:
**    inputSymbol: symbol for which to get sibling
**
** Output parameters:
**    symType: type of parent; invalid if nextSymbol = NULL_SYMBOL
**    nextSymbol: descriptor to parent found; NULL_SYMBOL if none exists
**
** Error: none
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetSymbolParent(SYM_DESCRIPTOR     inputSymbol,
                   SYM_TYPE_TYPE  FAR *symType,
                   SYM_DESCRIPTOR FAR *nextSymbol);


/*--------------------------------------------------------------------------*/
/* SymGetSymbolSibling
**
** Purpose:
**    Get sibling of <inputSymbol>.  Return it in <nextSymbol> and its type
**    in <symType>.
**
** Input parameter:
**    inputSymbol: symbol from which to get sibling
**
** Output parameters:
**    symType: type of symbol found; undefined if nextSymbol = NULL_SYMBOL
**    nextSymbol: descriptor to sibling found; NULL_SYMBOL if none exists
**
** Error: none
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetSymbolSibling(SYM_DESCRIPTOR     inputSymbol,
                    SYM_TYPE_TYPE  FAR *symType,
                    SYM_DESCRIPTOR FAR *nextSymbol);

/*--------------------------------------------------------------------------*/
/* SymGetAllModules
**
** Purpose:
**    Get all modules loaded.
**
** Input parameter:
**    none
**
** Output parameters:
**    moduleList:   list to hold module descriptor - SYM_DESCRIPTOR[listCount].
**    listCount:    maximum number of modules that moduleList can hold.
**    numReturned:  the actual number of modules found. <= listCount.
** Error: none
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetAllModules(SYM_DESCRIPTOR FAR *moduleList,
                 U16                listCount,
                 U16 FAR            *numReturn);


/**************************************
 ** CONTEXT-DEPENDENT TYPE RETRIEVAL **
 **************************************/

/****************************
 ** GET: (g) BITFIELD TYPE **
 ****************************/

/*--------------------------------------------------------------------------*/
/* SymGetTypeBitfield
**
** Purpose:
**    Given an index to a (g) bitfield type, retrieve its information.
**
** Input parameters:
**    typeIndex: index of type
**
** Output parameters:
**    bitfieldStruct: structure holding information about the bitfield
**
** Error: Reports error if:
**    <typeIndex> doesn't point to a (g) bitfield type
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetTypeBitfield(TYPE_INDEX               typeIndex,
                   TYPE_BITFIELD_STRUCT FAR *bitfieldStruct);


/*******************************************
 ** GET: (Z) C ARRAY with lower bound = 0 **
 *******************************************

/*--------------------------------------------------------------------------*/
/* SymGetTypeCArray
**
** Purpose:
**    Given an index to a (Z) C array with lower bound=0, retrieve its
**    information.
**
** Input parameters:
**    typeIndex: index of type
**
** Output parameters:
**    cArrayStruct: structure holding information about C array type
**
** Error: Reports error if:
**    <typeIndex> doesn't point to a (Z) range type
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetTypeCArray(TYPE_INDEX        typeIndex,
                 TYPE_C_ARRAY_STRUCT FAR *cArrayStruct);

/*******************************************
 ** GET: ARRAY for OMF51
 *******************************************
/*--------------------------------------------------------------------------*/
/* SymGetTypeArray51
**
** Purpose:
**    Given an index to an array in OMF51 format, retrieve its
**    information.
**
** Input parameters:
**    typeIndex: index of type
**
** Output parameters:
**    arrayStruct: structure holding information about OMF51 array type
**
** Error: Reports error if:
**    <typeIndex> doesn't exist in the type table
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT SymGetTypeArray51(TYPE_INDEX typeIndex,
                                 TYPE_OMF51_ARRAY_STRUCT *arrayStruct);

/*---------------------------------------------------------------------------
** SymGetTypeArrayDimSizeNth
**
** Purpose:
**    Given the type index to an array, and specified the Nth dimension,
**    retrieve the dimension size.
**
** Input parameters:
**    typeIndex: Type index to the array
**    n        : Dimension number starting from 1.
**
** Output parameters: dimension size of the Nth dimension of an OMF51 array
**
** Error: Reports error if:
**    <typeIndex> doesn't exist in the type table
**--------------------------------------------------------------------------*/
RETCODE EXPORT SymGetTypeArrayDimSizeNth(TYPE_INDEX typeIndex,
                                         U8 n, DIMENSION *dimSize);

/******************************************
 ** GET: (N) C language ENUMERATION TYPE **
 ******************************************/

/*--------------------------------------------------------------------------*/
/* SymGetTypeEnumName
**
** Purpose:
**    Look up the symbolic name of the (N) enumerated type given an integer
**    value.
**
** Input parameters:
**    typeIndex:
**        index to type of variable previously looked up by name or address
**    enumValue: 32 bit value to be looked up
**
** Output parameters:
**    enumName: resulting name; empty if no match
**    noMatch: TRUE if value didn't match any stored value
**
** Error:
**    Reports error if typeIndex doesn't point to an (N) enum type
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetTypeEnumName(TYPE_INDEX  typeIndex,
                   U32         enumValue,
                   LPSTR       enumName,
                   BOOLEAN FAR *noMatch);


/*--------------------------------------------------------------------------*/
/* SymGetTypeEnumValue
**
** Purpose:
**    Looks up the numeric value given the name of (N) enum component.
**    Opposite of SymGetTypeEnumName.
**
** Input parameters:
**    typeIndex:
**        index to type of variable prviously looked up by name or address
**    enumName: name to be looked up
**
** Output parameters:
**    enumValue: resulting number representing the name
**    noMatch: FALSE if name didn't match any stored name
**
** Error:
**    Reports error if typeIndex doesn't point to an (N) enum type
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetTypeEnumValue(TYPE_INDEX  typeIndex,
                    LPSTR       enumName,
                    U32     FAR *enumValue,
                    BOOLEAN FAR *noMatch);


/**********************
 ** GET: TYPE HEADER **
 **********************/

/*--------------------------------------------------------------------------*/
/* SymGetTypeHeader
**
** Purpose:
**    Retrieve the common header information for a type.  It is contained in a
**    structure.  Required before specific type information can be extracted.
**
** Input parameters:
**    typeIndex: index into type table
**
** Output parameters:
**    typeHeader:
**       structure containing the type of type and its size in MAUs
**
**    NOTE: the TYPE_HEADER_TYPE structure includes a pointer to the
**          name of the type returned.  This memory must be allocated
**          by the caller and the pointer put into the typeName field before
**          calling this function, otherwise, GPF.
**
** Error:
**    Reports error if <typeIndex> doesn't point to an entry in the type table
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetTypeHeader(TYPE_INDEX           typeIndex,
                 TYPE_HEADER_TYPE FAR *typeHeader);


/*************************
 ** GET: TYPE INDEX MAX **
 *************************/

/*--------------------------------------------------------------------------*/
/* SymGetTypeIndexMax
**
** Purpose:
**    Returns the maximum index loaded into the type index table so far.  Used
**    by loader to calculate the typeDelta value for loading the next module's
**    types (which restart numbering at T100).
**    NOTE: built-ins use the first 256 type indices, therefore the smallest
**          value returned is 0x100.  The loader must compensate for this.
**
** Input parameters: None
**
** Output parameters:
**    typeIndexMax: maximum type index loaded so far into type index table
**
** Error: None
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetTypeIndexMax(TYPE_INDEX FAR *typeIndexMax);


/****************************
 ** GET: TYPE MEMBER COUNT **
 ****************************/

/*--------------------------------------------------------------------------*/
/* SymGetTypeMemberCount
**
** Purpose:
**    Given an index to a type, return the number of members that make it up.
**    If the type is a simple type or a fixed sized complex type, returns 1.
**    If the type has nesting, the count only includes those components at
**    the first level.
**
** Input parameters:
**    typeIndex: index of type
**
** Output parameters:
**    memberCount: number of members
**
** Error: Reports error if:
**    <typeIndex> doesn't point to a valid entry in the type table
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetTypeMemberCount(TYPE_INDEX typeIndex,
                      U16    FAR *memberCount);


/**********************************************
 ** GET: (O,P) SMALL AND LARGE POINTER TYPES **
 **********************************************/

/*--------------------------------------------------------------------------*/
/* SymGetTypePointerTypeIndex
**
** Purpose:
**    Given an index to a small (O) pointer or large (P) type, retrieve the
**    type index to the pointer's type.
**
** Input parameters:
**    typeIndex: index of type
**
** Output parameters:
**    pointerTypeIndex: type index to pointer's type
**
** Error: Reports error if:
**    <typeIndex> doesn't point to a pointer type
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetTypePointerTypeIndex(TYPE_INDEX     typeIndex,
                           TYPE_INDEX FAR *pointerTypeIndex);

/********************************
 ** GET : OMF51 Pointer type   **
 *******************************/
/*--------------------------------------------------------------------------*/
/* SymGetTypePointer51
**
** Purpose:
**    Get OMF51 space pointer type.
**
** Input parameters:
**    typeIndex: Type index that the pointer points to.
**
** Output parameters:
**    ptrStruct: OMF51 generic pointer type information
**
** Error: Reports error if:
**    <typeIndex> doesn't exist.
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT SymGetTypePointer51(TYPE_INDEX typeIndex,
                                   TYPE_OMF51_PTR_STRUCT *ptrStruct);


/***********************************
 ** GET: (S,U) STRUCTURE OR UNION **
 ***********************************/

/*--------------------------------------------------------------------------*/
/* SymGetTypeStructUnion
**
** Purpose:
**    Look up the name of a structure or union component given an index to
**    the type.  Return the component's information and the component
**    index (where 0 is the first index).
**
** Input parameters:
**    typeIndex: index of type
**    structName: name of structure or union component to be looked up
**
** Output parameters:
**    structOrUnion: 3 elements making up the component
**    componentIndex: component index found, where first is 0
**    noMatch: FALSE if name didn't match any stored name
**
**
** Error: Reports error if:
**    <typeIndex> doesn't point to an entry in the type table or to a
**      (S) or (U) type
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetTypeStructUnion(TYPE_INDEX          typeIndex,
                      LPSTR               structName,
                      TYPE_S_U_STRUCT FAR *structOrUnion,
                      U16             FAR *componentIndex,
                      BOOLEAN         FAR *noMatch);


/*--------------------------------------------------------------------------*/
/* SymGetTypeStructUnionNth
**
** Purpose:
**    Given a data structure or union (S,U), retrieve nth component
**
** Input parameters:
**    typeIndex: index of type
**    n: nth component to be extracted where 0 is first
**
** Output parameters:
**    structOrUnion: 3 elements of nth structure or union component
**
** Error: Reports error if:
**    <typeIndex> doesn't point to an entry in the type table or to an
**      unknown type
**    Value of n beyond the number of components
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetTypeStructUnionNth(TYPE_INDEX          typeIndex,
                         U16                 n,
                         TYPE_S_U_STRUCT FAR *structOrUnion);


/***********************************
 ** GET: (T) TYPE NAME DEFINITION **
 ***********************************/

/*--------------------------------------------------------------------------*/
/* SymGetTypeTypeIndex
**
** Purpose:
**    Given an index to a (T) type name definition, retrieve its type index.
**
** Input parameters:
**    typeIndex: index of type
**
** Output parameters:
**    typeTypeIndex: type index to type's type
**
** Error: Reports error if:
**    <typeIndex> doesn't point to a type type
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetTypeTypeIndex(TYPE_INDEX     typeIndex,
                    TYPE_INDEX FAR *typeTypeIndex);

RETCODE EXPORT
SymGetTypeTypeType(TYPE_INDEX typeIndex,       
                   TYPE_INDEX *typeTypeIndex,
                   SEGMENTTYPE *segType);
                   
/*********************
 *** GET: VARIABLE ***
 *********************/

/*--------------------------------------------------------------------------*/
/* SymGetVar
**
** Purpose:
**    Given a descriptor to a variable, get its stored information which
**    includes its name, index to its type, storage class, whether it is a
**    constant, and its "address".
**    Note that "address" takes multiple forms.
**
** Input parameter:
**    inputSymbol: points to variable
**
** Output parameters:
**    varName: string of variable name; use MAX_SYMNAME_LENGTH for allocation
**    typeIndex: index to the variable type, size, etc.
**    storageClass: form of variable; used to interpret varAddr
**    registerClass: mapping of register to variable
**    isConstant: boolean indicating if the variable is read-only (TRUE) or
**                not (FALSE)
**    varAddr:
**        variable address; a union which is interpreted based on storageClass
**        and registerClass
**    funcDescriptor: descriptor to the function holding the requested
**                    variable.
**    moduleDescriptor: descriptor to the module holding the requested
**                      variable.
**    parentDescriptor: descriptor to the parent of the requested
**                      variable.
**
** Error:
**    reports ER_INVALID_ADDRESS if the isValidAddr field is FALSE
**    reports ER_DESCRIPTOR_NOT_VALID error if the descriptor does not point
**       to a variable
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymGetVar(SYM_DESCRIPTOR      inputSymbol,
          LPSTR               varName,
          TYPE_INDEX          FAR *typeIndex,
          VAR_STORAGE_CLASS   FAR *storageClass,
          VAR_REGISTER_CLASS  FAR *registerClass,
          BOOLEAN             FAR *isConstant,
          SYM_DESCRIPTOR      FAR *funcDescriptor,
          SYM_DESCRIPTOR      FAR *moduleDescriptor,
          SYM_DESCRIPTOR      FAR *parentDescriptor,
          GET_VAR_ADDR_STRUCT FAR *varAddr);

/*--------------------------------------------------------------------------*/
/* SymGetVarLifetimeInfo
**
** Purpose:
**    Given a descriptor to a variable get the current PC and determine
**    if the variable is currently DEAD or aLIVE.
**
** Input parameter:
**    inputSymbol: points to variable
**
** Output parameters:
**    lifetimeState: current living state of variable (i.e.: DEAD or LIVE)
**
** Error:
**    reports ER_INVALID_SYM_DESCRIPTOR if it's an invalid symbol descriptor
**    reports ER_NOT_A_VARIABLE or ER_NO_LIFETIME_INFO if symbol doesn't
**    have lifetime info.
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT SymGetVarLifetimeInfo(SYM_DESCRIPTOR      inputSymbol,
                                     VAR_LIFETIME_STATE FAR *lifetimeState);


/*--------------------------------------------------------------------------*/
/* SymInitialize
**
** Purpose:
**    Sets up the symbol table and intialized pertinent variables.
**
** Input parameter: none
**
** Output parameters: none
**
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymInitialize();


/************************************
 *** ACCESSING SYMBOLS BY ADDRESS ***
 ************************************/

/*--------------------------------------------------------------------------*/
/* SymMapAddr2Linenum
**
** Purpose:
**    Given an abstract address and a module descriptor, map to the closest
**    matching line number.  Its address must be less than or equal to
**    the requested address.  If line numbers are not loaded, this function
**    first calls the loader to load them.
**    This function is called if the module is already known - usually from
**    the source browser.  It is faster than SymMapAddr2LinenumModule since
**    it does not have to look up the module first.
**
** Input parameters;
**    linenumAddr: abstract address to be looked up.
**    moduleDescriptor:
**       module descriptor that points to the line number list for that module
**       Was previously looked up with SymMapAddr2Symbol or
**         SymMapAddr2LinenumModule
**
** Output parameters:
**    linenum:
**       The line number found that is closest less than or equal to
**       <linenumAddr>
**    column: column value assigned to the linenum
**    addrRange:
**        the start and end address of the linenum found
**    index: abstract pointer to the line number found; can be used to get
**           more information about line number with SymGetLinenumByIndex or
**           SymGetLinenumStmtByIndex
**
** Error:
**    Error reported if abstract address cannot be translated to an address
**       that can be looked up
**    Error reported if no line number address is less than the requested
**       address
**    Error reported if there are no line numbers for the module
**    Error reported if the module SYM_DESCRIPTOR is invalid
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymMapAddr2Linenum(OFFSET_ADDR_TYPE           linenumAddr,
                   SYM_DESCRIPTOR             module,
                   LINENUM_TYPE           FAR *linenum,
                   COLUMN_TYPE            FAR *column,
                   ADDR_RANGE_TYPE        FAR *addrRange,
                   LINENUM_DESCRIPTOR     FAR *index);


/*--------------------------------------------------------------------------*/
/* SymMapAddr2LinenumStmt
**
** Purpose:
**    Given an abstract address and a module descriptor, map to the closest
**    matching statement.  Its address must be less than or equal to
**    the requested address.  If line numbers are not loaded, this function
**    first calls the loader to load them.
**    This function is called if the module is already known - usually from
**    the source browser.  It is faster than SymMapAddr2LinenumModule since
**    it does not have to look up the module first.
**
** Input parameters;
**    linenumAddr: abstract address to be looked up.
**    moduleDescriptor:
**       module descriptor that points to the line number list for that module
**       Was previously looked up with SymMapAddr2Symbol or
**         SymMapAddr2LinenumModule
**
** Output parameters:
**    linenum:
**       The line number found that is closest less than or equal to
**       <linenumAddr>
**    columnRange: column range value assigned to the statement
**    addrRangeDesc:
**        the start and end address of the linenum found
**    index: abstract pointer to the line number found; can be used to get
**           more information about line number with SymGetLinenumByIndex or
**           SymGetLinenumStmtByIndex
**
** Error:
**    Error reported if abstract address cannot be translated to an address
**       that can be looked up
**    Error reported if no line number address is less than the requested
**       address
**    Error reported if there are no line numbers for the module
**    Error reported if the module SYM_DESCRIPTOR is invalid
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymMapAddr2LinenumStmt(OFFSET_ADDR_TYPE           linenumAddr,
                       SYM_DESCRIPTOR             module,
                       LINENUM_TYPE           FAR *linenum,
                       COLUMN_RANGE_TYPE      FAR *columnRange,
                       ADDR_RANGE_TYPE        FAR *addrRange,
                       LINENUM_DESCRIPTOR     FAR *index);


/*--------------------------------------------------------------------------*/
/* SymMapAddr2LinenumModule
**
** Purpose:
**    Given only an abstract address, map it to its parent (enclosing) module
**    and the closest matching line number.  This function returns the same
**    data as SymMapAddr2Linenum.  In addition, it returns the module
**    descriptor and address range of the module.  This function essentially
**    is the combination of SymMapAddr2Symbol followed by SymMapAddr2Linenum.
**
** Input parameters;
**    linenumAddr: abstract address to be looked up.
**
** Output parameters:
**    module:
**       module descriptor of module that contains requested address
**    modAddrRangeDesc: address range of module that contains requested addr
**    linenum:
**       The line number found that is closest less than or equal to
**       <linenumAddr>
**    column: column value assigned to the linenum
**    addrRange:
**        the start and end address of the linenum found
**    index: abstract pointer to the line number found; can be used to get
**           more information about line number with SymGetLinenumByIndex or
**           SymGetLinenumStmtByIndex
**
** Error:
**    Error reported if abstract address cannot be translated to an address
**       that can be looked up
**    Error if address does not match any module
**    Error reported if no line number address is less than the requested
**       address
**    Error reported if there are no line numbers for the module
**    Error reported if the moduleDescriptor is invalid
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymMapAddr2LinenumModule(OFFSET_ADDR_TYPE           linenumAddr,
                         SYM_DESCRIPTOR         FAR *module,
                         ADDR_RANGE_TYPE        FAR *modAddrRange,
                         LINENUM_TYPE           FAR *linenum,
                         COLUMN_TYPE            FAR *column,
                         ADDR_RANGE_TYPE        FAR *addrRange,
                         LINENUM_DESCRIPTOR     FAR *index);


/*--------------------------------------------------------------------------*/
/* SymMapAddr2LinenumStmtModule
**
** Purpose:
**    Given only an abstract address, map it to its parent (enclosing) module
**    and the closest matching line number statement.  This function is the
**    same as SymMapAddr2LinenumModule except it looks up the statement
**    that matches the address and returns the column range which includes
**    both the start and end column.
**
** Input parameters;
**    linenumAddr: abstract address to be looked up.
**
** Output parameters:
**    module:
**       module descriptor of module that contains requested address
**    modAddrRangeDesc: address range of module that contains requested addr
**    linenum:
**       The line number found that is closest less than or equal to
**       <linenumAddr>
**    columnRange: column start and end value assigned to the linenum
**    addrRange:
**        the start and end address of the linenum found
**    index: abstract pointer to the line number found; can be used to get
**           more information about line number with SymGetLinenumByIndex or
**           SymGetLinenumStmtByIndex
**
** Error:
**    Error reported if abstract address cannot be translated to an address
**       that can be looked up
**    Error if address does not match any module
**    Error reported if no line number address is less than the requested
**       address
**    Error reported if there are no line numbers for the module
**    Error reported if the moduleDescriptor is invalid
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymMapAddr2LinenumStmtModule(OFFSET_ADDR_TYPE           linenumAddr,
                             SYM_DESCRIPTOR         FAR *modDesc,
                             ADDR_RANGE_TYPE        FAR *modAddrRange,
                             LINENUM_TYPE           FAR *linenum,
                             COLUMN_RANGE_TYPE      FAR *columnRange,
                             ADDR_RANGE_TYPE        FAR *addrRange,
                             LINENUM_DESCRIPTOR     FAR *index);

/*--------------------------------------------------------------------------*/
/* SymMapAddr2Symbol
**
** Purpose:
**    Map an abstract address to a symbol that contains it.  It returns
**    the symbol with a starting address closest to the requested
**    address.  It also returns its type and parent information.  This
**    routine returns a symbol descriptor, then the caller
**    makes another call to get specific information about the symbol.
**
** Input parameters;
**    codeAddr: abstract address to be looked up.
**
** Output parameters:
**    memoryClass:
**       what basic symbol class; to be completed with hints when they are
**       implemented.  If an address match is not found, the memoryClass
**       value gives the caller more general information about the address
**    symbolType: basic symbol type - part of every symbol
**    offset:
**        distance the requested address is from the matching start address
**    outputSymbol:
**        descriptor to the symbol found that is closest to the requested addr
**    funcDescriptor: offset to parent function; NULL_SYMBOL if none exists
**    moduleDescriptor: offset to parent module; NULL_SYMBOL if none exists
**
** Error:
**    Error reported if abstract address cannot be translated to an address
**    that can be looked up
**    Error reported if address not found
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymMapAddr2Symbol(ADDRESS_TYPE   inputAddr,
                  MEM_ADDR_CLASS FAR *memoryClass,
                  SYM_TYPE_TYPE  FAR *symbolType,
                  U32            FAR *offset,
                  SYM_DESCRIPTOR FAR *outputSymbol,
                  SYM_DESCRIPTOR FAR *funcDescriptor,
                  SYM_DESCRIPTOR FAR *moduleDescriptor);

/*--------------------------------------------------------------------------*/
/* SymMapCodeAddr2Range
**
** Purpose:
**    Map an abstract address to a logical address range that contains this
**    address (addr.h routines must convert the logical address to physical
**    address). The address range is looked up by its specified
**    <codeClass>.  This routine is generally used by symbolic trace
**    disassembly with repetitive address lookup routines, where the next
**    address is likely to be located inside the same symbol range.  It is
**    also used to locate an emulator (code) break and map it to source line.
**    If a line number is looked up (codeClass=CT_LINENUM), the offset from
**    the line number can be calculated by subtracting the requested address
**    from the startAddr value returned (assuming the caller knows the
**    requested address is physical, or converts it to physical).
**
** Input parameters:
**    codeAddr: abstract address to be looked up.
**    codeClass:
**        indicates which range of addresses to return; if <unknown>, use
**        CT_UNKNOWN.
**
** Output parameters:
**    symbolName:
**        name of matching symbol containing <physAddr>; valid when
**        <codeClass> is NOT CT_LINENUM; use MAX_SYMNAME_LENGTH for allocation
**    linenum:
**        numeric value of line number; valid when <codeClass> is CT_LINENUM
**    addrRange:
**        start and end addresses of the symbol found that contains the
**        input address.  These are to be used locally by caller to check
**        next address for a match, thus reducing calls to this function: only
**        call when the next address does NOT fall into <addrRangeDesc>.
**    isFound:
**        indicates if a symbol of <codeClass> had an address range that
**        contains <addr>.  If FALSE, <symbolName> holds the
**        name of the HINT that matched the address, or, if no HINT is
**        found, "undefined".
**
** Error:
**   Error reported if abstract address cannot be translated to an address
**      that can be looked up and returned as a logical address range.
**   Error if address is not a code address.
*/
/*--------------------------------------------------------------------------*/

RETCODE EXPORT
SymMapCodeAddr2Range(OFFSET_ADDR_TYPE           codeAddr,
                     CODE_CLASS                 codeClass,
                     LPSTR                      symbolName,
                     U32                    FAR *linenum,
                     ADDR_RANGE_TYPE        FAR *addrRange,
                     BOOLEAN                FAR *isFound);


/*--------------------------------------------------------------------------*/
/* SymMapLinenum2FuncOrBlock
**
** Purpose:
**    Given a line number and its context, look up the most local function or
**    block that contains it.  Return the type (function or block), a
**    descriptor to it, and whether it was found or not.
**
** Input parameters;
**    module: pointer to module containing the line number.
**    linenum:
**        line number to be mapped to the function or block that contains it
**
** Output parameters:
**    symType: SYM_FUNCTION or SYM_BLOCK
**    outputSymbol: descriptor to the function or block
**
** Error:
**    Reports error if:
**        moduleName not found
**        linenum not in module context
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT
SymMapLinenum2FuncOrBlock(SYM_DESCRIPTOR     module,
                          LINENUM_TYPE       linenum,
                          SYM_TYPE_TYPE  FAR *symType,
                          SYM_DESCRIPTOR FAR *outputSymbol);


/*--------------------------------------------------------------------------*/
/* SymRemoveSymbols
**
** Purpose:
**    Removes all symbols that have been loaded.
**
** Input parameters;
**
** Output parameters:
*/
/*--------------------------------------------------------------------------*/
RETCODE EXPORT SymRemoveSymbols(VOID);


//------------------------------------------------------------------------
// SymCalcSymbolOffset
//
// Description:
//    Given a symbol descriptor and address, calculate the offset from
//    the beginning of that symbol to the input address.  If the input
//    address is less than the start of the symbol range, return a value
//    of 0.
//
// Input parameters:
//    symDesc: symbol descriptor to address to be compared
//    inputAddr: address to be compared with symbol's start address
//
//    NOTE: none of the descriptors are destroyed; this is the job of
//    the caller.  Also, none of the contents of the descriptors are
//    modified.
//
// Output parameter:
//    symbolOffset: simple offset (U32) from start to requested addr
//------------------------------------------------------------------------
RETCODE EXPORT
SymCalcSymbolOffset(SYM_DESCRIPTOR    symDesc,
                    ADDRESS_TYPE      inputAddr,
                    U32 FAR   *symbolOffset);


/*--------------------------------------------------------------------------*/
/* SymMapRegAddr2Var
**
** Purpose:
**    Look up a register variable given its index value and a
**    descriptor to the function it is defined in.  Returns its name,
**    its type index, its storage and register class, access to the full
**    "address" struct, a descriptor to the variable, and whether it was
**    found or not. The register can represent a passed parameter or local
**    variable.  It is assumed here that the caller will know the difference.
**
**    This routine could have problems because register allocations can change
**    and be reassigned to different variables within the same function or
**    block.  Also, with ATN 9 variable lifetime records, some states within
**    the procedure (state meaning position in execution) are represented as
**    "dead" register; i.e. the register isn't valid.
**    Also, register-to-variable representation is not stored in any sorted
**    manner.  All vars within the function have to be searched to find the
**    register assignments.
**
** Input parameters:
**    reg:
**        register index. This is processor dependent.  Loaders should conform
**        to the IEEE695 definitions and assignments as defined in the
**        appendices called Family Definitions (appendix F for 680X0)
**    function:
**        descriptor to function connected with register context; usually
**        obtained from source code line number reference or breakpoint code
**        location
**
** Output parameters:
**    symbolName: name looked up; use MAX_SYMNAME_LENGTH for allocation
**    typeIndex: index to variable's type
**    storageClass: indicates class of variable.
**    registerClass: indicates what type of variable the register represents
**        indicates class of variable.
**    varAddr:
**        complete class information on var including frame offset if it is a
**        locked register
**    outputSymbol: descriptor to symbol that the register is mapped to
**    isFound:
**        indicates if symbol found. If FALSE, symbol table doesn't hold
**        its reference.
**
** Error:
**    Reports error if index value isn't a valid stored index for variable
*/
/*--------------------------------------------------------------------------*/

RETCODE EXPORT
SymMapRegAddr2Var(REG_INDEX          reg,
                  SYM_DESCRIPTOR     function,
                  LPSTR              symbolName,
                  TYPE_INDEX         typeIndex,
                  VAR_STORAGE_CLASS  *storageClass,
                  VAR_REGISTER_CLASS *registerClass,
                  VOID               *varAddr,
                  SYM_DESCRIPTOR     *outputSymbol,
                  BOOLEAN            *isFound);


/*--------------------------------------------------------------------------*/
/* SymMapStackAddr2Var
**
** Purpose:
**    Look up a stack variable given its offset from top of stack frame and
**    a descriptor to the function it is defined in.  Returns its name,
**    index to its type, its class, its start and end (offset) address,
**    a descriptor to the variable, and whether it was found or not.
**    The var can be a passed parameter or local variable.  It is assumed here
**    that the caller will know the difference by the sign of offsetAddr.
**
** Input parameters;
**    offsetAddr: signed distance from top of stack frame
**    function: descriptor to function connected with stack frame; usually
**        obtained from source code function reference or breakpoint code
**        location
**
** Output parameters:
**    symbolName: name looked up; use MAX_SYMNAME_LENGTH for allocation
**    typeIndex: index to variable's type
**    storageClass: class of variable
**    registerClass: mapping of register to variable
**    size:
**        size of variable (in bytes)
**    offset:
**        distance the requested address is from the variable's start address
**    outputSymbol: descriptor to symbol
**    isFound:
**        indicates if symbol found. If FALSE, <symbolName> holds name of
**        HINT that matched the address, or, if no HINT is found, "undefined".
**
** Error:
**    1) <offsetAddr> larger than any local variable or param for that
**       function
**    2) inputSymbol doesn't point to a function
*/
/*--------------------------------------------------------------------------*/

RETCODE EXPORT
SymMapStackAddr2Var(S16                offsetAddr,
                    SYM_DESCRIPTOR     function,
                    LPSTR              symbolName,
                    TYPE_INDEX         typeIndex,
                    VAR_STORAGE_CLASS  *storageClass,
                    VAR_REGISTER_CLASS *registerClass,
                    U16                *size,
                    U16                *offset,
                    SYM_DESCRIPTOR     *outputSymbol,
                    BOOLEAN            *isFound);


int SrcGetModuleNum(U16& num);
int SrcGetModuleName(U32 moduleDesc , LPSTR str);
int SrcGetModuleRange(U32 moduleDesc , U32& start , U32& end);
int SrcGetModuleIndex(U16 num , U32* buffer , U16& returnNum);
int SrcAddr2Linenum(U32 addr , U16& linenum , U32& moduleDesc);
int SrcAddr2LinenumStart(U32 addr , U16& linenum , U32& moduleDesc);
int SrcAddr2LinenumRange(U32 addr,U16& linenum,U32& startAddr,U32& endAddr);
BOOL IsLibFunction( unsigned short uAddr );
void GetLineRange(unsigned short uAddr , unsigned short& uStart ,
                                         unsigned short& uEnd );
void GetStatementRange(unsigned short uAddr , unsigned short& uStart ,
                                         unsigned short& uEnd );
int SrcGetLoadPath( CString& str );

int SrcAddr2Statement(U32 addr,U16& linenum,U16& startCol,
                    U16& endCol,U32& moduleDesc);
int SrcAddr2StatementRange(U32 addr,U16& linenum,U16& startCol,
        U16& endCol,U32& startAddr,U32& endAddr);
        
int SrcLinenum2Addr(U32 moduleDesc , U16 linenum , U32& addr);
int SrcLinenum2Range(U32 moduleDesc,U16 linenum,
        U32& startAddr , U32& endAddr);
void DisplayLinenum( SYM_DESCRIPTOR moduleDesc ); 
void DisplayStatement( SYM_DESCRIPTOR moduleDesc ) ;
int SrcGetLdrStats(LPSTR moduleName,U32 *numSymbols,U16 *numModules,
    U32 *numTypes , U32 *numFuncs , U32 *linenums , U32 *bytes , int *percent);

int SrcGetNextFunc(SYM_DESCRIPTOR funcDesc,LPSTR funcName,
    SYM_DESCRIPTOR& nextDesc);
int SrcGetFirstFuncIndex(SYM_DESCRIPTOR moduleDesc,
    SYM_DESCRIPTOR& funcDesc);

#ifdef __cplusplus
}
#endif

int StackAddrMapBlock(U32 addr , SYM_DESCRIPTOR& moduleDesc ,
            SYM_DESCRIPTOR& funcDesc , SYM_DESCRIPTOR& blockDesc);

#define _SYMBLSVR_
#endif
/******************************** E O F ***********************************/
