
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SYMCLI.H__   1.7.1.0.1.2   09 Dec 1996 10:14:50   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SYMCLI.H__  $
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:14:50   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:58:08   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:15:06   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:26:40   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:53:46   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:47:22   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:52:06   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:55:28   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:38:04   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:00:22   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:14:48   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:22:40   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:02:24   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:41:18   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:56:16   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:07:34   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:34:02   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:47:56   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:19:12   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:14:24   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:14:16   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:33:10   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:26:56   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:11:44   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:13:18   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:11:22   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:08:50   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:31:38   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:18:18   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:24:00   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:28:16   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:29:02   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:41:36   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:07:18   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:46:56   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:28   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:26:16   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:48:58   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:22:26   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:49:24   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:57:00   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:49:40   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:53:30   Shirley
** Initial revision.
**
****************************************************************************/

/****************************************************************************
**
**  Name:  symcli.h
**
**  Description:
**     Prototype for the symbol server CLI parse routines
**
**  Status:  PRELIMINARY
**
**  $Log$
** 
**  $Header:   D:/EPSLDV1/SRC/LOG/SYMCLI.H__   1.7.1.0.1.2   09 Dec 1996 10:14:50   ZJRD  $
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/

#ifndef _SYMCLI_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "basewind.h"
                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/
#ifdef __cplusplus
extern "C" {
#endif


//--------------------------------------------------------------------------
// SendMessageToCli
//--------------------------------------------------------------------------
RETCODE SendMessageToCli(U8 FAR *msgPtr);


/***************************************************************************
** RemoveSymbols
**
** Description: Removes all loaded symbols and reinitializes the symbol
**              table.
**
** Input Parameters:
**    cmdString: a string of parsed tokens passed by the CLI
**    argc: number of tokens
**    argv[]: array holding an index to the parsed tokens in cmdString
** Output Parameters:
**    none:
** Errors:
**
***************************************************************************/
RETCODE EXPORT RemoveSymbols(LPSTR cmdString, U32 argc, U32 argv[]);

/***************************************************************************
** DisplaySymbols
**
** Description: Prints all symbols in the symbol table.
**
** Input Parameters:
**    cmdString: a string of parsed tokens passed by the CLI
**    argc: number of tokens
**    argv[]: array holding an index to the parsed tokens in cmdString
** Output Parameters:
**    none:
** Errors:
**
***************************************************************************/
RETCODE EXPORT DisplaySymbols(LPSTR cmdString, U32 argc, U32 argv[]);

//--------------------------------------------------------------------------
// Count
//
// Displays the number of symbols in the various tables
//--------------------------------------------------------------------------
RETCODE EXPORT
Count(LPSTR cmdString, U32 argc, U32 argv[]);


//--------------------------------------------------------------------------
// NameOf
//
// Converts an address into a symbol and displays it
//--------------------------------------------------------------------------
RETCODE EXPORT
NameOf(LPSTR cmdString, U32 argc, U32 argv[]);


//--------------------------------------------------------------------------
// AddressOf
//
// Converts a symbol path and name into an address; uses #mod#func#var
//   naming convention
//--------------------------------------------------------------------------
RETCODE EXPORT
AddressOf(LPSTR cmdString, U32 argc, U32 argv[]);

//--------------------------------------------------------------------------
// SymbolOpenFile
//
// Sets symbol output to go to <file>.
// Only one parameter is allowed - the path and filename
//--------------------------------------------------------------------------
RETCODE EXPORT
SymbolOpenFile(LPSTR cmdString, U32 argc, U32 argv[]);

//--------------------------------------------------------------------------
// SymbolCloseFile
//
// Closes file opened by SymbolOpenFile
// No parameters are allowed.
//--------------------------------------------------------------------------
RETCODE EXPORT
SymbolCloseFile(LPSTR cmdString, U32 argc, U32 argv[]);

//--------------------------------------------------------------------------
// DisplayTypes
//
// Diplay all types in symbol table.
//                    
//--------------------------------------------------------------------------
RETCODE EXPORT
DisplayTypes(LPSTR cmdString, U32 argc, U32 argv[]);

/****************************************************************************
**
**  TskCheckAbort
**
**  Description:
**    Acts as replacement for Windows API function GetAsyncKeyState(VK_ESCAPE)
**    As such it should match its behavior and return type.
**    This new version only calls when the app is active, as
**    defined by the "appIsActive" flag.  This is a crude
**    indication of focus.
**
**  Parameters:
**     aborted   flag: FALSE if esc not pressed, TRUE if pressed.
**
*****************************************************************************/

RETCODE EXPORT TskCheckAbort(BOOLEAN FAR *abort);

#ifdef __cplusplus
}
#endif

#define _SYMCLI_
#endif
/******************************** E O F ***********************************/
